<?php
include 'includes/db.php';

// Keine Session nötig
$spindnr = trim($_GET['spindnr'] ?? '');

if ($spindnr === '') {
    echo "<div class='container my-5'><div class='alert alert-danger'>Keine Spindnummer angegeben.</div></div>";
    exit;
}

// Kamerad suchen
$stmt = $conn->prepare("SELECT * FROM kameraden WHERE spindnr = ?");
$stmt->bind_param("s", $spindnr);
$stmt->execute();
$kamerad = $stmt->get_result()->fetch_assoc();

if (!$kamerad) {
    echo "<div class='container my-5'><div class='alert alert-danger'>Kamerad nicht gefunden.</div></div>";
    exit;
}

// Melder abrufen
$stmt_melder = $conn->prepare("SELECT * FROM melder WHERE kamerad_id = ?");
$stmt_melder->bind_param("i", $kamerad['id']);
$stmt_melder->execute();
$melder = $stmt_melder->get_result();
?>

<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>Mein Spind | cloud.F-Invent</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<div class="container my-5">
  <h2 class="text-center mb-4">Ausrüstung von <?= htmlspecialchars($kamerad['vorname'].' '.$kamerad['nachname']) ?></h2>

  <div class="card mb-4">
    <div class="card-body">
      <h5>Größen</h5>
      <ul class="list-group">
        <li class="list-group-item">Einsatzjacke: <?= htmlspecialchars($kamerad['groesse_jacke'] ?? '-') ?></li>
        <li class="list-group-item">Einsatzhose: <?= htmlspecialchars($kamerad['groesse_hose'] ?? '-') ?></li>
        <li class="list-group-item">Einsatzhose AGT: <?= htmlspecialchars($kamerad['groesse_hose_agt'] ?? '-') ?></li>
        <li class="list-group-item">Stiefel: <?= htmlspecialchars($kamerad['groesse_stiefel'] ?? '-') ?></li>
      </ul>
    </div>
  </div>

  <div class="card mb-4">
    <div class="card-body">
      <h5>Melderdaten</h5>
      <?php if ($melder->num_rows > 0): ?>
        <?php while ($item = $melder->fetch_assoc()): ?>
          <div class="mb-2">
            <strong>Seriennummer:</strong> <?= htmlspecialchars($item['seriennummer']) ?><br>
            <strong>Typ:</strong> <?= htmlspecialchars($item['typ']) ?><br>
            <strong>Kennung:</strong> <?= htmlspecialchars($item['kennung']) ?><br>
            <strong>Zubehör:</strong><br>
            <?= $item['ladegeraet'] ? '🔌 Ladegerät<br>' : '' ?>
            <?= $item['antenne'] ? '📡 Antenne<br>' : '' ?>
            <?= $item['schutztasche'] ? '👜 Schutztasche<br>' : '' ?>
          </div>
        <?php endwhile; ?>
      <?php else: ?>
        <p class="text-muted">Kein Melder vorhanden.</p>
      <?php endif; ?>
    </div>
  </div>

  <div class="text-center mb-4">
    <button class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#ticketModal">📋 Problem melden</button>
  </div>

</div>

<!-- Ticket Modal -->
<div class="modal fade" id="ticketModal" tabindex="-1" aria-labelledby="ticketModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form method="post" enctype="multipart/form-data" action="ticket_erstellen.php">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="ticketModalLabel">Neues Ticket erstellen</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Schließen"></button>
        </div>
        <div class="modal-body">
          <input type="hidden" name="kamerad_id" value="<?= $kamerad['id'] ?>">
          <div class="mb-3">
            <label class="form-label">Kategorie</label>
            <select name="kategorie" class="form-select" required>
              <option value="PSA">PSA</option>
              <option value="Melder">Melder</option>
              <option value="Dienstbekleidung">Dienstbekleidung</option>
              <option value="Uniform">Uniform</option>
            </select>
          </div>
          <div class="mb-3">
            <label class="form-label">Beschreibung</label>
            <textarea name="beschreibung" class="form-control" rows="3" required></textarea>
          </div>
          <div class="mb-3">
            <label class="form-label">Foto anhängen (optional)</label>
            <input type="file" name="anhang" class="form-control">
          </div>
        </div>
        <div class="modal-footer">
          <button type="submit" name="ticket_speichern" class="btn btn-primary">Ticket absenden</button>
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Abbrechen</button>
        </div>
      </div>
    </form>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

</body>
</html>
