<?php
session_start();
include 'includes/db.php';

// Zugriffsschutz
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

// Artikel abrufen
$artikel = $conn->query("SELECT * FROM lager_bestand ORDER BY artikelname ASC");
?>
<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="UTF-8">
  <title>Etiketten – Lagerartikel</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body {
      background: #fff;
      font-size: 10pt;
    }

    .etiketten-container {
      display: grid;
      grid-template-columns: repeat(3, 64mm);
      grid-template-rows: auto;
      gap: 2mm 1.5mm;
      padding: 10mm;
    }

    .etikett {
      width: 64mm;
      height: 25.4mm;
      border: 1px dotted #ccc;
      padding: 2mm;
      box-sizing: border-box;
      font-family: sans-serif;
      display: flex;
      flex-direction: column;
      justify-content: space-between;
    }

    .etikett h4 {
      font-size: 9pt;
      margin: 0 0 2mm 0;
    }

    .etikett small {
      font-size: 7pt;
      color: #333;
    }

    .qr img {
      width: 60px;
      height: 60px;
      float: right;
    }

    @media print {
      .noprint { display: none; }
      body { margin: 0; }
    }
  </style>
</head>
<body>
<div class="container-fluid my-3">
  <div class="noprint mb-3 text-center">
    <a href="dashboard.php" class="btn btn-secondary">&laquo; Zurück</a>
    <button onclick="window.print()" class="btn btn-primary">🖨️ Drucken</button>
  </div>

  <div class="etiketten-container">
    <?php while ($row = $artikel->fetch_assoc()): ?>
      <?php
        $id = $row['id'];
        $url = "https://app.f-invent.de/lager_qr.php?id=" . $id;
        $qr_url = "https://api.qrserver.com/v1/create-qr-code/?size=100x100&data=" . urlencode($url);

      ?>
      <td style="width:70mm;height:37mm;padding:4mm;text-align:center;vertical-align:middle;">
        <div style="display:flex;flex-direction:column;align-items:center;justify-content:center;height:100%;">
          <img src="<?= $qr_url ?>" alt="QR-Code" style="width:100px;height:100px;margin-bottom:5px;">
          <strong style="font-size:11px;"><?= htmlspecialchars($row['artikelname']) ?></strong>
          <span style="font-size:10px;">Mindestbestand: <?= $row['mindesbestand'] ?></span>
        </div>
      </td>

    <?php endwhile; ?>
  </div>
</div>
</body>
</html>
