-- Backup von kd54698_cloud am 2025-05-17_22-00-02

DROP TABLE IF EXISTS `adressen`;
CREATE TABLE `adressen` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bezeichnung` varchar(255) DEFAULT NULL,
  `strasse` varchar(255) DEFAULT NULL,
  `plz` varchar(10) DEFAULT NULL,
  `ort` varchar(255) DEFAULT NULL,
  `hinweis` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `adressen` VALUES ('1', 'Technische Zentrale Ammerland', 'Dreiberger Str. 2-4', '26160', 'Bad Zwischenahn', 'B-Dienst vorher anrufen!');


DROP TABLE IF EXISTS `atemschutz_pruefungen`;
CREATE TABLE `atemschutz_pruefungen` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `geraet_id` int(11) unsigned NOT NULL,
  `geprueft_am` date NOT NULL,
  `geprueft_von` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `atemschutz_pruefungen` VALUES ('1', '1', '2025-04-26', 'Nils Bonk');
INSERT INTO `atemschutz_pruefungen` VALUES ('2', '1', '2025-04-26', 'Nils Bonk');
INSERT INTO `atemschutz_pruefungen` VALUES ('3', '2', '2025-05-02', 'Nils Bonk');
INSERT INTO `atemschutz_pruefungen` VALUES ('4', '2', '2025-05-02', 'Nils Bonk');
INSERT INTO `atemschutz_pruefungen` VALUES ('5', '1', '2025-05-02', 'Nils Bonk');
INSERT INTO `atemschutz_pruefungen` VALUES ('6', '1', '2025-05-02', 'Nils Bonk');


DROP TABLE IF EXISTS `atemschutzgeraete`;
CREATE TABLE `atemschutzgeraete` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `geraetename` varchar(255) NOT NULL,
  `seriennummer` varchar(255) NOT NULL,
  `letzte_pruefung` date NOT NULL,
  `naechste_pruefung` date NOT NULL,
  `geprueft_von` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `atemschutzgeraete` VALUES ('1', 'A2BZTEST', '651651969', '2025-05-02', '2025-06-01', 'Nils Bonk');
INSERT INTO `atemschutzgeraete` VALUES ('2', 'A\"BZTEST2', '651651984', '2025-05-02', '2025-06-01', 'Nils Bonk');


DROP TABLE IF EXISTS `aufgaben`;
CREATE TABLE `aufgaben` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `absender_id` int(11) NOT NULL,
  `empfaenger_id` int(11) DEFAULT NULL,
  `einheit` varchar(255) NOT NULL,
  `titel` varchar(255) NOT NULL,
  `beschreibung` text NOT NULL,
  `faellig_am` date DEFAULT NULL,
  `status` enum('offen','erledigt') DEFAULT 'offen',
  `erstellt_am` datetime DEFAULT current_timestamp(),
  `prioritaet` enum('hoch','mittel','niedrig') DEFAULT 'mittel',
  `anhang` varchar(255) DEFAULT NULL,
  `gelesen` tinyint(1) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `aufgaben` VALUES ('1', '1', '13', 'A2BZ', 'Zeiterfassung', 'Bitte regelmäßig ausfüllen', '2025-05-06', 'offen', '2025-05-03 13:38:05', 'mittel', NULL, '0');
INSERT INTO `aufgaben` VALUES ('2', '1', NULL, 'A2BZ', 'Test Aufgabe', 'Test für alle', '2025-05-06', 'erledigt', '2025-05-03 13:39:35', 'mittel', NULL, '0');
INSERT INTO `aufgaben` VALUES ('3', '1', '1', 'A2BZ', 'asd', 'asd', '2025-05-04', 'erledigt', '2025-05-03 13:44:15', 'mittel', NULL, '0');
INSERT INTO `aufgaben` VALUES ('4', '1', '13', 'A2BZ', 'Melder', 'Moin Thede,\r\n\r\nkannst du mal einen Melder mit zur TZ nehmen?', '2025-05-12', 'offen', '2025-05-03 19:00:00', 'mittel', NULL, '0');
INSERT INTO `aufgaben` VALUES ('5', '1', '17', 'A2BZ', 'test', 'test', '2025-05-02', 'offen', '2025-05-03 20:13:20', 'mittel', NULL, '0');
INSERT INTO `aufgaben` VALUES ('6', '1', '1', 'A2BZ', 'test', 'dastand', '0000-00-00', 'erledigt', '2025-05-03 20:15:43', 'mittel', NULL, '0');
INSERT INTO `aufgaben` VALUES ('7', '1', '1', 'A2BZ', 'asd', 'asdasd', '0000-00-00', 'erledigt', '2025-05-03 20:18:38', 'mittel', NULL, '0');
INSERT INTO `aufgaben` VALUES ('8', '1', '1', 'A2BZ', 'asd', 'asdasd', '0000-00-00', 'erledigt', '2025-05-03 20:19:52', 'mittel', NULL, '0');
INSERT INTO `aufgaben` VALUES ('9', '1', '17', 'A2BZ', 'asdasdasdasd', 'asdasdasdasd', '2025-05-03', 'offen', '2025-05-03 20:24:27', 'mittel', NULL, '0');
INSERT INTO `aufgaben` VALUES ('10', '1', '13', 'A2BZ', 'Mach mal was', 'Mach doch mal was', '2025-05-03', 'erledigt', '2025-05-03 20:25:25', 'mittel', NULL, '0');
INSERT INTO `aufgaben` VALUES ('11', '1', '13', 'A2BZ', 'TZest', 'Test', '2025-05-03', 'offen', '2025-05-03 20:35:37', 'hoch', NULL, '0');
INSERT INTO `aufgaben` VALUES ('12', '13', '1', 'A2BZ', 'Änderungen', 'Moin Nils, hier einmal die Sachen die ich mir Anders vorstelle bei F-Invent. Es wäre schön wenn man beim Reiter Kameraden noch die Handschuhe wie TH/AGT Handschuhe die Größe eintragen kann. Bei den Jacken und Hosen wäre es schön wenn ich die Größe selbst ständig eintragen kann. Schön wäre es auch wenn ich im Reiter PSA unter Kameraden eine such Funktion bekäme dies wäre auch schön im Bereich PSA. Eine Lösch Funktion im Bereich PSA und Kameraden wäre auch super.', '2025-05-04', 'offen', '2025-05-04 16:54:09', 'hoch', NULL, '0');
INSERT INTO `aufgaben` VALUES ('13', '13', '1', 'A2BZ', 'Änderungen', 'Moin habe vergessen das die Helme und Lampe  auch in den Bereich Kameraden rein müssen da diese nahmen bezogen sind.', '2025-05-04', 'offen', '2025-05-04 17:06:38', 'mittel', NULL, '0');


DROP TABLE IF EXISTS `bestellungen`;
CREATE TABLE `bestellungen` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `artikelname` varchar(255) NOT NULL,
  `menge` int(11) NOT NULL,
  `verwendungszweck` text DEFAULT NULL,
  `herstellerlink` varchar(500) DEFAULT NULL,
  `status` enum('offen','genehmigt','abgelehnt') DEFAULT 'offen',
  `angelegt_von` int(11) DEFAULT NULL,
  `genehmigt_von` int(11) DEFAULT NULL,
  `kommentar` text DEFAULT NULL,
  `erstellt_am` datetime DEFAULT current_timestamp(),
  `genehmigt_am` datetime DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `angelegt_von` (`angelegt_von`),
  KEY `genehmigt_von` (`genehmigt_von`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `bestellungen` VALUES ('1', 'Seiz Handschuhe', '1', 'Lager', '', 'genehmigt', '1', '1', 'Ist Bestellt', '2025-05-17 21:22:03', '2025-05-17 21:23:09');


DROP TABLE IF EXISTS `chat_nachrichten`;
CREATE TABLE `chat_nachrichten` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `nachricht` text NOT NULL,
  `zeit` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `chat_nachrichten` VALUES ('1', '1', 'Hallo Moin', '2025-05-17 22:27:26');
INSERT INTO `chat_nachrichten` VALUES ('2', '1', 'Na ihr Nasen', '2025-05-17 22:27:38');


DROP TABLE IF EXISTS `db_backups`;
CREATE TABLE `db_backups` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `filename` varchar(255) NOT NULL,
  `filesize_kb` int(11) NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `db_backups` VALUES ('1', 'backup_kd54698_cloud_2025-05-04_11-44-01.sql', '495', '2025-05-04 11:44:01');
INSERT INTO `db_backups` VALUES ('2', 'backup_kd54698_cloud_2025-05-04_11-45-01.sql', '495', '2025-05-04 11:45:01');
INSERT INTO `db_backups` VALUES ('3', 'backup_kd54698_cloud_2025-05-04_11-46-01.sql', '495', '2025-05-04 11:46:01');
INSERT INTO `db_backups` VALUES ('4', 'backup_kd54698_cloud_2025-05-04_11-46-37.sql', '496', '2025-05-04 11:46:37');
INSERT INTO `db_backups` VALUES ('5', 'backup_kd54698_cloud_2025-05-04_22-00-01.sql', '520', '2025-05-04 22:00:01');
INSERT INTO `db_backups` VALUES ('6', 'backup_kd54698_cloud_2025-05-05_22-00-02.sql', '520', '2025-05-05 22:00:02');
INSERT INTO `db_backups` VALUES ('7', 'backup_kd54698_cloud_2025-05-06_22-00-01.sql', '521', '2025-05-06 22:00:02');
INSERT INTO `db_backups` VALUES ('8', 'backup_kd54698_cloud_2025-05-07_22-00-02.sql', '521', '2025-05-07 22:00:02');
INSERT INTO `db_backups` VALUES ('9', 'backup_kd54698_cloud_2025-05-08_22-00-02.sql', '521', '2025-05-08 22:00:02');
INSERT INTO `db_backups` VALUES ('10', 'backup_kd54698_cloud_2025-05-09_22-00-03.sql', '521', '2025-05-09 22:00:03');
INSERT INTO `db_backups` VALUES ('11', 'backup_kd54698_cloud_2025-05-10_22-00-02.sql', '521', '2025-05-10 22:00:02');
INSERT INTO `db_backups` VALUES ('12', 'backup_kd54698_cloud_2025-05-11_22-00-02.sql', '521', '2025-05-11 22:00:02');
INSERT INTO `db_backups` VALUES ('13', 'backup_kd54698_cloud_2025-05-12_22-00-02.sql', '522', '2025-05-12 22:00:02');
INSERT INTO `db_backups` VALUES ('14', 'backup_kd54698_cloud_2025-05-13_22-00-02.sql', '522', '2025-05-13 22:00:02');
INSERT INTO `db_backups` VALUES ('15', 'backup_kd54698_cloud_2025-05-14_22-00-02.sql', '522', '2025-05-14 22:00:02');
INSERT INTO `db_backups` VALUES ('16', 'backup_kd54698_cloud_2025-05-15_22-00-02.sql', '522', '2025-05-15 22:00:02');
INSERT INTO `db_backups` VALUES ('17', 'backup_kd54698_cloud_2025-05-16_22-00-02.sql', '522', '2025-05-16 22:00:02');


DROP TABLE IF EXISTS `dokumente`;
CREATE TABLE `dokumente` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `dateiname` varchar(255) NOT NULL,
  `anzeigename` varchar(255) DEFAULT NULL,
  `kategorie` varchar(100) NOT NULL,
  `barcode` varchar(255) DEFAULT NULL,
  `hochgeladen_am` datetime NOT NULL DEFAULT current_timestamp(),
  `einheit` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `dokumente` VALUES ('7', 'dokument_6813cb8617a46.png', 'Logo BZ', 'Bilder', '1020', '2025-05-01 21:29:10', 'A2BZ');


DROP TABLE IF EXISTS `feuerwehren`;
CREATE TABLE `feuerwehren` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `gemeinde_id` int(11) NOT NULL,
  `strasse` varchar(100) DEFAULT NULL,
  `plz` varchar(10) DEFAULT NULL,
  `ort` varchar(100) DEFAULT NULL,
  `obm_1` varchar(100) DEFAULT NULL,
  `obm_2` varchar(100) DEFAULT NULL,
  `obm_3` varchar(100) DEFAULT NULL,
  `geraetewart` varchar(100) DEFAULT NULL,
  `agw` varchar(100) DEFAULT NULL,
  `telefon` varchar(50) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `name2` varchar(255) NOT NULL,
  `art` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

INSERT INTO `feuerwehren` VALUES ('1', 'A2BZ', '1', 'Vor dem Esch 11-13', '26160', 'Bad Zwischenahn', 'Martin Schreiber', 'Tim Cölsmann', '', 'Jan Hendrik Friedrich', 'Adelbert Coman', '04403-1281', 'geraeteverwaltung@feuerwehr-bad-zwischenahn.de', 'Bad Zwischenahn', 'Schwerpunktwehr');


DROP TABLE IF EXISTS `ffw_fahrzeuge`;
CREATE TABLE `ffw_fahrzeuge` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `fahrzeugname` varchar(255) DEFAULT NULL,
  `fahrzeugbezeichnung` varchar(255) DEFAULT NULL,
  `fahrzeugkurz` varchar(255) DEFAULT NULL,
  `memo` text CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `lpruefung` varchar(255) NOT NULL,
  `kennzeichen` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `funkrufname` varchar(255) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL,
  `barcode_fzg` varchar(255) NOT NULL,
  `einheit` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=latin1 COLLATE=latin1_general_ci;

INSERT INTO `ffw_fahrzeuge` VALUES ('2', 'Tanklöschfahrzeug', 'TLF-16/25', 'TLF1625', '', '1720915200', 'WST-TL-231', '12-23-01', '90110', 'A2BZ');
INSERT INTO `ffw_fahrzeuge` VALUES ('3', 'Hilfeleistungslöschgruppenfahrzeug', 'HLF-20', 'HLF20', '', '1737676800', 'WST-LF-481', '12-48-01', '90111', 'A2BZ');
INSERT INTO `ffw_fahrzeuge` VALUES ('4', 'Löschgruppenfahrzeug', 'LF-8', 'LF8', '', '1723161600', 'WST-WS-62', '12-43-01', '90112', 'A2BZ');
INSERT INTO `ffw_fahrzeuge` VALUES ('5', 'Rüstwagen', 'RW-2', 'RW2', '', '1710892800', 'WST-RW-521', '12-52-01', '90113', 'A2BZ');
INSERT INTO `ffw_fahrzeuge` VALUES ('6', 'Gerätewagenlogistik', 'GWL-2', 'GWL2', '', '1733270400', 'WST-BZ-6', '12-68-01', '90114', 'A2BZ');
INSERT INTO `ffw_fahrzeuge` VALUES ('7', 'Einsatzleitwagen', 'ELW-1', 'ELW1', 'asdasd', '1721174400', 'WST-EL-808', '12-11-01', '90115', 'A2BZ');
INSERT INTO `ffw_fahrzeuge` VALUES ('8', 'Hilfeleistungslöschgruppenfahrzeug', 'HLF-10/6', 'HLF106', '', '0000-00-00', 'WST-AA-46', '12-46-2', '90116', 'A2A');
INSERT INTO `ffw_fahrzeuge` VALUES ('9', 'Gerätewagen Strahlenschutz', 'GW-Str.', 'GWSTR', 'Kreisfahrzeug', '0000-00-00', 'WST-272', '80-71-1', '90117', 'A2A');
INSERT INTO `ffw_fahrzeuge` VALUES ('10', 'Löschgruppenfahrzeug', 'LF-8/6', 'LF86', '', '0000-00-00', 'WST-FD-112', '12-45-3', '90118', 'A2D');
INSERT INTO `ffw_fahrzeuge` VALUES ('11', 'Mannschaftstransportwagen', 'MTW', 'MTW', '', '0000-00-00', 'WST-DJ-71', '12-17-3', '90119', 'A2D');
INSERT INTO `ffw_fahrzeuge` VALUES ('12', 'Löschgruppenfahrzeug', 'LF-8', 'LF8', 'HU    09/24\r\n', '0000-00-00', 'WST-FE-112', '12-43-4', '90120', 'A2E');
INSERT INTO `ffw_fahrzeuge` VALUES ('13', 'Mannschaftstransportwagen', 'MTW', 'MTW', '', '0000-00-00', 'WST-JE-112', '12-17-4', '90121', 'A2E');
INSERT INTO `ffw_fahrzeuge` VALUES ('14', 'Löschgruppenfahrzeug', 'LF-10/6', 'LF106', '', '0000-00-00', 'WST-FK-112', '12-45-5', '90122', 'A2K');
INSERT INTO `ffw_fahrzeuge` VALUES ('15', 'Tanklöschfahrzeug', 'TLF-8/18', 'TLF818', '', '0000-00-00', 'WST-F-550', '12-20-6', '90123', 'A2O');
INSERT INTO `ffw_fahrzeuge` VALUES ('16', 'Löschgruppenfahrzeug', 'LF10/6', 'LF106', '', '0000-00-00', 'WST-FO-705', '12-45-6', '90124', 'A2O');
INSERT INTO `ffw_fahrzeuge` VALUES ('17', 'Hilfeleistungslöschgruppenfahrzeug', 'HLF-10', 'HLF10', '', '0000-00-00', 'WST-FO-220', '12-46-7', '90125', 'A2OH');
INSERT INTO `ffw_fahrzeuge` VALUES ('18', 'Tanklöschfahrzeug', 'TLF-3000', 'TLF3000', '', '0000-00-00', 'WST-PF-133', '12-21-8', '90126', 'A2P');
INSERT INTO `ffw_fahrzeuge` VALUES ('19', 'Hilfeleistungslöschgruppenfahrzeug', 'HLF-10/6', 'HLF106', '', '0000-00-00', 'WST-PF-112', '12-46-8', '90127', 'A2P');
INSERT INTO `ffw_fahrzeuge` VALUES ('20', 'Feuerwehrhaus', 'Feuerwehrhaus', 'Feuerwehrhaus', '', '1735689600', '', '', '50001', 'A2BZ');
INSERT INTO `ffw_fahrzeuge` VALUES ('21', 'Feuerwehrhaus', 'Feuerwehrhaus', 'Feuerwehrhaus', 'Heinrichstraße 15\r\n26160 Bad Zwischenahn', '0000-00-00', '', '', '50002', 'A2A');
INSERT INTO `ffw_fahrzeuge` VALUES ('22', 'Feuerwehrhaus', 'Feuerwehrhaus', 'Feuerwehrhaus', '', '0000-00-00', '', '', '50003', 'A2D');
INSERT INTO `ffw_fahrzeuge` VALUES ('30', 'Feuerwehrhaus', 'Feuerwehrhaus', NULL, '', '0000-00-00', '', '', '50004', 'A2K');
INSERT INTO `ffw_fahrzeuge` VALUES ('31', 'Feuerwehrhaus', 'Feuerwehrhaus', NULL, '', '0000-00-00', '', '', '50005', 'A2O');
INSERT INTO `ffw_fahrzeuge` VALUES ('32', 'Feuerwehrhaus', 'Feuerwehrhaus', NULL, '', '0000-00-00', '', '', '50006', 'A2OH');
INSERT INTO `ffw_fahrzeuge` VALUES ('33', 'Feuerwehrhaus', 'Feuerwehrhaus', NULL, '', '0000-00-00', '', '', '50007', 'A2P');
INSERT INTO `ffw_fahrzeuge` VALUES ('34', 'Feuerwehrhaus', 'Feuerwehrhaus', NULL, '', '0000-00-00', '', '', '50008', 'A2E');
INSERT INTO `ffw_fahrzeuge` VALUES ('35', 'Führungsstelle', 'FüSt Bad Zwischenahn', 'fuest', '', '1756684800', '', '12-90-1', '60000', 'A2BZ');


DROP TABLE IF EXISTS `ffw_favoriten`;
CREATE TABLE `ffw_favoriten` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `geraet_id` int(11) NOT NULL,
  `erstellt_am` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id` (`user_id`,`geraet_id`),
  KEY `geraet_id` (`geraet_id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `ffw_favoriten` VALUES ('4', '1', '2213', '2025-05-03 20:46:23');
INSERT INTO `ffw_favoriten` VALUES ('5', '1', '2214', '2025-05-03 20:46:23');
INSERT INTO `ffw_favoriten` VALUES ('6', '1', '2215', '2025-05-03 20:46:24');


DROP TABLE IF EXISTS `ffw_geraete`;
CREATE TABLE `ffw_geraete` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `gemeinde_id` varchar(100) DEFAULT NULL,
  `barcode` varchar(255) NOT NULL DEFAULT '',
  `bezeichnung` varchar(255) NOT NULL,
  `baujahr` varchar(10) NOT NULL DEFAULT '',
  `lpruefung` int(50) NOT NULL,
  `fahrzeug` varchar(100) NOT NULL DEFAULT '',
  `gr` varchar(50) NOT NULL DEFAULT '',
  `bnorm` varchar(100) NOT NULL DEFAULT '',
  `gangelegt` varchar(100) NOT NULL DEFAULT '',
  `memo` text NOT NULL,
  `anzahl` varchar(255) NOT NULL DEFAULT '',
  `laenderung` varchar(25) NOT NULL DEFAULT '',
  `anzahlist` varchar(255) NOT NULL DEFAULT '',
  `standort` varchar(255) NOT NULL DEFAULT '',
  `verliehenan` varchar(255) NOT NULL DEFAULT '',
  `bezeichnungtz` varchar(255) NOT NULL DEFAULT '',
  `aenderungvon` varchar(100) NOT NULL DEFAULT '',
  `erstelltvon` varchar(100) NOT NULL DEFAULT '',
  `status` varchar(100) NOT NULL DEFAULT '',
  `auszusondern` varchar(255) NOT NULL,
  `lscan` varchar(255) NOT NULL,
  `kat` varchar(255) NOT NULL,
  `mpruefung` varchar(255) NOT NULL,
  `foev` varchar(5) NOT NULL,
  `funk_issi` varchar(255) NOT NULL,
  `einheit` varchar(50) NOT NULL,
  `snnr` varchar(255) NOT NULL,
  `p_intervall` varchar(255) NOT NULL,
  `pool_tz` varchar(10) NOT NULL,
  `fav` varchar(255) NOT NULL,
  `del` int(11) NOT NULL,
  `hashtag` text NOT NULL,
  `bild` varchar(255) NOT NULL,
  `file_path` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2576 DEFAULT CHARSET=utf8 COLLATE=utf8_general_ci;

INSERT INTO `ffw_geraete` VALUES ('99', NULL, '30351419', 'Handlampe Adalit ', '1514761200', '1738368000', '90113', 'Mannschaft Vorne', 'DIN 14649:2018-03', '18.04.2019 - 20:13:27', '', '1', '12.06.2021 - 14:06:19', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Handlampe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('104', NULL, '30351418', 'Handlampe Adalit ', '1514761200', '1738368000', '90113', 'Mannschaft Vorne', '', '19.04.2019 - 12:29:57', '', '1', '03.09.2022 - 14:49:24', '1', '', '', '', 'Nils Bonk', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Handlampe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('105', NULL, '30351417', 'Handlampe Adalit ', '1514761200', '1738368000', '90113', 'Mannschaft Vorne', 'DIN 14649:2018-03', '19.04.2019 - 12:31:46', '', '1', '12.06.2021 - 14:06:32', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Handlampe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('106', NULL, '30351435', 'Anhaltestab', '', '1738368000', '90113', 'Mannschaft Vorne', '', '19.04.2019 - 12:32:34', '', '1', '12.06.2021 - 14:05:13', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('107', NULL, '8002', 'Einmalhandschuhe', '', '1738368000', '90113', 'Mannschaft Vorne', '', '19.04.2019 - 12:33:32', '', '1', '12.06.2021 - 14:29:03', '1', 'Bitte auswählen', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verbrauchsmaterial', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', 'kein-bild.svg', '');
INSERT INTO `ffw_geraete` VALUES ('108', NULL, '2001', 'Fahrtenbuch', '', '1738368000', '90113', 'Mannschaft Vorne', '', '19.04.2019 - 12:34:11', '', '1', '12.06.2021 - 14:06:49', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('109', NULL, '2002', 'Funkverzeichnis', '', '1738368000', '90113', 'Mannschaft Vorne', '', '19.04.2019 - 12:34:45', '', '1', '12.06.2021 - 14:28:44', '1', 'Bitte auswählen', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('110', NULL, '2003', 'Dreikantschlüssel', '', '1738368000', '90113', 'Mannschaft Vorne', '', '19.04.2019 - 12:35:18', '', '1', '10.02.2023 - 17:24:38', '1', '', '', '', 'Nils Bonk', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('111', NULL, '2022', 'Warndreieck', '', '1738368000', '90113', '1', '', '19.04.2019 - 12:36:05', '', '2', '01.09.2022 - 19:17:17', '2', '', '', '', 'Nils Bonk', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('112', NULL, '2005', 'Faltleitkegel', '', '1738368000', '90113', '1', 'DIN1237681', '19.04.2019 - 12:36:41', '', '8', '12.06.2021 - 13:26:29', '8', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('113', NULL, '2008', 'Schilderständer', '', '1738368000', '90113', '1', '', '19.04.2019 - 12:37:31', '', '3', '12.06.2021 - 13:24:48', '3', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('114', NULL, '2007', 'Faltsignal', '', '1738368000', '90113', '1', '', '19.04.2019 - 12:38:46', '', '2', '12.06.2021 - 13:24:56', '2', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('115', NULL, '30351402', 'Solarblitz', '', '1738368000', '90113', '1', '', '19.04.2019 - 12:39:17', '', '1', '12.06.2021 - 13:27:28', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('116', NULL, '30351403', 'Solarblitz', '', '1738368000', '90113', '1', '', '19.04.2019 - 12:39:50', '', '1', '12.06.2021 - 13:27:44', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('117', NULL, '30351400', 'Solarblitz', '', '1738368000', '90113', '1', '', '19.04.2019 - 12:40:23', '', '1', '12.06.2021 - 13:28:00', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('118', NULL, '30351401', 'Solarblitz', '', '1738368000', '90113', '1', '', '19.04.2019 - 12:40:47', '', '1', '12.06.2021 - 13:27:36', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('119', NULL, '2004', 'Absperrband', '', '1738368000', '90113', '1', '', '19.04.2019 - 12:42:07', '', '1', '12.06.2021 - 14:21:49', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verbrauchsmaterial', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('120', NULL, '2006', 'Absperrstangen', '', '1738368000', '90113', '1', '', '19.04.2019 - 12:42:36', '', '9', '12.06.2021 - 13:25:09', '9', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('121', NULL, '2010', 'Wagenheber', '', '1738368000', '90113', '1', '', '19.04.2019 - 12:43:00', '', '1', '12.06.2021 - 13:27:07', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstiges', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('122', NULL, '2009', 'Warnschilder', '', '1738368000', '90113', '1', '', '19.04.2019 - 12:44:56', '3 Schilder Ätzend\r\n3 Schilder Giftig', '6', '12.06.2021 - 13:25:41', '6', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('123', NULL, '30351437', 'Warnlampe', '', '1738368000', '90113', '1', '', '19.04.2019 - 12:45:23', '', '1', '12.06.2021 - 13:28:23', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('124', NULL, '30351436', 'Warnlampe', '', '1738368000', '90113', '1', '', '19.04.2019 - 12:45:51', '', '1', '12.06.2021 - 13:28:34', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('125', NULL, '2011', 'Gummimatte', '', '1738368000', '90113', '3', '', '19.04.2019 - 12:46:50', '', '5', '12.06.2021 - 13:28:53', '5', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('126', NULL, '2012', 'Rettungsplattform', '', '1738368000', '90113', '3', '', '19.04.2019 - 12:47:20', 'Zubehör:\r\n\r\n2 Stützen\r\n1 Arbeitsplattform', '1', '12.06.2021 - 13:28:47', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('127', NULL, '2013', 'Mulde', '', '1738368000', '90113', '3', '', '19.04.2019 - 12:47:52', '', '1', '12.06.2021 - 13:55:31', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('128', NULL, '2014', 'Verbandkasten Fw', '', '1738368000', '90113', '3', '', '19.04.2019 - 12:50:43', 'Inhalt:\r\n\r\nHeftpflaster 2,5 cm x 5cm \r\nWundschnellverband 100 cm x 8 cm\r\nWundschnellverband10 cm x 6cm\r\nFingerkuppenverband \r\nWundschnellverband 18 cm x 2cm \r\nPflasterstrip 1,9 cm x 7,2 cm\r\nVerbandpäckchen l8 cm x 10 cm\r\nVerbandpäckchen l10 cm x 12 cm\r\nKo', '1', '12.06.2021 - 13:29:28', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.07.2023', '0', 'Erste Hilfe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('129', NULL, '2015', 'Dichtungskasten', '', '1738368000', '90113', '3', '', '19.04.2019 - 12:51:35', 'Inhalt:', '1', '12.06.2021 - 13:30:24', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verbrauchsmaterial', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('130', NULL, '2017', 'Verbrauchsmaterialkasten', '', '1738368000', '90113', '3', '', '19.04.2019 - 12:52:25', 'Inhalt:', '1', '12.06.2021 - 13:30:29', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verbrauchsmaterial', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('131', NULL, '2018', 'Werkzeug Holz', '', '1738368000', '90113', '3', '', '19.04.2019 - 12:53:47', 'Inhalt:', '1', '12.06.2021 - 13:30:39', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('132', NULL, '2019', 'Werkzeug Metall 1', '', '1738368000', '90113', '3', '', '19.04.2019 - 12:54:24', 'Inhalt:', '1', '12.06.2021 - 13:30:45', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('133', NULL, '2020', 'Werkzeug Metall 2', '', '1738368000', '90113', '3', '', '19.04.2019 - 12:54:59', 'Inhalt:', '1', '12.06.2021 - 13:30:52', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('134', NULL, '2016', 'Werkzeug Elektro', '', '1738368000', '90113', '3', '', '19.04.2019 - 12:55:40', 'Inhalt:\r\n\r\n1 Spannungsprüfer, zweipolig, DIN EN 61243-3, für Spannungen bis 750 V, IP65\r\n1 Warnschild DIN 4844-D-S001, Ø 100 mm\r\n2 Warnschild DIN 4844-D-H003, Ø 200 mm\r\n5 VDE-Schraubendreher DIN 7437, 0,6x3,5, 1x5,5, 1,2x6,5, 1,2x8, 1,6x10\r\n3 Schraubendre', '1', '12.06.2021 - 13:29:35', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('135', NULL, '30351224', 'Drahtseil', '', '1738368000', '90113', '3', '', '19.04.2019 - 12:56:30', '10mtr. 2t.', '1', '12.06.2021 - 13:31:13', '1', 'Bitte auswählen', '', 'DS1252102', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('136', NULL, '30351214', 'Schäkel', '', '1738368000', '90113', '3', '', '19.04.2019 - 12:57:21', '2t.', '1', '12.06.2021 - 13:37:09', '1', 'Bitte auswählen', '', 'SCHÄ1252110', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('137', NULL, '30351213', 'Schäkel', '', '1738368000', '90113', '3', '', '19.04.2019 - 12:58:27', '2t.', '1', '12.06.2021 - 13:36:42', '1', 'Bitte auswählen', '', 'SCHÄ1252111', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('138', NULL, '30351212', 'Schäkel', '', '1738368000', '90113', '3', '', '19.04.2019 - 12:59:03', '2t.', '1', '12.06.2021 - 13:36:50', '1', 'Bitte auswählen', '', 'SCHÄ1252112', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('139', NULL, '30351215', 'Schäkel', '', '1738368000', '90113', '3', '', '19.04.2019 - 12:59:39', '2t.', '1', '12.06.2021 - 13:37:00', '1', 'Bitte auswählen', '', 'SCHÄ1252109', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('140', NULL, '4988642', 'Rundschlinge', '1420066800', '1738368000', '90113', '3', '', '19.04.2019 - 13:00:26', '5mtr. 10t.', '1', '12.06.2021 - 13:35:32', '1', 'Bitte auswählen', '', 'RS1252101', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.01.2025', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('141', NULL, '4988643', 'Rundschlinge', '1420066800', '1738368000', '90113', '3', '', '19.04.2019 - 13:01:09', '5mtr. 10t.', '1', '12.06.2021 - 13:33:41', '1', 'Bitte auswählen', '', 'RS1252102', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.01.2025', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('142', NULL, '4988644', 'Rundschlinge', '1451602800', '1738368000', '90113', '3', '', '19.04.2019 - 13:01:46', '3mtr. 10t.', '1', '04.04.2025 - 09:33:42', '1', '', '', 'RS1252103', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Nicht Einsatzbereit', '', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('143', NULL, '4988645', 'Rundschlinge', '1451602800', '1738368000', '90113', '3', '', '19.04.2019 - 13:02:31', '3mtr. 10t.', '1', '12.06.2021 - 13:56:21', '1', 'Bitte auswählen', '', 'RS1252104', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.01.2026', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('144', NULL, '30351216', 'Schäkel', '', '1738368000', '90113', '3', '', '19.04.2019 - 13:03:16', '10t.', '1', '04.09.2019 - 19:38:42', '1', 'Bitte auswählen', '', 'SCHÄ1252108', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('145', NULL, '30351220', 'Schäkel', '', '1738368000', '90113', '3', '', '19.04.2019 - 13:03:44', '10t.', '1', '04.09.2019 - 19:38:43', '1', 'Bitte auswählen', '', 'SCHÄ1252104', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('146', NULL, '30351218', 'Schäkel', '', '1738368000', '90113', '3', '', '19.04.2019 - 13:04:18', '10t.', '1', '12.06.2021 - 13:33:03', '1', 'Bitte auswählen', '', 'SCHÄ1252106', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('147', NULL, '30351222', 'Schäkel', '', '1738368000', '90113', '3', '', '19.04.2019 - 13:04:53', '10t.', '1', '12.06.2021 - 13:34:18', '1', 'Bitte auswählen', '', 'SCHÄ1252102', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('148', NULL, '30351219', 'Schäkel', '', '1738368000', '90113', '3', '', '19.04.2019 - 13:05:29', '10t.', '1', '12.06.2021 - 14:22:27', '1', 'Bitte auswählen', '', 'SCHÄ1252105', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('149', NULL, '30351217', 'Schäkel', '', '1738368000', '90113', '3', '', '19.04.2019 - 13:06:04', '10t.', '1', '12.06.2021 - 13:33:17', '1', 'Bitte auswählen', '', 'SCHÄ1252107', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('150', NULL, '30351221', 'Schäkel', '', '1738368000', '90113', '3', '', '19.04.2019 - 13:06:37', '10t.', '1', '12.06.2021 - 13:34:40', '1', 'Bitte auswählen', '', 'SCHÄ1252103', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('151', NULL, '30351223', 'Schäkel', '', '1738368000', '90113', '3', '', '19.04.2019 - 13:07:11', '10t.', '1', '12.06.2021 - 13:34:50', '1', 'Bitte auswählen', '', 'SCHÄ1252101', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('152', NULL, '2023', 'Kantenschutz', '', '1738368000', '90113', '3', '', '19.04.2019 - 13:07:45', '', '4', '12.06.2021 - 13:32:08', '4', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('153', NULL, '30351225', 'Drahtseil', '', '1738368000', '90113', '3', '', '19.04.2019 - 13:08:26', '2,5mtr. 2t.', '1', '12.06.2021 - 14:23:04', '1', 'Bitte auswählen', '', 'DS1252101', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('154', NULL, '30351226', 'Drahtseil', '', '1738368000', '90113', '3', '', '19.04.2019 - 13:09:34', '2,5mtr. 2t.', '1', '12.06.2021 - 13:37:17', '1', 'Bitte auswählen', '22.09.2020', 'DS1252103', 'Jan Hendrik', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('155', NULL, '2021', 'Rettungskettensatz', '', '1738368000', '90113', '3', '', '19.04.2019 - 13:12:17', '6t.', '2', '12.06.2021 - 13:37:54', '2', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('156', NULL, '2028', 'Naßsauger', '', '1738368000', '90113', '5', '', '19.04.2019 - 13:13:50', '', '1', '12.06.2021 - 13:38:13', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('157', NULL, '2029', 'Naßsauger Zubehör', '', '1738368000', '90113', '5', '', '19.04.2019 - 13:14:30', 'Inhalt:', '1', '12.06.2021 - 14:25:17', '1', 'Bitte auswählen', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('158', NULL, '2025', 'Pressluftflaschen ', '', '1735689600', '90113', '5', '', '19.04.2019 - 13:15:03', '300bar', '4', '10.03.2022 - 16:22:54', '4', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('160', NULL, '2027', 'Atemanschluss', '', '1735689600', '90113', '5', '', '19.04.2019 - 13:16:04', '', '2', '10.03.2022 - 16:23:15', '2', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('163', NULL, '2030', 'Erdankerziehgerät', '', '1738368000', '90113', '5', '', '19.04.2019 - 13:18:50', '', '1', '12.06.2021 - 13:39:51', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('164', NULL, '2031', 'Erdanker', '', '1738368000', '90113', '5', '', '19.04.2019 - 13:20:16', '', '9', '12.06.2021 - 13:39:41', '9', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('165', NULL, '3035127', 'Umlenkrolle Winde', '', '1738368000', '90113', '3', '', '19.04.2019 - 13:20:41', '10t.', '1', '02.07.2022 - 07:57:32', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('166', NULL, '30351228', 'Umlenkrolle', '', '1738368000', '90113', '5', '', '19.04.2019 - 13:21:07', '3t.', '1', '12.06.2021 - 13:40:12', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('167', NULL, '30351229', 'Mehrzweckzug', '', '1738368000', '90113', '5', '', '19.04.2019 - 13:21:38', '1,6t.', '1', '12.06.2021 - 13:42:34', '1', 'Feuerwehrhaus', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('168', NULL, '2032', 'Löschdecke', '', '1738368000', '90113', '7', '', '19.04.2019 - 13:22:05', '', '1', '23.05.2024 - 10:28:10', '1', '', '', 'LÖ12521', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerlöscher', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('172', NULL, '30351230', 'Büffelwinde', '', '1738368000', '90113', '7', '', '19.04.2019 - 13:24:59', '10t.', '1', '12.06.2021 - 13:43:15', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('173', NULL, '30351420', 'Motorpumpenaggregat', '536454000', '1738368000', '90113', '4', '', '19.04.2019 - 13:27:01', 'Ausgesondert ', '1', '28.03.2020 - 14:20:52', '1', '', '28.03.2020', '', 'Nils', 'Jan Hendrik', 'Ausgesondert', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('174', NULL, '2035', 'Gojak', '', '1738368000', '90113', '4', '', '19.04.2019 - 13:27:33', '', '4', '12.06.2021 - 13:20:49', '4', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', 'x', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('175', NULL, '2036', 'Sackkarre', '', '1738368000', '90113', '4', '', '19.04.2019 - 13:27:58', '', '1', '12.06.2021 - 13:21:09', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sondergerät', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('176', NULL, '2037', 'Verkehrsunfallkasten', '', '1738368000', '90113', '4', '', '19.04.2019 - 13:28:34', 'Inhalt:', '1', '12.06.2021 - 13:20:41', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('177', NULL, '2038', 'Bohrmaschine', '', '1738368000', '90113', '4', '', '19.04.2019 - 13:28:58', '', '1', '12.06.2021 - 13:20:28', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('178', NULL, '2039', 'Säbelsäge', '', '1738368000', '90113', '4', '', '19.04.2019 - 13:29:24', '', '1', '12.06.2021 - 13:20:30', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('179', NULL, '2040', 'Trennschleiferset', '', '1738368000', '90113', '4', '', '19.04.2019 - 13:30:10', '1 Trennschleifer\r\n1 Winkelschleifer', '1', '12.06.2021 - 13:20:46', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('180', NULL, '2041', 'Bohrmaschine Zubehör', '', '1738368000', '90113', '4', '', '19.04.2019 - 13:31:17', 'Inhalt:', '1', '12.06.2021 - 14:25:02', '1', 'Bitte auswählen', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('181', NULL, '2042', 'Unterlegkeil Winde', '', '1738368000', '90113', '4', '', '19.04.2019 - 13:31:53', '', '2', '12.06.2021 - 14:25:09', '2', 'Bitte auswählen', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('182', NULL, '2043', 'Stiel für Astsäge', '', '1738368000', '90113', '6', '', '19.04.2019 - 13:32:27', '', '1', '12.06.2021 - 13:00:55', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('183', NULL, '30351467', 'Schleifkorbtrage', '', '1738368000', '90113', '6', '', '19.04.2019 - 13:32:52', '', '1', '12.06.2021 - 13:01:14', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sanitätsgerät', '20.12.2021', 'x', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('184', NULL, '30351468', 'Spineboard', '', '1738368000', '90113', '6', 'DIN EN 1865-1:2015-08', '19.04.2019 - 13:33:21', '', '1', '12.06.2021 - 13:02:29', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sanitätsgerät', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('185', NULL, '2034', 'Spineboard Zubehör', '', '1738368000', '90113', '6', '', '19.04.2019 - 13:34:04', 'Inhalt:', '1', '12.06.2021 - 13:02:14', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sanitätsgerät', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('186', NULL, '2046', 'Schachthaken', '', '1738368000', '90113', '6', '', '19.04.2019 - 13:34:31', '', '3', '12.06.2021 - 13:05:31', '3', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('187', NULL, '2044', 'Schutzausrüstungskiste', '', '1738368000', '90113', '6', '', '19.04.2019 - 13:35:36', 'Inhalt:', '1', '12.06.2021 - 13:03:52', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Schutzkleidung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('188', NULL, '30351476', 'Schnittschutzhose', '1551222000', '1738368000', '90113', '6', '', '19.04.2019 - 13:36:05', '', '1', '01.04.2020 - 10:28:27', '1', 'Bitte auswählen', '01.04.2020', '', 'Jan Hendrik', 'Jan Hendrik', 'Ausgesondert', '01.03.2024', '0', 'Säge Equipment', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('189', NULL, '30351477', 'Forsthelm', '1551222000', '1738368000', '90113', '6', '', '19.04.2019 - 13:36:31', '', '1', '12.06.2021 - 13:06:39', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '27.02.2024', '0', 'Säge Equipment', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('190', NULL, '2045', 'Bindestränge', '', '1738368000', '90113', '6', '', '19.04.2019 - 13:36:57', '', '20', '12.06.2021 - 13:06:11', '20', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('191', NULL, '30351465', 'Tragetuch', '', '1738368000', '90113', '6', 'DIN EN 1865:2015-08', '19.04.2019 - 13:37:34', '', '1', '12.06.2021 - 14:27:16', '1', 'Bitte auswählen', '', 'LEI12521', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sanitätsgerät', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('192', NULL, '8153', 'Ventilleine', '', '1738368000', '90113', '6', '', '19.04.2019 - 13:39:22', '', '1', '12.06.2021 - 14:26:38', '1', 'Bitte auswählen', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstiges', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('193', NULL, '8154', 'Ventilleine', '', '1738368000', '90113', '6', '', '19.04.2019 - 13:39:49', '', '1', '12.06.2021 - 14:26:44', '1', 'Bitte auswählen', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstiges', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('194', NULL, '8155', 'Ventilleine', '', '1738368000', '90113', '6', '', '19.04.2019 - 13:40:14', '', '1', '12.06.2021 - 14:26:51', '1', 'Bitte auswählen', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstiges', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('195', NULL, '30351865', 'Akku Kettensäge', '', '1738368000', '90113', '6', '', '19.04.2019 - 13:41:00', '', '1', '29.03.2020 - 16:17:29', '1', 'Bitte auswählen', '29.03.2020', '', 'Jan Hendrik', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Säge Equipment', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('196', NULL, '30351461', 'Motorkettensäge', '1525125600', '1738368000', '90113', '6', '', '19.04.2019 - 13:41:33', 'Stihl MS 462 C-M\r\n\r\nmit Zubehör\r\n\r\n50cm Schwert\r\nKetten Nr.\r\nBestell Nr. 3621 000 0072\r\n            36R3      72\r\n\r\n63cm Schwert\r\nKetten Nr.\r\nBestell Nr. 3621 000 0084\r\n            36RS      84\r\n\r\n', '1', '04.03.2022 - 15:49:28', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Säge Equipment', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('197', NULL, '30351410', 'TwinSaw', '', '1738368000', '90113', '6', '', '19.04.2019 - 13:42:08', '', '1', '25.09.2021 - 11:53:51', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', 'x', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('199', NULL, '2049', 'Leitungsroller', '', '1738368000', '90113', '6', '', '19.04.2019 - 13:43:04', '400V', '2', '12.06.2021 - 13:09:21', '2', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('200', NULL, '30351431', 'Verlängerungskabel', '', '1738368000', '90113', '6', '', '19.04.2019 - 13:43:34', '230V', '1', '28.03.2020 - 14:26:57', '1', '', '28.03.2020', '', 'Nils', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('201', NULL, '30351430', 'Verlängerungskabel', '', '1738368000', '90113', '6', '', '19.04.2019 - 13:45:18', '230V', '1', '20.03.2020 - 09:52:32', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('202', NULL, '30351432', 'Verlängerungskabel', '', '1738368000', '90113', '6', '', '19.04.2019 - 13:45:44', '230V', '1', '12.06.2021 - 13:10:30', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('203', NULL, '30351407', 'FI-Schutzschalter', '', '1738368000', '90113', '6', '', '19.04.2019 - 13:46:14', '', '1', '12.06.2021 - 13:16:19', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('204', NULL, '30351434', 'Verteilerbox', '', '1738368000', '90113', '6', '', '19.04.2019 - 13:46:48', '400V/230V', '1', '12.06.2021 - 13:11:36', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('205', NULL, '30351139', 'Wathose', '', '1738368000', '90113', '6', '', '19.04.2019 - 13:47:17', '', '1', '12.06.2021 - 14:27:00', '1', 'Bitte auswählen', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Schutzkleidung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('206', NULL, '30351459', 'Watstiefel', '', '1738368000', '90113', '6', '', '19.04.2019 - 13:47:50', '', '1', '12.06.2021 - 14:27:06', '1', 'Bitte auswählen', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Schutzkleidung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('207', NULL, '30351429', 'Abwassertauchpumpe ATP 15', '', '1738368000', '90113', '6', '', '19.04.2019 - 13:48:23', '', '1', '12.06.2021 - 13:16:35', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserentnahme', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('208', NULL, '2050', 'Kupplungsschlüssel', '', '1738368000', '90113', '6', '', '19.04.2019 - 13:48:51', '', '1', '12.06.2021 - 14:30:48', '1', 'Bitte auswählen', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('209', NULL, '2051', 'Absperrorgan B', '', '1738368000', '90113', '6', '', '19.04.2019 - 13:49:29', 'Absperrorgan B', '1', '12.06.2021 - 13:15:46', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('210', NULL, '2052', 'Saugstutzen', '', '1738368000', '90113', '6', '', '19.04.2019 - 13:50:05', 'Saugstutzen ATP', '1', '12.06.2021 - 13:15:53', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('211', NULL, '2055', 'Druckschlauch C', '', '1738368000', '90113', '6', '', '19.04.2019 - 13:50:35', 'Druckschlauch C', '2', '12.06.2021 - 13:15:37', '2', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('212', NULL, '2053', 'Druckschlauch B', '', '1738368000', '90113', '6', '', '19.04.2019 - 13:52:57', 'Druckschlauch B', '2', '12.06.2021 - 13:15:20', '2', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('213', NULL, '2054', 'Füllschlauch', '', '1738368000', '90113', '6', '', '19.04.2019 - 13:53:21', '', '1', '12.06.2021 - 13:15:33', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('214', NULL, '2057', 'Fällheber', '', '1738368000', '90113', '6', '', '19.04.2019 - 13:53:43', '', '1', '12.06.2021 - 13:13:46', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('215', NULL, '8001', 'Einmaldecke', '', '1738368000', '90113', '6', '', '19.04.2019 - 13:54:12', '', '3', '12.06.2021 - 13:13:50', '3', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verbrauchsmaterial', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('216', NULL, '30351465', 'Tragetuch', '', '1738368000', '90113', '6', 'DIN EN 1865:2015-08', '19.04.2019 - 13:37:34', '', '1', '12.06.2021 - 14:27:16', '1', 'Bitte auswählen', '', 'LEI12521', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sanitätsgerät', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('217', NULL, '8005', 'Einmallaken', '', '1738368000', '90113', '6', '', '19.04.2019 - 13:56:57', '', '2', '12.06.2021 - 14:27:22', '2', 'Bitte auswählen', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verbrauchsmaterial', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('218', NULL, '2058', 'Vorschlaghammer', '', '1738368000', '90113', '6', '', '19.04.2019 - 13:57:24', '', '1', '12.06.2021 - 12:58:01', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('219', NULL, '2056', 'Stoßbesen', '', '1738368000', '90113', '6', '', '19.04.2019 - 13:57:50', '', '2', '12.06.2021 - 12:58:55', '2', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('220', NULL, '2062', 'Spaten', '', '1738368000', '90113', '6', '', '19.04.2019 - 13:58:14', '', '1', '12.06.2021 - 12:58:20', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('221', NULL, '2061', 'Kreuzhacke', '', '1738368000', '90113', '6', '', '19.04.2019 - 13:58:42', '', '1', '12.06.2021 - 12:57:57', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('222', NULL, '2059', 'Gummischieber', '', '1738368000', '90113', '6', '', '19.04.2019 - 13:59:05', '', '1', '12.06.2021 - 12:59:05', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('223', NULL, '2060', 'Sandschaufel', '', '1738368000', '90113', '6', '', '19.04.2019 - 13:59:28', '', '2', '12.06.2021 - 12:58:22', '2', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('224', NULL, '2063', 'Spaten EX', '', '1738368000', '90113', '6', '', '19.04.2019 - 13:59:55', 'EX geschützt', '1', '22.01.2024 - 11:15:04', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Gefahrgut', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('225', NULL, '2064', 'Kreuzhacke EX', '', '1738368000', '90113', '6', '', '19.04.2019 - 14:00:21', 'EX geschützt', '1', '12.06.2021 - 12:58:30', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Gefahrgut', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('226', NULL, '2065', 'Stechschaufel EX', '', '1738368000', '90113', '6', '', '19.04.2019 - 14:01:18', 'EX geschützt', '1', '12.06.2021 - 12:57:55', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Gefahrgut', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('227', NULL, '2066', 'Bolzenschneider', '', '1738368000', '90113', '6', '', '19.04.2019 - 14:01:50', '', '1', '12.06.2021 - 13:00:04', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('228', NULL, '2067', 'Brechstange', '', '1738368000', '90113', '6', '', '19.04.2019 - 14:03:05', '1500mm', '1', '12.06.2021 - 14:27:30', '1', 'Bitte auswählen', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('229', NULL, '2068', 'Brechstange', '', '1738368000', '90113', '6', '', '19.04.2019 - 14:03:48', '700mm', '1', '12.06.2021 - 12:59:45', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('230', NULL, '2069', 'Holzaxt', '', '1738368000', '90113', '6', '', '19.04.2019 - 14:04:28', '', '1', '12.06.2021 - 12:59:52', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('231', NULL, '2070', 'Feuerwehraxt', '', '1738368000', '90113', '6', '', '19.04.2019 - 14:06:38', '', '1', '12.06.2021 - 12:59:47', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('232', NULL, '2071', 'Blechaufreißer', '', '1738368000', '90113', '6', '', '19.04.2019 - 14:10:30', '', '1', '12.06.2021 - 12:59:51', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('233', NULL, '2072', 'Astsäge', '', '1738368000', '90113', '6', '', '19.04.2019 - 14:12:48', '', '1', '12.06.2021 - 13:00:26', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('234', NULL, '2073', 'Beil', '', '1738368000', '90113', '6', '', '19.04.2019 - 14:13:15', '', '1', '12.06.2021 - 12:59:49', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('235', NULL, '2074', 'Drucklufttrommel', '', '1738368000', '90113', '8', '', '19.04.2019 - 14:14:16', '', '2', '12.06.2021 - 12:57:18', '2', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('236', NULL, '30351415', 'Handlampe Eismann EX', '', '1738368000', '90113', '8', '', '19.04.2019 - 14:15:37', '', '1', '12.06.2021 - 12:56:37', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Handlampe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('237', NULL, '30351416', 'Handlampe Eismann EX', '', '1738368000', '90113', '8', '', '19.04.2019 - 14:16:09', '', '1', '12.06.2021 - 12:56:53', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Handlampe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('238', NULL, '30348961', 'Multifunktionsleiter', '', '1738368000', '90113', 'Dach', '', '19.04.2019 - 14:18:42', '', '1', '12.06.2021 - 13:50:47', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Leitern', '20.12.2021', 'x', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('239', NULL, '30351466', 'Multifunktionsleiter', '', '1738368000', '90113', 'Dach', '', '19.04.2019 - 14:19:08', '', '1', '12.06.2021 - 13:51:07', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Leitern', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('240', NULL, '2111', 'Rohrdichtkissensatz', '', '1738368000', '90113', 'Dach', '', '19.04.2019 - 14:19:52', 'Rohrdichtkissen 10/20	\r\nRohrdichtkissen 20/40	\r\nRohrdichtkissen 30/50	\r\nRohrdichtkissen 50/120	\r\nDruckminderer 200/300bar	\r\nSchläuche	\r\nSteuerorgan	\r\n', '1', '12.06.2021 - 13:49:47', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('241', NULL, '2110', 'Schachtabdeckung', '', '1738368000', '90113', 'Dach', '', '19.04.2019 - 14:20:24', '', '1', '12.06.2021 - 13:49:55', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('242', NULL, '2109', 'Kanister 60ltr.', '', '1738368000', '90113', 'Dach', '', '19.04.2019 - 14:21:10', '60lt.', '5', '12.06.2021 - 13:44:16', '5', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstiges', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('243', NULL, '2077', 'Druckminderer', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 14:33:15', 'Rollwagen Gefahrgut1\r\n200/300bar', '1', '12.06.2021 - 14:29:40', '1', 'Bitte auswählen', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('244', NULL, '2107', 'Druckminderer', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 14:34:02', 'Rollwagen Gefahrgut 1\r\n8bar', '1', '12.06.2021 - 14:29:45', '1', 'Bitte auswählen', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('245', NULL, '2108', 'Druckluftanschluss', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 14:35:10', 'Rollwagen Gefahrgut 1\r\n2-Kreis', '1', '12.06.2021 - 14:29:50', '1', 'Bitte auswählen', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('246', NULL, '2078', 'Umfüllpumpe Zubehör', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 14:36:25', 'Rollwagen Gefahrgut 1\r\nDruckminderer, Saugschlauch, Druckschlauch\r\n', '1', '12.06.2021 - 14:17:01', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Gefahrgut', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('247', NULL, '2079', 'Umfüllpumpe', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 14:37:05', 'Rollwagen Gefahrgut 1\r\n', '1', '12.06.2021 - 14:11:39', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Gefahrgut', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('248', NULL, '2080', 'Erdungstrommel', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 14:37:37', 'Rollwagen Gefahrgut 1', '1', '12.06.2021 - 14:11:59', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Gefahrgut', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('249', NULL, '30351422', 'Leitungsroller', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 14:38:09', 'Rollwagen Gefahrgut 1\r\n400V EX', '1', '12.06.2021 - 14:29:25', '1', 'Bitte auswählen', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('250', NULL, '30351421', 'Leitungsroller', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 14:39:23', 'Rollwagen Gefahrgut 1\r\n230V EX', '1', '12.06.2021 - 14:29:18', '1', 'Bitte auswählen', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('251', NULL, '2085', 'Saugrohr', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 14:40:46', 'Rollwagen Gefahrgut 1\r\nVA', '1', '12.07.2024 - 09:08:54', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Nicht Einsatzbereit', '', '0', 'Gefahrgut', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('252', NULL, '2084', 'Saugrohr', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 14:41:20', 'Rollwagen Gefahrgut 1\r\nPE', '1', '12.06.2021 - 14:12:09', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Gefahrgut', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('253', NULL, '2083', 'Auslaufrohr', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 14:42:08', 'Rollwagen Gefahrgut 1', '1', '12.06.2021 - 14:12:12', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Gefahrgut', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('254', NULL, '2086', 'Erdungsspieß', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 14:42:41', 'Rollwagen Gefahrgut 1', '1', '12.06.2021 - 14:12:05', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Gefahrgut', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('255', NULL, '2087', 'Faltbehälter geschlossen', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 14:43:13', '1000l', '1', '12.06.2021 - 14:12:56', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Gefahrgut', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('256', NULL, '30351405', 'Fasspumpe', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 14:43:57', 'Rollwagen Gefahrgut 1', '1', '12.06.2021 - 14:12:26', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Gefahrgut', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('257', NULL, '2088', 'Multifunktionswannen', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 14:44:59', 'Rollwagen Gefahrgut 1', '2', '12.06.2021 - 14:13:04', '2', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Gefahrgut', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('258', NULL, '2089', 'Werkzeug EX', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 14:45:36', 'Inhalt:', '1', '12.06.2021 - 14:13:39', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Gefahrgut', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('259', NULL, '2090', 'Dichtungsmaterial Kasten', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 14:46:14', 'Inhalt:', '1', '12.06.2021 - 14:13:35', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verbrauchsmaterial', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('260', NULL, '2091', 'Sack Keile', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 14:47:10', '', '1', '12.06.2021 - 14:27:41', '1', 'Bitte auswählen', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verbrauchsmaterial', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('261', NULL, '2092', 'Erdungs Zubehör Kasten', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 14:47:50', 'Inhalt:', '1', '12.06.2021 - 14:13:29', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Gefahrgut', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('262', NULL, '2093', 'Rollwagen IBC Tank', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 14:48:48', 'Rollwagen IBC', '1', '12.06.2021 - 14:15:23', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Gefahrgut', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('264', NULL, '30351412', 'Strahler', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 14:52:09', 'Rollwagen Licht\r\n\r\n1000Watt', '1', '12.06.2021 - 14:31:11', '1', 'Bitte auswählen', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Beleuchtung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('265', NULL, '30351411', 'Strahler', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 14:52:16', 'Rollwagen Licht\r\n\r\n1000Watt', '1', '12.06.2021 - 14:31:05', '1', 'Bitte auswählen', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Beleuchtung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('266', NULL, '30351414', 'Strahler', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 14:53:51', 'Rollwagen Licht\r\n\r\n1000Watt', '1', '12.06.2021 - 14:19:38', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Beleuchtung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('267', NULL, '30351413', 'Strahler', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 14:54:19', 'Rollwagen Licht\r\n\r\n1000Watt', '1', '12.06.2021 - 14:18:17', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Beleuchtung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('268', NULL, '2095', 'Leitungsroller', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 14:56:06', 'Rollwagen Licht\r\n\r\n400V/230V', '2', '12.06.2021 - 14:20:04', '2', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('269', NULL, '30351433', 'Verteilerbox', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 14:58:12', 'Rollwagen Licht\r\n\r\n230V', '1', '12.06.2021 - 14:18:46', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('270', NULL, '30347125', 'Verteilerbox', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 14:59:09', 'Rollwagen Licht\r\n\r\n230V', '1', '12.06.2021 - 14:18:59', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('271', NULL, '2096', 'Stativ ', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 14:59:42', 'Rollwagen Licht\r\n\r\n', '2', '12.06.2021 - 14:17:59', '2', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Beleuchtung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('272', NULL, '2098', 'Plasmaschneider Zubehör', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 15:02:47', 'Rollwagen Licht\r\n\r\nInhalt:\r\n', '1', '12.06.2021 - 14:17:39', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('273', NULL, '2097', 'Lichtbrücke', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 15:05:40', 'Rollwagen Licht', '2', '12.06.2021 - 14:17:47', '2', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Beleuchtung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('274', NULL, '30351427', 'Plasmaschneider', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 15:06:25', 'Rollwagen Licht', '1', '12.06.2021 - 14:21:20', '1', 'Bitte auswählen', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('275', NULL, '30347123', 'Stromerzeuger', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 15:09:27', 'Rollwagen Licht\r\n\r\n5,5KvA', '1', '27.02.2020 - 17:22:00', '1', 'Bitte auswählen', '', 'NEA1252101', 'Jan Hendrik', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('276', NULL, '2099', 'Abspannseile Kiste', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 15:10:22', 'Rollwagen Licht\r\n\r\nInhalt:', '1', '12.06.2021 - 14:19:20', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('277', NULL, '30347207', 'FI-Schutzschalter', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 15:11:00', 'Rollwagen Licht', '1', '28.03.2020 - 19:42:53', '1', '', '28.03.2020', '', 'Nils', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('278', NULL, '2100', 'Rollwagen Holz', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 15:11:56', 'Inhalt:', '1', '12.06.2021 - 14:28:00', '1', 'Bitte auswählen', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('279', NULL, '2101', 'Polyethylenfolie', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 15:12:30', 'Rolle', '1', '12.06.2021 - 14:10:41', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verbrauchsmaterial', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('280', NULL, '2102', 'Bohle', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 15:13:44', 'Bohlen 50x240x2000', '8', '12.06.2021 - 14:10:32', '8', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('281', NULL, '2103', 'Kanthölzer', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 15:14:28', 'Kanthölzer 120x160x2000', '6', '12.06.2021 - 14:10:27', '6', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('282', NULL, '2104', 'Schienenplattformwagen', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 15:14:54', '', '1', '12.06.2021 - 14:10:47', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sondergerät', '20.12.2021', 'x', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('283', NULL, '2105', 'Baustützen', '', '1738368000', '90113', 'GR', '', '19.04.2019 - 15:15:23', '', '4', '12.06.2021 - 14:10:18', '4', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('284', NULL, '2106', 'Bauklammern', '', '1738368000', '90113', '4', '', '19.04.2019 - 15:15:45', '', '10', '02.07.2022 - 07:53:07', '10', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('285', NULL, '1001', 'Werkzeugkasten', '', '1737504000', '90111', '1', '', '19.04.2019 - 15:27:32', 'Inhalt: Din\r\n', '', '17.04.2025 - 19:51:39', '', '', '', '', 'Nils Bonk', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12 ', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('286', NULL, '1002', 'Formholz Kasten', '', '1737586800', '90111', '1', '', '19.04.2019 - 15:28:28', 'Inhalt:', '1', '17.09.2021 - 20:14:58', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('287', NULL, '30349739', 'Motorpumpenaggregat', '', '1738368000', '90113', '4', '', '19.04.2019 - 15:31:21', '', '1', '02.07.2022 - 07:56:35', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('288', NULL, '30349077', 'Rettungsschere', '', '1738368000', '90113', '4', '', '19.04.2019 - 15:31:48', '', '1', '02.07.2022 - 07:56:06', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('289', NULL, '30349072', 'Rettungsspreizer', '', '1738368000', '90113', '4', '', '19.04.2019 - 15:32:48', '', '1', '02.07.2022 - 07:56:18', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('290', NULL, '30349076', 'Rettungszylinder', '', '1737586800', '90111', '1', '', '19.04.2019 - 15:33:21', 'RZ2\r\n\r\nSchläuche 4/2019\r\n', '1', '17.09.2021 - 14:27:10', '1', 'Bitte auswählen', '', 'RZ1248102', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('291', NULL, '30349075', 'Rettungszylinder', '', '1737586800', '90111', '1', '', '19.04.2019 - 15:35:11', 'RZ3\r\n\r\nSchläuche 4/2019\r\n\r\n', '1', '17.09.2021 - 14:27:14', '1', 'Bitte auswählen', '', 'RZ1248103', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('292', NULL, '1003', 'Schwellerschuhe', '', '1737586800', '90111', '1', '', '19.04.2019 - 15:36:10', '', '2', '17.09.2021 - 14:38:03', '2', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('295', NULL, '1053', 'Hebekissen Set  ND', '', '1738368000', '90113', '4', '', '19.04.2019 - 15:38:40', 'Niederdruck 2x\r\n\r\n\r\nTYP 1/13', '1', '12.03.2023 - 16:03:12', '1', '', '12.03.2023', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Ausgesondert', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('296', NULL, '30349025', 'Rundschlinge', '1125525600', '1737586800', '90111', '1', '', '19.04.2019 - 15:40:26', '', '1', '22.09.2021 - 11:14:17', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('297', NULL, '30349024', 'Rundschlinge', '1125525600', '1737586800', '90111', '1', '', '19.04.2019 - 15:40:52', '', '1', '22.09.2021 - 11:14:30', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('298', NULL, '30349073', 'Pedalschneider', '', '1737586800', '90111', '1', '', '19.04.2019 - 15:42:00', 'Schlaüche 4/2011\r\n', '1', '17.09.2021 - 14:26:26', '1', 'Bitte auswählen', '', 'PK12481', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('299', NULL, '30349074', 'Rettungszylinder', '', '1737586800', '90111', '1', '', '19.04.2019 - 15:42:38', 'RZ1\r\n\r\nSchlaüche 4/2019\r\n', '1', '17.09.2021 - 14:27:16', '1', 'Bitte auswählen', '', 'RZ1248101', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('300', NULL, '30349022', 'Steuerorgan', '', '1737586800', '90111', '1', '', '19.04.2019 - 15:43:40', 'Armatur HD 8bar\r\n\r\n', '1', '17.09.2021 - 14:39:18', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('301', NULL, '30349060', 'Steuerorgan', '', '1738368000', '90113', '4', '', '19.04.2019 - 15:44:23', 'Armatur ND 1.0bar\r\n\r\n', '1', '12.03.2023 - 16:04:44', '1', '', '12.03.2023', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Ausgesondert', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('302', NULL, '30349061', 'Hebekissenschlauch', '', '1738368000', '90113', '4', '', '19.04.2019 - 15:45:40', 'ND\r\n\r\n\r\n', '1', '12.03.2023 - 16:04:08', '1', '', '12.03.2023', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Ausgesondert', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('303', NULL, '30349062', 'Hebekissenschlauch', '', '1738368000', '90113', '4', '', '19.04.2019 - 15:46:15', 'ND', '1', '12.03.2023 - 16:05:08', '1', '', '12.03.2023', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Ausgesondert', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('304', NULL, '30349023', 'Druckminderer', '', '1737586800', '90111', '1', '', '19.04.2019 - 15:47:10', '8bar\r\n\r\n', '1', '17.09.2021 - 14:37:20', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('305', NULL, '30349063', 'Druckminderer', '', '1738368000', '90113', 'Dach', '', '19.04.2019 - 15:47:39', '1bar', '1', '06.01.2022 - 14:55:01', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('306', NULL, '1016', 'Absperrband', '', '1737586800', '90111', '2', '', '19.04.2019 - 15:48:11', '', '1', '19.09.2021 - 13:48:54', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('308', NULL, '1007', 'Akku Schrauber', '', '1737586800', '90111', 'Mannschaft Hinten', '', '19.04.2019 - 15:50:19', '', '1', '10.09.2021 - 16:18:27', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('309', NULL, '30349756', 'Säbelsäge', '', '1737586800', '90111', '2', '', '19.04.2019 - 15:51:03', 'Akku\r\n', '1', '19.09.2021 - 14:18:29', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('310', NULL, '30349020', 'Hebekissen HD', '', '1737586800', '90111', '1', '', '19.04.2019 - 15:51:55', 'HD groß\r\n\r\n', '1', '17.09.2021 - 14:35:40', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('311', NULL, '30349019', 'Hebekissen HD', '', '1737586800', '90111', '1', '', '19.04.2019 - 15:52:29', 'HD mittel\r\n', '1', '17.09.2021 - 14:36:38', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('312', NULL, '30349021', 'Hebekissen HD', '', '1737586800', '90111', '1', '', '19.04.2019 - 15:53:03', 'HD klein\r\n\r\n', '1', '17.09.2021 - 14:35:46', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('313', NULL, '1013', 'Schlauchtragekorb', '', '1737586800', '90111', '6', '', '19.04.2019 - 15:53:49', '', '5', '18.09.2021 - 13:24:54', '5', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('314', NULL, '1006', 'Airbagkralle', '', '1737586800', '90111', '1', '', '19.04.2019 - 15:55:23', '', '1', '17.09.2021 - 14:38:22', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('315', NULL, '1012', 'Hohlstrahlrohr C', '', '1737586800', '90111', '6', '', '19.04.2019 - 15:58:05', '', '3', '28.09.2021 - 10:18:35', '3', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserabgabe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('318', NULL, '1009', 'Verkehrsunfallkasten', '', '1737586800', '90111', '1', '', '19.04.2019 - 16:00:01', '', '1', '17.09.2021 - 20:08:22', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('319', NULL, '1010', 'Ziehfix', '', '1737586800', '90111', 'Mannschaft Hinten', '', '19.04.2019 - 16:00:37', '', '1', '23.09.2021 - 09:52:12', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('320', NULL, '1011', 'Türöffnung Rucksack', '', '1737586800', '90111', 'Mannschaft Hinten', '', '19.04.2019 - 16:01:06', '', '1', '23.09.2021 - 09:52:02', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('321', NULL, '1054', 'Atemanschluss', '', '1642633200', '90111', 'Mannschaft Hinten', '', '19.04.2019 - 16:01:33', '', '4', '02.07.2022 - 08:04:30', '4', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('322', NULL, '1055', 'Druckschlauch C', '978303600', '1737586800', '90111', '5', '', '19.04.2019 - 16:02:20', 'Druckschlauch C', '4', '20.01.2024 - 19:50:30', '4', '', '', '', 'Nils Bonk', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('323', NULL, '1015', 'Verteiler B/B/C/B/C', '', '1737586800', '90111', 'Traversenkasten Links', '', '19.04.2019 - 16:03:06', '', '1', '17.09.2021 - 19:52:07', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('324', NULL, '1017', 'Hydroschild', '', '1737586800', '90111', '4', '', '19.04.2019 - 16:03:57', '', '1', '18.09.2021 - 13:54:34', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserabgabe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('325', NULL, '1018', 'Übergangsstück', '', '1737586800', '90111', 'GR', '', '19.04.2019 - 16:04:50', 'C/B\r\n\r\n', '2', '17.09.2021 - 10:55:46', '2', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('326', NULL, '1056', 'Pressluftflaschen', '', '1642633200', '90111', '4', '', '19.04.2019 - 16:05:33', '', '4', '21.01.2022 - 14:56:36', '4', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('328', NULL, '1020', 'Seilschlauchhalter', '1744934400', '1746144000', '90110', '2', '', '19.04.2019 - 16:06:55', 'Topteil 1', '2', '17.04.2025 - 20:05:49', '2', '', '', 'qrewer', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', '', '20.12.2021', '', '', 'A2BZ', '123465', '12', '', '', '0', '#hlf #test', '', '');
INSERT INTO `ffw_geraete` VALUES ('329', NULL, '1021', 'Faltleitkegel', '', '1737586800', '90111', '2', '', '19.04.2019 - 16:07:22', '', '4', '29.06.2022 - 15:51:38', '4', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('330', NULL, '1022', 'Einmaldecke', '', '1737586800', '90111', '2', '', '19.04.2019 - 16:07:38', '', '4', '23.09.2021 - 10:15:21', '4', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Erste Hilfe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('331', NULL, '1019', 'Druckbegrenzungsventil', '', '1737586800', '90111', 'GR', '', '19.04.2019 - 16:08:40', '', '1', '17.09.2021 - 10:58:27', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('332', NULL, '1058', 'Druckschlauch B', '', '1737586800', '90111', '5', '', '19.04.2019 - 16:09:14', '8 Schläuche auf Haspel\r\n2 in Traversenkasten', '14', '18.09.2021 - 13:07:23', '14', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('333', NULL, '1046', 'Abgasschlauch groß', '', '1737586800', '90111', 'GR', '', '19.04.2019 - 16:10:59', '', '1', '10.09.2021 - 16:18:23', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('334', NULL, '1047', 'Stativ', '', '1737586800', '90111', '2', '', '19.04.2019 - 16:12:53', '', '1', '24.09.2021 - 15:07:47', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Beleuchtung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('335', NULL, '1049', 'Schachthaken', '', '1737586800', '90111', '4', '', '19.04.2019 - 16:13:50', '', '1', '18.09.2021 - 13:51:50', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.02.2024', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('336', NULL, '1048', 'Schornsteinfegerset', '', '1737586800', '90111', '5', '', '19.04.2019 - 16:14:52', '', '1', '17.09.2021 - 14:20:24', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('337', NULL, '30349737', 'Stromerzeuger', '', '1733526000', '50001', '------', '', '19.04.2019 - 16:15:36', 'Stromerzeuger 8,3 kV\r\n\r\nRollwagen Strom', '1', '20.01.2025 - 12:23:28', '1', '', '', 'NEA1248101', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('338', NULL, '1059', 'Fahrzeugstabilisierungssystem', '', '1737586800', '90111', '1', '', '19.04.2019 - 16:16:34', 'FSS 1248101\r\nFSS 1248102\r\nFSS 1248103\r\n\r\nBewegliche Teile mit Silikonspray behandeln\r\n(vierteljährlich)\r\n\r\n', '3', '17.09.2021 - 14:23:39', '3', 'Bitte auswählen', '', 'FSS1248101', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('339', NULL, '30350259', 'Schleifkorbtrage', '', '1721253600', '90110', 'Dach', '', '19.04.2019 - 16:17:18', '', '1', '08.06.2023 - 20:33:38', '1', '', '', 'Rett2124', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sanitätsgerät', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('343', NULL, '1051', 'Ansaugschlauch D/D', '', '1737586800', '90111', '6', '', '19.04.2019 - 16:20:57', '', '1', '18.09.2021 - 13:39:25', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserführend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('344', NULL, '1045', 'Leitungsroller', '', '1737586800', '90111', '2', '', '19.04.2019 - 16:21:31', '', '2', '19.09.2021 - 14:03:01', '2', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('345', NULL, '30350249', 'Motorkettensäge', '1325372400', '1737586800', '90111', '3', '', '19.04.2019 - 16:26:47', 'Stihl MS 441/C\r\n\r\nKetten Nr.\r\nBestell Nr. 3626 000 0060\r\n            36RS3      60\r\n\r\n40cm Schwert\r\n\r\n', '1', '04.03.2022 - 15:44:55', '1', '', '', 'MO2107', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Säge Equipment', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('351', NULL, '1044', 'Strahler mit Tragegestell', '', '1737586800', '90111', '2', '', '19.04.2019 - 16:36:02', '', '1', '19.09.2021 - 13:58:55', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Beleuchtung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('352', NULL, '1050', 'Ansaugschlauch', '', '1737586800', '90111', 'Traversenkasten Rechts', '', '19.04.2019 - 16:36:41', 'Saugschlauch D', '1', '19.09.2021 - 14:00:18', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('355', NULL, '1040', 'Multifunktionswanne', '', '1737586800', '90111', '1', '', '19.04.2019 - 16:38:16', '75ltr.', '1', '17.09.2021 - 20:09:53', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('356', NULL, '1041', 'Stab Pack', '', '1737586800', '90111', '1', '', '19.04.2019 - 16:38:56', '', '2', '23.01.2025 - 09:34:36', '2', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Bedingt Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('358', NULL, '1042', 'Stützkrümmer B', '', '1737586800', '90111', '6', '', '19.04.2019 - 16:39:56', '', '1', '28.09.2021 - 10:17:38', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserabgabe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('359', NULL, '1035', 'Zumischer Z4', '', '1737586800', '90111', '6', '', '19.04.2019 - 16:40:24', '', '1', '18.09.2021 - 13:09:16', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('360', NULL, '1038', 'Lafette', '', '1737586800', '90111', '4', '', '19.04.2019 - 16:41:01', '', '1', '18.09.2021 - 13:46:56', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstiges', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('361', NULL, '1037', 'Wasserwerfer', '', '1737586800', '90111', '4', '', '19.04.2019 - 16:41:42', '', '1', '18.09.2021 - 13:46:15', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserabgabe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('362', NULL, '30349068', 'Schäkel', '', '1737586800', '90111', '1', '', '19.04.2019 - 16:42:41', '', '1', '22.09.2021 - 11:14:48', '1', 'Bitte auswählen', '', 'SCHÄ1248105', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('363', NULL, '30349070', 'Schäkel', '', '1737586800', '90111', '1', '', '19.04.2019 - 16:43:23', '', '1', '22.09.2021 - 11:14:50', '1', 'Bitte auswählen', '', 'SCHÄ1248107', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('365', NULL, '30349065', 'Schäkel', '', '1737586800', '90111', '1', '', '19.04.2019 - 16:44:16', '', '1', '22.09.2021 - 11:15:30', '1', 'Bitte auswählen', '', 'SCHÄ1248102', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('367', NULL, '30349069', 'Schäkel', '', '1737586800', '90111', '1', '', '19.04.2019 - 17:18:27', '', '1', '22.09.2021 - 11:15:34', '1', 'Bitte auswählen', '', 'SCHÄ1248106', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('368', NULL, '30349067', 'Schäkel', '', '1737586800', '90111', '1', '', '19.04.2019 - 17:19:47', '', '1', '22.09.2021 - 11:16:11', '1', 'Bitte auswählen', '', 'SCHÄ1248104', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('369', NULL, '1036', 'Kupplungsschlüssel', '', '1737586800', '90111', 'GR', '', '19.04.2019 - 17:21:10', '', '1', '17.09.2021 - 19:51:27', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('371', NULL, '1033', 'Überflurhydrantenschlüssel', '', '1737586800', '90111', 'GR', '', '19.04.2019 - 17:25:17', '', '1', '17.09.2021 - 19:45:24', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('372', NULL, '1032', 'Kappenheber', '', '1737586800', '90111', 'GR', '', '19.04.2019 - 17:25:42', '', '1', '17.09.2021 - 19:48:59', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('373', NULL, '1031', 'Hammer', '', '1737586800', '90111', 'GR', '', '19.04.2019 - 17:26:14', '', '1', '17.09.2021 - 19:45:49', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('374', NULL, '1030', 'Schlauchpaket', '', '1737586800', '90111', '4', '', '19.04.2019 - 17:26:51', '', '1', '18.09.2021 - 13:56:04', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('375', NULL, '1029', 'Feuerwehraxt', '', '1737586800', '90111', '2', '', '19.04.2019 - 17:45:44', '', '2', '02.07.2022 - 08:03:26', '2', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('376', NULL, '1075', 'Saugschlauch', '', '1737586800', '90111', 'Dach', '', '19.04.2019 - 17:49:09', 'Saugschlauch A', '4', '19.09.2021 - 14:10:49', '4', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('378', NULL, '1073', 'Kanister 10l', '', '1737586800', '90111', '3', '', '19.04.2019 - 17:53:00', '', '1', '17.09.2021 - 14:01:19', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstiges', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('379', NULL, '1076', 'Saugkorb', '', '1737586800', '90111', 'Dach', '', '19.04.2019 - 17:54:11', '', '1', '02.07.2022 - 08:05:05', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserentnahme', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('380', NULL, '1074', 'Übergangsstück ', '', '1737586800', '90111', 'GR', '', '19.04.2019 - 17:55:15', 'Übergangsstück A>B\r\n', '1', '17.09.2021 - 10:55:48', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('381', NULL, '1071', 'Absperrorgan B', '', '1737586800', '90111', 'GR', '', '19.04.2019 - 17:56:28', 'B\r\n\r\n\r\n', '1', '17.09.2021 - 10:57:28', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('382', NULL, '1072', 'Astsäge', '', '1737586800', '90111', '2', '', '19.04.2019 - 17:56:54', '', '1', '19.09.2021 - 15:03:51', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Säge Equipment', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('383', NULL, '30349755', 'Akku Strahler', '', '1737586800', '90111', '4', '', '19.04.2019 - 16:20:15', '', '1', '18.09.2021 - 14:08:12', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Beleuchtung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('384', NULL, '4961457', 'Mehrgasmessgerät', '', '1737586800', '90111', 'Mannschaft Vorne', '', '19.04.2019 - 17:58:12', 'ch4  Methan\r\nO2   Sauerstoff\r\nCo2  Kohlenstoffdioxid \r\nCO   Kohlenstoffmonoxid \r\n\r\n\r\nIm November kommt Dräger\r\n\r\n', '1', '22.01.2025 - 16:17:35', '1', '', '', 'MEß2104', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Nicht Einsatzbereit', '', '0', 'Gefahrgut', '16.08.2022', '', '', 'A2BZ', '', '1', '', 'x', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('389', NULL, '30348001', 'Handlampe Adalit ', '', '1737586800', '90111', 'Mannschaft Hinten', '', '19.04.2019 - 18:09:07', '', '1', '23.09.2021 - 09:43:38', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Handlampe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('390', NULL, '30348000', 'Handlampe Adalit ', '', '1737586800', '90111', 'Mannschaft Hinten', '', '19.04.2019 - 18:09:33', '', '1', '23.09.2021 - 09:44:23', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Handlampe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('391', NULL, '30347999', 'Handlampe Adalit ', '', '1737586800', '90111', 'Mannschaft Hinten', '', '19.04.2019 - 18:10:03', '', '1', '23.09.2021 - 09:44:27', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Handlampe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('392', NULL, '1081', 'Fahrtenbuch', '', '1737586800', '90111', 'Mannschaft Vorne', '', '19.04.2019 - 18:11:46', '', '1', '23.09.2021 - 09:40:25', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('394', NULL, '30350143', 'Anhaltestab', '', '1737586800', '90111', 'Mannschaft Vorne', '', '19.04.2019 - 18:12:50', '', '1', '23.09.2021 - 10:32:13', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('395', NULL, '1064', 'Funkverzeichnis', '', '1737586800', '90111', 'Mannschaft Vorne', '', '19.04.2019 - 18:13:23', '', '1', '23.09.2021 - 09:43:13', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('396', NULL, '1079', 'Fahrzeugführerweste', '', '1737586800', '90111', 'Mannschaft Vorne', '', '19.04.2019 - 18:13:50', '', '1', '23.09.2021 - 09:40:28', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('397', NULL, '1080', 'Fahrstuhlschlüssel', '', '1737586800', '90111', 'Mannschaft Vorne', '', '19.04.2019 - 18:14:25', '', '1', '23.09.2021 - 09:40:21', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('405', NULL, '30350193', 'Spineboard', '', '1737586800', '90111', '2', '', '19.04.2019 - 18:20:15', '', '1', '23.01.2025 - 09:40:27', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Nicht Einsatzbereit', '', '0', 'Sanitätsgerät', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('407', NULL, '1060', 'Kübelspritze', '', '1705705200', '90111', '4', '', '19.04.2019 - 18:22:00', '', '1', '23.05.2024 - 10:27:45', '1', '', '', 'KÜB12481', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerlöscher', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('408', NULL, '1062', 'Bügelsäge', '', '1737586800', '90111', '2', '', '19.04.2019 - 18:22:36', '', '1', '19.09.2021 - 14:01:59', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('409', NULL, '1082', 'Bolzenschneider', '', '1737586800', '90111', '2', '', '19.04.2019 - 18:23:08', 'groß\r\n\r\nGerät ist bei Schlingmann', '1', '17.10.2021 - 12:32:05', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('412', NULL, '1085', 'Rohrzange', '', '1737586800', '90111', '2', '', '19.04.2019 - 18:30:05', '', '2', '22.09.2021 - 11:17:11', '2', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('413', NULL, '1063', 'Warnweste', '', '1737586800', '90111', 'Mannschaft Hinten', '', '19.04.2019 - 18:31:19', '', '5', '25.09.2021 - 11:54:05', '4', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Schutzkleidung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('414', NULL, '1086', 'Stiel für Astsäge', '', '1737586800', '90111', '2', '', '19.04.2019 - 18:31:51', '', '1', '19.09.2021 - 15:05:35', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Säge Equipment', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('415', NULL, '30350295', 'Hitzeschutz', '', '1737586800', '90111', '4', '', '19.04.2019 - 18:32:29', 'Haube+Handschuhe', '1', '18.09.2021 - 14:06:42', '1', 'Bitte auswählen', '', 'Hiz2121', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Schutzkleidung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('417', NULL, '1061', 'Zubehör Spineboard', '', '1737586800', '90111', '2', '', '19.04.2019 - 18:33:48', '', '1', '23.01.2025 - 09:40:37', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Nicht Einsatzbereit', '', '0', 'Rettungsgerät', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('419', NULL, '30350294', 'Tragetuch', '', '1737586800', '90111', 'Mannschaft Hinten', '', '19.04.2019 - 18:35:28', '', '1', '23.09.2021 - 09:50:39', '1', 'Bitte auswählen', '', 'Rett2115', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sanitätsgerät', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('423', NULL, '30350195', 'Steckleiterteil', '', '1737586800', '90111', 'Dach', '', '19.04.2019 - 18:53:12', '', '1', '18.09.2021 - 13:49:02', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Leitern', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('424', NULL, '30350256', 'Steckleiterteil', '', '1737586800', '90111', 'Dach', '', '19.04.2019 - 18:53:34', '', '1', '18.09.2021 - 13:49:45', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Leitern', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('425', NULL, '30350196', 'Steckleiterteil', '', '1737586800', '90111', 'Dach', '', '19.04.2019 - 18:53:57', '', '1', '18.09.2021 - 13:49:04', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Leitern', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('426', NULL, '30350255', 'Steckleiterteil', '', '1737586800', '90111', 'Dach', '', '19.04.2019 - 18:55:27', '', '1', '18.09.2021 - 13:49:10', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Leitern', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('427', NULL, '30350254', 'Schiebleiter', '', '1737586800', '90111', 'Dach', '', '19.04.2019 - 18:55:47', '', '1', '19.09.2021 - 14:11:28', '1', 'Bitte auswählen', '', 'LEITER2118', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Leitern', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('429', NULL, '1089', 'Kombischaumrohr S4/M4', '', '1737586800', '90111', '6', '', '19.04.2019 - 18:57:04', '', '1', '18.09.2021 - 13:28:32', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserabgabe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('430', NULL, '1090', 'Abgasschlauch groß', '', '1737586800', '90111', 'GR', '', '19.04.2019 - 18:57:25', '', '1', '17.09.2021 - 20:39:05', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('431', NULL, '1091', 'Spaten', '', '1737586800', '90111', '1', '', '19.04.2019 - 18:57:56', '', '2', '02.07.2022 - 08:05:21', '2', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('432', NULL, '1092', 'Forke', '', '1737586800', '90111', '2', '', '19.04.2019 - 18:58:28', '', '2', '22.09.2021 - 11:20:12', '2', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('433', NULL, '1093', 'Dunggabel', '', '1737586800', '90111', '2', '', '19.04.2019 - 18:58:54', '', '1', '22.09.2021 - 11:17:18', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('434', NULL, '1094', 'Schlauchbrücke', '', '1737586800', '90111', 'Dach', '', '19.04.2019 - 18:59:26', '', '3', '22.09.2021 - 11:17:21', '3', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('435', NULL, '1095', 'Feuerpatsche', '', '1737586800', '90111', '2', '', '19.04.2019 - 19:01:10', '', '2', '22.09.2021 - 11:19:37', '2', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('436', NULL, '1096', 'Stoßbesen', '', '1737586800', '90111', '2', '', '19.04.2019 - 19:01:53', '', '2', '19.09.2021 - 13:57:13', '2', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('437', NULL, '1097', 'Sandschaufel', '', '1737586800', '90111', '2', '', '19.04.2019 - 19:02:58', '', '2', '22.09.2021 - 11:20:00', '2', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('439', NULL, '30350258', 'Steckleiter-Verbindungsteil ', '', '1721253600', '90110', 'Dach', '', '19.04.2019 - 19:04:40', 'Verbindungsteil Steckleiter', '1', '08.06.2023 - 20:45:02', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Leitern', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('440', NULL, '30350191', 'Wathose', '', '1737586800', '90111', '5', '', '19.04.2019 - 19:05:12', '', '1', '17.09.2021 - 14:22:12', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Schutzkleidung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('441', NULL, '30350192', 'Wathose', '', '1737586800', '90111', '5', '', '19.04.2019 - 19:05:36', '', '1', '17.09.2021 - 14:22:32', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Schutzkleidung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('442', NULL, '1098', 'Mittelschaumpistole', '', '1737586800', '90111', '6', '', '19.04.2019 - 19:06:12', '', '1', '18.09.2021 - 13:16:19', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstiges', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('443', NULL, '1099', 'Spalthammer', '', '1737586800', '90111', '2', '', '19.04.2019 - 19:06:39', '', '1', '19.09.2021 - 15:08:33', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('444', NULL, '2112', 'Funkgerät HRT', '', '1738368000', '90113', 'Mannschaft Vorne', '', '22.04.2019 - 11:11:54', 'Sepura HRT', '1', '27.09.2021 - 14:04:37', '1', 'Bitte auswählen', '', '12-52-1-1', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '02.12.2022', '', '6224886', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('445', NULL, '2094', 'Gefahrgutschläuche', '', '1738368000', '90113', 'GR', '', '23.04.2019 - 12:42:57', '', '4', '12.06.2021 - 14:15:32', '4', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Gefahrgut', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('446', NULL, '2033', 'Eimer', '', '1738368000', '90113', 'Traversenkasten Links', '', '10.05.2019 - 16:36:11', '', '3', '12.06.2021 - 13:43:44', '3', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('447', NULL, '2075', 'Bindemittel', '', '1738368000', '90113', 'Traversenkasten Rechts', '', '10.05.2019 - 16:37:44', '', '3', '12.06.2021 - 12:56:20', '3', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('448', NULL, '2076', 'Unterlegkeil', '', '1738368000', '90113', 'Traversenkasten Rechts', '', '10.05.2019 - 16:38:19', '', '2', '12.06.2021 - 14:09:32', '2', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('450', NULL, '1028', 'Hydrantenschlüssel', '', '1737586800', '90111', 'GR', '', '10.05.2019 - 16:40:14', '', '1', '17.09.2021 - 19:42:07', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('452', NULL, '1023', 'Bindemittel', '', '1737586800', '90111', '1', '', '10.05.2019 - 16:41:46', '', '1', '10.09.2021 - 16:18:41', '1', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('453', NULL, '1024', 'Mulde', '', '1737586800', '90111', '1', '', '10.05.2019 - 16:42:20', '', '3', '17.09.2021 - 20:06:11', '3', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('467', NULL, '30351469', 'Kombi Kanister', '1414796400', '1738368000', '90113', '6', '', '09.07.2019 - 17:41:37', '', '1', '12.06.2021 - 13:09:17', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Ausgesondert', '01.11.2019', '0', 'Säge Equipment', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('468', NULL, '2116', 'Halligan-Tool', '1554156000', '1738368000', '90113', '6', '', '09.07.2019 - 17:44:03', '', '1', '12.06.2021 - 12:57:48', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('469', NULL, '2113', 'Verbandkasten', '1512082800', '1738368000', '90113', 'Mannschaft Vorne', '', '09.07.2019 - 17:56:20', 'KFZ Verbandkasten', '1', '12.06.2021 - 13:53:03', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.12.2022', '0', 'Erste Hilfe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('470', NULL, '3001', 'Brandfluchthaube', '1383260400', '1529964000', '90110', '1', '', '17.07.2019 - 12:32:35', 'MSA S-Cap\r\n\r\n\r\n\r\n', '1', '08.06.2023 - 20:19:15', '1', '', '', 'A2BZFL01', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('471', NULL, '3002', 'Brandfluchthaube', '1383260400', '1529964000', '90110', '1', 'DIN EN 403:2004-08', '17.07.2019 - 12:34:03', 'MSA C-Cap\r\n', '1', '08.06.2023 - 20:19:19', '1', '', '', 'A2BZFL02', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('472', NULL, '3003', 'Brandfluchthaube', '1383260400', '1529964000', '90110', '1', 'DIN EN 403:2004-08', '17.07.2019 - 12:35:59', 'MSA C-Cap\r\n\r\n', '1', '12.06.2021 - 11:32:09', '1', '', '', 'A2BZFL03', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('473', NULL, '3004', 'Brandfluchthaube', '1383260400', '1529964000', '90110', '1', '', '17.07.2019 - 12:37:34', 'MSA C-Cap\r\n\r\n', '1', '08.06.2023 - 20:19:29', '1', '', '', 'A2BZFL04', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('474', NULL, '3005', 'Brandfluchthaube', '1383260400', '1529964000', '90110', '1', 'DIN EN 403:2004-08', '17.07.2019 - 12:39:02', 'MSA C-Cap\r\n\r\n', '1', '08.06.2023 - 20:19:25', '1', '', '', 'A2BZFL05', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('475', NULL, '3006', 'Brandfluchthaube', '1383260400', '1529964000', '90110', '1', 'DIN EN 403:2004-08', '17.07.2019 - 12:40:33', 'MSA C-Cap\r\n\r\n', '1', '08.06.2023 - 20:19:36', '1', '', '', 'A2BZFL06', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('476', NULL, '3007', 'Brandfluchthaube', '1383260400', '1529964000', '90110', '1', 'DIN EN 403:2004-08', '17.07.2019 - 12:42:03', 'MSA C-Cap\r\n\r\n', '1', '08.06.2023 - 20:19:43', '1', '', '', 'A2BZFL07', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('477', NULL, '3008', 'Brandfluchthaube', '1383260400', '1529964000', '90110', '1', 'DIN EN 403:2004-08', '17.07.2019 - 12:43:31', 'MSA C-Cap\r\n\r\n', '1', '08.06.2023 - 20:19:47', '1', '', '', 'A2BZFL08', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('478', NULL, '3009', 'Brandfluchthaube', '1383260400', '1529964000', '90110', 'Mannschaft Hinten', 'DIN EN 403:2004-08', '17.07.2019 - 12:46:08', 'MSA C-Cap\r\n\r\n', '1', '08.06.2023 - 20:50:33', '1', '', '', 'A2BZFL19', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('479', NULL, '3010', 'Brandfluchthaube', '1383260400', '1529964000', '90110', 'Mannschaft Hinten', 'DIN EN 403:2004-08', '17.07.2019 - 12:47:27', 'MSA C-Cap\r\n\r\n', '1', '08.06.2023 - 20:50:37', '1', '', '', 'A2BZFL13', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('480', NULL, '3011', 'Brandfluchthaube', '1383260400', '1529964000', '90110', 'Mannschaft Hinten', 'DIN EN 403:2004-08', '17.07.2019 - 12:48:50', 'MSA C-Cap\r\n\r\n', '1', '08.06.2023 - 20:50:41', '1', '', '', 'A2BZFL46', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('484', NULL, '30346520', 'Kübelspritze', '', '1720908000', '90110', '5', '', '17.07.2019 - 13:05:57', '', '1', '23.05.2024 - 10:28:51', '1', '', '', 'KÜB12231', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerlöscher', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('485', NULL, '3012', 'Handlampe HS 4 Ex ', '', '1721253600', '90110', 'Mannschaft Hinten', '', '17.07.2019 - 13:23:55', 'HS 4 Ex', '1', '12.06.2021 - 10:57:28', '1', '', '01.04.2020', 'HA122301', 'Jan Hendrik', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Handlampe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('486', NULL, '3013', 'Handlampe Halo 4 Ex ', '', '1721253600', '90110', 'Mannschaft Hinten', '', '17.07.2019 - 13:26:12', '', '1', '08.06.2023 - 20:50:45', '1', '', '', 'HA122303', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Handlampe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('487', NULL, '3014', 'Handlampe HS 4 EX', '', '1721253600', '90110', 'Mannschaft Hinten', '', '17.07.2019 - 13:27:19', '', '1', '08.06.2023 - 20:50:54', '1', '', '', 'HA122304', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Handlampe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('488', NULL, '3015', 'Handlampe Adalit ', '', '1721253600', '90110', 'Mannschaft Vorne', 'DIN 14649:2018-03', '17.07.2019 - 13:30:38', 'Lampe war zur Überprüfung auf der TZ\r\nLampe wurde eingeschickt und ist nicht zu reparieren. Rücksprache mit Tim am 21.10.2019 er spricht mit Andrea und kümmert sich um Ersatz, zu dem soll auch die andere Adalit 2000 ersetzt werden.', '1', '06.11.2019 - 19:52:50', '1', '', '', 'HA122302', 'Jan Hendrik', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Handlampe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('489', NULL, '3016', 'Handlampe Adalit ', '1388530800', '1721253600', '90110', 'Mannschaft Hinten', 'DIN 14649:2018-03', '17.07.2019 - 13:33:06', '', '1', '08.06.2023 - 20:51:24', '1', '', '', 'HA122305', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Handlampe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('490', NULL, '3017', 'Handlampe Adalit', '', '1721253600', '90110', 'Mannschaft Hinten', '', '17.07.2019 - 13:35:10', '', '1', '24.09.2023 - 09:13:19', '1', '', '', 'HA122306', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Handlampe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('491', NULL, '30353847', 'Handlampe Adalit ', '1546297200', '1721253600', '90110', 'Mannschaft Vorne', '', '17.07.2019 - 13:40:26', '', '1', '08.06.2023 - 20:53:26', '1', '', '', 'HA122307', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Handlampe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('492', NULL, '3018', 'Akku Strahler', '', '1721253600', '90110', '1', '', '17.07.2019 - 13:50:22', '', '1', '08.06.2023 - 20:19:51', '1', '', '', 'LED122301', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Beleuchtung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('493', NULL, '3021', 'Solarblitz', '', '1721253600', '90110', '2', 'EN 12352', '17.07.2019 - 13:58:00', '', '1', '08.06.2023 - 20:23:44', '1', '', '', 'BLIZ122303', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('494', NULL, '3020', 'Solarblitz', '', '1721253600', '90110', '2', 'EN 12352', '17.07.2019 - 13:58:34', '', '1', '08.06.2023 - 20:23:48', '1', '', '', 'BLIZ122302', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('495', NULL, '3019', 'Solarblitz', '', '1721253600', '90110', '2', 'EN 12352', '17.07.2019 - 13:59:05', '', '1', '08.06.2023 - 20:23:51', '1', '', '', 'BLIZ122301', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('497', NULL, '1100', 'Abwassertauchpumpe ATP 10', '1546297200', '1737586800', '90111', '5', '', '22.07.2019 - 13:27:48', 'Mast ATP 10\r\n', '1', '17.09.2021 - 14:13:18', '1', '', '', 'ATP124811', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('499', NULL, '3022', 'Bindemittel', '', '1721253600', '90110', '1', '', '28.07.2019 - 20:43:34', '', '1', '08.06.2023 - 20:19:55', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('500', NULL, '3023', 'Stativ', '', '1721253600', '90110', '1', ' DIN 14640', '28.07.2019 - 20:44:29', '', '1', '08.06.2023 - 20:20:00', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Beleuchtung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('501', NULL, '3024', 'Hygienekiste', '', '1721253600', '90110', '1', '', '28.07.2019 - 20:45:56', 'Inhalt: Müllsäcke, Disinfektionsmittel, Grobreinigungsset', '1', '08.06.2023 - 20:20:03', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('502', NULL, '3025', 'Abspannseile ', '', '1721253600', '90110', '1', '', '28.07.2019 - 20:46:49', '', '1', '08.06.2023 - 20:20:08', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('503', NULL, '3026', 'Hitzeschutz', '', '1721253600', '90110', '1', '', '28.07.2019 - 20:48:19', 'Kiste mit 4 Paar Hitzeschutzhandschuhe und 5 Hitzeschutzhauben', '1', '08.06.2023 - 20:20:50', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Schutzkleidung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('504', NULL, '3027', 'Pressluftflaschen', '', '1627250400', '90110', '3', '', '28.07.2019 - 20:49:39', '', '4', '08.06.2023 - 20:24:06', '4', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('506', NULL, '3029', 'Atemanschluss', '', '1627250400', '90110', '3', 'DIN EN 136:1998-04', '28.07.2019 - 20:51:01', '', '2', '08.06.2023 - 20:24:10', '2', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('507', NULL, '3030', 'Hitzeschutzanzug', '', '1721253600', '90110', '3', '', '28.07.2019 - 20:51:52', '', '2', '08.06.2023 - 20:24:14', '2', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Schutzkleidung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('508', NULL, '3031', 'Notfallrucksack', '', '1721253600', '90110', '3', '', '28.07.2019 - 20:52:22', '', '1', '08.06.2023 - 20:24:19', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Erste Hilfe', '20.12.2021', 'x', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('510', NULL, '3033', 'Übergangsstück', '', '1721253600', '90110', '5', '', '03.08.2019 - 11:57:36', 'Übergangsstück B>C', '3', '08.06.2023 - 20:28:08', '3', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('511', NULL, '3034', 'Kugelhahnverteiler', '', '1721253600', '90110', 'GR', '', '03.08.2019 - 11:58:48', 'B/ CBC', '1', '08.06.2023 - 20:45:45', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('512', NULL, '3035', 'Hydroschild', '', '1721253600', '90110', '5', '', '03.08.2019 - 12:00:29', '', '1', '08.06.2023 - 20:25:12', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserabgabe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('513', NULL, '3036', 'Druckbegrenzungsventil', '', '1721253600', '90110', '5', '', '03.08.2019 - 12:01:44', '', '1', '08.06.2023 - 20:25:16', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('514', NULL, '3037', 'Übergangsstück', '', '1721253600', '90110', '5', '', '03.08.2019 - 12:03:36', 'Übergangsstück C>D', '1', '08.06.2023 - 20:25:20', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('515', NULL, '3038', 'Schaummittel', '', '1721253600', '90110', '5', '', '03.08.2019 - 12:05:51', '20ltr.', '6', '08.06.2023 - 20:25:24', '6', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('516', NULL, '3039', 'Zumischer Z4', '', '1721253600', '90110', '5', '', '03.08.2019 - 12:06:37', '', '1', '08.06.2023 - 20:25:29', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('517', NULL, '3040', 'Ansaugschlauch', '', '1721253600', '90110', '5', 'DIN EN 16712-2:2015-12', '03.08.2019 - 12:07:44', 'Saugschlauch D', '1', '08.06.2023 - 20:25:32', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('518', NULL, '3041', 'Mittelschaumrohr M4', '', '1721253600', '90110', '5', '', '03.08.2019 - 12:08:26', '', '1', '08.06.2023 - 20:25:37', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserabgabe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('519', NULL, '3042', 'Schlauchmanschette', '', '1721253600', '90110', '5', '', '03.08.2019 - 12:10:29', '3 Größe C\r\n3 Größe B', '10', '08.06.2023 - 20:25:41', '10', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('520', NULL, '3043', 'Mulde', '', '1721253600', '90110', '5', 'DIN 14060:2012-09', '03.08.2019 - 12:11:32', '', '1', '08.06.2023 - 20:25:45', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('521', NULL, '3044', 'Stoßbesen', '', '1721253600', '90110', '5', '', '03.08.2019 - 12:12:35', '', '1', '08.06.2023 - 20:26:30', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('522', NULL, '3045', 'Stechschaufel', '', '1721253600', '90110', '5', '', '03.08.2019 - 12:13:26', '', '2', '08.06.2023 - 20:26:35', '2', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('523', NULL, '3046', 'Dunggabel', '', '1721253600', '90110', '5', '', '03.08.2019 - 12:14:01', '', '2', '08.06.2023 - 20:26:39', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('524', NULL, '3047', 'Kreuzhacke', '', '1721253600', '90110', '5', 'DIN 20109:1990-06', '03.08.2019 - 12:14:41', '', '1', '08.06.2023 - 20:26:59', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('525', NULL, '3048', 'Brechstange', '', '1721253600', '90110', '5', '', '03.08.2019 - 12:15:41', 'Brechstange lang 1,80mtr.', '1', '08.06.2023 - 20:27:03', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('526', NULL, '3049', 'Forke', '', '1721253600', '90110', '5', '', '03.08.2019 - 12:16:53', '', '2', '08.06.2023 - 20:27:08', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('527', NULL, '3050', 'Mehrzweckstrahlrohr D', '', '1721253600', '90110', '5', 'DIN EN 15182-3:2010-04', '03.08.2019 - 12:17:45', '', '1', '08.06.2023 - 20:27:11', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserabgabe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('528', NULL, '3051', 'Holzaxt', '', '1721253600', '90110', '5', 'DIN 7294:2014-01', '03.08.2019 - 12:18:40', '', '1', '08.06.2023 - 20:27:15', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('529', NULL, '3052', 'Vorschlaghammer', '', '1721253600', '90110', '5', '', '03.08.2019 - 12:19:20', '', '1', '09.06.2023 - 16:57:12', '0', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Nicht Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('530', NULL, '3053', 'Verteiler', '', '1721253600', '90110', 'Traversenkasten Links', 'DIN 14345:2012-05', '03.08.2019 - 12:49:09', 'B/ CBC', '1', '08.06.2023 - 20:53:36', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('531', NULL, '3054', 'Verteiler', '', '1721253600', '90110', 'Traversenkasten Rechts', 'DIN 14345:2012-05', '03.08.2019 - 12:49:40', 'B/ CBC', '1', '08.06.2023 - 20:53:44', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('534', NULL, '3055', 'Strahler mit Tragegestell', '', '1721253600', '90110', '1', '', '04.08.2019 - 17:14:36', 'LED Lichtbrücke', '1', '13.04.2025 - 12:37:06', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Beleuchtung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('535', NULL, '3056', 'Leitungsroller', '', '1721253600', '90110', '1', '', '04.08.2019 - 17:15:52', '', '2', '08.06.2023 - 20:18:13', '2', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('536', NULL, '3057', 'Hohlstrahlrohr D', '1451602800', '1721253600', '90110', '6', 'DIN EN 15182-2:2010-04', '04.08.2019 - 17:36:30', 'Hohlstrahlrohr D', '1', '08.06.2023 - 20:28:12', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserabgabe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('537', NULL, '3058', 'Druckschlauch B', '', '1721253600', '90110', '6', 'DIN 14811/A3:2018-11', '04.08.2019 - 17:38:56', '', '5', '08.06.2023 - 20:28:19', '5', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('538', NULL, '3059', 'Standrohr', '1598911200', '1721253600', '90110', '6', '', '04.08.2019 - 17:40:08', '', '1', '08.06.2023 - 20:28:44', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserentnahme', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('539', NULL, '3060', 'Schwerschaumrohr S4', '', '1721253600', '90110', '5', '', '04.08.2019 - 17:41:31', '', '1', '08.06.2023 - 20:27:53', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserabgabe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('540', NULL, '3061', 'Überflurhydrantenschlüssel', '', '1721253600', '90110', '6', '', '04.08.2019 - 17:42:56', '', '1', '08.06.2023 - 20:29:56', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('541', NULL, '3062', 'Hydrantenschlüssel', '', '1721253600', '90110', '6', 'DIN 3223:2012-11', '04.08.2019 - 17:46:03', '', '1', '08.06.2023 - 20:30:00', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('542', NULL, '3063', 'Schachthaken', '', '1721253600', '90110', '6', '', '04.08.2019 - 17:53:53', '', '1', '08.06.2023 - 20:30:04', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('543', NULL, '3064', 'Stützkrümmer', '', '1721253600', '90110', '6', 'DIN 14368:2015-01', '04.08.2019 - 17:55:42', '', '1', '08.06.2023 - 20:30:09', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('544', NULL, '3065', 'Mehrzweckstrahlrohr B', '', '1721253600', '90110', '6', 'DIN EN 15182-3:2010-04', '04.08.2019 - 17:56:26', '', '1', '08.06.2023 - 20:30:14', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserabgabe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('546', NULL, '3067', 'Mittelschaumpistole', '', '1721253600', '90110', '6', '', '04.08.2019 - 18:01:51', '', '1', '08.06.2023 - 20:30:19', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserabgabe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('547', NULL, '3068', 'Schaummittel', '', '1721253600', '90110', '6', '', '04.08.2019 - 18:03:14', '2ltr. Reserve', '1', '08.06.2023 - 20:30:25', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('548', NULL, '3069', 'Seilschlauchhalter', '', '1721253600', '90110', '4', '', '04.08.2019 - 18:09:42', '', '6', '08.06.2023 - 20:24:39', '6', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('549', NULL, '3070', 'Feuerwehraxt', '', '1721253600', '90110', '4', 'DIN 14900:2015-09', '04.08.2019 - 18:15:42', '', '1', '08.06.2023 - 20:24:47', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('550', NULL, '3071', 'Druckschlauch C', '', '1721253600', '90110', '4', 'DIN 14811/A3:2018-11', '04.08.2019 - 18:17:02', '30mtr. Druckschlauch', '1', '08.06.2023 - 20:24:53', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('552', NULL, '3073', 'Absperrorgan C', '', '1721253600', '90110', '4', '', '04.08.2019 - 18:23:40', 'für Schlauchpaket', '1', '08.06.2023 - 20:24:57', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('553', NULL, '3074', 'Hohlstrahlrohr C', '', '1721253600', '90110', '6', '', '04.08.2019 - 18:26:22', 'AWG Turbo 2235', '2', '08.06.2023 - 20:30:36', '2', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserabgabe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('554', NULL, '3075', 'Schlauchtragekorb', '', '1721253600', '90110', '4', '', '04.08.2019 - 18:29:38', '', '4', '08.06.2023 - 20:25:03', '4', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('555', NULL, '3076', 'Druckschlauch C', '', '1721253600', '90110', '4', 'DIN 14811/A3:2018-11', '04.08.2019 - 18:35:37', '', '10', '08.06.2023 - 20:25:08', '10', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('556', NULL, '3077', 'Rauchschutzvorhang', '', '1737586800', '90111', '6', '', '04.08.2019 - 18:38:54', 'Rauchschutzvorhang klein', '1', '18.09.2021 - 13:08:27', '1', '', '', 'SO2101', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sondergerät', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('557', NULL, '3078', 'Rauchschutzvorhang', '', '1737586800', '90111', '6', '', '04.08.2019 - 18:39:51', 'Rauchschutzvorhang', '1', '01.08.2022 - 08:34:34', '1', '', '', 'SO2102', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sondergerät', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('558', NULL, '3079', 'Verkehrsleitkegel', '', '1721253600', '90110', '2', '', '06.08.2019 - 11:13:33', '', '6', '08.06.2023 - 20:21:14', '6', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('559', NULL, '3080', 'FI-Schutzschalter', '', '1721253600', '90110', '2', 'DIN VDE 0661:1988-04', '06.08.2019 - 11:19:06', '', '1', '08.06.2023 - 20:21:19', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('560', NULL, '3081', 'Verteilerbox', '', '1721253600', '90110', '1', '', '06.08.2019 - 11:20:48', '230/230/230', '1', '08.06.2023 - 20:18:28', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('561', NULL, '3082', 'Verlängerungskabel', '', '1721253600', '90110', '2', '', '06.08.2019 - 11:22:13', '', '1', '08.06.2023 - 20:21:30', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('562', NULL, '3083', 'Trennschleifer', '', '1721253600', '90110', '2', '', '06.08.2019 - 11:23:43', 'Trnnschleifer mit Zubehör', '1', '08.06.2023 - 20:21:34', '1', '', '', 'FLX1223101', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('563', NULL, '3084', 'Werkzeugkasten', '', '1721253600', '90110', '2', '', '06.08.2019 - 11:24:50', '', '1', '08.06.2023 - 20:21:39', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('564', NULL, '3085', 'Tauchpumpe TP8', '', '1721253600', '90110', '2', '', '06.08.2019 - 11:25:29', '', '1', '08.06.2023 - 20:21:37', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('565', NULL, '3086', 'Absperrorgan B', '', '1721253600', '90110', '2', '', '06.08.2019 - 11:28:30', 'Absperrorgan B für Tauchpumpe', '1', '08.06.2023 - 20:22:23', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('566', NULL, '3087', 'Schornsteinfegerset', '', '1721253600', '90110', '2', '', '06.08.2019 - 11:29:14', '', '1', '08.06.2023 - 20:22:34', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('567', NULL, '30346070', 'Schnittschutzhose', '1451430000', '1721253600', '90110', '2', 'DIN EN 381-5:1995-06', '06.08.2019 - 15:50:23', '', '1', '08.06.2023 - 20:21:09', '1', '', '26.07.2021', 'A2BZ2103', 'Jan Hendrik', 'Jan Hendrik', 'Ausgesondert', '30.12.2020', '0', 'Säge Equipment', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('568', NULL, '30346069', 'Schnittschutzhose', '1614898800', '1737586800', '90111', '3', 'DIN EN 381-5:1995-06', '06.08.2019 - 15:51:57', '', '1', '12.09.2021 - 19:13:30', '1', '', '', 'A2BZ2102', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '05.03.2026', '0', 'Säge Equipment', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('570', NULL, '30346615', 'Motorkettensäge', '1167606000', '1721253600', '90110', '2', '', '06.08.2019 - 15:55:57', 'Stihl MS 441\r\n\r\nKetten Nr.\r\nBestell Nr. 3626 000 0072\r\n            36RS3      72\r\n\r\n50cm Schwert\r\n\r\n\r\n', '1', '08.06.2023 - 20:22:42', '1', '', '', 'MO2105', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Säge Equipment', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('571', NULL, '30353700', 'Kombi Kanister', '1517439600', '1721253600', '90110', '2', '', '06.08.2019 - 15:57:09', '', '1', '08.06.2023 - 20:22:52', '1', '', '', 'KOMBI12101', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.02.2023', '0', 'Säge Equipment', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('572', NULL, '30346616', 'Rettungssäge', '', '1721253600', '90110', '2', '', '06.08.2019 - 16:02:54', '', '1', '10.05.2020 - 10:07:33', '1', '', '10.05.2020', '', 'Jan Hendrik', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Säge Equipment', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('575', NULL, '30346521', 'Wasserlüfter', '', '1721253600', '90110', '2', '', '06.08.2019 - 16:08:22', '', '1', '08.06.2023 - 20:23:03', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserabgabe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('576', NULL, '30347668', 'Elektrolüfter', '', '1721253600', '90110', '2', '', '06.08.2019 - 16:08:51', '', '1', '08.06.2023 - 20:23:10', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('577', NULL, '21431', 'Pressluftatmer', '1136070000', '1643842800', '90112', 'Mannschaft Hinten', '', '06.08.2019 - 16:57:34', 'PSS 7000 mit Safty Belt', '1', '28.08.2022 - 11:22:45', '1', '', '28.08.2022', '201001', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Atemschutz', '08.08.2022', '', '', 'A2BZ', '', '6', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('578', NULL, '30346754', 'Pressluftatmer', '1325372400', '1642633200', '90111', 'Mannschaft Hinten', '', '06.08.2019 - 16:58:53', 'PSS 7000 mit Safty Belt', '1', '28.08.2022 - 11:22:13', '1', '', '28.08.2022', '201002', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Atemschutz', '08.08.2022', '', '', 'A2BZ', '', '6', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('579', NULL, '21433', 'Pressluftatmer', '1325372400', '1643842800', '90112', 'Mannschaft Hinten', '', '06.08.2019 - 17:00:34', ' PSS 7000 mit Safty Belt', '1', '30.08.2022 - 10:26:18', '1', '', '30.08.2022', '201003', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Atemschutz', '08.08.2022', '', '', 'A2BZ', '', '6', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('580', NULL, '01358816', 'Pressluftatmer', '1356994800', '1642633200', '90111', 'Mannschaft Hinten', '', '06.08.2019 - 17:01:46', 'PSS 7000 mit Safty Belt\r\n\r\n', '1', '28.08.2022 - 11:22:21', '1', '', '28.08.2022', '201004', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Atemschutz', '08.08.2022', '', '', 'A2BZ', '', '6', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('581', NULL, '093956', 'Pressluftatmer', '', '1594245600', '90110', 'Mannschaft Hinten', '', '06.08.2019 - 17:03:11', 'PSS 90 RA', '1', '28.08.2020 - 12:15:08', '1', '', '28.08.2020', '201005', 'Jan Hendrik', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '6', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('582', NULL, '093957', 'Pressluftatmer', '', '1594245600', '90110', '3', '', '06.08.2019 - 17:04:12', 'PSS 90 RA', '1', '28.08.2020 - 12:15:13', '1', '', '28.08.2020', '201006', 'Jan Hendrik', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '6', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('583', NULL, '093958', 'Pressluftatmer', '', '1594245600', '90110', '3', '', '06.08.2019 - 17:05:13', 'PSS 90 RA', '1', '28.08.2020 - 12:15:15', '1', '', '28.08.2020', '201007', 'Jan Hendrik', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '6', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('584', NULL, '093959', 'Pressluftatmer', '', '1594245600', '90110', 'Mannschaft Hinten', '', '06.08.2019 - 17:06:08', 'PSS 90 RA', '1', '28.08.2020 - 12:15:17', '1', '', '28.08.2020', '201008', 'Jan Hendrik', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '6', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('587', NULL, '054624', 'Pressluftatmer', '', '1735689600', '90113', '5', '', '06.08.2019 - 17:13:03', 'PA 94up', '1', '29.11.2020 - 11:35:32', '1', '', '29.11.2020', '201011', 'Jan Hendrik', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '6', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('588', NULL, '054623', 'Pressluftatmer', '', '1735689600', '90113', '5', '', '06.08.2019 - 17:14:02', 'PSS 90 RA', '1', '29.11.2020 - 11:35:33', '1', '', '29.11.2020', '201012', 'Jan Hendrik', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '6', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('589', NULL, '30350936', 'Pressluftatmer', '1514761200', '1643842800', '90112', '1', '', '06.08.2019 - 17:15:28', 'PSS 7000 mit Safty Belt', '1', '28.08.2022 - 11:22:51', '1', '', '28.08.2022', '201013', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Atemschutz', '08.08.2022', '', '', 'A2BZ', '', '6', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('590', NULL, '30350951', 'Pressluftatmer', '1514761200', '1643842800', '90112', '1', '', '06.08.2019 - 17:16:12', ' PSS 7000 mit Safty Belt', '1', '28.08.2022 - 11:22:57', '1', '', '28.08.2022', '201014', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Atemschutz', '08.08.2022', '', '', 'A2BZ', '', '6', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('591', NULL, '05774720', 'Atemschutznotfalltasche', '', '1704927600', '90110', '3', '', '06.08.2019 - 17:17:20', 'RPS 3500 Rescue Pack', '1', '08.07.2024 - 19:59:34', '1', '', '', '201015', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Atemschutz', '08.08.2022', '', '', 'A2BZ', '', '6', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('592', NULL, '3088', 'Dreikantschlüssel', '', '1721253600', '90110', 'Mannschaft Vorne', '', '10.08.2019 - 09:53:23', '', '2', '08.06.2023 - 20:52:23', '2', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('593', NULL, '3089', 'Anhaltestab', '', '1721253600', '90110', 'Mannschaft Vorne', '', '10.08.2019 - 09:54:41', '', '2', '08.06.2023 - 20:52:28', '2', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('594', NULL, '3090', 'Verbandtasche', '', '1721253600', '90110', 'Mannschaft Hinten', '', '10.08.2019 - 09:56:02', '', '1', '08.06.2023 - 20:46:47', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.05.2024', '0', 'Erste Hilfe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('595', NULL, '3091', 'Funkverzeichnis', '', '1721253600', '90110', 'Mannschaft Vorne', '', '10.08.2019 - 09:57:03', '', '1', '08.06.2023 - 20:52:35', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('596', NULL, '3092', 'Schlüsselkasten', '', '1737586800', '90111', 'Mannschaft Vorne', '', '10.08.2019 - 09:57:49', '', '1', '27.09.2021 - 14:25:03', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('597', NULL, '3093', 'Hydrantenverzeichnis', '', '1721253600', '90110', 'Mannschaft Vorne', '', '10.08.2019 - 09:59:16', '', '1', '08.06.2023 - 20:52:39', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('598', NULL, '3094', 'Gurtmesser', '', '1721253600', '90110', 'Mannschaft Vorne', '', '10.08.2019 - 10:00:03', '', '1', '08.06.2023 - 20:52:44', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('600', NULL, '3097', 'Funkgerät HRT', '', '1721253600', '90110', 'Mannschaft Vorne', '', '13.08.2019 - 11:04:32', '12-23-1-3   Sepura HRT', '1', '08.06.2023 - 20:52:54', '1', '', '', '12-23-1-3', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '02.12.2022', '', '6224855', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('601', NULL, '3096', 'Funkgerät HRT', '', '1721253600', '90110', 'Mannschaft Vorne', '', '13.08.2019 - 11:06:07', '12-23-1-2  Sepura HRT', '1', '08.06.2023 - 20:53:01', '1', '', '', '12-23-1-2', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '02.12.2022', '', '6224854', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('602', NULL, '3095', 'Funkgerät HRT', '', '1721253600', '90110', 'Mannschaft Vorne', '', '13.08.2019 - 11:54:51', '12-23-1-1 Sepura HRT', '1', '08.06.2023 - 20:53:06', '1', '', '', '12-23-1-1', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '02.12.2022', '', '4224386', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('603', NULL, '3098', 'Atemschutzüberwachungstafel', '', '1737586800', '90111', 'Mannschaft Hinten', '', '13.08.2019 - 12:00:44', '', '1', '10.09.2021 - 16:10:43', '1', '', '', 'Meß1203', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sondergerät', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('604', NULL, '3099', 'Atememschutzüberwachungsweste', '', '1737586800', '90111', 'Mannschaft Hinten', '', '13.08.2019 - 12:02:15', '', '1', '10.09.2021 - 16:10:38', '1', '', '', 'ASÜ122312', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sondergerät', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('605', NULL, '01358823', 'Wärmebildkamera', '1662228720', '1737586800', '90111', 'Mannschaft Hinten', '', '13.08.2019 - 12:04:31', '', '1', '09.02.2022 - 15:34:14', '1', '', '', 'WBK122311', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('606', NULL, '30350846', 'Tragetuch', '', '1721253600', '90110', 'Mannschaft Hinten', 'DIN EN 1865:2015-08', '13.08.2019 - 12:05:44', '', '1', '08.06.2023 - 20:46:55', '1', '', '', 'Rett2120', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sanitätsgerät', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('608', NULL, '3100', 'Filter', '', '1627250400', '90112', 'Mannschaft Hinten', 'DIN EN 143:2007-02', '13.08.2019 - 12:12:58', '', '1', '17.10.2021 - 11:40:08', '1', '', '', 'FIL122311', 'Daniel', 'Jan Hendrik', 'Einsatzbereit', '01.04.2024', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('609', NULL, '3101', 'Filter', '', '1627250400', '90112', 'Mannschaft Hinten', 'DIN EN 143:2007-02', '13.08.2019 - 12:13:50', '', '1', '17.10.2021 - 11:40:32', '1', '', '', 'FIL122312', 'Daniel', 'Jan Hendrik', 'Einsatzbereit', '01.04.2024', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('610', NULL, '3102', 'Filter', '', '1627250400', '90110', 'Mannschaft Hinten', 'DIN EN 143:2007-02', '13.08.2019 - 12:14:31', '', '1', '08.06.2023 - 20:46:58', '1', '', '', 'FIL122313', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.04.2024', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('611', NULL, '3103', 'Filter', '', '1627250400', '90110', 'Mannschaft Hinten', 'DIN EN 143:2007-02', '13.08.2019 - 12:15:04', '', '1', '08.06.2023 - 20:47:02', '1', '', '', 'FIL122314', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.04.2024', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('614', NULL, '3104', 'Atemanschluss', '', '1627250400', '90110', 'Mannschaft Hinten', 'DIN EN 136:1998-04', '18.08.2019 - 10:41:56', '', '2', '08.06.2023 - 20:47:14', '2', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('616', NULL, '30346068', 'Löschdecke', '', '1720908000', '90110', 'Mannschaft Hinten', '', '18.08.2019 - 11:06:59', '', '1', '23.05.2024 - 10:28:24', '1', '', '', 'LÖ2119', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerlöscher', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('617', NULL, '3106', 'Warnweste', '', '1721253600', '90110', 'Mannschaft Hinten', '', '18.08.2019 - 11:08:48', '', '3', '08.06.2023 - 20:47:27', '3', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Schutzkleidung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('618', NULL, '3107', 'Kuhfuss', '', '1721253600', '90110', 'Mannschaft Hinten', '', '18.08.2019 - 11:11:20', 'Kuhfuss 300mm', '1', '08.06.2023 - 20:47:31', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('619', NULL, '3108', 'Brechstange', '', '1721253600', '90110', 'Mannschaft Hinten', '', '18.08.2019 - 11:13:00', 'Brechstange 400mm', '1', '08.06.2023 - 20:47:34', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('620', NULL, '3109', 'Bolzenschneider', '', '1721253600', '90110', 'Mannschaft Hinten', '', '18.08.2019 - 11:14:45', '', '1', '08.06.2023 - 20:47:38', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('621', NULL, '3110', 'Bügelsäge', '', '1721253600', '90110', 'Mannschaft Hinten', '', '18.08.2019 - 11:17:27', '', '1', '08.06.2023 - 20:47:41', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('622', NULL, '3111', 'Wagenheber', '', '1721253600', '90110', 'Mannschaft Hinten', '', '18.08.2019 - 11:19:06', '', '1', '08.06.2023 - 20:47:45', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('623', NULL, '30346519', 'Abschleppseil', '', '1721253600', '90110', 'Mannschaft Hinten', 'DIN 76031', '18.08.2019 - 11:21:39', '', '1', '08.06.2023 - 20:47:54', '1', '', '', 'DS1223101', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('624', NULL, '30346517', 'Schäkel', '', '1721253600', '90110', 'Mannschaft Hinten', '', '18.08.2019 - 11:23:11', '5T.', '1', '08.06.2023 - 20:48:13', '1', '', '', 'SCHÄ1223102', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('625', NULL, '30346518', 'Schäkel', '', '1721253600', '90110', 'Mannschaft Hinten', '', '18.08.2019 - 11:24:09', '5T.', '1', '08.06.2023 - 20:48:39', '1', '', '', 'SCHÄ1223101', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('626', NULL, '30346515', 'Schäkel', '', '1721253600', '90110', 'Mannschaft Hinten', '', '18.08.2019 - 11:25:39', '6T.', '1', '08.06.2023 - 20:48:47', '1', '', '', 'SCHÄ1223103', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('627', NULL, '30346516', 'Schäkel', '', '1721253600', '90110', 'Mannschaft Hinten', '', '18.08.2019 - 11:26:25', '6T.', '1', '08.06.2023 - 20:48:54', '1', '', '', 'SCHÄ1223104', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('628', NULL, '3112', 'Verbandkasten Fw', '', '1721253600', '90110', 'Mannschaft Hinten', '', '18.08.2019 - 11:29:15', '', '1', '08.06.2023 - 20:48:59', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.06.2034', '0', 'Erste Hilfe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('629', NULL, '8004', 'Einmallaken', '', '1721253600', '90110', 'Mannschaft Hinten', '', '18.08.2019 - 11:32:04', '', '2', '08.06.2023 - 20:49:03', '2', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verbrauchsmaterial', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '#test #gwl', 'gwl.jpg', '');
INSERT INTO `ffw_geraete` VALUES ('630', NULL, '1101', 'Hitzeschutz', '', '1737586800', '90111', '4', '', '18.08.2019 - 11:38:46', '', '1', '18.09.2021 - 14:06:02', '1', '', '', 'HIZ2120', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Schutzkleidung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('632', NULL, '30346074', 'Wathose', '', '1721253600', '90110', 'Dach', '', '18.08.2019 - 11:56:49', '', '1', '08.06.2023 - 20:33:44', '1', '', '', 'AR2112', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Schutzkleidung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('633', NULL, '30346073', 'Wathose', '', '1721253600', '90110', 'Dach', '', '18.08.2019 - 11:57:31', '', '1', '08.06.2023 - 20:33:53', '1', '', '', 'AR2111', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Schutzkleidung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('634', NULL, '30346613', 'Steckleiterteil', '', '1721253600', '90110', 'Dach', 'DIN EN 1147-LM:2010-10', '18.08.2019 - 11:58:39', 'A Teil', '1', '08.06.2023 - 20:42:40', '1', '', '', 'A2BZ11', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Leitern', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('635', NULL, '30346079', 'Steckleiterteil', '', '1721253600', '90110', 'Dach', 'DIN EN 1147-LM:2010-10', '18.08.2019 - 11:59:11', 'B Teil', '1', '08.06.2023 - 20:42:47', '1', '', '', 'A2BZ03', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Leitern', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('636', NULL, '30346081', 'Steckleiterteil', '', '1721253600', '90110', 'Dach', 'DIN EN 1147-LM:2010-10', '18.08.2019 - 11:59:49', 'B Teil', '1', '08.06.2023 - 20:43:02', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Leitern', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('637', NULL, '30346080', 'Steckleiterteil', '', '1721253600', '90110', 'Dach', 'DIN EN 1147-LM:2010-10', '18.08.2019 - 12:00:25', 'B Teil', '1', '08.06.2023 - 20:43:09', '1', '', '', 'A2BZ04', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Leitern', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('638', NULL, '30350881', 'Schleifkorbtrage', '1546297200', '1737586800', '90111', '2', '', '18.08.2019 - 12:01:10', '', '1', '08.11.2021 - 10:59:43', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.01.2029', '0', 'Sanitätsgerät', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('639', NULL, '3113', 'Saugkorb', '', '1721253600', '90110', 'GR', 'DIN 14362:2018-02', '18.08.2019 - 12:02:39', '', '1', '08.06.2023 - 20:45:14', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserentnahme', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('640', NULL, '3114', 'Sammelstück', '', '1721253600', '90110', 'GR', '', '18.08.2019 - 12:03:18', '', '1', '08.06.2023 - 20:45:18', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('641', NULL, '3115', 'Absperrorgan B', '', '1721253600', '90110', 'GR', '', '18.08.2019 - 12:04:55', 'Absperrorgan B', '1', '08.06.2023 - 20:45:22', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('642', NULL, '3116', 'Kupplungsschlüssel', '', '1721253600', '90110', 'GR', 'DIN 14822-1:2016-03', '18.08.2019 - 12:05:46', '', '3', '08.06.2023 - 20:45:25', '3', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('643', NULL, '30346522', 'Heckpumpe', '1185919200', '1721253600', '90110', 'GR', '', '18.08.2019 - 12:09:29', '', '1', '08.06.2023 - 20:45:33', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserabgabe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('644', NULL, '3118', 'Abgasschlauch groß', '', '1721253600', '90110', 'GR', '', '18.08.2019 - 12:10:14', '', '1', '08.06.2023 - 20:45:36', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('645', NULL, '3119', 'Schlauchbrücke', '', '1721253600', '90110', 'Dach', 'DIN 14820-1:2015-09', '18.08.2019 - 12:14:17', '', '4', '08.06.2023 - 20:43:13', '4', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('646', NULL, '3120', 'Saugschlauch', '', '1721253600', '90110', 'Dach', '', '18.08.2019 - 12:14:42', '', '4', '08.06.2023 - 20:43:16', '3', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('647', NULL, '3121', 'Werfer', '', '1721253600', '90110', 'Dach', '', '18.08.2019 - 12:21:12', '', '1', '08.06.2023 - 20:43:25', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserabgabe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('648', NULL, '30346078', 'Einreißhaken', '', '1721253600', '90110', 'Dach', ' DIN 14851:1988-11', '18.08.2019 - 12:31:48', 'Einreißhaken mit Verlängerung', '1', '08.06.2023 - 20:43:32', '1', '', '', 'AR2107', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('649', NULL, '3122', 'Feuerpatsche', '', '1721253600', '90110', 'Dach', '', '18.08.2019 - 12:33:09', '', '4', '08.06.2023 - 20:43:38', '4', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sondergerät', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('650', NULL, '3126', 'Brandfluchthaube', '1383260400', '1529964000', '90110', 'Mannschaft Hinten', 'DIN EN 403:2004-08', '22.08.2019 - 14:38:39', 'MSA S-Cap\r\n', '1', '08.06.2023 - 20:49:07', '1', '', '', 'A2BZFL20', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('651', NULL, '3125', 'Brandfluchthaube', '1383260400', '1529964000', '90110', 'Mannschaft Hinten', 'DIN EN 403:2004-08', '22.08.2019 - 14:40:30', 'MSA S-Cap\r\n', '1', '08.06.2023 - 20:49:46', '1', '', '', 'A2BZFL17', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('652', NULL, '3124', 'Brandfluchthaube', '1383260400', '1529964000', '90110', 'Mannschaft Hinten', 'DIN EN 403:2004-08', '22.08.2019 - 14:43:22', 'MSA S-Cap\r\n', '1', '08.06.2023 - 20:49:51', '1', '', '', 'A2BZFL14', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('653', NULL, '3123', 'Brandfluchthaube', '1383260400', '1529964000', '90110', 'Mannschaft Hinten', 'DIN EN 403:2004-08', '22.08.2019 - 14:44:49', 'MSA S-Cap\r\n', '1', '08.06.2023 - 20:49:55', '1', '', '', 'A2BZFL15', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('654', NULL, '3127', 'Brandfluchthaube', '1383260400', '1529964000', '90110', 'Mannschaft Hinten', 'DIN EN 403:2004-08', '22.08.2019 - 14:47:53', 'MSA S-Cap\r\n', '1', '08.06.2023 - 20:50:00', '1', '', '', 'A2BZFL44', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('655', NULL, '3128', 'Brandfluchthaube', '1383260400', '1529964000', '90110', 'Mannschaft Hinten', 'DIN EN 403:2004-08', '22.08.2019 - 14:49:51', 'MSA S-Cap\r\n', '1', '08.06.2023 - 20:50:04', '1', '', '', 'A2BZFL48', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('656', NULL, '3130', 'Brandfluchthaube', '1383260400', '1529964000', '90110', 'Mannschaft Hinten', 'DIN EN 403:2004-08', '22.08.2019 - 14:53:52', 'MSA S-Cap\r\n', '1', '08.06.2023 - 20:50:08', '1', '', '', 'A2BZFL16', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('657', NULL, '3129', 'Brandfluchthaube', '1383260400', '1529964000', '90110', 'Mannschaft Hinten', 'DIN EN 403:2004-08', '22.08.2019 - 14:55:02', 'MSA S-Cap\r\n', '1', '08.06.2023 - 20:50:16', '1', '', '', 'A2BZFL38', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('658', NULL, '1109', 'Brandfluchthaube', '1383260400', '1529964000', '90111', 'Mannschaft Hinten', '', '22.08.2019 - 15:15:09', 'MSA S-Cap\r\n', '1', '10.09.2021 - 16:18:51', '1', '', '', 'A2BZFL41', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('659', NULL, '1108', 'Brandfluchthaube', '1383260400', '1529964000', '90111', 'Mannschaft Hinten', '', '22.08.2019 - 15:16:29', 'MSA S-Cap\r\n', '1', '10.09.2021 - 16:18:52', '1', '', '', 'A2BZFL42', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('660', NULL, '1107', 'Brandfluchthaube', '1383260400', '1529964000', '90111', 'Mannschaft Hinten', '', '22.08.2019 - 15:19:01', 'MSA S-Cap\r\n', '1', '10.09.2021 - 16:18:53', '1', '', '', 'A2BZFL11', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('661', NULL, '1106', 'Brandfluchthaube', '1383260400', '1529964000', '90111', 'Mannschaft Hinten', '', '22.08.2019 - 15:20:11', 'MSA S-Cap\r\n', '1', '10.09.2021 - 16:18:56', '1', '', '', 'A2BZFL12', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('662', NULL, '1105', 'Brandfluchthaube', '1383260400', '1529964000', '90111', 'Mannschaft Hinten', '', '22.08.2019 - 15:22:32', 'MSA S-Cap\r\n', '1', '10.09.2021 - 16:18:57', '1', '', '', 'A2BZFL50', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('663', NULL, '1104', 'Brandfluchthaube', '1383260400', '1529964000', '90111', 'Mannschaft Hinten', '', '22.08.2019 - 15:23:37', 'MSA S-Cap\r\n', '1', '10.09.2021 - 16:18:58', '1', '', '', 'A2BZFL45', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('664', NULL, '1103', 'Brandfluchthaube', '1383260400', '1529964000', '90111', 'Mannschaft Hinten', '', '22.08.2019 - 15:24:52', 'MSA S-Cap\r\n', '1', '10.09.2021 - 16:19:00', '1', '', '', 'A2BZFL49', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('665', NULL, '1102', 'Brandfluchthaube', '1383260400', '1529964000', '90111', 'Mannschaft Hinten', '', '22.08.2019 - 15:26:29', 'MSA S-Cap\r\n', '1', '23.11.2021 - 19:12:58', '1', '', '', 'A2BZFL47', 'Nils Bonk', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('666', NULL, '4001', 'Brandfluchthaube', '1383260400', '1529964000', '90114', 'GR', '', '22.08.2019 - 16:59:19', 'MSA S-Cap\r\n', '1', '12.06.2021 - 14:44:38', '1', '', '', 'A2BZFL22', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('667', NULL, '4002', 'Brandfluchthaube', '1383260400', '1529964000', '90114', 'GR', '', '22.08.2019 - 17:00:05', 'MSA S-Cap\r\n', '1', '12.06.2021 - 14:44:50', '1', '', '', 'A2BZFL10', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('668', NULL, '4003', 'Brandfluchthaube', '1383260400', '1529964000', '90114', 'GR', '', '22.08.2019 - 17:02:24', 'MSA S-Cap\r\n', '1', '12.06.2021 - 14:44:48', '1', '', '', 'A2BZFL09', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('669', NULL, '4004', 'Brandfluchthaube', '1383260400', '1529964000', '90114', 'GR', '', '22.08.2019 - 17:04:49', 'MSA S-Cap\r\n', '1', '12.06.2021 - 14:44:40', '1', '', '', 'A2BZFL23', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('670', NULL, '4005', 'Brandfluchthaube', '1383260400', '1529964000', '90114', 'GR', '', '22.08.2019 - 17:06:10', 'MSA S-Cap\r\n', '1', '12.06.2021 - 14:44:46', '1', '', '', 'A2BZFL25', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('671', NULL, '4006', 'Brandfluchthaube', '1383260400', '1529964000', '90114', 'GR', '', '22.08.2019 - 17:08:24', 'MSA S-Cap\r\n', '1', '12.06.2021 - 14:44:52', '1', '', '', 'A2BZFL27', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('672', NULL, '4007', 'Brandfluchthaube', '1383260400', '1529964000', '90114', 'GR', '', '22.08.2019 - 17:09:34', 'MSA S-Cap\r\n', '1', '12.06.2021 - 14:44:42', '1', '', '', 'A2BZFL24', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('673', NULL, '4008', 'Brandfluchthaube', '1383260400', '1529964000', '90114', 'GR', '', '22.08.2019 - 17:10:54', 'MSA S-Cap\r\n', '1', '12.06.2021 - 14:44:44', '1', '', '', 'A2BZFL28', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('674', NULL, '4009', 'Brandfluchthaube', '1383260400', '1529964000', '90114', 'GR', '', '22.08.2019 - 17:12:22', 'MSA S-Cap\r\n', '1', '12.06.2021 - 14:45:21', '1', '', '', 'A2BZFL26', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('675', NULL, '4010', 'Brandfluchthaube', '1383260400', '1529964000', '90114', 'GR', '', '22.08.2019 - 17:20:09', 'MSA S-Cap\r\n', '1', '12.06.2021 - 14:44:04', '1', '', '', 'A2BZFL21', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('676', NULL, '4011', 'Brandfluchthaube', '1383260400', '1529964000', '90114', 'GR', '', '22.08.2019 - 17:22:46', 'MSA S-Cap\r\n', '1', '12.06.2021 - 14:44:02', '1', '', '', 'A2BZFL35', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('677', NULL, '4012', 'Brandfluchthaube', '1383260400', '1529964000', '90114', 'GR', '', '22.08.2019 - 17:23:43', 'MSA S-Cap\r\n', '1', '12.06.2021 - 14:43:59', '1', '', '', 'A2BZFL36', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('678', NULL, '4013', 'Brandfluchthaube', '1383260400', '1529964000', '90114', 'GR', '', '22.08.2019 - 17:25:01', 'MSA S-Cap\r\n', '1', '12.06.2021 - 14:41:51', '1', '', '', 'A2BZFL43', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('679', NULL, '4014', 'Brandfluchthaube', '1383260400', '1529964000', '90114', 'GR', '', '22.08.2019 - 17:26:13', 'MSA S-Cap\r\n', '1', '12.06.2021 - 14:44:01', '1', '', '', 'A2BZFL40', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('680', NULL, '4015', 'Brandfluchthaube', '1383260400', '1529964000', '90114', 'GR', '', '22.08.2019 - 17:27:16', 'MSA S-Cap\r\n', '1', '12.06.2021 - 14:41:34', '1', '', '', 'A2BZFL30', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('681', NULL, '4016', 'Brandfluchthaube', '1383260400', '1529964000', '90114', 'GR', '', '22.08.2019 - 17:29:13', 'MSA S-Cap\r\n', '1', '12.06.2021 - 14:41:32', '1', '', '', 'A2BZFL39', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('682', NULL, '4017', 'Brandfluchthaube', '1383260400', '1529964000', '90114', 'GR', '', '22.08.2019 - 17:30:41', 'MSA S-Cap\r\n', '1', '12.06.2021 - 14:41:35', '1', '', '', 'A2BZFL29', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('683', NULL, '4018', 'Brandfluchthaube', '1383260400', '1529964000', '90114', 'GR', '', '22.08.2019 - 17:32:09', 'MSA S-Cap\r\n', '1', '12.06.2021 - 14:41:31', '1', '', '', 'A2BZFL33', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('684', NULL, '4019', 'Brandfluchthaube', '1383260400', '1529964000', '90114', 'GR', '', '22.08.2019 - 17:33:13', 'MSA S-Cap\r\n', '1', '12.06.2021 - 14:41:43', '1', '', '', 'A2BZFL37', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('685', NULL, '4020', 'Brandfluchthaube', '1383260400', '1529964000', '90114', 'GR', '', '22.08.2019 - 17:34:57', 'MSA S-Cap\r\n', '1', '12.06.2021 - 14:41:36', '1', '', '', 'A2BZFL32', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('686', NULL, '4021', 'Brandfluchthaube', '1383260400', '1529964000', '90114', 'GR', '', '22.08.2019 - 17:36:02', 'MSA S-Cap\r\n', '1', '12.06.2021 - 14:41:29', '1', '', '', 'A2BZFL34', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('687', NULL, '4022', 'Brandfluchthaube', '1383260400', '1529964000', '90114', 'GR', '', '22.08.2019 - 17:37:14', 'MSA S-Cap\r\n', '1', '12.06.2021 - 14:47:42', '1', '', '', 'A2BZFL31', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '26.06.2022', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('691', NULL, '3131', 'Verteiler', '', '1721253600', '90110', 'Dach', 'DIN 14345:2012-05', '24.08.2019 - 11:12:35', 'Verteiler BB/CBC', '1', '08.06.2023 - 20:43:41', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('692', NULL, '3132', 'Schwerschaumrohr Werfer', '', '1721253600', '90110', 'Dach', '', '24.08.2019 - 11:13:59', '', '1', '08.06.2023 - 20:44:37', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserabgabe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('693', NULL, '3133', 'Bierzeltgarnitur', '', '1721253600', '90110', 'Dach', '', '24.08.2019 - 11:14:48', '1 Tisch und 2 Bänke', '1', '08.06.2023 - 20:44:40', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sondergerät', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('694', NULL, '3134', 'Lafette', '', '1721253600', '90110', 'Dach', '', '24.08.2019 - 11:15:17', '', '1', '08.06.2023 - 20:44:44', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sondergerät', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('701', NULL, '5004', 'Holzaxt', '', '1723154400', '90112', '1', '', '08.09.2019 - 17:32:38', '', '2', '03.09.2022 - 12:43:49', '2', '', '', '', 'Nils Bonk', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('702', NULL, '5005', 'Abgasschlauch klein', '', '1723154400', '50001', '1', '', '08.09.2019 - 17:33:20', '', '1', '15.08.2024 - 14:00:08', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('703', NULL, '5006', 'Kanister 10ltr.', '', '1723154400', '50001', '1', '', '08.09.2019 - 17:34:18', '10ltr. Benzin', '1', '15.08.2024 - 14:00:20', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('708', NULL, '5011', 'Pressluftflaschen', '', '1628632800', '90112', '1', '', '08.09.2019 - 17:42:08', '', '4', '29.06.2022 - 16:32:59', '4', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('709', NULL, '5012', 'Füllstutzen', '', '1723154400', '50001', '1', '', '08.09.2019 - 17:42:49', '', '1', '15.08.2024 - 14:00:37', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('710', NULL, '5013', 'Druckschlauch B', '', '1723154400', '90112', '3', '', '08.09.2019 - 17:43:53', 'B- Schläuche', '6', '29.06.2022 - 16:32:55', '6', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('711', NULL, '5014', 'Druckschlauch C', '', '1723154400', '90112', '3', '', '08.09.2019 - 17:45:12', 'C- Druckschläuche', '2', '29.06.2022 - 16:32:53', '2', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('712', NULL, '5015', 'Saugschutzkorb', '', '1723154400', '90112', '3', '', '08.09.2019 - 17:45:53', '', '1', '29.06.2022 - 16:32:50', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserabgabe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('713', NULL, '5016', 'Verteiler', '', '1723154400', '90112', '3', '', '08.09.2019 - 17:46:35', 'B/CBC', '1', '29.06.2022 - 16:32:48', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('714', NULL, '5017', 'Schlauchtragekorb', '', '1723154400', '90112', '3', '', '08.09.2019 - 17:47:22', '', '4', '29.06.2022 - 16:32:46', '4', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('716', NULL, '5019', 'Übergangsstück', '', '1723154400', '90112', '3', '', '08.09.2019 - 17:49:15', 'B>C', '2', '29.06.2022 - 16:32:41', '2', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('717', NULL, '5020', 'Mulde', '', '1723154400', '90112', '3', '', '08.09.2019 - 17:50:07', '', '1', '29.06.2022 - 16:32:38', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('718', NULL, '5021', 'Kohleschaufel', '', '1723154400', '90112', '3', '', '08.09.2019 - 17:51:19', '', '1', '29.06.2022 - 16:32:36', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('719', NULL, '5022', 'Seilschlauchhalter', '', '1723154400', '90112', '3', '', '08.09.2019 - 17:52:00', '', '3', '29.06.2022 - 16:32:33', '3', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('720', NULL, '5023', 'Feuerwehraxt', '', '1723154400', '90112', '3', '', '08.09.2019 - 17:52:42', '', '2', '29.06.2022 - 16:32:18', '2', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('721', NULL, '5024', 'Hohlstrahlrohr C', '', '1723154400', '90112', '3', '', '08.09.2019 - 17:53:27', 'auf Schlauchtragekorb', '1', '29.06.2022 - 16:32:10', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserabgabe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('722', NULL, '5025', 'Druckschlauch C', '', '1723154400', '90112', '4', '', '08.09.2019 - 17:54:23', 'Druckschlauch C', '1', '12.06.2021 - 15:35:57', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('723', NULL, '5026', 'Druckschlauch B', '', '1723154400', '90112', '4', '', '08.09.2019 - 17:54:56', 'Druckschlauch B', '8', '29.06.2022 - 16:32:01', '8', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('724', NULL, '5027', 'Mittelschaumrohr M2', '', '1723154400', '90112', '4', '', '08.09.2019 - 17:55:36', 'Z2', '1', '12.06.2021 - 15:41:56', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserabgabe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('725', NULL, '5028', 'Schlauchbrücke', '', '1723154400', '90112', '4', '', '08.09.2019 - 17:56:09', '', '3', '29.06.2022 - 16:28:54', '3', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('726', NULL, '5029', 'Schaummittel', '', '1723154400', '90112', '2', '', '08.09.2019 - 17:56:47', '', '3', '02.07.2022 - 07:41:11', '3', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('727', NULL, '5030', 'Seilschlauchhalter', '', '1723154400', '90112', '4', '', '08.09.2019 - 17:57:32', '', '3', '12.06.2021 - 15:31:51', '3', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('728', NULL, '5031', 'Zumischer Z2', '', '1723154400', '90112', '4', '', '08.09.2019 - 17:58:01', 'Z2', '1', '29.06.2022 - 16:28:10', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('729', NULL, '5032', 'Saugschlauch', '', '1723154400', '90112', 'GR', '', '08.09.2019 - 17:58:43', 'A Saugschlauch', '6', '02.07.2022 - 07:41:40', '4', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('730', NULL, '5033', 'Forke', '', '1723154400', '90112', '2', '', '09.09.2019 - 16:07:37', '', '3', '12.06.2021 - 15:42:31', '3', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('731', NULL, '5034', 'Feuerpatsche', '', '1723154400', '90112', '2', '', '09.09.2019 - 16:08:21', '', '2', '12.06.2021 - 15:40:51', '2', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('732', NULL, '5035', 'Schaufel', '', '1723154400', '90112', '2', '', '09.09.2019 - 16:08:57', '', '1', '12.06.2021 - 15:40:17', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('734', NULL, '5037', 'Werkzeugkasten', '', '1723154400', '90112', '2', '', '09.09.2019 - 16:10:41', '', '1', '12.06.2021 - 15:39:59', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('735', NULL, '5038', 'Standrohr', '', '1723154400', '90112', '2', '', '09.09.2019 - 16:11:30', 'Ersatz ist bestellt', '1', '28.03.2020 - 19:42:01', '1', '', '28.03.2020', '', 'Nils', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Wasserabgabe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('736', NULL, '5039', 'Hydrantenschlüssel', '', '1723154400', '90112', '2', '', '09.09.2019 - 16:12:12', '', '1', '12.06.2021 - 15:42:25', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('737', NULL, '5040', 'Übergangsstück', '', '1723154400', '90112', '2', '', '09.09.2019 - 16:12:50', 'C>D', '1', '12.06.2021 - 15:30:12', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('738', NULL, '5041', 'Überflurhydrantenschlüssel', '', '1723154400', '90112', '2', '', '09.09.2019 - 16:13:36', '', '1', '12.06.2021 - 15:38:36', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('739', NULL, '5042', 'Schachthaken', '', '1723154400', '90112', '2', '', '09.09.2019 - 16:14:07', '', '2', '12.06.2021 - 15:38:39', '2', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('741', NULL, '5044', 'Stützkrümmer', '', '1723154400', '90112', '2', '', '09.09.2019 - 16:15:30', '', '1', '12.06.2021 - 15:39:39', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('742', NULL, '5045', 'Mehrzweckstrahlrohr C', '', '1723154400', '90112', '2', '', '09.09.2019 - 16:16:29', '', '3', '12.06.2021 - 15:39:54', '3', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserabgabe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('743', NULL, '5046', 'Mehrzweckstrahlrohr B', '', '1723154400', '90112', '2', '', '09.09.2019 - 16:17:10', '', '1', '12.06.2021 - 15:39:43', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserabgabe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('744', NULL, '5047', 'Schlauchhalter', '', '1723154400', '90112', '2', '', '09.09.2019 - 16:17:57', '', '4', '12.06.2021 - 15:36:35', '4', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('745', NULL, '5048', 'Forke', '', '1723154400', '90112', '2', '', '09.09.2019 - 16:18:40', '', '2', '12.06.2021 - 15:41:37', '2', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('746', NULL, '5049', 'Stoßbesen', '', '1723154400', '90112', '2', '', '09.09.2019 - 16:19:23', '', '1', '12.06.2021 - 15:41:41', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('747', NULL, '5050', 'Brechstange', '', '1723154400', '90112', '2', '', '09.09.2019 - 16:20:00', '1400mm', '1', '12.06.2021 - 15:40:37', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('748', NULL, '5051', 'Schachthaken', '', '1723154400', '90112', '2', '', '09.09.2019 - 16:20:36', '', '1', '12.06.2021 - 15:42:07', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('749', NULL, '5052', 'Mehrzweckstrahlrohr D', '', '1723154400', '90112', '2', '', '09.09.2019 - 16:21:15', '', '1', '12.06.2021 - 15:39:12', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserabgabe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('750', NULL, '5053', 'Schlauchmanschette', '', '1723154400', '90112', 'GR', '', '09.09.2019 - 16:22:06', 'B', '7', '12.06.2021 - 15:44:57', '7', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('753', NULL, '5056', 'Sammelstück', '', '1723154400', '90112', 'GR', '', '09.09.2019 - 16:24:34', '', '2', '12.06.2021 - 15:32:49', '2', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('754', NULL, '5057', 'Saugkorb', '', '1723154400', '90112', 'GR', '', '09.09.2019 - 16:25:08', '', '1', '12.06.2021 - 15:32:52', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserentnahme', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('755', NULL, '5058', 'Schwimmboje', '', '1723154400', '90112', 'GR', '', '09.09.2019 - 16:25:46', '', '1', '12.06.2021 - 15:33:16', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('756', NULL, '5059', 'Flachsaugkorb', '', '1723154400', '90112', 'GR', '', '09.09.2019 - 16:26:28', '', '1', '12.06.2021 - 15:37:30', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserentnahme', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('757', NULL, '5060', 'Kupplungsschlüssel', '', '1723154400', '90112', 'GR', '', '09.09.2019 - 16:27:04', '', '3', '12.06.2021 - 15:33:08', '3', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('759', NULL, '5062', 'Schlauchmanschette', '', '1723154400', '90112', 'GR', '', '09.09.2019 - 16:28:35', 'C', '10', '12.06.2021 - 15:45:14', '10', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('760', NULL, '5063', 'Schlauchmanschette', '', '1723154400', '90112', 'GR', '', '09.09.2019 - 16:29:12', 'B', '7', '12.06.2021 - 15:45:19', '7', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('761', NULL, '5064', 'Übergangsstück', '', '1723154400', '90112', 'GR', '', '09.09.2019 - 16:29:52', 'A>B', '1', '12.06.2021 - 15:34:34', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('762', NULL, '5065', 'Absperrorgan B', '', '1723154400', '90112', 'GR', '', '09.09.2019 - 16:31:24', 'B', '1', '12.06.2021 - 15:32:56', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('763', NULL, '5066', 'Verteiler', '', '1723154400', '90112', 'GR', '', '09.09.2019 - 16:32:00', 'B/CBC', '1', '12.06.2021 - 15:32:54', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('764', NULL, '5067', 'Dreikantschlüssel', '', '1723154400', '90112', 'Mannschaft Vorne', '', '09.09.2019 - 17:36:15', '', '2', '12.06.2021 - 15:15:52', '2', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('765', NULL, '5068', 'Verbandkasten', '', '1723154400', '90112', 'Mannschaft Vorne', '', '09.09.2019 - 17:37:27', '', '1', '12.06.2021 - 15:25:32', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.06.2024', '0', 'Erste Hilfe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('766', NULL, '5069', 'Gurtmesser', '', '1723154400', '90112', 'Mannschaft Vorne', '', '09.09.2019 - 17:38:07', '', '2', '12.06.2021 - 15:21:24', '2', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('767', NULL, '5070', 'Funkverzeichnis', '', '1723154400', '90112', 'Mannschaft Vorne', '', '09.09.2019 - 17:39:00', '', '1', '12.06.2021 - 15:22:31', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('768', NULL, '5071', 'Hydrantenverzeichnis', '', '1723154400', '90112', 'Mannschaft Vorne', '', '09.09.2019 - 17:39:59', '', '1', '12.06.2021 - 15:24:42', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('769', NULL, '5072', 'Warndreieck', '', '1723154400', '90112', 'Mannschaft Vorne', '', '09.09.2019 - 17:40:36', '', '1', '12.06.2021 - 15:24:06', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('772', NULL, '5075', 'Atemanschluss', '', '1628632800', '90112', 'Mannschaft Hinten', '', '09.09.2019 - 17:44:06', '', '5', '16.08.2021 - 10:39:31', '5', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('774', NULL, '5077', 'Kuhfuss', '', '1723154400', '90112', 'Mannschaft Hinten', '', '10.09.2019 - 16:28:32', '', '1', '12.06.2021 - 15:27:07', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('775', NULL, '5078', 'Gummistiefel', '', '1723154400', '90112', 'Mannschaft Hinten', '', '10.09.2019 - 16:29:15', '2 Paar', '2', '12.06.2021 - 15:22:01', '2', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Schutzkleidung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('776', NULL, '5079', 'Warnweste', '', '1723154400', '90112', 'Mannschaft Hinten', '', '10.09.2019 - 16:29:54', '', '3', '12.06.2021 - 15:21:52', '3', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Schutzkleidung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('777', NULL, '5080', 'Bügelsäge', '', '1723154400', '90112', 'Mannschaft Hinten', '', '10.09.2019 - 16:31:57', '', '1', '12.06.2021 - 15:23:18', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('778', NULL, '5081', 'Bolzenschneider', '', '1723154400', '90112', 'Mannschaft Hinten', '', '10.09.2019 - 16:33:02', 'Bolzenschneider klein', '1', '12.06.2021 - 15:21:31', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('779', NULL, '5082', 'Brechstange', '', '1723154400', '90112', 'Mannschaft Hinten', '', '10.09.2019 - 16:34:04', 'Brechstange klein', '1', '12.06.2021 - 15:26:47', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('810', NULL, '4023', 'Druckschlauch B', '', '1733526000', '90114', 'GR', '', '11.09.2019 - 12:42:49', 'Druckschlauch B', '67', '12.06.2021 - 14:34:49', '67', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('811', NULL, '4024', 'Standrohr', '', '1733526000', '90114', 'GR', '', '11.09.2019 - 12:44:04', '', '1', '12.06.2021 - 14:39:37', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserentnahme', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('812', NULL, '4025', 'Überflurhydrantenschlüssel', '', '1733526000', '90114', 'GR', '', '11.09.2019 - 12:44:35', '', '1', '12.06.2021 - 14:35:51', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('813', NULL, '4026', 'Bindemittel', '', '1733526000', '90114', 'GR', '', '11.09.2019 - 12:45:25', 'Faß Bindemittel\r\n\r\nRollcontainer Schaummittel/Bindemittel', '1', '12.06.2021 - 14:39:02', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('814', NULL, '4027', 'RC Schaummittel', '', '1733526000', '50001', '------', '', '11.09.2019 - 12:46:01', 'Rollcontainer Schaummittel', '10', '20.01.2025 - 12:22:50', '10', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('815', NULL, '4028', 'Schwimmsaugkorb', '', '1733526000', '90114', 'GR', '', '11.09.2019 - 12:46:38', 'Rollcontainer TS', '1', '31.01.2024 - 16:48:13', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserentnahme', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('816', NULL, '4029', 'Unterlegkeil ', '', '1733526000', '90114', 'Traversenkasten Links', '', '11.09.2019 - 12:47:28', 'Traversenkasten links klein\r\n\r\nRollcontainer Schaummittel/Bindemittel', '1', '12.06.2021 - 14:50:42', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('817', NULL, '4030', 'Verkehrsleitkegel', '', '1733526000', '90114', 'Traversenkasten Rechts', '', '11.09.2019 - 12:48:40', 'Traversenkasten rechts klein\r\n\r\n', '8', '12.06.2021 - 14:53:03', '8', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('818', NULL, '4031', 'Schlauchbrücke', '', '1733526000', '90114', 'Traversenkasten Rechts', '', '11.09.2019 - 12:49:35', 'Traversenkasten rechts groß', '5', '12.06.2021 - 14:53:13', '5', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('819', NULL, '4031', 'Schlauchtragekorb', '', '1733526000', '90114', 'Traversenkasten Links', '', '11.09.2019 - 12:50:18', 'Traversenkasten rechts groß', '5', '12.06.2021 - 14:53:13', '5', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('820', NULL, '4032', 'Druckbegrenzungsventil', '', '1638140400', '50001', 'GR', '', '11.09.2019 - 12:51:31', 'Rollcontainer WFA', '1', '15.12.2022 - 09:11:25', '1', '', '15.12.2022', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('821', NULL, '4033', 'Stützkrümmer', '', '1638140400', '50001', 'GR', '', '11.09.2019 - 12:52:12', 'Rollcontainer WFA', '1', '15.12.2022 - 09:13:01', '1', '', '15.12.2022', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('822', NULL, '4034', 'Kübelspritze', '', '1736377200', '50001', 'GR', '', '11.09.2019 - 12:52:44', 'Rollcontainer WFA', '1', '09.01.2025 - 16:29:39', '1', '', '', 'KÜB12681', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerlöscher', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('823', NULL, '4035', 'Übergangsstück', '', '1638140400', '50001', 'GR', '', '11.09.2019 - 12:53:18', 'B>C\r\n\r\nRollcontainer WFA', '3', '15.12.2022 - 09:13:28', '3', '', '15.12.2022', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('824', NULL, '4036', 'Verteiler', '', '1638140400', '50001', 'GR', '', '11.09.2019 - 12:54:07', 'B/CBC\r\n\r\nRollcontainer WFA', '1', '15.12.2022 - 09:13:40', '1', '', '15.12.2022', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('825', NULL, '4037', 'Mehrzweckstrahlrohr C', '', '1638140400', '50001', 'GR', '', '11.09.2019 - 12:55:01', 'Rollcontainer WFA', '2', '15.12.2022 - 09:14:01', '2', '', '15.12.2022', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Wasserabgabe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('826', NULL, '4038', 'Mehrzweckstrahlrohr B', '', '1638140400', '50001', 'GR', '', '11.09.2019 - 12:55:43', 'Rollcontainer WFA', '2', '15.12.2022 - 09:14:14', '2', '', '15.12.2022', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Wasserabgabe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('827', NULL, '4039', 'Wasserstrahlpumpe', '', '1638140400', '50001', 'GR', '', '11.09.2019 - 12:56:25', 'Rollcontainer WFA', '1', '15.12.2022 - 09:14:32', '1', '', '15.12.2022', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Wasserentnahme', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('828', NULL, '4040', 'Schlauchmanschette', '', '1733526000', '90114', 'GR', '', '11.09.2019 - 12:56:57', 'Rollcontainer WFA', '16', '12.06.2021 - 14:46:34', '16', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('829', NULL, '4041', 'Gasflasche', '', '1638140400', '50001', 'GR', '', '11.09.2019 - 12:57:38', 'Rollcontainer WFA', '1', '15.12.2022 - 09:14:51', '1', '', '15.12.2022', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('830', NULL, '4042', 'Brenner', '', '1638140400', '50001', 'GR', '', '11.09.2019 - 12:58:02', 'Rollcontainer WFA', '1', '15.12.2022 - 09:15:06', '1', '', '15.12.2022', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('834', NULL, '4046', 'Schlauchwickler', '', '1733526000', '90114', 'GR', '', '11.09.2019 - 13:19:54', 'Kofferaufbau', '2', '12.06.2021 - 14:42:12', '2', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sondergerät', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('835', NULL, '4047', 'Brechstange', '', '1733526000', '90114', 'GR', '', '11.09.2019 - 13:20:33', 'Kofferaufbau', '3', '11.01.2022 - 20:13:21', '3', '', '11.01.2022', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('836', NULL, '4048', 'Stoßbesen', '', '1733526000', '90114', 'GR', '', '11.09.2019 - 13:21:06', 'Kofferaufbau', '1', '12.06.2021 - 14:43:26', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('837', NULL, '4049', 'Bügelsäge', '', '1733526000', '90114', 'GR', '', '11.09.2019 - 13:21:39', 'Kofferaufbau', '2', '12.06.2021 - 14:42:07', '2', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('838', NULL, '4050', 'Schaufel', '', '1733526000', '90114', 'GR', '', '11.09.2019 - 13:43:34', 'Kofferaufbau', '1', '12.06.2021 - 14:46:45', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('839', NULL, '4051', 'Verbandkasten Fw', '', '1733526000', '90114', 'Mannschaft Hinten', '', '11.09.2019 - 13:45:16', 'Verbandkasten groß', '1', '12.06.2021 - 14:58:27', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.06.2034', '0', 'Erste Hilfe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('840', NULL, '4052', 'Werkzeugkasten', '', '1733526000', '90114', 'Mannschaft Hinten', '', '11.09.2019 - 13:51:16', '', '1', '12.06.2021 - 14:59:00', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('841', NULL, '4053', 'Warnweste', '', '1733526000', '90114', 'Mannschaft Hinten', '', '11.09.2019 - 13:51:50', '', '2', '12.06.2021 - 14:59:20', '2', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Schutzkleidung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('842', NULL, '4054', 'Warndreieck', '', '1733526000', '90114', 'Mannschaft Hinten', '', '11.09.2019 - 13:52:22', '', '2', '12.06.2021 - 15:01:18', '2', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('843', NULL, '4055', 'Verbandkasten', '', '1733526000', '90114', 'Mannschaft Hinten', '', '11.09.2019 - 13:53:11', 'Verbandkasten klein', '1', '12.06.2021 - 14:57:50', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.05.2024', '0', 'Erste Hilfe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('845', NULL, '4057', 'Standrohr', '', '1733526000', '90114', 'GR', '', '11.09.2019 - 13:55:06', 'Rollcontainer TS', '1', '12.06.2021 - 14:39:39', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserentnahme', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('846', NULL, '4058', 'Überflurhydrantenschlüssel', '', '1733526000', '90114', 'GR', '', '11.09.2019 - 13:55:40', 'Rollcontainer TS', '1', '12.06.2021 - 14:37:21', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('847', NULL, '4059', 'Abgasschlauch klein', '', '1733526000', '90114', 'GR', '', '11.09.2019 - 13:56:31', 'Rollcontainer TS', '1', '12.06.2021 - 14:46:56', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('848', NULL, '4060', 'Saugschlauch', '', '1733526000', '90114', 'GR', '', '11.09.2019 - 13:57:12', 'Rollcontainer TS', '4', '12.06.2021 - 14:38:09', '4', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('849', NULL, '4061', 'Kanister 10ltr.', '', '1733526000', '90114', 'GR', '', '11.09.2019 - 13:57:56', 'Kanister 10ltr. Benzin', '1', '12.06.2021 - 14:49:18', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('850', NULL, '4062', 'Schachthaken', '', '1733526000', '90114', 'GR', '', '11.09.2019 - 13:58:36', 'Schachthaken lang\r\n\r\nRollcontainer TS', '1', '12.06.2021 - 14:37:10', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('851', NULL, '4063', 'Schachthaken', '', '1733526000', '90114', 'GR', '', '11.09.2019 - 13:59:15', 'Schachthaken klein\r\n\r\nRollcontainer TS', '2', '12.06.2021 - 14:36:30', '2', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('852', NULL, '4064', 'Saugkorb', '', '1733526000', '90114', 'GR', '', '11.09.2019 - 13:59:45', 'Rollcontainer TS', '1', '12.06.2021 - 14:47:20', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserentnahme', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('853', NULL, '4065', 'Saugschutzkorb', '', '1733526000', '90114', 'GR', '', '11.09.2019 - 14:00:23', 'Rollcontainer TS', '1', '12.06.2021 - 14:47:25', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('854', NULL, '4066', 'Kupplungsschlüssel', '', '1733526000', '90114', 'GR', '', '11.09.2019 - 14:01:05', 'Rollcontainer TS', '3', '12.06.2021 - 14:35:41', '3', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('855', NULL, '4067', 'Übergangsstück', '', '1733526000', '90114', 'GR', '', '11.09.2019 - 14:01:48', 'A>B\r\n\r\nRollcontainer TS', '1', '12.06.2021 - 14:37:37', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('856', NULL, '4068', 'Sammelstück', '', '1733526000', '90114', 'GR', '', '11.09.2019 - 14:02:24', 'Rollcontainer TS', '1', '12.06.2021 - 14:35:47', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserentnahme', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('857', NULL, '4069', 'Verlängerung', '', '1733526000', '90114', 'GR', '', '11.09.2019 - 14:03:31', 'Verlängerung für UH\r\n\r\nRollcontainer TS', '3', '12.06.2021 - 14:36:09', '3', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('858', NULL, '4070', 'Turbinentauchpumpe', '', '1733526000', '90114', 'GR', '', '11.09.2019 - 14:04:19', 'Rollcontainer TS', '1', '12.06.2021 - 14:47:33', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserentnahme', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('859', NULL, '4071', 'Funkverzeichnis', '', '1733526000', '90114', 'Mannschaft Vorne', '', '11.09.2019 - 14:04:49', '', '1', '12.06.2021 - 15:02:47', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('860', NULL, '4072', 'Hydrantenverzeichnis', '', '1733526000', '90114', 'Mannschaft Vorne', '', '11.09.2019 - 14:05:48', '', '1', '12.06.2021 - 15:03:14', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('861', NULL, '4073', 'Fahrzeugführerweste', '', '1733526000', '90114', 'Mannschaft Vorne', '', '11.09.2019 - 14:06:22', '', '1', '12.06.2021 - 15:01:44', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('862', NULL, '30354638', 'Rettungsspreizer', '1546297200', '1737586800', '90111', '1', '', '17.09.2019 - 12:14:40', 'Typ SP 53 BS', '1', '22.09.2021 - 11:22:18', '1', '', '', 'SP12481', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('863', NULL, '30354639', 'Motorpumpenaggregat', '1546297200', '1737586800', '90111', '1', '', '17.09.2019 - 12:15:53', '', '1', '17.09.2021 - 14:28:58', '1', '', '', 'MP12481', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('864', NULL, '30354637', 'Rettungsschere', '1546297200', '1737586800', '90111', '1', '', '17.09.2019 - 12:16:51', 'Typ RSU 180 Plus\r\n\r\n', '1', '22.09.2021 - 11:22:02', '1', '', '', 'SG12481', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('865', NULL, '6001', 'Solarblitz', '', '1722463200', '90115', 'GR', '', '17.09.2019 - 12:47:39', 'test\r\n', '2', '08.06.2023 - 21:02:40', '2', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('866', NULL, '6002', 'Flipchart', '', '1722463200', '90115', 'GR', '', '17.09.2019 - 12:48:27', '', '1', '08.06.2023 - 21:02:43', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sondergerät', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('868', NULL, '6003', 'Warnlampe', '', '1722463200', '90115', 'GR', '', '17.09.2019 - 12:50:58', '', '2', '08.06.2023 - 21:02:48', '2', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('869', NULL, '6004', 'Fernglas', '', '1722463200', '90115', 'GR', '', '17.09.2019 - 12:51:30', '', '1', '08.06.2023 - 21:02:55', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sondergerät', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('870', NULL, '6005', 'Absperrband', '', '1722463200', '90115', 'GR', '', '17.09.2019 - 12:52:02', '', '1', '08.06.2023 - 21:03:00', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('871', NULL, '6006', 'Adapter für Anhänger', '', '1722463200', '90115', 'Mannschaft Vorne', '', '17.09.2019 - 12:52:26', '', '1', '08.06.2023 - 21:04:03', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sondergerät', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('872', NULL, '6007', 'Faltleitkegel', '', '1722463200', '90115', 'GR', '', '10.09.2019 - 16:51:40', '', '2', '08.06.2023 - 21:03:04', '2', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('873', NULL, '6008', 'Überbrückungskabel', '', '1722463200', '90115', 'GR', '', '17.09.2019 - 12:53:41', '', '1', '08.06.2023 - 21:03:14', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sondergerät', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('874', NULL, '6009', 'Anhaltestab', '', '1722463200', '90115', 'GR', '', '17.09.2019 - 12:54:07', '', '2', '08.06.2023 - 21:03:17', '2', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('875', NULL, '6010', 'Faltsignal', '', '1722463200', '90115', 'GR', '', '17.09.2019 - 12:54:39', 'fghfgh', '2', '08.06.2023 - 21:03:21', '2', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '22222', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('877', NULL, '6012', 'Verbandkasten', '', '1722463200', '90115', 'Mannschaft Vorne', '', '17.09.2019 - 12:55:57', '', '1', '08.06.2023 - 21:04:06', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Erste Hilfe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('878', NULL, '6013', 'Dreikantschlüssel', '', '1722463200', '90115', 'Mannschaft Vorne', '', '17.09.2019 - 12:56:35', '', '2', '08.06.2023 - 21:04:10', '2', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('879', NULL, '6014', 'MagLite Lampe', '', '1722463200', '90115', 'Mannschaft Vorne', '', '17.09.2019 - 12:57:02', '', '2', '08.06.2023 - 21:04:14', '2', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Handlampe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('880', NULL, '6015', 'Windmesser', '', '1722463200', '90115', 'GR', '', '17.09.2019 - 12:58:08', '', '1', '08.06.2023 - 21:03:24', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sondergerät', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('881', NULL, '6016', 'Funkgerät HRT', '', '1722463200', '90115', 'Mannschaft Vorne', '', '17.09.2019 - 12:59:42', 'HRT', '1', '08.06.2023 - 21:04:26', '1', '', '', '12-11-1-1', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '02.12.2022', '', '4222933', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('882', NULL, '6017', 'Funkgerät HRT', '', '1722463200', '90115', 'Mannschaft Vorne', '', '17.09.2019 - 13:00:18', 'HRT', '1', '08.06.2023 - 21:04:33', '1', '', '', '12-11-1-2', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '02.12.2022', '', '6221838', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('883', NULL, '6018', 'Funkgerät HRT', '', '1722463200', '90115', 'Mannschaft Hinten', '', '17.09.2019 - 13:00:48', 'HRT', '1', '08.06.2023 - 21:03:38', '1', '', '', '12-11-1-3', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '02.12.2022', '', '6224930', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('884', NULL, '6019', 'Funkgerät HRT', '', '1722463200', '90115', 'Mannschaft Hinten', '', '17.09.2019 - 13:01:24', 'HRT', '1', '08.06.2023 - 21:03:42', '1', '', '', '12-11-1-4', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '02.12.2022', '', '6224931', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('885', NULL, '6020', 'Einspeisekabel', '', '1722463200', '90115', 'GR', '', '18.09.2019 - 15:15:57', '', '1', '08.06.2023 - 21:03:27', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('887', NULL, '30354614', 'Kübelspritze', '', '1725141600', '90112', '2', '', '20.09.2019 - 15:48:11', '', '1', '23.05.2024 - 10:29:12', '1', '', '', 'KÜB12431', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerlöscher', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('888', NULL, '30344613', 'Krankentrage', '', '1723154400', '90112', 'GR', '', '20.09.2019 - 16:06:19', '', '1', '12.06.2021 - 15:33:58', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sanitätsgerät', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('889', NULL, '5036', 'Tragkraftspritze', '', '1723154400', '50001', '1', '', '20.09.2019 - 16:15:40', 'FOX 2', '1', '15.08.2024 - 13:59:43', '1', '', '', 'TS12431', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserentnahme', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('891', NULL, '30347540', 'Einreißhaken', '', '1723154400', '90112', 'Dach', '', '20.09.2019 - 16:19:17', '', '1', '12.06.2021 - 15:44:41', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('892', NULL, '5043', 'Holzaxt', '', '1723154400', '90112', '3', '', '20.09.2019 - 16:36:02', '', '1', '12.06.2021 - 15:29:56', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('893', NULL, '30347128', 'Anhaltestab', '', '1723154400', '90112', 'Mannschaft Vorne', '', '20.09.2019 - 16:39:27', '', '1', '12.06.2021 - 15:15:00', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('894', NULL, '30347129', 'Anhaltestab', '', '1723154400', '90112', 'Mannschaft Hinten', '', '20.09.2019 - 16:40:30', '', '1', '12.06.2021 - 15:25:56', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('895', NULL, '30347208', 'Solarblitz', '', '1723154400', '90112', 'Mannschaft Hinten', '', '20.09.2019 - 16:42:03', '', '1', '12.06.2021 - 15:24:28', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('896', NULL, '30347209', 'Solarblitz', '', '1723154400', '90112', 'Mannschaft Hinten', '', '20.09.2019 - 16:42:47', '', '1', '12.06.2021 - 15:24:23', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('897', NULL, '30347120', 'Handlampe HS 4 EX', '', '1723154400', '90112', 'Mannschaft Hinten', '', '20.09.2019 - 16:43:45', 'Nr.5  ', '1', '12.06.2021 - 15:19:13', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Handlampe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('898', NULL, '30347118', 'Handlampe Halo 4 EX', '', '1723154400', '90112', 'Mannschaft Hinten', '', '20.09.2019 - 16:45:02', 'Nr.3   Hallo4 EX', '1', '12.06.2021 - 15:16:22', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Handlampe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('899', NULL, '30347117', 'Handlampe HS 4 EX', '', '1723154400', '90112', 'Mannschaft Hinten', '', '20.09.2019 - 16:46:31', 'Nr.2  ', '1', '12.06.2021 - 15:17:32', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Handlampe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('900', NULL, '30347116', 'Handlampe Halo 4 EX', '', '1723154400', '90112', 'Mannschaft Vorne', '', '20.09.2019 - 16:47:39', 'Nr.1 ', '1', '12.06.2021 - 15:17:00', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Handlampe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('901', NULL, '30354138', 'Handlampe Halo 4 ', '', '1723154400', '90112', 'Mannschaft Hinten', '', '20.09.2019 - 16:48:19', '', '1', '12.06.2021 - 15:19:23', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Handlampe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('902', NULL, '5073', 'Verbandkasten Fw', '', '1723154400', '90112', 'Mannschaft Hinten', '', '20.09.2019 - 16:55:07', '', '1', '12.06.2021 - 15:25:45', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.07.2023', '0', 'Erste Hilfe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('903', NULL, '30347997', 'Akku Strahler', '', '1723154400', '90112', '2', '', '20.09.2019 - 16:57:30', '', '1', '12.06.2021 - 15:43:07', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Beleuchtung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('904', NULL, '5061', 'Schlauchmanschette', '', '1723154400', '90112', 'GR', '', '20.09.2019 - 17:00:33', 'C', '9', '12.06.2021 - 15:33:01', '9', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('905', NULL, '5076', 'Forke gewinkelt', '', '1723154400', '90112', '2', '', '20.09.2019 - 17:02:43', '', '2', '12.06.2021 - 15:40:58', '2', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('906', NULL, '30356411', 'Abschleppseil', '', '1723154400', '90112', 'Mannschaft Hinten', '', '20.09.2019 - 17:03:33', '', '1', '12.06.2021 - 15:22:54', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('907', NULL, '30354610', 'Abschleppseil', '', '1723154400', '90112', 'Mannschaft Hinten', '', '20.09.2019 - 17:04:04', '', '1', '12.06.2021 - 15:23:11', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('908', NULL, '5001', 'Funkgerät HRT', '', '1723154400', '90112', 'Mannschaft Vorne', '', '20.09.2019 - 17:07:58', '', '1', '27.09.2021 - 13:45:41', '1', '', '', '12-43-1-1', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '02.12.2022', '', '4224387', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('909', NULL, '5002', 'Funkgerät HRT', '', '1723154400', '90112', 'Mannschaft Vorne', '', '20.09.2019 - 17:08:59', '', '1', '27.09.2021 - 13:45:44', '1', '', '', '12-43-1-2', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '02.12.2022', '', '6223908', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('910', NULL, '5003', 'Funkgerät HRT', '', '1723154400', '90112', 'Mannschaft Hinten', '', '20.09.2019 - 17:10:01', '', '1', '27.09.2021 - 13:45:48', '1', '', '', '12-43-1-3', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '02.12.2022', '', '6223909', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('911', NULL, '5009', 'Funkgerät HRT', '', '1723154400', '90112', 'Mannschaft Hinten', '', '20.09.2019 - 17:14:54', '', '1', '30.06.2022 - 12:10:06', '1', '', '', '12-43-1-4', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '02.12.2022', '', '6223910', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('912', NULL, '30354756', 'Wathose', '', '1723154400', '90112', 'Mannschaft Hinten', '', '20.09.2019 - 17:17:25', '', '1', '12.06.2021 - 15:26:07', '1', '', '', 'AR2116', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Schutzkleidung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('913', NULL, '30354757', 'Wathose', '', '1723154400', '90112', 'Mannschaft Hinten', '', '20.09.2019 - 17:18:03', '', '1', '12.06.2021 - 15:26:16', '1', '', '', 'AR2117', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Schutzkleidung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('914', NULL, '30347126', 'Warnlampe', '', '1723154400', '90112', 'Mannschaft Hinten', '', '20.09.2019 - 17:18:49', '', '1', '12.06.2021 - 15:26:27', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('915', NULL, '30347127', 'Warnlampe', '', '1723154400', '90112', 'Mannschaft Hinten', '', '20.09.2019 - 17:19:17', '', '1', '12.06.2021 - 15:26:22', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('916', NULL, '5010', 'Tragetuch', '', '1723154400', '90112', 'Mannschaft Hinten', '', '20.09.2019 - 17:22:46', 'groß', '1', '12.06.2021 - 15:20:28', '1', '', '', 'Rett2122', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sanitätsgerät', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('917', NULL, '5055', 'Tragetuch', '', '1723154400', '90112', 'Mannschaft Hinten', '', '20.09.2019 - 17:23:27', '', '1', '12.06.2021 - 15:20:34', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sanitätsgerät', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('918', NULL, '5008', 'Ansaugschlauch', '', '1723154400', '90112', '4', '', '20.09.2019 - 17:26:10', 'D', '1', '26.07.2022 - 19:56:13', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('919', NULL, '5007', 'Wagenheber', '', '1723154400', '90112', 'Mannschaft Hinten', '', '20.09.2019 - 17:29:39', '', '1', '12.06.2021 - 15:21:04', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('920', NULL, '5074', 'Unterlegkeil', '', '1723154400', '90112', 'Mannschaft Hinten', '', '20.09.2019 - 17:31:29', '', '1', '12.06.2021 - 15:21:24', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('921', NULL, '5018', 'Steckleiterteil', '', '1723154400', '90112', 'Dach', '', '20.09.2019 - 17:33:51', '', '4', '29.06.2022 - 16:32:43', '4', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Leitern', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('924', NULL, '2117', 'Rundschlinge', '1546297200', '1738368000', '90113', '5', '', '25.09.2019 - 15:52:08', '2t.\r\nS/N 11228', '1', '12.06.2021 - 13:40:44', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.01.2029', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('925', NULL, '2118', 'Rundschlinge', '1230764400', '1738368000', '90113', '5', '', '25.09.2019 - 15:54:35', '2t.\r\nSN 11217', '1', '12.06.2021 - 13:41:03', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.01.2029', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('926', NULL, '2119', 'Rundschlinge', '1546297200', '1738368000', '90113', '5', '', '25.09.2019 - 15:55:37', '2t.\r\nSN 11317', '1', '12.06.2021 - 13:40:25', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.01.2029', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('927', NULL, '2120', 'Rundschlinge', '1546297200', '1738368000', '90113', '5', '', '25.09.2019 - 16:09:46', '2t.\r\nSN11252', '1', '12.06.2021 - 13:40:51', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.01.2029', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('928', NULL, '2121', 'Rundschlinge', '1546297200', '1738368000', '90113', '5', '', '25.09.2019 - 16:12:44', '2t.\r\nSN 11308', '1', '12.06.2021 - 13:41:44', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.01.2029', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('929', NULL, '2122', 'Rundschlinge', '1546297200', '1738368000', '90113', '5', '', '25.09.2019 - 16:16:07', '2t.\r\nSN11244', '1', '12.06.2021 - 13:41:57', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.01.2029', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('930', NULL, '2123', 'Spanngurt', '1546297200', '1738368000', '90113', '3', '', '25.09.2019 - 16:39:40', 'SN 0024\r\n4m', '1', '12.06.2021 - 14:23:55', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '01.01.2029', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('931', NULL, '2124', 'Spanngurt', '1541026800', '1738368000', '90113', '3', '', '25.09.2019 - 16:47:05', 'SN08938\r\n6m.', '1', '12.06.2021 - 14:23:59', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '01.01.2028', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('934', NULL, '5083', 'Spanngurt', '1546297200', '1723154400', '90112', '2', '', '25.09.2019 - 16:59:59', 'SN 0508\r\n4m', '1', '12.06.2021 - 15:42:59', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '01.01.2029', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('935', NULL, '5084', 'Spanngurt', '1541026800', '1723154400', '90112', '2', '', '25.09.2019 - 17:02:05', 'SN 08737\r\n6m', '1', '12.06.2021 - 15:42:54', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '01.01.2028', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('936', NULL, '3135', 'Spanngurt', '1541026800', '1721253600', '90110', '2', '', '25.09.2019 - 17:08:05', 'SN 08874\r\n6m', '1', '08.06.2023 - 20:23:22', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.11.2028', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('937', NULL, '3136', 'Spanngurt', '1546297200', '1721253600', '90110', '2', '', '25.09.2019 - 17:09:33', 'SN0188\r\n4m', '1', '08.06.2023 - 20:23:26', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.01.2029', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('941', NULL, '30354609', 'Tragkraftspritze', '1561932000', '1733526000', '90114', 'GR', '', '28.09.2019 - 13:38:42', '', '1', '12.06.2021 - 14:37:53', '1', '', '', 'TS12681', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserentnahme', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('942', NULL, '30349144', 'Warnlampe', '', '1733526000', '90114', 'Mannschaft Hinten', '', '28.09.2019 - 14:22:07', '', '1', '12.06.2021 - 15:01:05', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('943', NULL, '30349145', 'Warnlampe', '', '1733526000', '90114', 'Mannschaft Hinten', '', '28.09.2019 - 14:23:51', '', '1', '12.06.2021 - 15:00:59', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('945', NULL, '4074', 'Ladungssicherungsnetz', '', '1733526000', '90114', 'GR', '', '28.09.2019 - 14:29:17', '', '1', '12.06.2021 - 14:43:39', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('946', NULL, '3034778', 'Akku Strahler', '', '1733526000', '90114', 'GR', '', '28.09.2019 - 14:35:25', '', '1', '12.06.2021 - 14:43:07', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Beleuchtung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('947', NULL, '30349105', 'Solarblitz', '', '1733526000', '90114', 'Mannschaft Hinten', '', '28.09.2019 - 14:36:24', '', '1', '12.06.2021 - 15:00:52', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('948', NULL, '30349006', 'Rundschlinge', '', '1638140400', '50001', 'GR', '', '28.09.2019 - 14:38:38', '4t.', '1', '15.12.2022 - 09:15:15', '1', '', '15.12.2022', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Ausgesondert', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('949', NULL, '30349005', 'Rundschlinge', '', '1638140400', '50001', 'GR', '', '28.09.2019 - 14:40:07', '4t.', '1', '15.12.2022 - 09:15:25', '1', '', '15.12.2022', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Ausgesondert', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('950', NULL, '4075', 'Spanngurt', '1354316400', '1733526000', '90114', 'GR', '', '28.09.2019 - 14:52:05', '', '6', '12.06.2021 - 14:43:49', '6', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.12.2022', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('951', NULL, '4076', 'Spanngurt', '1377986400', '1733526000', '90114', 'GR', '', '28.09.2019 - 14:54:38', '', '1', '12.06.2021 - 14:48:07', '1', '', '', 'SPG1268107', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '01.09.2023', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('953', NULL, '4077', 'Kantenschutz', '', '1733526000', '90114', 'GR', '', '28.09.2019 - 15:00:16', '2 Sorten', '30', '12.06.2021 - 14:43:45', '30', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('954', NULL, '4078', 'Anti Rutschmatte', '', '1733526000', '90114', 'GR', '', '28.09.2019 - 15:05:35', '', '11', '12.06.2021 - 14:43:41', '11', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('955', NULL, '4044', 'Solarblitz', '', '1733526000', '90114', 'Mannschaft Hinten', '', '28.09.2019 - 15:11:35', '', '2', '12.06.2021 - 14:58:33', '2', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('956', NULL, '4056', 'Hydrantenschlüssel', '', '1733526000', '90114', 'GR', '', '28.09.2019 - 15:12:42', '1 im Koffer\r\n1 auf dem RW TS', '2', '12.06.2021 - 14:39:17', '2', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('957', NULL, '4079', 'Funkgerät HRT', '', '1733526000', '90114', 'Mannschaft Vorne', '', '28.09.2019 - 15:15:55', '', '1', '27.09.2021 - 14:22:35', '1', '', '', '12-68-1-1', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '02.12.2022', '', '6224867', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('958', NULL, '4045', 'Füllstutzen', '', '1733526000', '90114', 'GR', '', '28.09.2019 - 15:18:08', 'RW TS', '1', '12.06.2021 - 14:35:37', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('959', NULL, '30354759', 'Forsthelm', '1470002400', '1723154400', '90112', '1', '', '28.09.2019 - 15:26:00', '', '1', '12.06.2021 - 15:44:04', '1', '', '', '2108', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '01.08.2021', '0', 'Säge Equipment', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('960', NULL, '30354760', 'Kombi Kanister', '1541026800', '1723154400', '90112', '1', '', '28.09.2019 - 15:26:53', '', '1', '12.06.2021 - 15:28:47', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.11.2023', '0', 'Säge Equipment', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('961', NULL, '5085', 'Schnittschutzhose', '', '1723154400', '90112', '1', '', '28.09.2019 - 15:31:09', '', '1', '18.04.2023 - 10:49:24', '1', '', '18.04.2023', '2104', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Säge Equipment', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('962', NULL, '30354761', 'Motorkettensäge', '', '1723154400', '90112', '1', '', '28.09.2019 - 15:32:05', 'Stihl 024 AV\r\n\r\nKetten Nr.\r\nBestell Nr. 3686 000 0056\r\n            26 RM 56     \r\n32cm Schwert', '1', '04.03.2022 - 15:51:49', '1', '', '', 'Mo2104', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Säge Equipment', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('963', NULL, '30349113', 'Anhaltestab', '', '1733526000', '90114', 'Mannschaft Vorne', '', '28.09.2019 - 15:36:39', '', '1', '12.06.2021 - 15:03:07', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('964', NULL, '30349167', 'Anhaltestab', '', '1733526000', '90114', 'Mannschaft Hinten', '', '28.09.2019 - 15:37:07', '', '1', '12.06.2021 - 15:00:41', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('965', NULL, '30349165', 'Handlampe HS 4 EX ', '', '1703026800', '50001', '------', '', '28.09.2019 - 15:38:21', '', '1', '10.12.2024 - 16:55:25', '1', '', '10.12.2024', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Handlampe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('966', NULL, '30349125', 'Handlampe HS 4 EX ', '', '1703026800', '50001', '------', '', '28.09.2019 - 15:39:02', '', '1', '10.12.2024 - 16:55:56', '1', '', '10.12.2024', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Handlampe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('967', NULL, '30349166', 'Handlampe Halo 4 EX ', '', '1734649200', '90112', 'Mannschaft Vorne', '', '28.09.2019 - 15:39:39', '', '1', '10.12.2024 - 16:57:40', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Handlampe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('969', NULL, '4082', 'Schlauchtragekorb', '', '1733526000', '90114', 'Traversenkasten Links', '', '28.09.2019 - 15:47:28', 'Am 04.06.2020 auf TLF verlastet. Als Ersatz bis der vom TLF repariert ist.', '4', '12.06.2021 - 14:52:35', '4', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserfuehrend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('970', NULL, '2125', 'Funkgerät HRT', '', '1738368000', '90113', 'Mannschaft Vorne', '', '02.10.2019 - 10:23:09', 'sepura HRT', '1', '27.09.2021 - 14:04:39', '1', '', '', '12-52-1-2', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '02.12.2022', '', '6224887', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('971', NULL, '8500', 'Schaumlöscher 6l', '', '1716328800', '50001', '', '', '18.10.2019 - 15:33:58', '\r\n ', '1', '23.05.2024 - 10:20:19', '1', '', '', 'A2BZ01', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerlöscher', '20.12.2021', '', '', 'A2BZ', '', '24', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('972', NULL, '8501', 'Schaumlöscher 6l', '', '1716328800', '50001', '', '', '18.10.2019 - 15:36:26', '', '1', '23.05.2024 - 10:20:38', '1', '', '', 'A2BZ16', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerlöscher', '20.12.2021', '', '', 'A2BZ', '', '24', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('973', NULL, '5086', 'CSA Kiste', '', '1723154400', '90112', 'Dach', '', '18.10.2019 - 15:50:11', '1 CSA Nr. 22 Fabrik Nr.FRKB-0094 BJ.27.02.2016\r\n2 Overall 56\r\n1 Helm\r\n1 Paar Socken\r\n1 Paar Puschen\r\n1 Trainingsanzug\r\n1 Folie\r\n1 Schutzhaube\r\n1 Zubehörkiste ( 1 Headset, 2 Fettstift, 1 Lappen, Klarsichtmittel, 1 Tüte Ohrstecker)', '1', '12.06.2021 - 15:43:59', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Gefahrgut', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('974', NULL, '5087', 'CSA Kiste', '', '1723154400', '90112', 'Dach', '', '18.10.2019 - 15:51:17', '1 CSA Nr. 20  Fabrik Nr. FRKB-0109 BJ. 28.02.2017\r\n2 Overall 52\r\n1 Helm\r\n1 Paar Socken\r\n1 Paar Puschen\r\n1 Trainingsanzug\r\n1 Folie\r\n1 Schutzhaube\r\n1 Zubehörkiste ( 1 Headset, 2 Fettstift, 1 Lappen, Klarsichtmittel, 1 Tüte Ohrstecker)', '1', '12.06.2021 - 15:44:08', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Gefahrgut', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('975', NULL, '5088', 'CSA Kiste', '', '1723154400', '90112', 'Dach', '', '18.10.2019 - 15:53:53', '1 CSA Nr. 21 Fabrik Nr. FRKB-0096 BJ. 27.02.2017\r\n2 Overall 54\r\n1 Helm\r\n1 Paar Socken\r\n1 Paar Puschen\r\n1 Trainingsanzug\r\n1 Schutzhaube\r\n1 Zubehörkiste ( 1 Headset, 2 Fettstift, 1 Lappen, Klarsichtmittel, 1 Tüte Ohrstecker)', '1', '02.07.2022 - 07:42:53', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Gefahrgut', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('976', NULL, '5089', 'CSA Kiste', '', '1723154400', '90112', '2', '', '18.10.2019 - 16:00:20', '1 CSA Nr. 23 Fabrik Nr.FRKB-0095 BJ. 27.02.2017\r\n2 Overall 54\r\n1 Helm\r\n1 Paar Socken\r\n1 Paar Puschen\r\n1 Trainingsanzug\r\n1 Schutzhaube\r\n1 Zubehörkiste ( 1 Headset, 2 Fettstift, 1 Lappen, Klarsichtmittel, 1 Tüte Ohrstecker)', '1', '12.06.2021 - 15:44:14', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Gefahrgut', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('977', NULL, '5090', 'Erkundungshilfe Kiste', '', '1723154400', '90112', 'Dach', '', '18.10.2019 - 16:14:01', 'Einmalhandschuhe\r\nErkundungshilfe', '1', '02.07.2022 - 07:43:20', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Gefahrgut', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('978', NULL, '5091', 'Gefahrgutunterlagen Kiste', '', '1723154400', '90112', '4', '', '18.10.2019 - 16:18:24', 'Gefahrgutunterlagen', '1', '02.07.2022 - 07:43:55', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Gefahrgut', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('979', NULL, '5092', 'Gefahrguthandschuhe Kiste', '', '1723154400', '90112', '4', '', '18.10.2019 - 16:20:23', 'Gefahrguthandschuhe', '1', '02.07.2022 - 07:43:44', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Gefahrgut', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('980', NULL, '1112', 'Funkgerät HRT', '', '1737586800', '90111', 'Mannschaft Vorne', '', '18.10.2019 - 16:43:30', '', '1', '16.12.2021 - 19:37:03', '1', '', '', '12-48-1-1', 'Nils Bonk', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '19.01.2024', '', '6224866', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('983', NULL, '8502', 'Pulverlöscher P12', '', '1716328800', '50001', '', '', '22.10.2019 - 10:55:35', 'Gloria\r\n\r\nPG 12', '1', '23.05.2024 - 10:17:59', '1', '', '', 'A2BZ 14', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerlöscher', '20.12.2021', '', '', 'A2BZ', '', '24', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('984', NULL, '8503', 'Pulverlöscher P12', '', '1716328800', '50001', '', '', '22.10.2019 - 10:57:06', 'Gloria\r\n\r\nPG 12', '1', '23.05.2024 - 10:18:09', '1', '', '', 'A2BZ 13', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerlöscher', '20.12.2021', '', '', 'A2BZ', '', '24', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('985', NULL, '4083', 'Faltbehälter offen', '', '1733526000', '90114', 'GR', '', '28.10.2019 - 14:05:00', '', '1', '12.06.2021 - 14:38:16', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserentnahme', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('986', NULL, '1113', 'Astsäge', '', '1737586800', '90111', '2', '', '28.10.2019 - 14:48:13', '', '1', '17.09.2021 - 14:39:41', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('987', NULL, '2126', 'Stativ', '', '1738368000', '90113', 'GR', '', '28.10.2019 - 14:52:24', 'Rollwagen Licht', '1', '12.06.2021 - 14:29:36', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Beleuchtung', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('988', NULL, '1114', 'Funkgerät MRT', '', '1737586800', '90111', 'Mannschaft Vorne', '', '28.10.2019 - 19:51:28', '', '1', '15.12.2021 - 16:51:02', '1', '', '', '12-48-1-0', 'Nils Bonk', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '19.01.2024', '', '4227886', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('989', NULL, '5093', 'Funkgerät MRT', '', '1723154400', '90112', 'Mannschaft Vorne', '', '28.10.2019 - 19:53:26', '', '1', '08.12.2021 - 19:53:37', '1', '', '', '12-43-1-0', 'Nils Bonk', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '02.12.2022', '', '4227888', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('990', NULL, '6021', 'Funkgerät MRT', '', '1722463200', '90115', 'Mannschaft Vorne', '', '28.10.2019 - 19:54:30', '', '1', '08.06.2023 - 21:04:37', '1', '', '', '12-11-1-0', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '02.12.2022', '', '4227893', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('991', NULL, '2127', 'Funkgerät MRT', '', '1738368000', '90113', 'Mannschaft Vorne', '', '28.10.2019 - 19:55:41', '', '1', '08.12.2021 - 19:53:23', '1', '', '', '12-52-1-0', 'Nils Bonk', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '02.12.2022', '', '4227879', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('992', NULL, '4084', 'Funkgerät MRT', '', '1733526000', '90114', 'Mannschaft Vorne', '', '28.10.2019 - 19:56:55', '', '1', '08.12.2021 - 19:53:36', '1', '', '', '12-68-1-0', 'Nils Bonk', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '02.12.2022', '', '4227878', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('993', NULL, '3137', 'Funkgerät MRT', '', '1721253600', '90110', 'Mannschaft Vorne', '', '28.10.2019 - 19:58:08', '', '1', '08.06.2023 - 20:53:12', '1', '', '', '12-23-1-0', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '02.12.2022', '', '4227889', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('994', NULL, '2128', 'Funkgerät 2mtr.', '', '1738368000', '90113', 'Mannschaft Vorne', '', '28.10.2019 - 20:02:10', '', '1', '12.06.2021 - 14:07:42', '1', '', '', '12-52-1-1', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '02.12.2022', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('996', NULL, '2129', 'Funkgerät 2mtr.', '', '1738368000', '90113', 'Mannschaft Vorne', '', '28.10.2019 - 20:03:07', '', '1', '12.06.2021 - 14:07:37', '1', '', '', '12-52-1-2', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '02.12.2022', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('997', NULL, '6022', 'Tordrücker', '', '1722463200', '90115', 'Mannschaft Vorne', '', '29.10.2019 - 09:43:53', '', '1', '08.06.2023 - 21:04:39', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('998', NULL, '3138', 'Tordrücker', '01.2021', '1721253600', '90110', 'Mannschaft Vorne', '', '29.10.2019 - 09:45:00', '', '1', '08.06.2023 - 20:53:17', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('999', NULL, '1115', 'Tordrücker', '', '1737586800', '90111', 'Mannschaft Vorne', '', '29.10.2019 - 09:45:54', '', '1', '18.09.2021 - 13:49:50', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1000', NULL, '5094', 'Tordrücker', '', '1723154400', '90112', 'Mannschaft Vorne', '', '29.10.2019 - 09:46:51', '', '1', '12.06.2021 - 15:13:01', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1002', NULL, '2130', 'Tordrücker', '', '1679954400', '50001', '------', '', '29.10.2019 - 09:47:42', '', '1', '29.03.2023 - 12:02:13', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1003', NULL, '4085', 'Tordrücker', '', '1733526000', '90114', 'Mannschaft Vorne', '', '29.10.2019 - 09:49:02', '', '1', '12.06.2021 - 15:02:52', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstige', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1005', NULL, '3139', 'Brandfluchthaube', '', '1499896800', '90110', 'Mannschaft Hinten', '', '29.10.2019 - 15:07:31', 'Dräger Parat C', '1', '09.07.2020 - 16:42:33', '1', '', '09.07.2020', 'FIL2111', 'Jan Hendrik', 'Jan Hendrik', 'Ausgesondert', '01.08.2020', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1006', NULL, '3140', 'Brandfluchthaube', '', '1627250400', '90110', 'Mannschaft Hinten', '', '29.10.2019 - 15:16:26', 'Dräger Parat C', '1', '08.06.2023 - 20:51:34', '1', '', '', 'FIL2117', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.11.2023', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1007', NULL, '3141', 'Brandfluchthaube', '', '1627250400', '90110', 'Mannschaft Hinten', '', '29.10.2019 - 15:19:30', 'Dräger Parat C', '1', '17.07.2023 - 13:00:36', '1', '', '17.07.2023', 'FIL2113', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1008', NULL, '3142', 'Brandfluchthaube', '', '1627250400', '90110', 'Mannschaft Hinten', '', '29.10.2019 - 15:22:31', 'Dräger Parat C', '1', '08.06.2023 - 20:51:43', '1', '', '', 'FIL2114', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.11.2023', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1009', NULL, '3143', 'Brandfluchthaube', '', '1627250400', '90110', 'Mannschaft Hinten', '', '29.10.2019 - 15:24:21', 'Dräger Parat C', '1', '08.06.2023 - 20:51:48', '1', '', '', 'FIL2116', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.11.2023', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1012', NULL, '30353545', 'Rollwagen Pulver', '', '1716933600', '90114', 'GR', '', '17.11.2019 - 10:36:22', '', '1', '30.05.2024 - 13:39:26', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerlöscher', '20.12.2021', '', '', 'A2BZ', '', '24', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1013', NULL, '4086', 'Werkzeugsatz FOX 4', '', '1733526000', '90114', 'GR', '', '17.11.2019 - 10:54:34', 'Inhalt\r\n3 Zündkerzen\r\n1 Zündkerzennuss\r\n1 Torx 20\r\n1Torx 30\r\n1 Mauelschlüssel 10\r\n1 Spühlschlauch', '1', '12.06.2021 - 14:48:35', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1015', NULL, '30347203', 'Stromerzeuger', '', '1733526000', '50001', '------', '', '23.11.2019 - 14:38:18', 'Endress 304 SG\r\n151008/0011\r\n\r\n\r\n', '1', '20.01.2025 - 12:24:08', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1016', NULL, '30353494', 'Velängerungskabel EX', '', '1738368000', '90113', 'GR', '', '25.11.2019 - 11:10:27', '', '1', '12.06.2021 - 13:12:10', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1017', NULL, '30353495', 'Velängerungskabel EX', '', '1738368000', '90113', 'GR', '', '25.11.2019 - 11:11:27', '', '1', '12.06.2021 - 13:12:26', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1018', NULL, '8999', 'FI-Schutzschalter', '', '1703026800', '50001', '', '', '05.12.2019 - 15:57:39', '', '1', '16.01.2024 - 11:20:27', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1019', NULL, '8998', 'FI-Schutzschalter', '', '1606518000', '50001', '', '', '05.12.2019 - 17:26:05', '', '1', '01.12.2021 - 20:02:25', '1', '', '01.12.2021', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1020', NULL, '6023', 'Zugführerweste', '', '1722463200', '90115', 'Mannschaft Vorne', '', '07.12.2019 - 15:00:10', '', '1', '08.06.2023 - 21:04:45', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstiges', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1021', NULL, '6024', 'Einsatzleiterweste', '', '1722463200', '90115', 'Mannschaft Vorne', '', '07.12.2019 - 15:00:48', '', '1', '08.06.2023 - 21:04:51', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstiges', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1022', NULL, '3145', 'Fahrzeugführerweste', '', '1721253600', '90110', 'Mannschaft Vorne', '', '07.12.2019 - 15:02:25', '', '1', '08.06.2023 - 20:53:31', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstiges', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1023', NULL, '5095', 'Fahrzeugführerweste', '', '1723154400', '90112', 'Mannschaft Vorne', '', '07.12.2019 - 15:04:28', '', '1', '12.06.2021 - 15:16:00', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstiges', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1024', NULL, '2131', 'Fahrzeugführerweste', '', '1738368000', '90113', 'Mannschaft Vorne', '', '07.12.2019 - 15:05:46', '', '1', '12.06.2021 - 14:29:11', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstiges', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1026', NULL, '4087', 'Adapter für Anhänger', '', '1733526000', '90114', 'Mannschaft Vorne', '', '21.12.2019 - 11:14:02', '', '1', '12.06.2021 - 15:03:48', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstiges', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1027', NULL, '3146', 'Übergangsstück', '', '1721253600', '90110', '4', '', '21.12.2019 - 12:09:49', 'Übergangsstück Schlauchtragekorb', '1', '08.06.2023 - 20:24:22', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserführend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1029', NULL, '1116', 'Prüfrörchenkiste', '', '1737586800', '90111', 'Mannschaft Hinten', '', '22.12.2019 - 09:33:57', '- Prüfrörchen Chlor\r\n- Gasspürpumpe\r\n- PH Papier\r\n- Röhrchen Öffner', '1', '23.09.2021 - 09:49:27', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Gefahrgut', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1030', NULL, '1117', 'Prüfrörchen', '', '1737586800', '90111', 'Mannschaft Hinten', '', '22.12.2019 - 09:35:40', '2 Pakete\r\n\r\nPrüfröhrchen Chlor', '2', '23.09.2021 - 09:49:25', '2', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.12.2021', '0', 'Gefahrgut', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1031', NULL, '1118', 'Dräger Handpumpe', '', '1737586800', '90111', 'Mannschaft Hinten', '', '22.12.2019 - 09:37:34', '', '1', '07.02.2023 - 15:56:02', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Gefahrgut', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1032', NULL, '1119', 'Dräger Pumpe', '', '1737586800', '90111', 'Mannschaft Hinten', '', '22.12.2019 - 10:13:35', 'Dräger Pump X-am 1/2/5000', '1', '20.12.2023 - 10:03:19', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Gefahrgut', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1035', NULL, '4088', 'Verlängerungskabel 12V', '', '1733526000', '90114', 'Mannschaft Vorne', '', '24.02.2020 - 08:51:25', '', '1', '12.06.2021 - 15:03:52', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstiges', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1036', NULL, '2132', 'Feile für Kette', '', '1738368000', '90113', '6', '', '24.02.2020 - 17:01:13', '', '1', '12.06.2021 - 13:13:03', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', '', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1037', NULL, '30356166', 'Stromerzeuger', '1575154800', '1737586800', '90111', '2', '', '27.02.2020 - 17:26:47', '13 KV \r\n', '1', '19.09.2021 - 13:24:21', '1', '', '', 'NEA125201', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1038', NULL, '1120', 'Schaummittel', '', '1737586800', '90111', '6', '', '18.03.2020 - 18:08:51', '2l Reserve', '1', '18.09.2021 - 13:18:51', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstiges', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1039', NULL, '2133', 'Kanister 10ltr.', '1583017200', '1738368000', '90113', 'GR', '', '20.03.2020 - 10:00:05', 'Rollwagenlicht\r\n\r\n10ltr. Super', '1', '12.06.2021 - 14:17:55', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstiges', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1040', NULL, '30351469', 'Kombi Kanister', '1564610400', '1738368000', '90113', '6', '', '20.03.2020 - 10:03:46', '', '1', '12.06.2021 - 13:09:17', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '20.03.2025', '0', 'Säge Equipment', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1041', NULL, '2134', 'Ausgießer ', '', '1738368000', '90113', 'GR', '', '22.03.2020 - 09:29:15', 'Rollwagen Licht', '1', '12.06.2021 - 14:19:13', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstiges', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1042', NULL, '30356704', 'Verlängerungskabel 10mtr.', '', '1738368000', '90113', '6', '', '27.03.2020 - 11:59:58', '', '1', '12.06.2021 - 14:26:16', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1043', NULL, '30356706', 'FI-Schutzschalter', '', '1738368000', '90113', '6', '', '27.03.2020 - 12:01:42', '', '1', '12.06.2021 - 13:11:54', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1044', NULL, '30356705', 'Verlängerungskabel 10mtr.', '', '1738368000', '90113', '6', '', '27.03.2020 - 12:02:59', '', '1', '12.06.2021 - 13:09:36', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1046', NULL, '5096', 'Chemikalienschutzanzug ', '1488236400', '1723154400', '90112', '4', '', '29.03.2020 - 19:49:11', 'Fabrik Nr. FRKB-0109', '1', '02.07.2022 - 07:46:30', '1', '', '', 'Anzug Nr.20', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Gefahrgut', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1047', NULL, '5097', 'Chemikalienschutzanzug ', '1488150000', '1723154400', '90112', 'Dach', '', '29.03.2020 - 19:50:20', 'Fabrik Nr. FRKB-0096', '1', '02.07.2022 - 07:46:40', '1', '', '', 'Anzug Nr. 21', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Gefahrgut', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1048', NULL, '5098', 'Chemikalienschutzanzug ', '1456527600', '1723154400', '90112', 'Dach', '', '29.03.2020 - 19:51:30', 'Fabrik Nr. FRKB-0094', '1', '02.07.2022 - 07:46:50', '1', '', '', 'Anzug Nr. 22', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Gefahrgut', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1049', NULL, '5099', 'Chemikalienschutzanzug ', '1488150000', '1723154400', '90112', 'Dach', '', '29.03.2020 - 19:52:21', 'Fabrik Nr. FRKB-0095', '1', '02.07.2022 - 07:47:00', '1', '', '', 'Anzug Nr. 23', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Gefahrgut', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1051', NULL, '30350188', 'Forsthelm', '1538344800', '1737586800', '90111', '3', '', '30.03.2020 - 10:22:16', '', '1', '17.09.2021 - 13:46:12', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.10.2023', '0', 'Säge Equipment', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1052', NULL, '30356717', 'Schnittschutzhose', '1559772000', '1737586800', '90111', '3', '', '01.04.2020 - 10:25:55', '', '1', '17.09.2021 - 13:52:58', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '06.06.2024', '0', 'Säge Equipment', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1053', NULL, '30356716', 'Schnittschutzhose', '1559772000', '1738368000', '90113', '6', '', '01.04.2020 - 10:27:27', '', '1', '12.06.2021 - 13:07:05', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '06.06.2024', '0', 'Säge Equipment', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1057', NULL, '80010', 'Einmaldecke', '', '1680040800', '50001', '', '', '01.04.2020 - 19:07:36', '', '3', '29.03.2023 - 11:57:15', '3', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verbrauchsmaterial', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1058', NULL, '80020', 'Einmalhandschuhe XL', '', '1679954400', '50001', '', '', '01.04.2020 - 19:11:10', '', '6', '29.03.2023 - 11:57:31', '6', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verbrauchsmaterial', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1059', NULL, '80030', 'Absperrband', '', '1679954400', '50001', '', '', '01.04.2020 - 19:12:36', '', '2', '29.03.2023 - 11:57:54', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verbrauchsmaterial', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1060', NULL, '80040', 'Disinfektionsmittel', '', '1679954400', '50001', '', '', '01.04.2020 - 19:14:06', '', '6', '29.03.2023 - 11:58:05', '6', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verbrauchsmaterial', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1061', NULL, '80050', 'Einmallaken', '', '1679954400', '50001', '', '', '01.04.2020 - 19:15:10', '', '3', '29.03.2023 - 11:58:16', '3', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verbrauchsmaterial', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1062', NULL, '80060', 'FFP3 Masken', '', '1679954400', '50001', '', '', '01.04.2020 - 19:16:20', '', '50', '29.03.2023 - 11:58:28', '60', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verbrauchsmaterial', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1063', NULL, '5100', 'Adapter für Anhänger', '', '1723154400', '90112', 'Mannschaft Vorne', '', '03.04.2020 - 16:55:11', '', '1', '12.06.2021 - 15:23:33', '1', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstiges', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1065', NULL, '3147', 'Einspeisekabel', '', '1721253600', '90110', 'Mannschaft Vorne', '', '03.04.2020 - 17:00:24', '', '1', '08.06.2023 - 20:52:19', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1066', NULL, '30350133', 'Einspeisekabel', '', '1737586800', '90111', 'Mannschaft Vorne', '', '03.04.2020 - 17:08:42', '', '1', '19.09.2021 - 14:00:00', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1069', NULL, '3148', 'Filter', '', '1627250400', '90110', 'Mannschaft Hinten', '', '23.04.2020 - 14:11:07', '', '1', '08.06.2023 - 20:46:19', '1', '', '', 'FIL122315', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.03.2026', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1070', NULL, '3149', 'Filter', '', '1627250400', '90110', 'Mannschaft Hinten', '', '23.04.2020 - 14:14:26', '', '1', '08.06.2023 - 20:46:23', '1', '', '', 'FIL122316', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.03.2026', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1071', NULL, '3150', 'Filter', '', '1627250400', '90110', 'Mannschaft Hinten', '', '23.04.2020 - 14:16:27', '', '1', '08.06.2023 - 20:46:25', '1', '', '', 'FIL122317', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.03.2026', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1072', NULL, '3151', 'Filter', '', '1627250400', '90110', 'Mannschaft Hinten', '', '23.04.2020 - 14:17:39', '', '1', '08.06.2023 - 20:46:29', '1', '', '', 'FIL122318', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.03.2026', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1073', NULL, '3152', 'Filter', '', '1627250400', '90110', 'Mannschaft Hinten', '', '23.04.2020 - 14:18:31', '', '1', '08.06.2023 - 20:46:34', '1', '', '', 'FIL122319', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.03.2026', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1074', NULL, '3153', 'Filter', '', '1627250400', '90110', 'Mannschaft Hinten', '', '23.04.2020 - 14:19:50', '', '1', '08.06.2023 - 20:46:38', '1', '', '', 'FIL1223110', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.03.2026', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1075', NULL, '3154', 'Filter', '', '1627250400', '90110', 'Mannschaft Hinten', '', '23.04.2020 - 14:20:47', '', '1', '08.06.2023 - 20:46:43', '1', '', '', 'FIL1223111', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.03.2026', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1076', NULL, '1121', 'Filter', '', '1628632800', '90112', 'Mannschaft Hinten', '', '23.04.2020 - 14:25:44', '', '1', '21.01.2022 - 15:01:10', '1', '', '', 'FIL124811', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1077', NULL, '1122', 'Filter', '', '1628632800', '90112', 'Mannschaft Hinten', '', '23.04.2020 - 14:26:29', '', '1', '21.01.2022 - 15:01:09', '1', '', '', 'FIL124812', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1078', NULL, '1123', 'Filter', '', '1628632800', '90112', 'Mannschaft Hinten', '', '23.04.2020 - 14:27:28', '', '1', '21.01.2022 - 15:01:08', '1', '', '', 'FIL124813', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1079', NULL, '1124', 'Filter', '', '1642633200', '90111', 'Mannschaft Hinten', '', '23.04.2020 - 14:28:02', '', '1', '21.01.2022 - 14:58:31', '1', '', '', 'FIL124814', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1080', NULL, '1125', 'Filter', '', '1642633200', '90111', 'Mannschaft Hinten', '', '23.04.2020 - 14:28:39', '', '1', '21.01.2022 - 14:58:32', '1', '', '', 'FIL124815', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1081', NULL, '1126', 'Filter', '', '1642633200', '90111', 'Mannschaft Hinten', '', '23.04.2020 - 14:29:56', '', '1', '21.01.2022 - 14:58:33', '1', '', '', 'FIL124816', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1082', NULL, '1127', 'Filter', '', '1642633200', '90111', 'Mannschaft Hinten', '', '23.04.2020 - 14:31:06', '', '1', '21.01.2022 - 14:58:35', '1', '', '', 'FIL124818', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1083', NULL, '1128', 'Filter', '', '1642633200', '90111', 'Mannschaft Hinten', '', '23.04.2020 - 14:31:50', '', '1', '21.01.2022 - 14:58:37', '1', '', '', 'FIL124817', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1084', NULL, '1129', 'Filter', '', '1642633200', '90111', 'Mannschaft Hinten', '', '23.04.2020 - 14:32:24', '', '1', '21.01.2022 - 14:58:38', '1', '', '', 'FIL124819', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1085', NULL, '1130', 'Filter', '', '1642633200', '90111', 'Mannschaft Hinten', '', '23.04.2020 - 14:33:05', '', '1', '21.01.2022 - 14:58:39', '1', '', '', 'FIL1248110', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1086', NULL, '5101', 'Filter', '', '1628632800', '90112', 'Mannschaft Hinten', '', '23.04.2020 - 14:34:01', '', '1', '16.08.2021 - 10:36:11', '1', '', '', 'FIL124311', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.03.2026', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1087', NULL, '5102', 'Filter', '', '1628632800', '90112', 'Mannschaft Hinten', '', '23.04.2020 - 14:34:47', '', '1', '16.08.2021 - 10:36:12', '1', '', '', 'FIL124312', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.03.2026', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1088', NULL, '5103', 'Filter', '', '1628632800', '90112', 'Mannschaft Hinten', '', '23.04.2020 - 14:35:20', '', '1', '16.08.2021 - 10:36:14', '1', '', '', 'FIL124313', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.03.2026', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1089', NULL, '5104', 'Filter', '', '1628632800', '90112', 'Mannschaft Hinten', '', '23.04.2020 - 14:35:51', '', '1', '16.08.2021 - 10:36:17', '1', '', '', 'FIL124314', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '01.03.2026', '0', 'Atemschutz', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1090', NULL, '1131', 'Halligan-Tool', '', '1737586800', '90111', '2', '', '27.04.2020 - 14:11:29', '', '1', '02.07.2022 - 08:06:05', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1091', NULL, '8504', 'Schaumlöscher 6l', '', '1713736800', '50001', '', '', '27.04.2020 - 19:01:20', 'Minimax\r\n\r\n6l Schaum', '1', '23.05.2024 - 10:18:19', '1', '', '', 'A2BZ05', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerlöscher', '20.12.2021', '', '', 'A2BZ', '', '24', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1093', NULL, '1132', 'Fällheber', '', '1737586800', '90111', '2', '', '09.05.2020 - 10:01:23', '', '1', '22.09.2021 - 11:21:51', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1095', NULL, '8505', 'Pulverlöscher P12', '', '1716328800', '50001', '', '', '11.05.2020 - 10:03:17', 'Gloria\r\n\r\nP 12\r\n\r\nehm. Barcode:\r\n30352717', '1', '23.05.2024 - 10:21:12', '1', '', '', 'A2BZ11', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerlöscher', '20.12.2021', '', '', 'A2BZ', '', '24', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1096', NULL, '8506', 'Pulverlöscher P12', '', '1716328800', '50001', '', '', '11.05.2020 - 10:11:39', 'Gloria\r\n\r\nP 12\r\n\r\nehm. Barcode:\r\n30351987', '1', '23.05.2024 - 10:21:24', '1', '', '', 'A2BZ10', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerlöscher', '20.12.2021', '', '', 'A2BZ', '', '24', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1097', NULL, '8507', 'Pulverlöscher P6', '', '1716328800', '90114', 'GR', '', '11.05.2020 - 10:18:07', 'Gloria\r\n\r\nP 6\r\n\r\nehm. Barcode\r\n30350174', '1', '23.05.2024 - 10:21:43', '1', '', '', 'A2BZ04', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerlöscher', '20.12.2021', '', '', 'A2BZ', '', '24', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1098', NULL, '1133', 'Navigationsgerät', '', '1737586800', '90111', 'Mannschaft Vorne', '', '11.05.2020 - 12:05:04', '', '1', '12.09.2021 - 10:52:16', '1', '', '', 'NAV12481', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '19.01.2024', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1099', NULL, '8508', 'Pulverlöscher P12', '', '1716328800', '50001', '------', '', '11.05.2020 - 12:42:33', 'Gloria\r\n\r\nP 12\r\n\r\nehm. Barcode 30350320', '1', '23.05.2024 - 10:21:55', '1', '', '', 'A2BZ09', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerlöscher', '20.12.2021', '', '', 'A2BZ', '', '24', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1100', NULL, '8509', 'Pulverlöscher P6', '', '1716328800', '90110', '1', '', '11.05.2020 - 12:50:59', 'Gloria\r\n\r\n6kg \r\n\r\nehm. Barcode 30346077', '1', '23.05.2024 - 10:22:08', '1', '', '', 'A2BZ08', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerlöscher', '20.12.2021', '', '', 'A2BZ', '', '24', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1101', NULL, '8510', 'Pulverlöscher P12', '', '1716328800', '90110', '1', '', '11.05.2020 - 12:55:23', 'Jokel\r\n\r\n12kg\r\n\r\nehm. Barcode 30346076', '1', '23.05.2024 - 10:22:29', '1', '', '', 'A2BZ06', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerlöscher', '20.12.2021', '', '', 'A2BZ', '', '24', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1102', NULL, '8511', 'CO2 Löscher 5kg', '', '1716328800', '90110', '1', '', '11.05.2020 - 13:00:36', 'Gloria\r\n\r\n5kg Co2\r\n\r\nehm. Barcode 30346075\r\n\r\n', '1', '23.05.2024 - 10:22:40', '1', '', '', 'A2BZ02', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerlöscher', '20.12.2021', '', '', 'A2BZ', '', '24', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1103', NULL, '8512', 'CO2 Löscher 5kg', '', '1716328800', '90110', '1', '', '11.05.2020 - 13:03:37', 'Gloria\r\n\r\n5kg Co2', '1', '23.05.2024 - 10:22:54', '1', '', '', 'A2BZ17', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerlöscher', '20.12.2021', '', '', 'A2BZ', '', '24', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1104', NULL, '8513', 'Pulverlöscher P12', '', '1716328800', '90111', '4', '', '11.05.2020 - 13:14:41', 'Gloria\r\n\r\n12kg\r\n', '1', '23.05.2024 - 10:23:11', '1', '', '', 'A2BZ18', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerlöscher', '20.12.2021', '', '', 'A2BZ', '', '24', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1105', NULL, '3155', 'Navigationsgerät', '', '1721253600', '90110', 'Mannschaft Vorne', '', '11.05.2020 - 13:23:05', '', '1', '08.06.2023 - 20:52:32', '1', '', '', 'NAV12231', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '02.12.2022', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1106', NULL, '8514', 'Pulverlöscher P12', '', '1738368000', '90113', '7', '', '11.05.2020 - 13:33:29', 'Gloria\r\n\r\n12kg\r\n\r\nehm. Barcode 30351473\r\n', '1', '23.05.2024 - 10:23:22', '1', '', '', 'A2BZ', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerlöscher', '20.12.2021', '', '', 'A2BZ', '', '24', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1107', NULL, '8515', 'Schaumlöscher 9l', '', '1738368000', '90113', '7', '', '11.05.2020 - 13:35:30', 'Gloria\r\n\r\n9l\r\n\r\nehm. Barcode 30351475 ', '1', '23.05.2024 - 10:23:35', '1', '', '', 'A2BZ22', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerlöscher', '20.12.2021', '', '', 'A2BZ', '', '24', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1108', NULL, '8516', 'CO2 Löscher 5kg', '', '1738368000', '90113', '7', '', '11.05.2020 - 13:36:38', 'Gloria\r\n\r\n5kg\r\n\r\nehm. Barcode 30351474', '1', '23.05.2024 - 10:23:48', '1', '', '', 'A2BZ21', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerlöscher', '20.12.2021', '', '', 'A2BZ', '', '24', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1109', NULL, '8517', 'Pulverlöscher P12', '', '1716328800', '50001', '------', '', '11.05.2020 - 13:41:16', 'Magazin\r\n\r\nGloria\r\n\r\n12kg\r\n\r\nehm. Barcode 30355678\r\n', '1', '23.05.2024 - 10:24:17', '1', '', '', 'A2BZ12', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerlöscher', '20.12.2021', '', '', 'A2BZ', '', '24', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1110', NULL, '8518', 'Pulverlöscher P12', '', '1716328800', '90112', '2', '', '11.05.2020 - 13:46:28', 'Gloria\r\n\r\n12kg\r\n\r\nehm. Barcode 30348196', '1', '23.05.2024 - 10:24:29', '1', '', '', 'A2BZ03', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerlöscher', '20.12.2021', '', '', 'A2BZ', '', '24', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1111', NULL, '6025', 'Navigationsgerät', '', '1722463200', '90115', 'Mannschaft Vorne', '', '11.05.2020 - 15:54:31', '', '1', '08.06.2023 - 21:04:00', '1', '', '', 'NAV12111', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '02.12.2022', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1112', NULL, '2135', 'Navigationsgerät', '', '1738368000', '90113', 'Mannschaft Vorne', '', '11.05.2020 - 16:01:49', '', '1', '12.06.2021 - 14:28:34', '1', '', '', 'NAV12521', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '02.12.2022', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1113', NULL, '5105', 'Navigationsgerät', '', '1723154400', '90112', 'Mannschaft Vorne', '', '11.05.2020 - 16:05:23', '', '1', '12.06.2021 - 15:12:55', '1', '', '', 'NAV12431', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '02.12.2022', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('1114', NULL, '4089', 'Navigationsgerät', '', '1733526000', '90114', 'Mannschaft Vorne', '', '11.05.2020 - 16:06:49', '', '1', '12.09.2021 - 10:52:18', '1', '', '', 'NAV12681', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '02.12.2022', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2000', NULL, '2136', 'Rohrklemme', '1588284000', '1738368000', '90113', '6', '', '26.05.2020 - 21:22:44', '', '1', '12.06.2021 - 12:59:54', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2002', NULL, '30355897', 'Einspeisekabel 63A', '', '1651874400', 'lima', '', '', '10.06.2020 - 09:01:21', '', '1', '29.07.2022 - 08:53:14', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2003', NULL, '30355896', 'Einspeisekabel 32A', '', '1651874400', 'lima', '', '', '10.06.2020 - 09:02:17', '', '1', '29.07.2022 - 08:53:15', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2004', NULL, '8156', 'Halteleine', '', '1659304800', '50001', '', '', '11.06.2020 - 16:47:59', '', '1', '01.08.2022 - 08:33:10', '1', '', '', 'A2BZ', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstiges', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2005', NULL, '8157', 'Halteleine', '', '1659304800', '50001', '', '', '11.06.2020 - 16:55:32', '', '1', '01.08.2022 - 08:33:11', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstiges', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2007', NULL, '8158', 'Ventilleine', '', '1659304800', '50001', '', '', '11.06.2020 - 17:00:15', 'RC Pumpe', '1', '12.02.2024 - 12:27:18', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstiges', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2008', NULL, '8152', 'Ventilleine', '', '1659304800', '50001', '', '', '11.06.2020 - 17:05:05', '', '1', '01.08.2022 - 08:33:13', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', '', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2009', NULL, '8200', 'Erdungsspieß ', '', '1651874400', 'lima', '', '', '11.06.2020 - 17:15:58', '', '1', '29.07.2022 - 08:53:17', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2010', NULL, '8201', 'Erdungskabel', '', '1651874400', 'lima', '', '', '11.06.2020 - 17:16:57', '', '1', '29.07.2022 - 08:53:19', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2011', NULL, '30357175', 'Rettungssäge', '1590962400', '1737586800', '90111', '3', '', '02.07.2020 - 10:40:36', 'Stihl MS 462 C-M\r\n\r\n', '1', '22.09.2021 - 11:23:29', '1', '', '', 'MO2106', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Säge Equipment', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2012', NULL, '2137', 'Bereitstellungsplane', '', '1738368000', '90113', '4', '', '02.07.2020 - 11:19:54', '', '1', '12.06.2021 - 13:21:18', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2013', NULL, '1134', 'Bereitstellungsplane', '', '1737586800', '90111', '1', '', '06.07.2020 - 13:12:43', '', '1', '17.09.2021 - 14:37:44', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2014', NULL, '1052', 'Steckschlüssel', '', '1737586800', '90111', '1', '', '08.07.2020 - 11:41:44', 'Steckschlüssel 10\r\nin VU Kasten', '1', '22.09.2021 - 11:20:50', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2015', NULL, '1057', 'Steckschlüssel', '', '1737586800', '90111', '1', '', '08.07.2020 - 11:42:39', 'Steckschlüssel 13\r\nin VU Kasten', '1', '22.09.2021 - 11:20:52', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2019', NULL, '5106', 'Trainingsanzug', '', '1723154400', '90112', 'Mannschaft Hinten', '', '29.07.2020 - 10:53:23', '', '4', '12.06.2021 - 15:24:58', '4', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstiges', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2022', NULL, '1136', 'Badelatschen', '', '1737586800', '90111', 'Mannschaft Hinten', '', '29.07.2020 - 11:11:49', '', '4', '06.01.2022 - 14:55:42', '4', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstiges', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2026', NULL, '5107', 'Badelatschen', '', '1723154400', '90112', 'Mannschaft Hinten', '', '29.07.2020 - 11:14:46', '', '4', '12.06.2021 - 15:24:53', '4', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstiges', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2027', NULL, '5108', 'Socken', '', '1723154400', '90112', 'Mannschaft Hinten', '', '29.07.2020 - 11:15:08', '', '4', '12.06.2021 - 15:24:48', '4', '', '', '', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstiges', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2028', NULL, '30357779', 'Systemtrenner', '', '1721253600', '90110', '6', '', '20.08.2020 - 11:37:41', '', '1', '08.06.2023 - 20:33:29', '1', '', '', 'SYT1223101', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserführend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2029', NULL, '30357788', 'Systemtrenner', '', '1723154400', '90112', '2', '', '20.08.2020 - 11:38:29', '', '1', '12.06.2021 - 15:37:42', '1', '', '', 'SYT1243101', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserführend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2030', NULL, '30357789', 'Systemtrenner', '', '1737586800', '90111', 'GR', '', '20.08.2020 - 11:39:52', '', '1', '17.09.2021 - 19:44:28', '1', '', '', 'SYT1248101', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserführend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2031', NULL, '30357787', 'Systemtrenner', '', '1733526000', '90114', 'GR', '', '20.08.2020 - 11:41:01', '', '1', '22.09.2021 - 11:20:57', '1', '', '', 'SYT1268101', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserführend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2032', NULL, '30357869', 'Pressluftatmer', '1596232800', '1641855600', '90110', 'Mannschaft Hinten', '', '28.08.2020 - 12:19:38', 'PSS 7000 mit Safety Belt', '1', '28.08.2022 - 11:23:27', '1', '', '28.08.2022', '201005', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Atemschutz', '08.08.2022', '', '', 'A2BZ', '', '6', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2033', NULL, '30357886', 'Pressluftatmer', '1596232800', '1641855600', '90110', '3', '', '28.08.2020 - 12:22:50', 'PSS 7000 mit Safety Belt', '1', '28.08.2022 - 11:23:32', '1', '', '28.08.2022', '201006', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Atemschutz', '08.08.2022', '', '', 'A2BZ', '', '6', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2034', NULL, '30357870', 'Pressluftatmer', '1596232800', '1641855600', '90110', '3', '', '28.08.2020 - 12:23:54', 'PSS 7000 mit Safety Belt', '1', '28.08.2022 - 11:23:42', '1', '', '28.08.2022', '201007', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Atemschutz', '08.08.2022', '', '', 'A2BZ', '', '6', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2035', NULL, '30357871', 'Pressluftatmer', '1596232800', '1641855600', '90110', 'Mannschaft Hinten', '', '28.08.2020 - 12:25:11', 'PSS 7000 mit Safety Belt', '1', '28.08.2022 - 11:23:47', '1', '', '28.08.2022', '201008', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Atemschutz', '08.08.2022', '', '', 'A2BZ', '', '6', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2036', NULL, '5109', 'Standrohr', '', '1723154400', '90112', '2', '', '22.09.2020 - 11:01:54', '', '1', '16.08.2021 - 10:39:26', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserentnahme', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2037', NULL, '30357077', 'Handlampe Adalit	', '31.12.2019', '1721253600', '90110', 'Mannschaft Hinten', '', '22.09.2020 - 11:05:17', '', '1', '27.01.2024 - 09:32:54', '1', '', '', '', 'Nils Bonk', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Beleuchtungsgerät', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2038', NULL, '30357823', 'Drahtseil', '', '1738368000', '90113', '3', '', '22.09.2020 - 11:07:01', '2,5mtr. 2t.', '1', '15.06.2023 - 12:43:32', '1', '', '', 'DS1252104', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2039', NULL, '30358322', 'Akku Strahler', '', '1722463200', '90115', 'GR', '', '05.11.2020 - 09:59:26', '', '1', '08.06.2023 - 21:03:35', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Beleuchtungsgerät', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2040', NULL, '30358469', 'Pressluftatmer', '1596232800', '1642633200', '90111', 'Mannschaft Hinten', '', '29.11.2020 - 11:51:43', 'PSS 7000 mit Safty Belt', '1', '28.08.2022 - 11:22:27', '1', '', '28.08.2022', '201009', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Atemschutz', '08.08.2022', '', '', 'A2BZ', '', '6', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2041', NULL, '30358534', 'Pressluftatmer', '1596232800', '1642633200', '90111', 'Mannschaft Hinten', '', '29.11.2020 - 11:52:03', 'PSS 7000 mit Safty Belt', '1', '28.08.2022 - 11:22:38', '1', '', '28.08.2022', '201010', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Atemschutz', '08.08.2022', '', '', 'A2BZ', '', '6', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2042', NULL, '30358535', 'Pressluftatmer', '1596232800', '1735689600', '90113', '5', '', '29.11.2020 - 11:52:20', 'PSS 7000 mit Safty Belt', '1', '28.08.2022 - 11:23:05', '1', '', '28.08.2022', '201011', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Atemschutz', '08.08.2022', '', '', 'A2BZ', '', '6', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2043', NULL, '30358536', 'Pressluftatmer', '1596232800', '1735689600', '90113', '5', '', '29.11.2020 - 11:52:37', 'PSS 7000 mit Safty Belt', '1', '28.08.2022 - 11:23:19', '1', '', '28.08.2022', '201012', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Ausgesondert', '', '0', 'Atemschutz', '08.08.2022', '', '', 'A2BZ', '', '6', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2044', NULL, '30349958', 'Systemtrenner', '', '1733526000', '90114', 'GR', '', '07.12.2020 - 18:26:49', '', '1', '12.06.2021 - 14:48:55', '1', '', '', 'SYT1268102', 'Nils', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserführend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2045', NULL, '1138', 'Elektrowerkzeug ', '', '1737586800', '90111', '1', '', '14.12.2020 - 12:45:13', '', '1', '17.09.2021 - 20:34:56', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2046', NULL, '2141', 'Kantenschutz', '', '1738368000', '90113', '4', '', '14.12.2020 - 12:45:50', '', '6', '12.06.2021 - 13:21:12', '6', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2047', NULL, '30358599', 'Mehrgasmessgerät', '', '1744840800', '90111', 'Mannschaft Vorne', '', '21.12.2020 - 12:26:01', 'ch4\r\nCo\r\nCo2\r\nO2\r\nH2S\r\nPID\r\n\r\n', '1', '17.04.2025 - 13:35:40', '1', '', '', 'MEß2105', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Gefahrgut', '16.08.2022', '', '', 'A2BZ', '', '1', '', 'x', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2049', NULL, '1140', 'Funkgerät HRT Atex', '', '1737586800', '90111', 'Mannschaft Vorne', '', '17.01.2021 - 08:28:56', '', '1', '27.09.2021 - 14:23:15', '1', '', '', '12-48-1-2', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '19.01.2024', '', '6227333', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2050', NULL, '80061', 'FFP2 Masken', '', '1680040800', '50001', '', '', '19.01.2021 - 11:54:08', '', '100', '29.03.2023 - 11:56:25', '160', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verbrauchsmaterial', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2051', NULL, '80062', 'Mundschutz Typ 2R', '', '1680127200', '50001', '', '', '19.01.2021 - 11:56:02', '', '100', '29.03.2023 - 11:56:57', '200', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verbrauchsmaterial', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2052', NULL, '5110', 'Funkgerät HRT Atex', '', '1723154400', '90112', 'Mannschaft Vorne', '', '25.01.2021 - 10:56:24', '', '1', '27.09.2021 - 14:22:10', '1', '', '', '12-43-1-8', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '02.12.2022', '', '6227328', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2053', NULL, '3159', 'Schlauchpaket', '', '1721253600', '90110', '4', '', '16.02.2021 - 10:53:31', '', '1', '08.06.2023 - 20:24:29', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstiges', '20.12.2021', 'x', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2054', NULL, '5111', 'Funkgerät HRT', '', '1723154400', '90112', 'Mannschaft Hinten', '', '11.03.2021 - 11:16:09', '', '1', '21.01.2022 - 15:01:05', '1', '', '', '12-43-1-5', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '02.12.2022', '', '6223911', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2055', NULL, '5112', 'Funkgerät HRT', '', '1723154400', '90112', 'Mannschaft Hinten', '', '11.03.2021 - 11:20:50', '', '1', '21.01.2022 - 15:01:06', '1', '', '', '12-43-1-6', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '02.12.2022', '', '6223912', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2056', NULL, '2142', 'Akku Kettensäge', '1614553200', '1738368000', '90113', '6', '', '06.05.2021 - 10:43:16', 'Stihl MSA 200C\r\n\r\nKetten Best. Nr.\r\n3670 000 0064\r\n\r\n30cm Schwert', '1', '02.07.2022 - 07:55:06', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Säge Equipment', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2058', NULL, '6026', 'LAN Kabel 15mtr.', '1744934400', '1722384000', '90115', 'GR', '', '15.05.2021 - 12:15:26', 'blaaaaaa', '1', '08.06.2023 - 21:02:21', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Bedingt Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '651698432161651', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2059', NULL, '6027', 'LAN Kabel 20mtr.', '', '1722463200', '90115', 'GR', '', '15.05.2021 - 12:17:38', '', '1', '08.06.2023 - 21:02:24', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2060', NULL, '3160', 'Halligan-Tool', '', '1721253600', '90110', 'Mannschaft Hinten', '', '17.05.2021 - 16:02:43', '', '1', '08.06.2023 - 20:45:49', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2064', NULL, '6028', 'Fahrtenbuch', '', '1722463200', '90115', 'Mannschaft Vorne', '', '12.06.2021 - 10:24:59', '', '1', '08.06.2023 - 21:03:56', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstiges', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2065', NULL, '6029', 'Abschnittsleiterweste', '', '1722463200', '90115', 'GR', '', '12.06.2021 - 10:31:35', '', '3', '08.06.2023 - 21:02:28', '3', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstiges', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2066', NULL, '30357392', 'Verlängerungskabel 15m', '', '1722463200', '90115', 'GR', '', '12.06.2021 - 10:35:49', '', '1', '08.06.2023 - 21:02:37', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2067', NULL, '3161', 'Fahrtenbuch', '', '1721253600', '90110', 'Mannschaft Vorne', '', '12.06.2021 - 10:50:54', '', '1', '08.06.2023 - 20:52:00', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstiges', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2068', NULL, '30357434', 'Warnlampe', '', '1721253600', '90110', 'Mannschaft Vorne', '', '12.06.2021 - 10:52:47', '', '1', '08.06.2023 - 20:52:08', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2069', NULL, '30357433', 'Warnlampe', '', '1721253600', '90110', 'Mannschaft Vorne', '', '12.06.2021 - 10:53:17', '', '1', '08.06.2023 - 20:52:15', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2070', NULL, '3162', 'Einmaldecke', '', '1721253600', '90110', 'Mannschaft Hinten', '', '12.06.2021 - 11:24:37', '', '2', '08.06.2023 - 20:45:54', '2', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verbrauchsmaterial', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2071', NULL, '30346514', 'Krankentrage', '', '1721253600', '90110', 'Mannschaft Hinten', '', '12.06.2021 - 11:27:45', '', '1', '08.06.2023 - 20:46:14', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sanitätsgerät', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2072', NULL, '3117', 'Füllschlauch', '', '1721253600', '90110', 'GR', '', '12.06.2021 - 11:47:46', '', '1', '08.06.2023 - 20:45:09', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserführend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2073', NULL, '3163', 'Leader Hohlstrahlrohr', '', '1721253600', '90110', '6', '', '12.06.2021 - 12:03:59', '', '1', '08.06.2023 - 20:28:38', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserabgabe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2075', NULL, '1141', 'Funkgerät HRT', '1622498400', '1737586800', '90111', 'Mannschaft Hinten', '', '16.06.2021 - 15:31:57', '', '1', '27.09.2021 - 14:02:46', '1', '', '', '12-48-1-6', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '19.01.2024', '', '6227940', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2076', NULL, '1142', 'Funkgerät HRT', '1622498400', '1737586800', '90111', 'Mannschaft Vorne', '', '16.06.2021 - 16:05:24', '', '1', '21.12.2021 - 10:09:07', '1', '', '', '12-48-1-4', 'Nils Bonk', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '19.01.2024', '', '6227938', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2077', NULL, '1143', 'Funkgerät HRT', '1622498400', '1737586800', '90111', 'Mannschaft Hinten', '', '16.06.2021 - 16:06:48', '', '1', '27.09.2021 - 14:02:44', '1', '', '', '12-48-1-5', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '19.01.2024', '', '6227939', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2078', NULL, '1144', 'Funkgerät HRT', '1622498400', '1737586800', '90111', 'Mannschaft Hinten', '', '16.06.2021 - 16:10:36', '', '1', '27.09.2021 - 14:02:48', '1', '', '', '12-48-1-7', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '19.01.2024', '', '6227941', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2079', NULL, '1145', 'Funkgerät HRT', '1622498400', '1737586800', '90111', 'Mannschaft Vorne', '', '16.06.2021 - 16:18:50', '', '1', '27.09.2021 - 14:02:41', '1', '', '', '12-48-1-3', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '19.01.2024', '', '6227937', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2080', NULL, '30346072', 'Forsthelm', '1626991200', '1737586800', '90111', '3', '', '26.07.2021 - 19:27:56', '', '1', '12.09.2021 - 19:16:04', '1', '', '', '2107', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '23.07.2026', '0', 'Säge Equipment', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2081', NULL, '30346071', 'Forsthelm', '1626991200', '1721253600', '90110', '2', '', '26.07.2021 - 19:29:07', '', '1', '08.06.2023 - 20:21:02', '1', '', '', '2109', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '23.07.2026', '0', 'Säge Equipment', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2083', NULL, '30346070', 'Schnittschutzhose', '1626645600', '1721253600', '90110', '2', '', '26.07.2021 - 19:32:28', '', '1', '08.06.2023 - 20:21:09', '1', '', '', '2103', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '23.07.2026', '0', 'Säge Equipment', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2084', NULL, '1005', 'Füllschlauch', '', '1737586800', '90111', 'GR', '', '17.09.2021 - 10:53:45', '', '2', '', '2', '', '', '', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserführend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2085', NULL, '1014', 'Sammelstück 3A', '', '1737586800', '90111', 'GR', '', '17.09.2021 - 11:01:30', '', '1', '', '1', '', '', '', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserführend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2086', NULL, '1022', 'Einmaldecke', '', '1737586800', '90111', '2', '', '19.04.2019 - 16:07:38', '', '4', '23.09.2021 - 10:15:21', '4', 'Bitte auswählen', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Erste Hilfe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2087', NULL, '1026', 'Übergangsstück C>D', '', '1737586800', '90111', 'GR', '', '17.09.2021 - 11:04:21', '', '1', '22.09.2021 - 11:26:35', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserführend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2088', NULL, '1025', 'Einreißhaken', '', '1737586800', '90111', 'Dach', '', '17.09.2021 - 12:18:38', '', '1', '', '1', '', '', '', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2089', NULL, '1025', 'Einreißhaken', '', '1737586800', '90111', 'Dach', '', '17.09.2021 - 12:18:38', '', '1', '', '1', '', '', '', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2090', NULL, '1034', 'Schornsteinfegerstangen', '', '1737586800', '90111', 'Dach', '', '17.09.2021 - 12:23:47', '', '1', '', '1', '', '', '', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Werkzeug', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2091', NULL, '30359534', 'Motorkettensäge', '1577833200', '1737586800', '90111', '3', '', '17.09.2021 - 13:27:24', 'Stihl MS201C\r\n\r\nKetten Best. Nr. \r\n3636 000 0050\r\n63 PM3 50\r\n\r\n35cm Schwert', '1', '04.03.2022 - 15:47:49', '1', '', '', 'MO2108', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Säge Equipment', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2092', NULL, '30359319', 'Tauchpumpe K5', '', '1737586800', '90111', '5', '', '17.09.2021 - 14:15:03', '', '1', '', '1', '', '', '', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2093', NULL, '30357768', 'Kettensatz Zylinder', '', '1737586800', '90111', '1', '', '17.09.2021 - 20:21:42', '', '1', '07.06.2022 - 18:33:52', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2094', NULL, '30357769', 'Kettensatz Zylinder', '', '1737586800', '90111', '1', '', '17.09.2021 - 20:22:44', '', '1', '07.06.2022 - 18:33:53', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2095', NULL, '30357767', 'Kettensatz Spreizer', '', '1737586800', '90111', '1', '', '17.09.2021 - 20:24:14', '', '1', '', '1', '', '', '', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2096', NULL, '30357766', 'Kettensatz Spreizer', '', '1737586800', '90111', '1', '', '17.09.2021 - 20:25:37', '', '1', '', '1', '', '', '', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Anschlagmittel', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2097', NULL, '30359266', 'Multifunktionsleiter', '1609455600', '1737586800', '90111', '6', '', '18.09.2021 - 13:32:52', '', '1', '', '1', '', '', '', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Leitern', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2098', NULL, '1300', 'Schaumlöscher 9l', '', '1716328800', '90111', '4', '', '18.09.2021 - 13:59:38', '', '1', '23.05.2024 - 10:18:43', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerlöscher', '20.12.2021', '', '', 'A2BZ', '', '24', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2099', NULL, '1301', 'CO2 Löscher 5kg', '', '1716328800', '90111', '4', '', '18.09.2021 - 14:01:02', '', '1', '23.05.2024 - 10:19:35', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerlöscher', '20.12.2021', '', '', 'A2BZ', '', '24', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2100', NULL, '30359326', 'Elektrolüfter', '1633039200', '1737586800', '90111', '2', '', '19.09.2021 - 13:43:11', 'Leader Typ:ESP230 Neo', '1', '', '1', '', '', '', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2101', NULL, '30359265', 'Tragetuch XXL', '', '1737586800', '90111', '2', '', '19.09.2021 - 14:16:09', '', '1', '19.09.2021 - 14:16:38', '1', '', '', 'Rett2116', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Rettungsgerät', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2102', NULL, '30359330', 'Solarblitz', '', '1737586800', '90111', '2', '', '19.09.2021 - 14:21:17', '', '1', '', '1', '', '', '', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Beleuchtungsgerät', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2103', NULL, '30359329', 'Solarblitz', '', '1737586800', '90111', '2', '', '19.09.2021 - 14:21:56', '', '1', '', '1', '', '', '', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Beleuchtungsgerät', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2104', NULL, '30359331', 'Solarblitz', '', '1737586800', '90111', '2', '', '19.09.2021 - 14:55:18', '', '1', '', '1', '', '', '', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Beleuchtungsgerät', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2105', NULL, '30359328', 'Solarblitz', '', '1737586800', '90111', '2', '', '19.09.2021 - 14:56:05', '', '1', '', '1', '', '', '', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Beleuchtungsgerät', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2106', NULL, '30359321', 'Handlampe Adalit', '', '1737586800', '90111', 'Mannschaft Hinten', '', '23.09.2021 - 09:46:02', '', '1', '23.09.2021 - 09:57:58', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Handlampe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2107', NULL, '30359320', 'Handlampe Eismann EX', '', '1737586800', '90111', 'Mannschaft Hinten', '', '23.09.2021 - 09:47:30', '', '1', '', '1', '', '', '', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Handlampe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2109', NULL, '30359327', 'Verbandkasten Fw', '', '1737586800', '90111', 'Mannschaft Hinten', '', '23.09.2021 - 09:54:42', '', '1', '15.12.2021 - 16:50:46', '1', '', '', '', 'Nils Bonk', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Erste Hilfe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2110', NULL, '30350141', 'FI-Schutzschalter', '', '1737586800', '90111', '2', '', '23.09.2021 - 10:26:07', '', '1', '', '1', '', '', '', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2111', NULL, '30359324', 'Abzweigstück', '', '1737586800', '90111', '2', '', '23.09.2021 - 10:27:02', '', '1', '', '1', '', '', '', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2112', NULL, '30359317', 'Winkelschleifer Akku', '', '1737586800', '90111', '2', '', '23.09.2021 - 10:28:46', '', '1', '', '1', '', '', '', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2113', NULL, '30359316', 'Trennschleifer Akku', '', '1737586800', '90111', '2', '', '23.09.2021 - 10:29:40', '', '1', '', '1', '', '', '', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2115', NULL, '30359322', 'Handlampe Adalit', '', '1737586800', '90111', 'Mannschaft Vorne', '', '23.09.2021 - 10:36:03', '', '1 ', '', '1', '', '', '', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Beleuchtungsgerät', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2116', NULL, '5113', 'Funkgerät HRT', '', '1723154400', '90112', 'Mannschaft Hinten', '', '27.09.2021 - 13:59:21', '', '1', '27.09.2021 - 14:01:51', '1', '', '', '12-43-1-7', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '02.12.2022', '', '6223913', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2117', NULL, '1146', 'Hohlstrahlrohr B', '', '1737586800', '90111', '6', '', '28.09.2021 - 10:20:53', '', '1', '', '1', '', '', '', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserabgabe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2118', NULL, '3164', 'Stützkrümmer C', '', '1721253600', '90110', '6', '', '28.09.2021 - 10:32:41', '', '1', '08.06.2023 - 20:33:11', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserführend', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2119', NULL, '3165', 'Hohlstrahlrohr C 400l', '', '1721253600', '90110', '6', '', '28.09.2021 - 10:33:21', '', '1', '08.06.2023 - 20:33:17', '1', '', '', '', 'Jan Hendrik', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserabgabe', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2120', NULL, '30359647', 'Sprungretter', '1617228000', '1737586800', '90111', '3', '', '14.10.2021 - 09:10:27', '', '1', '', '1', '', '', '', '', 'Jan Hendrik', 'Einsatzbereit', '01.04.2036', '0', 'Rettungsgerät', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2121', NULL, '10000', 'Pressluftatmer', '1355228015', '1648418400', '50001', 'Mannschaft Vorne', '', '', 'Test Gerät, bitte nicht Löschen.', '1', '28.08.2022 - 11:21:34', '1', '', '28.08.2022', 'Press', 'Jan Hendrik Friedrich', 'root', 'Ausgesondert', '', '0', 'Atemschutz', '10.04.2022', 'x', '', 'A2BZ', '14478988', '6', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2123', NULL, '8101', 'Diesel Kanister 20l.', '', '1680040800', '50001', '', '', '10.11.2021 - 08:52:10', '', '1', '29.03.2023 - 11:58:41', '1', '', '', 'DKan1', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Dieselkanister', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2124', NULL, '8102', 'Diesel Kanister 20l.', '', '1680040800', '50001', '', '', '10.11.2021 - 08:56:23', '', '1', '29.03.2023 - 11:59:02', '1', '', '', 'DKan2', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Dieselkanister', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2125', NULL, '8103', 'Diesel Kanister 20l.', '', '1680040800', '50001', '', '', '10.11.2021 - 08:56:53', '', '1', '29.03.2023 - 11:59:17', '1', '', '', 'DKan3', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Dieselkanister', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2126', NULL, '8104', 'Diesel Kanister 20l.', '', '1680040800', '50001', '', '', '10.11.2021 - 08:57:34', '', '1', '29.03.2023 - 11:59:51', '1', '', '', 'DKan4', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Dieselkanister', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2127', NULL, '8105', 'Diesel Kanister 20l.', '', '1661983200', '50001', '', '', '10.11.2021 - 08:58:38', '', '1', '01.09.2022 - 19:25:17', '1', '', '', 'DKan5', 'Nils Bonk', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Dieselkanister', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2128', NULL, '8106', 'Benzin Kanister 10l', '', '1680040800', '50001', '', '', '10.11.2021 - 08:59:25', '', '1', '29.03.2023 - 12:00:07', '1', '', '', 'BKan1', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verbrauchsmaterial', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2129', NULL, '8107', 'Benzin Kanister 10l', '', '1680040800', '50001', '', '', '10.11.2021 - 08:59:58', '', '1', '29.03.2023 - 12:00:27', '1', '', '', 'BKan2', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Verbrauchsmaterial', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2137', NULL, '30346067', 'FHA', '', '1733526000', '50001', '', '', '06.12.2021 - 14:39:34', 'Seriennummer: 112793\r\n\r\n', '1', '20.01.2025 - 12:17:53', '1', '', '', 'SICH2101', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Haltegurt', '20.12.2021', '', '', 'A2BZ', '112793', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2138', NULL, '30346064', 'FHA', '', '1720908000', '50001', '', '', '06.12.2021 - 14:40:34', 'Seriennummer: 114896', '1', '02.08.2024 - 10:52:58', '1', '', '', 'SICH2102', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Haltegurt', '20.12.2021', '', '', 'A2BZ', '114896', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2139', NULL, '30346065', 'FHA', '', '1720908000', '50001', '', '', '06.12.2021 - 14:41:27', 'Seriennummer: 115208', '1', '02.08.2024 - 10:53:23', '1', '', '', 'SICH2103', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Haltegurt', '20.12.2021', '', '', 'A2BZ', '115208', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2140', NULL, '30349616', 'FHA', '', '1720908000', '50001', '', '', '06.12.2021 - 14:42:26', 'Seriennummer: 57203-040\r\n', '1', '02.08.2024 - 10:53:39', '1', '', '', 'SICH2104', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Haltegurt', '20.12.2021', '', '', 'A2BZ', '57203-040', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2141', NULL, '3050638', 'FHA', '', '1733526000', '50001', '', '', '06.12.2021 - 14:44:03', 'Seriennummer: 57408-008\r\nGröße: 4', '1', '20.01.2025 - 12:19:03', '1', '', '', 'SICH2105', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Haltegurt', '20.12.2021', '', '', 'A2BZ', '57408-008', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2142', NULL, '30346061', 'FHA', '', '1720908000', '50001', '', '', '06.12.2021 - 14:45:35', 'Seriennummer: 52102-157\r\n\r\nGröße: 3', '1', '02.08.2024 - 10:53:56', '1', '', '', 'SICH2106', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Haltegurt', '20.12.2021', '', '', 'A2BZ', '52102-157', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2143', NULL, '30346063', 'FHA', '', '1720908000', '50001', '', '', '06.12.2021 - 14:46:37', 'Seriennummer: 56559-128\r\nGröße: 3', '1', '02.08.2024 - 10:54:15', '1', '', '', 'SICH2107', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Haltegurt', '20.12.2021', '', '', 'A2BZ', '56559-128', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2144', NULL, '30346066', 'FHA', '', '1733526000', '50001', '', '', '06.12.2021 - 14:47:41', 'Seriennummer: 55285-039\r\nGröße: 2', '1', '20.01.2025 - 12:19:18', '1', '', '', 'SICH2108', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Haltegurt', '20.12.2021', '', '', 'A2BZ', '55285-039', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2145', NULL, '30346062', 'FHA', '', '1736636400', '50001', '', '', '06.12.2021 - 14:48:45', 'Seriennummer: 49634-029\r\nGröße: 2 ', '1', '27.01.2025 - 13:03:29', '1', '', '', 'SICH2109', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Haltegurt', '20.12.2021', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2146', NULL, '30350183', 'FHA', '', '1736636400', '50001', '', '', '06.12.2021 - 14:49:42', 'Seriennummer: 55285-181\r\nGröße: 2', '1', '27.01.2025 - 13:03:51', '1', '', '', 'SICH2110', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Haltegurt', '20.12.2021', '', '', 'A2BZ', '55285-181', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2147', NULL, '30350187', 'FHA', '', '1720908000', '50001', '', '', '06.12.2021 - 14:50:39', 'Seriennummer: 52102-047\r\nGröße: 3', '1', '02.08.2024 - 10:54:43', '1', '', '', 'SICH2111', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Haltegurt', '20.12.2021', '', '', 'A2BZ', '52102-047', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2148', NULL, '30350182', 'FHA', '', '1736636400', '50001', '', '', '06.12.2021 - 14:51:37', 'Seriennummer: 55280-164\r\nGröße: 2', '1', '27.01.2025 - 13:04:10', '1', '', '', 'SICH2112', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Haltegurt', '20.12.2021', '', '', 'A2BZ', '55280-164', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2149', NULL, '30350186', 'FHA', '', '1736636400', '50001', '', '', '06.12.2021 - 14:52:31', 'Seriennummer: 56359-030\r\nGröße: 1', '1', '27.01.2025 - 13:04:21', '1', '', '', 'SICH2113', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Haltegurt', '20.12.2021', '', '', 'A2BZ', '56359-030', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2150', NULL, '30350185', 'FHA', '', '1733526000', '50001', '', '', '06.12.2021 - 14:53:27', 'Seriennummer: 115197\r\nGröße: 3', '1', '20.01.2025 - 12:19:40', '1', '', '', 'SICH2114', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Haltegurt', '20.12.2021', '', '', 'A2BZ', '115197', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2151', NULL, '30350184', 'FHA', '', '1674514800', '50001', '', '', '06.12.2021 - 14:59:24', 'Seriennummer: 115232\r\nGröße: 3', '1', '05.03.2023 - 08:56:12', '1', '', '', 'SICH2115', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Haltegurt', '20.12.2021', '', '', 'A2BZ', '115232', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2152', NULL, '30349619', 'FHA', '', '1733526000', '50001', '', '', '06.12.2021 - 15:00:19', 'Seriennummer: 56359-066\r\nGröße: 1', '1', '20.01.2025 - 12:20:08', '1', '', '', 'SICH2116', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Haltegurt', '20.12.2021', '', '', 'A2BZ', '56359-066', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2153', NULL, '30351472', 'FHA', '', '1736636400', '50001', '', '', '06.12.2021 - 15:01:08', 'Seriennummer: 147089\r\nGröße: 1', '1', '27.01.2025 - 13:04:47', '1', '', '', 'SICH2130', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Haltegurt', '20.12.2021', '', '', 'A2BZ', '147089', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2154', NULL, '30351470', 'FHA', '', '1736636400', '50001', '', '', '06.12.2021 - 15:02:02', 'Seriennummer: 148204\r\nGröße: 1', '1', '27.01.2025 - 13:05:34', '1', '', '', 'SICH2128', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Haltegurt', '20.12.2021', '', '', 'A2BZ', '148204', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2155', NULL, '30349621', 'FHA', '', '1733526000', '50001', '', '', '06.12.2021 - 15:03:00', 'Seriennummer: 60196-026\r\nGröße: 2', '1', '20.01.2025 - 12:20:23', '1', '', '', 'SICH2131', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Haltegurt', '20.12.2021', '', '', 'A2BZ', '60196-026', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2156', NULL, '30349624', 'FHA', '', '1701385200', '50001', '', '', '06.12.2021 - 15:04:22', 'Seriennummer: 60282-058\r\nGröße: 1', '1', '27.12.2023 - 19:45:39', '1', '', '', 'SICH2132', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Haltegurt', '20.12.2021', '', '', 'A2BZ', '60282-058', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2157', NULL, '30351471', 'FHA', '', '1736636400', '50001', '', '', '06.12.2021 - 15:05:22', 'Seriennummer: 147078\r\nGröße: 1\r\nLieske\r\n', '1', '27.01.2025 - 13:05:47', '1', '', '', 'SICH2119', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Haltegurt', '20.12.2021', '', '', 'A2BZ', '147078', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2158', NULL, '30356312', 'FHA', '', '1720908000', '50001', '', '', '06.12.2021 - 15:06:35', 'Seriennummer: 19822300840\r\nGröße: 3', '1', '02.08.2024 - 10:55:03', '1', '', '', 'SICH2129', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Haltegurt', '20.12.2021', '', '', 'A2BZ', '19822300840', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2159', NULL, '30356314', 'FHA', '', '1720908000', '50001', '', '', '06.12.2021 - 15:07:40', 'Seriennummer: 20822200058\r\nGröße: 2', '1', '02.08.2024 - 10:55:18', '1', '', '', 'SICH2118', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Haltegurt', '20.12.2021', '', '', 'A2BZ', '20822200058', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2160', NULL, '30356315', 'FHA', '', '1720908000', '50001', '', '', '06.12.2021 - 15:08:27', 'Seriennummer: 20822200151\r\nGröße: 2', '1', '02.08.2024 - 10:55:34', '1', '', '', 'SICH2117', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Haltegurt', '20.12.2021', '', '', 'A2BZ', '20822200151', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2161', NULL, '30356313', 'FHA', '', '1733526000', '50001', '', '', '06.12.2021 - 15:09:12', 'Seriennummer: 20822100001\r\nGröße: 1', '1', '20.01.2025 - 12:20:37', '1', '', '', 'SICH2120', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Haltegurt', '20.12.2021', '', '', 'A2BZ', '20822100001', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2162', NULL, '30356316', 'FHA', '', '1677193200', '50001', '', '', '06.12.2021 - 15:09:58', 'Seriennummer: 20822100010\r\nGröße: 1', '1', '27.12.2023 - 19:44:56', '1', '', '', 'SICH2123', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Haltegurt', '20.12.2021', '', '', 'A2BZ', '20822100010', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2163', NULL, '30356317', 'FHA', '', '1733526000', '50001', '', '', '06.12.2021 - 15:10:44', 'Seriennummer: 19822301580\r\nGröße: 3', '1', '20.01.2025 - 12:21:15', '1', '', '', 'SICH2124', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Haltegurt', '20.12.2021', '', '', 'A2BZ', '19822301580', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2164', NULL, '30346058', 'F 30', '1420066800', '1721253600', '90110', 'Mannschaft Hinten', '', '06.12.2021 - 15:19:20', '', '1', '08.12.2021 - 19:34:30', '1', '', '', 'LEI2103', 'Nils Bonk', 'Jan Hendrik', 'Einsatzbereit', '2270140473', '0', 'Feuerwehrleine', '20.12.2021', '', '', '', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2165', NULL, '30346059', 'F 30', '1483225200', '1721253600', '90110', 'Mannschaft Hinten', '', '06.12.2021 - 15:19:56', '', '1', '06.12.2021 - 15:32:24', '1', '', '', 'LEI2131', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerwehrleine', '20.12.2021', '', '', '', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2166', NULL, '30350251', 'F 30', '1388530800', '1737586800', '90111', 'Mannschaft Hinten', '', '06.12.2021 - 15:20:34', '', '1', '', '1', '', '', 'LEI2129', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerwehrleine', '20.12.2021', '', '', '', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2167', NULL, '30351988', 'F 30', '1514761200', '1737586800', '90111', 'Mannschaft Hinten', '', '06.12.2021 - 15:21:12', '', '1', '', '1', '', '', 'LEI2126', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerwehrleine', '20.12.2021', '', '', '', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2168', NULL, '30347536', 'F 30', '1388530800', '1723154400', '90112', 'Mannschaft Hinten', '', '06.12.2021 - 15:22:00', '', '1', '06.12.2021 - 15:33:34', '1', '', '', 'LEI2117', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerwehrleine', '20.12.2021', '', '', '', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2169', NULL, '30347537', 'F 30', '1230764400', '1723154400', '90112', 'Mannschaft Hinten', '', '06.12.2021 - 15:23:08', '', '1', '06.12.2021 - 15:33:35', '1', '', '', 'LEI2123', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerwehrleine', '20.12.2021', '', '', '', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2170', NULL, '30347539', 'F 30', '1451602800', '1723154400', '90112', 'Mannschaft Hinten', '', '06.12.2021 - 15:23:44', '', '1', '06.12.2021 - 15:33:36', '1', '', '', 'LEI2125', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerwehrleine', '20.12.2021', '', '', '', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2171', NULL, '30351465', 'F 30', '1136070000', '1738368000', '90113', '6', '', '06.12.2021 - 15:24:23', '', '1', '', '1', '', '', 'LEI2114', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerwehrleine', '20.12.2021', '', '', '', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2172', NULL, '30351464', 'F 30', '1388530800', '1738368000', '90113', '6', '', '06.12.2021 - 15:24:53', '', '1', '', '1', '', '', 'LEI2113', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerwehrleine', '20.12.2021', '', '', '', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2173', NULL, '30351463', 'F 30', '1230764400', '1738368000', '90113', '6', '', '06.12.2021 - 15:25:25', '', '1', '', '1', '', '', 'LEI2124', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerwehrleine', '20.12.2021', '', '', '', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2174', NULL, '30353695', 'F 30', '1483225200', '1721253600', '90110', 'Mannschaft Hinten', '', '06.12.2021 - 15:26:00', '', '1', '', '1', '', '', 'LEI2104', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerwehrleine', '20.12.2021', '', '', '', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2175', NULL, '30354710', 'F 30', '1420066800', '1733526000', '90114', 'Mannschaft Hinten', '', '06.12.2021 - 15:26:30', '', '1', '21.01.2022 - 15:06:13', '1', '', '', 'LEI2112', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '2273925997', '0', 'Feuerwehrleine', '20.12.2021', '', '', '', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2176', NULL, '30356555', 'F 30', '1546297200', '1737586800', '90111', 'Mannschaft Hinten', '', '06.12.2021 - 15:27:03', '', '1', '', '1', '', '', 'A2BZ19', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerwehrleine', '20.12.2021', '', '', '', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2177', NULL, '30356554', 'F 30', '1546297200', '1737586800', '90111', 'Mannschaft Hinten', '', '06.12.2021 - 15:27:49', '', '1', '', '1', '', '', 'A2BZ16', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerwehrleine', '20.12.2021', '', '', '', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2178', NULL, '30347538', 'F 30', '1577833200', '1723154400', '90112', 'Mannschaft Hinten', '', '06.12.2021 - 15:28:25', '', '1', '06.12.2021 - 15:33:37', '1', '', '', 'LEI2130', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerwehrleine', '20.12.2021', '', '', '', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2179', NULL, '30359291', 'F 30', '1609455600', '1737586800', '90111', 'Mannschaft Hinten', '', '06.12.2021 - 15:28:59', '', '1', '', '1', '', '', 'LEI2108', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerwehrleine', '20.12.2021', '', '', '', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2180', NULL, '30358627', 'F 30', '1627768800', '1721253600', '90110', 'Mannschaft Hinten', '', '06.12.2021 - 15:31:00', '', '1', '', '1', '', '', 'LEI2111', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerwehrleine', '20.12.2021', '', '', '', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2181', NULL, '30355661', 'F 30', '1167606000', '1737586800', '90111', 'Mannschaft Hinten', '', '06.12.2021 - 15:31:43', '', '1', '', '1', '', '', 'LEI2122', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerwehrleine', '20.12.2021', '', '', '', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2182', NULL, '30355649', 'F 30', '1325372400', '1721253600', '90110', 'Mannschaft Hinten', '', '06.12.2021 - 15:32:10', '', '1', '', '1', '', '', 'LEI2106', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerwehrleine', '20.12.2021', '', '', '', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2183', NULL, '11000', 'Pressluftatmer', '597970800', '1639522800', '50001', 'Mannschaft Vorne', '', '15.12.2021 - 19:37:15', '121212\r\n', '1', '28.08.2022 - 11:21:47', '1', '', '28.08.2022', 'DRÄ', 'Jan Hendrik Friedrich', 'Nils', 'Ausgesondert', '', '0', 'Atemschutz', '10.04.2022', '', '', '', '', '6', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2186', NULL, '3166', 'Funkgerät HRT', '', '1721253600', '90110', 'Mannschaft Hinten', '', '16.12.2021 - 19:28:41', '', '1', '30.06.2022 - 12:10:31', '1', '', '', '12-23-1-4', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '10.02.2022', '', '6228522', '', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2187', NULL, '3167', 'Funkgerät HRT', '', '1721253600', '90110', 'Mannschaft Hinten', '', '16.12.2021 - 19:31:02', '', '1', '16.12.2021 - 19:38:10', '1', '', '', '12-23-1-5', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '10.02.2022', '', '6228523', '', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2188', NULL, '4090', 'Funkgerät HRT', '', '1733526000', '90114', 'Mannschaft Vorne', '', '16.12.2021 - 19:35:50', '', '1', '16.12.2021 - 19:38:12', '1', '', '', '12-68-1-2', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '10.02.2022', '', '6228524', '', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2189', NULL, '4091', 'Funkgerät HRT', '', '1733526000', '90114', 'Mannschaft Hinten', '', '16.12.2021 - 19:37:53', '', '1', '16.12.2021 - 19:38:14', '1', '', '', '12-68-1-3', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Funk', '10.02.2022', '', '6228525', '', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2191', NULL, '30359999', 'Schnittschutzhose', '1614898800', '1737586800', '90111', '3', '', '24.02.2022 - 19:37:31', '', '1', '', '1', '', '', '', '', 'Jan Hendrik', 'Einsatzbereit', '05.03.2026', '0', 'Säge Equipment', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2192', NULL, '8519', 'CO2 Löscher 2kg', '', '1716328800', '90115', 'Mannschaft Hinten', '', '24.04.2022 - 07:48:29', '2kg', '1', '23.05.2024 - 10:24:44', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerlöscher', '', '', '', 'A2BZ', '', '24', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2193', NULL, '8520', 'Pulverlöscher P2', '', '1716328800', '90115', 'Mannschaft Hinten', '', '24.04.2022 - 07:49:47', '', '1', '23.05.2024 - 10:25:01', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerlöscher', '', '', '', 'A2BZ', '', '24', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2194', NULL, '2143', 'Spannungsprüfer Bahn', '', '1738368000', '90113', '4', '', '06.06.2022 - 12:00:37', 'Set 1', '1', '06.06.2022 - 12:04:18', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2195', NULL, '2144', 'Spannungsprüfer Bahn', '', '1738368000', '90113', '4', '', '06.06.2022 - 12:01:04', 'Set 2', '1', '06.06.2022 - 12:04:43', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2196', NULL, '2145', 'Erdungsstange Bahn', '', '1738368000', '90113', '4', '', '06.06.2022 - 12:01:57', 'Set 1', '2', '', '2', '', '', '', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2197', NULL, '2146', 'Erdungsstange Bahn', '', '1738368000', '90113', '4', '', '06.06.2022 - 12:02:23', 'Set 2', '2', '', '2', '', '', '', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2198', NULL, '2147', 'Erdungskabel Bahn', '', '1738368000', '90113', '4', '', '06.06.2022 - 12:03:01', 'Set 1', '2', '', '2', '', '', '', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2199', NULL, '2148', 'Erdungskabel Bahn', '', '1738368000', '90113', '4', '', '06.06.2022 - 12:03:35', 'Set 2', '2', '', '2', '', '', '', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2200', NULL, '30360053', 'Verlängerungskabel 16A', '', '1738368000', '90113', '6', '', '30.06.2022 - 10:33:38', '', '1', '', '1', '', '', '', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Elektro', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2201', NULL, '1302', 'Verteiler B/B/C/B/C', '', '1737586800', '90111', 'Traversenkasten Rechts', '', '02.07.2022 - 08:01:44', '', '1', '', '1', '', '', '', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2202', NULL, '2149', 'Bahnerdungsset 1', '', '1738368000', '90113', '4', '', '05.07.2022 - 10:46:25', '', '1', '', '1', '', '', '', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2203', NULL, '2150', 'Bahnerdungsset 2', '', '1738368000', '90113', 'Dach', '', '05.07.2022 - 10:47:28', '', '1', '', '1', '', '', '', '', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'TH', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2204', NULL, '3168', 'Lutte', '', '1721253600', '90110', '2', '', '05.07.2022 - 20:38:33', '', '1', '09.06.2023 - 16:55:39', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstiges', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2205', NULL, '3169', 'Saugschlauch Werfer', '', '1721253600', '90110', 'GR', '', '05.07.2022 - 20:48:29', '', '1', '09.06.2023 - 16:56:02', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstiges', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2206', NULL, '30360109', 'RC Lüfter', '', '1703026800', '50001', '', '', '29.08.2022 - 10:37:02', '', '1', '16.01.2024 - 11:19:54', '1', '', '', 'RC1268104', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sondergerät', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2207', NULL, '30360110', 'Großlüfter', '', '1703026800', '50001', '', '', '29.08.2022 - 10:38:11', '', '1', '16.01.2024 - 11:20:10', '1', '', '', 'ÜL1268101', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sondergerät', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2208', NULL, '8521', 'Pulverlöscher P6', '', '1716328800', '50001', '', '', '29.08.2022 - 10:40:51', 'RC Lüfter', '1', '23.05.2024 - 10:25:11', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Feuerlöscher', '', '', '', 'A2BZ', '', '24', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2209', NULL, '4092', 'Windmesser', '', '1703026800', '50001', '', '', '29.08.2022 - 10:51:19', 'RC Lüfter', '1', '16.01.2024 - 11:21:12', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik', 'Einsatzbereit', '', '0', 'Sonstiges', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2210', NULL, '30359712', 'FI-Schutzschalter', '', '1737586800', '90111', '2', '', '1671092259', '', '1', '', '1', '', '1638399600', '', '', 'Jan Hendrik&nbsp;Friedrich', 'Einsatzbereit', '', '0', 'Elektro', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2211', NULL, '1155', 'Mehrgasmessgerät', '', '1737586800', '90111', 'Mannschaft Hinten', '', '1674808342', 'Pac Co', '1', '12.03.2023 - 16:15:11', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik&nbsp;Friedrich', 'Einsatzbereit', '', '0', 'Gefahrgut', '', '', '', 'A2BZ', '', '1', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2212', NULL, '05775009', 'Co Messgerät', '', '1744840800', '90111', 'Mannschaft Hinten', '', '1674815961', '', '1', '17.04.2025 - 13:36:09', '1', '', '', 'Meß2101', 'Jan Hendrik Friedrich', 'Jan Hendrik&nbsp;Friedrich', 'Einsatzbereit', '', '0', 'Gefahrgut', '', '', '', 'A2BZ', '', '1', '', 'x', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2213', NULL, '61000', 'Mini PC ASUS P91N', '0', '1746230400', '60000', '1', '', '1675367022', 'Arbeitsplatz 1\r\nASUS PN-41\r\n\r\nZubehör:\r\n\r\nMaus + Tastatur', '1', '21.11.2024 - 20:58:43', '1', '', '', 'A2BZ-AP1', 'Thede Meischen', 'Nils&nbsp;Bonk', 'Einsatzbereit', '', '0', 'EDV', '', '', '', 'A2BZ', '', '1', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2214', NULL, '60001', 'Mini PC ASUS P91N', '0', '1746230400', '60000', '1', '', '1675367846', 'Zubehör:\r\n\r\nMaus + Tastatur\r\n\r\nASUS PN-41', '1', '12.02.2023 - 08:45:33', '1', '', '', 'A2BZ-AP2', 'Nils Bonk', 'Nils&nbsp;Bonk', 'Einsatzbereit', '', '0', 'EDV', '', '', '', 'A2BZ', '', '1', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2215', NULL, '60003', 'Mini PC ASUS P91N', '0', '1705363200', '60000', '1', '', '1675367888', 'Zubehör:\r\n\r\nMaus + Tastatur\r\n\r\nASUS PN-41', '1', '12.02.2023 - 08:45:42', '1', '', '', 'A2BZ-AP3', 'Nils Bonk', 'Nils&nbsp;Bonk', 'Einsatzbereit', '', '0', 'EDV', '', '', '', 'A2BZ', '', '1', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2216', NULL, '60004', 'Monitor', '', '1705446000', '60000', '1', '', '1675367967', '', '1', '12.02.2023 - 08:42:46', '1', '', '', 'A2BZ-AP1', 'Nils Bonk', 'Nils&nbsp;Bonk', 'Einsatzbereit', '', '0', 'EDV', '', '', '', 'A2BZ', '', '1', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2217', NULL, '60005', 'Monitor', '', '1705446000', '60000', '1', '', '1675368067', '', '1', '12.02.2023 - 08:42:54', '1', '', '', 'A2BZ-AP2', 'Nils Bonk', 'Nils&nbsp;Bonk', 'Einsatzbereit', '', '0', 'EDV', '', '', '', 'A2BZ', '', '1', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2218', NULL, '60006', 'Monitor', '', '1705446000', '60000', '1', '', '1675368100', '', '1', '12.02.2023 - 08:43:03', '1', '', '', 'A2BZ-AP3', 'Nils Bonk', 'Nils&nbsp;Bonk', 'Einsatzbereit', '', '0', 'EDV', '', '', '', 'A2BZ', '', '1', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2219', NULL, '60007', 'SEB VBP4010', '', '1705446000', '60000', '1', '', '1675368155', 'Zubehör:\r\nHeadset, Fußtaster, Hörer', '1', '12.02.2023 - 08:44:42', '1', '', '', 'A2BZ-SEB1', 'Nils Bonk', 'Nils&nbsp;Bonk', 'Einsatzbereit', '', '0', 'Funk', '11.02.2023', '', '', 'A2BZ', '', '1', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2220', NULL, '60008', 'SEB VBP4010', '', '1705446000', '60000', '1', '', '1675368183', 'Zubehör:\r\nHeadset, Fußtaster, Hörer\r\n', '1', '07.06.2023 - 08:27:28', '1', '', '', 'A2BZ-SEB2', 'Nils', 'Nils&nbsp;Bonk', 'Einsatzbereit', '', '1', 'Funk', '11.02.2023', '', '', 'A2BZ', '', '1', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2221', NULL, '60009', 'Funkgerät FRT', '0', '1744761600', '60000', '1', '', '1675368243', '', '1', '07.06.2023 - 08:27:33', '1', '', '', '12-90-1A', 'Nils', 'Nils&nbsp;Bonk', 'Einsatzbereit', '', '1', 'Funk', '11.02.2023', '', '', 'A2BZ', '', '1', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2222', NULL, '60010', 'Funkgerät FRT', '', '1730329200', '60000', '1', '', '1675368284', '', '1', '31.10.2024 - 20:21:33', '1', '', '', '12-90-1B', 'Nils Bonk', 'Nils&nbsp;Bonk', 'Einsatzbereit', '', '0', 'Funk', '11.02.2023', '', '', 'A2BZ', '', '1', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2223', NULL, '30360750', 'Emergency Plug', '1672527600', '1738368000', '90113', '3', '', '1679061258', '', '1', '', '1', '', '1677625200', '', '', 'Jan Hendrik&nbsp;Friedrich', 'Einsatzbereit', '', '0', 'TH', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2224', NULL, '30360522', 'Schnittschutzhose', '', '1723154400', '90112', '1', '', '1681807922', '', '1', '02.05.2023 - 08:56:20', '1', '', '', '2104', 'Jan Hendrik Friedrich', 'Jan Hendrik&nbsp;Friedrich', 'Bedingt Einsatzbereit', '', '0', 'Schutzkleidung', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2225', NULL, '30360813', 'Feuerwehrleine', '1682632800', '1721253600', '90110', 'Mannschaft Hinten', '', '1682706136', '', '1', '08.06.2023 - 20:50:24', '1', '', '', 'A2BZ4', 'Jan Hendrik', 'Jan Hendrik&nbsp;Friedrich', 'Einsatzbereit', '2035922400', '0', '', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2226', NULL, '2151', 'Akku Schrauber', '', '1738368000', '90113', '4', '', '1682708457', '', '1', '', '1', '', '', '', '', 'Jan Hendrik&nbsp;Friedrich', 'Einsatzbereit', '', '0', 'Elektro', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2227', NULL, '1000', 'Test', '', '1725832800', '90120', 'Mannschaft Vorne', '', '1686144182', '111', '1', '10.09.2024 - 07:50:08', '1', '', '10.09.2024', 'test', 'Florian Oltmer', 'Manuel&nbsp;Arntjen', 'Ausgesondert', '', '0', 'Anschlagmittel', '', '', '', 'A2E', '', '1', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2229', NULL, '30359815', 'Saugschlauch', '', '1686162333', '90126', '1', '', '18.12.2021 - 17:15:04', '', '1', '23.12.2021 - 09:42:20', '1', '', '', '', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2230', NULL, '30359812', 'Saugschlauch', '', '1686162333', '90126', '1', '', '18.12.2021 - 17:16:08', '', '1', '23.12.2021 - 09:42:40', '1', '', '', '', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2231', NULL, '30359814', 'Saugschlauch', '', '1686162333', '90127', '1', '', '18.12.2021 - 17:17:47', '', '1', '07.06.2023 - 20:18:48', '1', '', '', '', 'test test', 'Henning', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2232', NULL, '30349390', 'Krankentrage', '', '1686162333', '90126', '1', '', '18.12.2021 - 17:20:19', '', '1', '20.12.2021 - 18:23:33', '1', '', '', '', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'Sanitätsgerät', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2233', NULL, '30349093', 'Megaphone', '', '1686162333', '90126', '1', '', '18.12.2021 - 17:28:26', '', '1', '18.12.2021 - 19:24:47', '1', '', '', '', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'Sondergerät', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2234', NULL, '30355272', 'Kübelspritze', '', '1686162333', '90126', '3', '', '18.12.2021 - 17:32:34', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Wasserabgabe', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2235', NULL, '30349449', 'Pulverlöscher P12', '', '1686162333', '90126', '3', '', '18.12.2021 - 17:35:10', '', '1', '04.04.2022 - 19:20:07', '1', '', '', '', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'Feuerlöscher', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2236', NULL, '7005', 'Pressluftatmer', '', '1686162333', '90126', '5', '', '18.12.2021 - 17:44:20', '', '1', '11.05.2023 - 09:08:54', '1', '', '', 'PSS 7000', 'Henning', 'Henning', 'Einsatzbereit', '', '0', 'Atemschutz', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2237', NULL, '7006', 'Pressluftatmer', '', '1686162333', '90126', '5', '', '18.12.2021 - 17:45:05', '', '1', '01.11.2022 - 15:52:16', '1', '', '', 'PSS 7000', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'Atemschutz', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2238', NULL, '7007', 'Pressluftatmer', '', '1686162333', '90126', '5', '', '18.12.2021 - 17:45:38', '', '1', '01.11.2022 - 15:52:33', '1', '', '', 'PSS 7000', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'Atemschutz', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2239', NULL, '30355822', 'Handlampe Halo 4 Ex ', '', '1686162333', '90126', '5', '', '18.12.2021 - 17:49:45', '', '1', '18.12.2021 - 19:25:09', '1', '', '', '', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'Handlampe', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2240', NULL, '30354283', 'Handlampe AccuLux HL 25 Ex', '', '1686162333', '90126', '5', '', '18.12.2021 - 17:51:49', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Handlampe', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2241', NULL, '30354282', 'Handlampe AccuLux HL 25 Ex', '', '1686162333', '90126', '5', '', '18.12.2021 - 17:52:38', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Handlampe', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2242', NULL, '3501', 'F 30', '2011', '1686162333', '90126', '5', '', '05.01.2022 - 12:49:44', '', '1', '05.01.2022 - 16:08:44', '1', '', '', 'A2P8', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'Anschlagmittel', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2243', NULL, '3502', 'F 30', '2015', '1686162333', '90126', '5', '', '05.01.2022 - 12:53:13', '', '1', '05.01.2022 - 16:10:01', '1', '', '', 'A2P9', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'Anschlagmittel', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2244', NULL, '3503', 'F 30', '2011', '1686162333', '90126', '5', '', '05.01.2022 - 12:54:29', '', '1', '05.01.2022 - 16:10:15', '1', '', '', 'A2P4', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'Anschlagmittel', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2245', NULL, '3701', 'Feuerwehraxt', '', '1686162333', '90126', '5', '', '05.01.2022 - 12:59:10', '', '1', '05.01.2022 - 16:09:41', '1', '', '', '', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'Arbeitsgerät', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2246', NULL, '3702', 'Löschrucksack', '', '1686162333', '90126', '7', '', '05.01.2022 - 13:16:27', '', '1', '05.01.2022 - 16:10:35', '1', '', '', '', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'Wasserabgabe', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2247', NULL, '3703', 'Löschrucksack', '', '1686162333', '90126', '7', '', '05.01.2022 - 13:17:15', '', '1', '05.01.2022 - 16:11:04', '1', '', '', '', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'Wasserabgabe', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2248', NULL, '30355804', 'Verbandkasten Fw', '', '1686162333', '90126', '7', '', '05.01.2022 - 13:54:48', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '30.06.2025', '0', 'Erste Hilfe', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2249', NULL, '3704', 'Schlauchhalter', '', '1686162333', '90126', '7', '', '05.01.2022 - 13:57:22', '', '4', '', '4', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Anschlagmittel', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2250', NULL, '3705', 'Schlauchtragekorb', '', '1686162333', '90126', '7', '', '05.01.2022 - 14:02:56', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Sonstiges', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2251', NULL, '3706', 'Schlauchtragekorb', '', '1686162333', '90126', '7', '', '05.01.2022 - 14:04:24', '', '1', '05.01.2022 - 16:11:24', '1', '', '', '', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'Sonstiges', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2252', NULL, '3707', 'Waldbrandtragekorb', '', '1686162333', '90126', '7', '', '05.01.2022 - 14:23:44', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Sonstiges', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2253', NULL, '3708', 'Hohlstrahlrohr C', '', '1686162333', '90126', '7', '', '05.01.2022 - 14:25:40', '', '1', '05.01.2022 - 14:26:27', '1', '', '', '', 'Henning', 'Henning', 'Einsatzbereit', '', '0', 'Wasserabgabe', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2254', NULL, '3709', 'Druckschlauch C', '', '1686162333', '90126', '7', '', '05.01.2022 - 14:41:26', '', '13', '05.01.2022 - 17:24:23', '13', '', '', '', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'Sonstiges', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2255', NULL, '3716', 'Hohlstrahlrohr D', '', '1686162333', '90126', '7', '', '05.01.2022 - 15:00:35', '', '1', '05.01.2022 - 16:12:04', '1', '', '', '', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'Wasserabgabe', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2256', NULL, '3717', 'Hohlstrahlrohr D', '', '1686162333', '90126', '7', '', '05.01.2022 - 15:02:14', '', '1', '05.01.2022 - 16:12:25', '1', '', '', '', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'Wasserabgabe', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2257', NULL, '3718', 'Hohlstrahlrohr D', '', '1686162333', '90126', '7', '', '05.01.2022 - 15:02:46', '', '1', '05.01.2022 - 16:12:40', '1', '', '', '', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'Wasserabgabe', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2258', NULL, '3719', 'Verteiler', '', '1686162333', '90126', '7', '', '05.01.2022 - 15:03:59', 'C/DCD', '1', '05.01.2022 - 16:13:04', '1', '', '', '', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2259', NULL, '3720', 'Druckschlauch D', '', '1686162333', '90126', '7', '', '05.01.2022 - 15:05:13', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Sonstiges', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2260', NULL, '3721', 'Druckschlauch D', '', '1686162333', '90126', '7', '', '05.01.2022 - 15:06:09', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Sonstiges', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2261', NULL, '3722', 'Druckschlauch D', '', '1686162333', '90126', '7', '', '05.01.2022 - 15:07:38', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Sonstiges', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2262', NULL, '3504', 'Atemanschluss', '', '1686162333', '90126', '5', '', '05.01.2022 - 15:21:10', '', '1', '05.01.2022 - 15:31:49', '1', '', '', '', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'Atemschutz', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2263', NULL, '3505', 'Atemanschluss', '', '1686162333', '90126', '5', '', '05.01.2022 - 15:22:42', '', '1', '05.01.2022 - 15:30:47', '1', '', '', '', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'Atemschutz', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2264', NULL, '3506', 'Atemanschluss', '', '1686162333', '90126', '5', '', '05.01.2022 - 15:23:57', '', '1', '05.01.2022 - 15:32:11', '1', '', '', '', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'Atemschutz', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2265', NULL, '3507', 'Atemanschluss', '', '1686162333', '90126', '5', '', '05.01.2022 - 15:24:39', '', '1', '05.01.2022 - 15:34:07', '1', '', '', '', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'Atemschutz', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2266', NULL, '3508', 'Atemanschluss', '', '1686162333', '90126', '5', '', '05.01.2022 - 15:26:22', '', '1', '05.01.2022 - 15:34:30', '1', '', '', '', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'Atemschutz', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2267', NULL, '3509', 'Atemanschluss', '', '1686162333', '90126', '5', '', '05.01.2022 - 15:27:47', '', '1', '05.01.2022 - 15:37:44', '1', '', '', '', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'Atemschutz', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2268', NULL, '3510', 'Pressluftflaschen ', '', '1686162333', '90126', '5', '', '05.01.2022 - 15:40:27', '', '3', '05.01.2022 - 15:56:42', '3', '', '', '', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'Atemschutz', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2269', NULL, '3301', 'Bindemittel', '', '1686162333', '90126', '3', '', '05.01.2022 - 15:53:18', '', '1', '17.01.2022 - 21:38:57', '1', '', '', '', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'Verbrauchsmaterial', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2270', NULL, '3302', 'Faltbehälter offen', '', '1686162333', '90126', '3', '', '05.01.2022 - 15:54:41', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Sonstiges', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2271', NULL, '3303', 'Mulde', '', '1686162333', '90126', '3', '', '05.01.2022 - 15:55:47', '', '3', '05.01.2022 - 16:06:50', '3', '', '', '', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'Sonstiges', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2272', NULL, '3304', 'Holzaxt', '', '1686162333', '90126', '3', '', '05.01.2022 - 15:58:18', '', '1', '05.01.2022 - 16:07:10', '1', '', '', '', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'Arbeitsgerät', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2273', NULL, '3305', 'Spalthammer', '', '1686162333', '90126', '3', '', '05.01.2022 - 15:58:53', '', '1', '05.01.2022 - 16:07:30', '1', '', '', '', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'Arbeitsgerät', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2274', NULL, '3306', 'Bügelsäge', '', '1686162333', '90126', '3', '', '05.01.2022 - 15:59:52', '', '1', '05.01.2022 - 16:07:49', '1', '', '', '', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'Arbeitsgerät', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2275', NULL, '3307', 'Bolzenschneider', '', '1686162333', '90126', '3', '', '05.01.2022 - 16:01:35', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Arbeitsgerät', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2276', NULL, '3308', 'Brechstange', '', '1686162333', '90126', '3', '', '05.01.2022 - 16:02:18', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Arbeitsgerät', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2277', NULL, '3309', 'Halligan-Tool', '', '1686162333', '90126', '3', '', '05.01.2022 - 16:02:56', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Arbeitsgerät', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2278', NULL, '3310', 'Turbinentauchpumpe', '', '1686162333', '90126', '3', '', '05.01.2022 - 16:05:32', '', '1', '07.06.2023 - 20:39:23', '1', '', '', '', 'test test', 'Henning', 'Einsatzbereit', '', '0', 'Wasserentnahme', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2279', NULL, '3101', 'Unterlegkeil', '', '1686162333', '90126', '1', '', '23.06.2022 - 09:30:09', '', '1', '07.06.2023 - 20:34:40', '1', '', '', '', 'test test', 'Henning', 'Einsatzbereit', '', '0', 'Sonstiges', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2280', NULL, '3102', 'Reinigungsequipment', '', '1686162333', '90126', '1', '', '23.06.2022 - 09:35:34', '', '1', '08.06.2023 - 20:46:58', '1', '', '', '', 'Jan Hendrik', 'Henning', 'Einsatzbereit', '', '1', 'Sonstiges', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2281', NULL, '30349119', 'Anhaltestab', '', '1686162333', '90126', 'Mannschaft Vorne', '', '23.06.2022 - 09:40:26', '', '1', '29.06.2022 - 20:45:22', '1', '', '', 'WK1221801', 'Karsten Becker', 'Karsten', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2282', NULL, '30349123', 'Anhaltestab', '', '1686162333', '90126', 'Mannschaft Vorne', '', '23.06.2022 - 09:42:49', '', '1', '29.06.2022 - 20:46:48', '1', '', '', 'WK1221802', 'Karsten Becker', 'Karsten', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2283', NULL, '30358592', 'Tragetuch', '01.06.2020', '1686162333', '90126', '1', '', '23.06.2022 - 09:49:01', '', '1', '04.07.2022 - 18:59:39', '1', '', '', '', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'Rettungsgerät', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2284', NULL, '30353107', 'Funkgerät HRT', '', '1686162333', '90126', 'Mannschaft Vorne', '', '23.06.2022 - 09:50:51', '', '1', '07.07.2022 - 18:21:26', '1', '', '', 'FUG12-21-8-1', 'Karsten Becker', 'Karsten', 'Einsatzbereit', '', '0', 'Funk', '', '', '4222312', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2285', NULL, '30358839', 'Tragetuch', '09.2020', '1686162333', '90126', '1', '', '23.06.2022 - 09:51:23', '', '1', '23.06.2022 - 09:51:52', '1', '', '', '', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'Rettungsgerät', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2286', NULL, '3103', 'Wolldecke', '', '1686162333', '90126', '1', '', '23.06.2022 - 09:59:16', '', '1', '08.06.2023 - 20:47:02', '1', '', '', '', 'Jan Hendrik', 'Henning', 'Einsatzbereit', '', '1', 'Erste Hilfe', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2287', NULL, '30349387', 'Abschleppseil', '01.01.2016', '1686162333', '90126', '1', '', '23.06.2022 - 10:04:03', '', '1', '04.07.2022 - 18:59:04', '1', '', '', '', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'Sonstiges', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2288', NULL, '30349389', 'Abschleppseil', '', '1686162333', '90126', '1', '', '23.06.2022 - 10:06:47', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Sonstiges', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2289', NULL, '303493', 'Abschleppseil', '', '1686162333', '90126', '1', '', '23.06.2022 - 10:10:42', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Sonstiges', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2290', NULL, '30349092', 'Warnlampe', '', '1686162333', '90126', 'Mannschaft Vorne', '', '23.06.2022 - 10:13:08', '', '1', '29.06.2022 - 20:56:17', '1', '', '', 'ULOLED', 'Karsten Becker', 'Karsten', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2291', NULL, '30349385', 'Schäkel', '', '1686162333', '90126', '1', '', '23.06.2022 - 10:13:17', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Anschlagmittel', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2292', NULL, '30349386', 'Schäkel', '', '1686162333', '90126', '1', '', '23.06.2022 - 10:14:15', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Anschlagmittel', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2293', NULL, '30349384', 'Schäkel', '', '1686162333', '90126', '1', '', '23.06.2022 - 10:15:35', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Anschlagmittel', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2294', NULL, '30358505', 'Verbandkasten', '', '1686162333', '90126', 'Mannschaft Vorne', '', '23.06.2022 - 10:16:07', 'Vollständigkeit laut Inventarliste, Verfallsdatum der Wundauflagen beachten.', '1', '29.06.2022 - 21:04:21', '1', '', '', 'REF10007', 'Karsten Becker', 'Karsten', 'Einsatzbereit', '', '0', 'Erste Hilfe', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2295', NULL, '3901', 'Bordwerkzeug', '11.12.2013', '1686162333', '90126', 'Mannschaft Vorne', '', '23.06.2022 - 10:25:43', '', '1', '29.06.2022 - 21:05:40', '1', '', '', 'Tasche-schwarz', 'Karsten Becker', 'Karsten', 'Einsatzbereit', '', '0', 'Werkzeug', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2296', NULL, '3902', 'Warnweste', '', '1686162333', '90126', 'Mannschaft Vorne', '', '23.06.2022 - 10:28:58', '', '3', '23.06.2022 - 10:35:50', '3', '', '', '', 'Karsten Becker', 'Karsten', 'Einsatzbereit', '', '0', 'Schutzkleidung', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2297', NULL, '3104', 'Einsatzverpflegung', '', '1686162333', '90126', '1', '', '23.06.2022 - 10:29:29', '', '2', '08.06.2023 - 20:47:14', '2', '', '', '', 'Jan Hendrik', 'Henning', 'Einsatzbereit', '09.11.2022', '1', 'Verbrauchsmaterial', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2298', NULL, '3903', 'Warndreieck', '11.12.2013', '1686162333', '90126', 'Mannschaft Vorne', '', '23.06.2022 - 10:32:25', '', '1', '29.06.2022 - 21:06:59', '1', '', '', '8K0860251', 'Karsten Becker', 'Karsten', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2299', NULL, '3105', 'Einmalhandschuhe', '', '1686162333', '90126', '1', '', '23.06.2022 - 10:33:23', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '05.2023', '0', 'Erste Hilfe', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2300', NULL, '3106', 'Einmalhandschuhe XL', '01.10.2018', '1686162333', '90126', '1', '', '23.06.2022 - 10:35:39', '', '3', '08.06.2023 - 20:47:27', '3', '', '', '', 'Jan Hendrik', 'Henning', 'Einsatzbereit', '01.09.2023', '1', 'Erste Hilfe', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2301', NULL, '3107', 'Absperrband', '', '1686162333', '90126', '1', '', '23.06.2022 - 10:37:40', 'Kuhfuss 300mm', '1', '08.06.2023 - 20:47:31', '1', '', '', '', 'Jan Hendrik', 'Henning', 'Einsatzbereit', '', '1', 'Verbrauchsmaterial', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2302', NULL, '3108', 'Absperrorgan A', '', '1686162333', '90126', '1', '', '23.06.2022 - 10:41:23', 'Brechstange 400mm', '1', '08.06.2023 - 20:47:34', '1', '', '', '', 'Jan Hendrik', 'Henning', 'Einsatzbereit', '', '1', 'Wasserführend', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2303', NULL, '3904', 'Schreibmaterial', '', '1686162333', '90126', 'Mannschaft Vorne', '', '23.06.2022 - 10:42:28', '', '1', '23.06.2022 - 10:48:25', '1', '', '', 'Notizmappe', 'Karsten Becker', 'Karsten', 'Einsatzbereit', '', '0', 'Verbrauchsmaterial', '', 'x', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2304', NULL, '3109', 'Druckschlauch A', '', '1686162333', '90126', '1', '', '23.06.2022 - 10:43:19', '', '1', '08.06.2023 - 20:47:38', '1', '', '', '', 'Jan Hendrik', 'Henning', 'Einsatzbereit', '', '1', 'Wasserführend', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2305', NULL, '3905', 'Schlüsselmappe', '', '1686162333', '90126', 'Mannschaft Vorne', '', '23.06.2022 - 10:45:43', '', '1', '24.06.2022 - 16:34:27', '1', '', '', '', 'Henning Zu Jeddeloh', 'Karsten', 'Einsatzbereit', '', '0', 'Sonstiges', '', 'x', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2306', NULL, '3110', 'Elektrowerkzeug ', '', '1686162333', '90126', '1', '', '23.06.2022 - 10:47:42', '', '1', '08.06.2023 - 20:47:41', '1', '', '', '', 'Jan Hendrik', 'Henning', 'Einsatzbereit', '', '1', 'Werkzeug', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2307', NULL, '3906', 'Fahrzeugführerweste', '', '1686162333', '90126', 'Mannschaft Vorne', '', '23.06.2022 - 10:52:58', '', '1', '29.06.2022 - 21:07:26', '1', '', '', '12-23-8', 'Karsten Becker', 'Karsten', 'Einsatzbereit', '', '0', 'Dienstbekleidung', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2308', NULL, '3801', 'Druckschlauch B', '', '1686162333', '90126', '8', '', '23.06.2022 - 10:53:57', '', '5', '23.06.2022 - 10:57:05', '5', '', '', '', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2309', NULL, '3802', 'Mehrzweckstrahlrohr B', '', '1686162333', '90126', '8', '', '23.06.2022 - 10:56:44', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Wasserabgabe', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2310', NULL, '3803', 'Mehrzweckstrahlrohr C', '', '1686162333', '90126', '8', '', '23.06.2022 - 10:58:13', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Wasserabgabe', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2311', NULL, '3804', 'Mehrzweckstrahlrohr D', '', '1686162333', '90126', '8', '', '23.06.2022 - 10:58:58', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Wasserabgabe', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2312', NULL, '3805', 'Druckbegrenzungsventil', '', '1686162333', '90126', '8', '', '23.06.2022 - 11:04:03', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2313', NULL, '3806', 'Hydroschild', '', '1686162333', '90126', '8', '', '23.06.2022 - 11:06:04', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Wasserabgabe', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2314', NULL, '3807', 'Absperrorgan B', '', '1686162333', '90126', '8', '', '23.06.2022 - 11:06:49', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2315', NULL, '3601', 'Schaummittel', '', '1686162333', '90126', '6', '', '23.06.2022 - 11:06:52', 'Schaummittelkanister, 20 Liter, 3%', '6', '', '6', '', '', 'Kanister, gelb', '', 'Karsten', 'Einsatzbereit', '', '0', 'Verbrauchsmaterial', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2316', NULL, '3808', 'Druckschlauch D', '', '1686162333', '90126', '8', '', '23.06.2022 - 11:07:47', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2317', NULL, '3809', 'Stützkrümmer B', '', '1686162333', '90126', '8', '', '23.06.2022 - 11:09:24', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2318', NULL, '3602', 'Kombischaumrohr S4/M4', '', '1686162333', '90126', '6', '', '23.06.2022 - 11:10:57', '', '1', '05.07.2022 - 22:28:32', '1', '', '', 'AWG', 'Henning Zu Jeddeloh', 'Karsten', 'Einsatzbereit', '', '0', 'Wasserabgabe', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2319', NULL, '3603', 'Ansaugschlauch D/D', '', '1686162333', '90126', '6', '', '23.06.2022 - 11:14:37', '', '1', '', '1', '', '', 'Schaummittelsaugschlauch', '', 'Karsten', 'Einsatzbereit', '', '0', 'Wasserabgabe', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2320', NULL, '3810', 'Übergangsstück B>C', '', '1686162333', '90126', '8', '', '23.06.2022 - 11:14:40', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2321', NULL, '3811', 'Übergangsstück C>D', '', '1686162333', '90126', '8', '', '23.06.2022 - 11:15:15', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2322', NULL, '3812', 'Hohlstrahlrohr C', '', '1686162333', '90126', '8', '', '23.06.2022 - 11:17:41', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Wasserabgabe', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2323', NULL, '3604', 'Zumischer Z4', '', '1686162333', '90126', '6', 'DIN 14384', '23.06.2022 - 11:19:44', 'AWG Zumischer 0 - 6%, 400l/min', '1', '', '1', '', '', 'AWG  Z4R', '', 'Karsten', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2324', NULL, '3605', 'Übergangsstück C>D', '', '1686162333', '90126', '6', '', '23.06.2022 - 11:22:33', '', '1', '05.07.2022 - 22:08:40', '1', '', '', '', 'Henning Zu Jeddeloh', 'Karsten', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2325', NULL, '3813', 'Druckschlauch B', '', '1686162333', '90126', 'Traversenkasten Rechts', '', '23.06.2022 - 11:23:41', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2326', NULL, '3606', 'Übergangsstück A>B', '', '1686162333', '90126', '6', '', '23.06.2022 - 11:23:47', '', '1', '05.07.2022 - 22:03:30', '1', '', '', '', 'Henning Zu Jeddeloh', 'Karsten', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2327', NULL, '3814', 'Verteiler', '', '1686162333', '90126', 'Traversenkasten Rechts', '', '23.06.2022 - 11:25:29', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2328', NULL, '3607', 'Übergangsstück', '', '1686162333', '90126', '6', '', '23.06.2022 - 11:27:22', 'Übergangsstück zur Druckerzeugung bei sonst offener Wasserabgabe. Eigenbau. Schützt die FPN vor Kavitation bei der Brunnenprüfung.', '1', '29.06.2022 - 20:12:07', '1', '', '', '2 B mit Verengung', 'Karsten Becker', 'Karsten', 'Einsatzbereit', '', '0', 'Sondergerät', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2329', NULL, '30358503', 'Atemschutzüberwachungstafel', '', '1686162333', '90126', 'GR', '', '23.06.2022 - 11:28:25', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Atemschutz', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2330', NULL, '30357786', 'Systemtrenner', '', '1686162333', '90126', '6', '', '23.06.2022 - 11:30:57', '', '1', '29.06.2022 - 20:16:55', '1', '', '', 'SYT1223801', 'Karsten Becker', 'Karsten', 'Einsatzbereit', '', '0', 'Wasserentnahme', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2331', NULL, '3907', 'Saugkorb', '', '1686162333', '90126', 'GR', '', '23.06.2022 - 11:32:15', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Wasserentnahme', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2332', NULL, '3908', 'Saugschutzkorb', '', '1686162333', '90126', 'GR', '', '23.06.2022 - 11:34:16', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Wasserentnahme', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2333', NULL, '30357820', 'Systemtrenner', '', '1686162333', '90126', '6', '', '23.06.2022 - 11:34:18', '', '1', '29.06.2022 - 20:18:25', '1', '', '', 'SYT1221802', 'Karsten Becker', 'Karsten', 'Einsatzbereit', '', '0', 'Wasserentnahme', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2334', NULL, '3909', 'Sammelstück', '', '1686162333', '90126', 'GR', '', '23.06.2022 - 11:36:29', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2335', NULL, '3910', 'Kupplungsschlüssel', '', '1686162333', '90126', 'GR', '', '23.06.2022 - 11:38:11', '', '3', '', '3', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Werkzeug', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2336', NULL, '3608', 'Standrohr', '', '1686162333', '90126', '6', '', '23.06.2022 - 11:39:02', '', '1', '29.06.2022 - 20:20:13', '1', '', '', '', 'Karsten Becker', 'Karsten', 'Einsatzbereit', '', '0', 'Wasserentnahme', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2337', NULL, '3911', 'Druckschlauch B 5m', '', '1686162333', '90126', 'GR', '', '23.06.2022 - 11:39:45', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2338', NULL, '3609', 'Hydrantenschlüssel', '', '1686162333', '90126', '6', '', '23.06.2022 - 11:42:57', '', '1', '29.06.2022 - 20:31:42', '1', '', '', '', 'Karsten Becker', 'Karsten', 'Einsatzbereit', '', '0', 'Arbeitsgerät', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2339', NULL, '3912', 'Halteleine', '', '1686162333', '90126', 'GR', '', '23.06.2022 - 11:45:10', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Anschlagmittel', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2340', NULL, '3913', 'Ventilleine', '', '1686162333', '90126', 'GR', '', '23.06.2022 - 11:46:07', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Anschlagmittel', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2341', NULL, '3610', 'Handradverlängerung', '', '1686162333', '90126', '6', '', '23.06.2022 - 11:47:00', '', '1', '04.07.2022 - 18:58:15', '1', '', '', '', 'Henning Zu Jeddeloh', 'Karsten', 'Einsatzbereit', '', '0', 'Werkzeug', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2342', NULL, '3611', 'Unterflurhydrantendeckelheber', '', '1686162333', '90126', '6', '', '23.06.2022 - 11:48:00', '', '1', '04.07.2022 - 18:55:51', '1', '', '', 'LM S2', 'Henning Zu Jeddeloh', 'Karsten', 'Einsatzbereit', '', '0', 'Arbeitsgerät', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2343', NULL, '3401', 'Druckschlauch B', '', '1686162333', '90126', '4', '', '23.06.2022 - 11:51:38', '', '6', '', '6', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2344', NULL, '3612', 'Schlauchwickler', '', '1686162333', '90126', '6', '', '23.06.2022 - 11:51:42', '', '1', '29.06.2022 - 20:21:12', '1', '', '', 'Barth ', 'Karsten Becker', 'Karsten', 'Einsatzbereit', '', '0', 'Arbeitsgerät', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2345', NULL, '3402', 'Druckschlauch D', '', '1686162333', '90126', '4', '', '23.06.2022 - 11:52:30', '', '4', '', '4', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2346', NULL, '3201', 'Verkehrsleitkegel', '', '1686162333', '90126', '2', '', '23.06.2022 - 11:55:19', '', '8', '', '8', '', '', '', '', 'Karsten', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2347', NULL, '3403', 'Trainingsanzug', '', '1686162333', '90126', '4', '', '23.06.2022 - 11:58:26', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Dienstbekleidung', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2348', NULL, '3404', 'Overall', '', '1686162333', '90126', '4', '', '23.06.2022 - 11:59:14', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Dienstbekleidung', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2349', NULL, '3202', 'Staukiste', '', '1686162333', '90126', '2', '', '23.06.2022 - 12:00:15', 'Beinhaltet: Sonnenschutz-Tarp, Luftpistole, Luftschlauch, Reifenfüller', '1', '23.06.2022 - 12:44:51', '1', '', '', '', 'Karsten Becker', 'Karsten', 'Einsatzbereit', '', '0', 'Sonstiges', '23.06.2022', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2350', NULL, '3405', 'Zumischer Z2', '', '1686162333', '90126', '4', '', '23.06.2022 - 12:01:07', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2351', NULL, '30349140', 'Solarblitz', '', '1686162333', '90126', '4', '', '23.06.2022 - 12:04:44', '', '2', '', '2', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2352', NULL, '30348346', 'Forsthelm', '08.12.21', '1686162333', '90126', '2', '', '23.06.2022 - 12:06:07', '', '1', '29.06.2022 - 20:02:26', '1', '', '', 'WAH2803', 'Karsten Becker', 'Karsten', 'Einsatzbereit', '', '0', 'Schutzkleidung', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2353', NULL, '3406', 'Faltsignal', '', '1686162333', '90126', '4', '', '23.06.2022 - 12:10:03', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2354', NULL, '30349493', 'Motorkettensäge', '', '1686162333', '90126', '2', '', '23.06.2022 - 12:10:25', 'Dazugehörig: Ersatzkette, Werkzeuge', '1', '29.06.2022 - 20:04:09', '1', '', '', 'MS 261C', 'Karsten Becker', 'Karsten', 'Einsatzbereit', '', '0', 'Säge Equipment', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2355', NULL, '3407', 'Drahtseil', '', '1686162333', '90126', '4', '', '23.06.2022 - 12:11:08', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'TH', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2356', NULL, '3408', 'Übergangsstück A>B', '', '1686162333', '90126', '4', '', '23.06.2022 - 12:11:57', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2357', NULL, '30348345', 'Kombi Kanister', '', '1686162333', '90126', '2', '', '23.06.2022 - 12:14:43', 'Dazu gehören jeweils eine Ausgusstülle für die zwei Kanisterteile.', '1', '29.06.2022 - 20:05:40', '1', '', '', 'KOMBI2802', 'Karsten Becker', 'Karsten', 'Einsatzbereit', '', '0', 'Säge Equipment', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2358', NULL, '30349444', 'Forsthelm', '', '1686162333', '90126', '2', '', '23.06.2022 - 12:24:19', '', '1', '29.06.2022 - 20:07:16', '1', '', '', 'WAH2804', 'Karsten Becker', 'Karsten', 'Einsatzbereit', '', '0', 'Schutzkleidung', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2359', NULL, '3203', 'Spaltkeil', '', '1686162333', '90126', '2', '', '23.06.2022 - 12:26:57', '', '3', '', '3', '', '', '', '', 'Karsten', 'Einsatzbereit', '', '0', 'Säge Equipment', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2360', NULL, '30349490', 'Steckleiterteil', '01.05.2013', '1686162333', '90126', 'Dach', '', '23.06.2022 - 12:27:48', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Leitern', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2361', NULL, '30349489', 'Steckleiterteil', '', '1686162333', '90126', 'Dach', '', '23.06.2022 - 12:29:32', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Leitern', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2362', NULL, '30349445', 'Schnittschutzhose', '', '1686162333', '90126', '2', '', '23.06.2022 - 12:30:27', '', '1', '29.06.2022 - 20:07:43', '1', '', '', 'SCHN2801', 'Karsten Becker', 'Karsten', 'Einsatzbereit', '', '0', 'Schutzkleidung', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2363', NULL, '30349491', 'Steckleiterteil', '01.02.2014', '1686162333', '90126', 'Dach', '', '23.06.2022 - 12:31:02', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Leitern', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2364', NULL, '30348343', 'Schnittschutzhose', '', '1686162333', '90126', '2', '', '23.06.2022 - 12:31:44', '', '1', '29.06.2022 - 20:08:00', '1', '', '', 'SCHN2802', 'Karsten Becker', 'Karsten', 'Einsatzbereit', '', '0', 'Schutzkleidung', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2365', NULL, '30349446', 'Steckleiterteil', '01.02.2014', '1686162333', '90126', 'Dach', '', '23.06.2022 - 12:33:26', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Leitern', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2366', NULL, '3914', 'Schlauchbrücke', '', '1686162333', '90126', 'Dach', '', '23.06.2022 - 12:38:43', '', '4', '', '4', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Arbeitsgerät', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2367', NULL, '30349492', 'Einreißhaken', '', '1686162333', '90126', 'Dach', '', '23.06.2022 - 12:40:42', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Arbeitsgerät', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2368', NULL, '3204', 'Mehrzweckzug', '', '1686162333', '90126', '2', '', '23.06.2022 - 12:43:09', 'Bestehend aus: Mehrzweckzug, Hebelrohr, Ersatzstifte, 2 Stück Rundschlinge 2m, 1 Stück Rundschlinge 4m', '1', '23.06.2022 - 12:45:45', '1', '', '', 'MZ 32', 'Karsten Becker', 'Karsten', 'Einsatzbereit', '', '0', 'TH', '26.06.2022', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2369', NULL, '30356407', 'Saugschlauch', '', '1686162333', '90126', 'Dach', '', '23.06.2022 - 12:45:19', 'Dichtung Tauschen', '1', '09.08.2022 - 21:31:25', '1', '', '', '', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2370', NULL, '30359816', 'Saugschlauch', '', '1686162333', '90126', 'Dach', '', '23.06.2022 - 12:46:24', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2371', NULL, '3915', 'Feuerpatsche', '', '1686162333', '90126', 'Dach', '', '23.06.2022 - 12:48:36', '', '4', '', '4', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Arbeitsgerät', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2372', NULL, '3916', 'Dunggabel', '', '1686162333', '90126', 'Dach', '', '23.06.2022 - 12:49:50', '', '3', '', '3', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Arbeitsgerät', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2373', NULL, '3205', 'Mehrzweckzug', '', '1686162333', '90126', '2', '', '23.06.2022 - 12:49:56', 'Bestehend aus: 10 Erdnägeln, 1 Stück Bodenanker, 1 Stück Umlenkrolle', '1', '', '1', '', '', 'Zubehör MZ 32', '', 'Karsten', 'Einsatzbereit', '', '0', 'TH', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2374', NULL, '3917', 'Stoßbesen', '', '1686162333', '90126', 'Dach', '', '23.06.2022 - 12:50:44', '', '4', '23.06.2022 - 13:21:23', '4', '', '', '', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'Arbeitsgerät', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2375', NULL, '3918', 'Sandschaufel', '', '1686162333', '90126', 'Dach', '', '23.06.2022 - 12:52:34', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Arbeitsgerät', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2376', NULL, '3919', 'Spaten', '', '1686162333', '90126', 'Dach', '', '23.06.2022 - 12:53:29', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Arbeitsgerät', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2377', NULL, '3206', 'Werkzeugkasten', '', '1686162333', '90126', '2', '', '23.06.2022 - 12:53:52', '', '1', '', '1', '', '', '', '', 'Karsten', 'Einsatzbereit', '', '0', 'Werkzeug', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2378', NULL, '3920', 'Wiedehopfhacke', '', '1686162333', '90126', 'Dach', '', '23.06.2022 - 12:58:17', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Arbeitsgerät', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2379', NULL, '3921', 'Faltbehältergestell', '', '1686162333', '90126', 'Dach', '', '23.06.2022 - 13:01:09', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Sonstiges', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2380', NULL, '30355641', 'Hebebaum', '', '1686162333', '90126', 'Dach', '', '23.06.2022 - 13:04:02', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'TH', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2381', NULL, '3922', 'Ansaugschlauch D/D', '', '1686162333', '90126', 'Dach', '', '23.06.2022 - 13:06:10', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2382', NULL, '3923', 'Gestell für Wasserwerfer', '', '1686162333', '90126', 'Dach', '', '23.06.2022 - 13:09:17', '', '1', '23.06.2022 - 13:09:27', '1', '', '', '', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'Sonstiges', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2383', NULL, '3924', 'Schwerschaumrohr Werfer', '', '1686162333', '90126', 'Dach', '', '23.06.2022 - 13:12:48', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Wasserabgabe', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2384', NULL, '3925', 'Wasserwerfer', '', '1686162333', '90126', 'Dach', '', '23.06.2022 - 13:18:23', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Wasserabgabe', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2385', NULL, '3926', 'Güllefassadapter', '', '1686162333', '90126', 'Dach', '', '23.06.2022 - 13:19:17', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2386', NULL, '3927', 'Erdankerziehgerät', '', '1686162333', '90126', 'Dach', '', '23.06.2022 - 13:22:16', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Arbeitsgerät', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2387', NULL, '1701', 'Funkgerät HRT', '', '1686162333', '90127', 'Mannschaft Vorne', '', '23.06.2022 - 15:30:12', 'TMO F_WST_1', '1', '07.07.2022 - 18:56:03', '1', '', '', 'FUG12-46-8-5', 'Karsten Becker', 'Karsten', 'Einsatzbereit', '', '0', 'Funk', '', '', '6224865', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2388', NULL, '30352628', 'Hebekissen ND', '01.03.2011', '1686162333', '90127', '2', '', '23.06.2022 - 15:32:28', '', '1', '23.06.2022 - 15:35:08', '1', '', '', '', 'Henning Zu Jeddeloh', 'Henning', 'Einsatzbereit', '', '0', 'TH', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2389', NULL, '1702', 'Funkgerät HRT', '', '1686162333', '90127', 'Mannschaft Vorne', '', '23.06.2022 - 15:33:52', '', '1', '07.07.2022 - 19:03:26', '1', '', '', 'FUG12-46-8-8', 'Karsten Becker', 'Karsten', 'Einsatzbereit', '', '0', 'Funk', '', '', '6227332', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2390', NULL, '30352629', 'Hebekissen ND', '01.03.2011', '1686162333', '90127', '2', '', '23.06.2022 - 15:34:50', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'TH', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2391', NULL, '1703', 'Funkgerät HRT', '', '1686162333', '90127', 'Mannschaft Vorne', '', '23.06.2022 - 15:37:04', '', '1', '07.07.2022 - 18:49:55', '1', '', '', 'FUG12-46-8-4', 'Karsten Becker', 'Karsten', 'Einsatzbereit', '', '0', 'Funk', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2392', NULL, '1704', 'Funkgerät HRT', '', '1686162333', '90127', 'Mannschaft Vorne', '', '23.06.2022 - 15:38:14', 'DMO 307_F', '1', '07.07.2022 - 18:56:58', '1', '', '', 'FUG12-46-8-3', 'Karsten Becker', 'Karsten', 'Einsatzbereit', '', '0', 'Funk', '', '', '6223895', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2393', NULL, '1201', 'Pressluftflasche 200bar', '', '1686162333', '90127', '2', '', '23.06.2022 - 15:38:27', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'TH', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2394', NULL, '1202', 'Blechaufreißer', '', '1686162333', '90127', '2', '', '23.06.2022 - 15:39:27', '', '1', '05.07.2022 - 20:48:51', '1', '', '', '', 'Henning', 'Henning', 'Einsatzbereit', '', '0', 'TH', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2395', NULL, '1203', 'Umfüllpumpe', '', '1686162333', '90127', '2', '', '23.06.2022 - 15:41:34', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'TH', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2396', NULL, '1705', 'Wärmebildkamera', '', '1686162333', '90127', 'Mannschaft Vorne', '', '23.06.2022 - 15:44:18', 'Ein Akku in der Wärmebildkamera, ein Akku ist in der Ladehalterung', '1', '23.06.2022 - 15:44:28', '1', '', '', 'FLIR K45', 'Karsten Becker', 'Karsten', 'Einsatzbereit', '', '0', 'Sondergerät', '', 'x', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2397', NULL, '1204', 'Druckluftschlauch', '', '1686162333', '90127', '2', '', '23.06.2022 - 15:44:29', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Sonstiges', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2398', NULL, '1205', 'Druckluftpistole', '', '1686162333', '90127', '2', '', '23.06.2022 - 15:46:27', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'Sonstiges', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2399', NULL, '1706', 'Einsatztablett', '', '1686162333', '90127', 'Mannschaft Vorne', '', '23.06.2022 - 15:53:42', '', '1', '29.06.2022 - 21:47:13', '1', '', '', '', 'Karsten Becker', 'Karsten', 'Einsatzbereit', '', '0', 'Sondergerät', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2400', NULL, '30352630', 'Doppelsteuerorgan', '01.03.2011', '1686162333', '90127', '2', '', '23.06.2022 - 15:55:20', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'TH', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2401', NULL, '1707', 'Fahrzeugführerweste', '', '1686162333', '90127', 'Mannschaft Vorne', '', '23.06.2022 - 15:56:59', '', '1', '23.06.2022 - 15:58:43', '1', '', '', '12-46-8', 'Karsten Becker', 'Karsten', 'Einsatzbereit', '', '0', 'Schutzkleidung', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2402', NULL, '30352631', 'Druckminderer', '01.03.2011', '1686162333', '90127', '2', '', '23.06.2022 - 15:57:04', '', '1', '', '1', '', '', 'DM12468', '', 'Henning', 'Einsatzbereit', '', '0', 'TH', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2403', NULL, '1708', 'Zugführerweste', '', '1686162333', '90127', 'Mannschaft Vorne', '', '23.06.2022 - 15:58:29', '', '1', '', '1', '', '', 'Zugführer Petersfehn', '', 'Karsten', 'Einsatzbereit', '', '0', 'Schutzkleidung', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2404', NULL, '30359522', 'Füllschlauch', '01.03.2011', '1686162333', '90127', '2', '', '23.06.2022 - 15:58:53', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'TH', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2405', NULL, '30359521', 'Füllschlauch', '01.03.2011', '1686162333', '90127', '2', '', '23.06.2022 - 16:00:03', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'TH', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2406', NULL, '1709', 'Einsatzkamera', '', '1686162333', '90127', 'Mannschaft Vorne', '', '23.06.2022 - 16:01:12', '', '1', '23.06.2022 - 16:04:29', '1', '', '', 'Sony', 'Karsten Becker', 'Karsten', 'Einsatzbereit', '', '0', 'Arbeitsgerät', '', 'x', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2407', NULL, '30353319', 'Handlampe Acculux', '', '1686162333', '90127', 'Mannschaft Vorne', '', '23.06.2022 - 16:07:36', '', '1', '', '1', '', '', '', '', 'Karsten', 'Einsatzbereit', '', '0', 'Handlampe', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2408', NULL, '30352632', 'Spanngurt', '30.03.2009', '1686162333', '90127', '2', '', '23.06.2022 - 16:11:15', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'TH', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2409', NULL, '1710', 'Funkgerät MRT', '', '1686162333', '90127', 'Mannschaft Vorne', '', '23.06.2022 - 16:11:50', '', '1', '07.07.2022 - 18:54:56', '1', '', '', '12-46-8', 'Karsten Becker', 'Karsten', 'Einsatzbereit', '', '0', 'Funk', '', '', '4227880', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2410', NULL, '1711', 'Einsatzleiterweste', '', '1686162333', '90127', 'Mannschaft Vorne', '', '23.06.2022 - 16:13:54', '', '1', '', '1', '', '', 'Einsatzleiter', '', 'Karsten', 'Einsatzbereit', '', '0', 'Schutzkleidung', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2411', NULL, '30352633', 'Spanngurt', '30.03.2009', '1686162333', '90127', '2', '', '23.06.2022 - 16:14:03', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'TH', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2412', NULL, '1712', 'Türöffnung Satz', '', '1686162333', '90127', 'Mannschaft Vorne', '', '23.06.2022 - 16:19:16', '', '1', '', '1', '', '', 'Wohnungsöffnung', '', 'Karsten', 'Einsatzbereit', '', '0', 'Werkzeug', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2413', NULL, '30352634', 'Spanngurt', '', '1686162333', '90127', '2', '', '23.06.2022 - 16:20:32', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'TH', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2414', NULL, '30356554', 'Rundschlinge', '01.11.2016', '1686162333', '90127', '2', '', '23.06.2022 - 16:23:24', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'TH', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2415', NULL, '30353325', 'Navigationsgerät', '', '1686162333', '90127', 'Mannschaft Vorne', '', '23.06.2022 - 16:24:05', '', '1', '', '1', '', '', '', '', 'Karsten', 'Einsatzbereit', '', '0', 'Sonstiges', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2416', NULL, '04988613', 'Rundschlinge', '01.01.2016', '1686162333', '90127', '2', '', '23.06.2022 - 16:27:10', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'TH', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2417', NULL, '1713', 'Schlüsselmappe', '', '1686162333', '90127', 'Mannschaft Vorne', '', '23.06.2022 - 16:29:18', '', '1', '', '1', '', '', 'HLF 12-46-8', '', 'Karsten', 'Einsatzbereit', '', '0', 'Sonstiges', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2418', NULL, '30353317', 'Handlampe Acculux', '', '1686162333', '90127', 'Mannschaft Hinten', '', '23.06.2022 - 16:31:22', '', '1', '29.06.2022 - 21:22:14', '1', '', '', '', 'Karsten Becker', 'Karsten', 'Einsatzbereit', '', '0', 'Beleuchtungsgerät', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2419', NULL, '1206', 'TH Zubehör', '', '1686162333', '90127', '2', '', '23.06.2022 - 16:31:54', 'Spanngurthacken      6x\r\nFederkörner          1x\r\nPacketbandroller     1x\r\nAbklebefolie         1x\r\nStaubmasken          9x\r\nKantenschutz         1x\r\nNothammer            1x\r\nBereitstellungsplane 1x', '1', '04.07.2022 - 18:39:51', '1', '', '', '', 'Henning', 'Henning', 'Einsatzbereit', '', '0', 'TH', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2420', NULL, '30353315', 'Handlampe Eismann EX', '', '1686162333', '90127', 'Mannschaft Hinten', '', '23.06.2022 - 16:32:58', '', '1', '29.06.2022 - 21:22:42', '1', '', '', '', 'Karsten Becker', 'Karsten', 'Einsatzbereit', '', '0', 'Beleuchtungsgerät', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2421', NULL, '05774799', 'Mehrgasmessgerät', '', '1686162333', '90127', 'Mannschaft Hinten', '', '23.06.2022 - 16:41:31', '', '1', '01.11.2022 - 15:53:38', '1', '', '', 'Dräger X-am 5000', 'Henning Zu Jeddeloh', 'Karsten', 'Einsatzbereit', '', '0', 'Atemschutz', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2422', NULL, '30352642', 'Rettungszylinder', '01.01.1999', '1686162333', '90127', '2', '', '23.06.2022 - 16:45:21', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'TH', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2423', NULL, '30352643', 'Rettungszylinder', '01.01.2002', '1686162333', '90127', '2', '', '23.06.2022 - 16:47:47', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'TH', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2424', NULL, '30353318', 'Handlampe Acculux', '', '1686162333', '90127', 'Mannschaft Hinten', '', '23.06.2022 - 16:48:28', '', '1', '29.06.2022 - 21:23:33', '1', '', '', '', 'Karsten Becker', 'Karsten', 'Einsatzbereit', '', '0', 'Beleuchtungsgerät', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2425', NULL, '30352639', 'Rettungszylinder', '12.11.2012', '1686162333', '90127', '2', '', '23.06.2022 - 16:49:14', '', '1', '', '1', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'TH', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2426', NULL, '1207', 'Schwellerschuhe', '', '1686162333', '90127', '2', '', '23.06.2022 - 16:53:35', '', '2', '', '2', '', '', '', '', 'Henning', 'Einsatzbereit', '', '0', 'TH', '', '', '', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2427', NULL, '1714', 'Funkgerät HRT', '', '1686162333', '90127', 'Mannschaft Hinten', '', '23.06.2022 - 16:53:42', '', '1', '07.07.2022 - 19:01:43', '1', '', '', 'FUG12-46-8-6', 'Karsten Becker', 'Karsten', 'Einsatzbereit', '', '0', 'Funk', '', '', '6227330', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2428', NULL, '1715', 'Funkgerät HRT', '', '1686162333', '90127', 'Mannschaft Hinten', '', '23.06.2022 - 16:57:17', '', '1', '07.07.2022 - 18:48:59', '1', '', '', 'FUG12-46-8-7', 'Karsten Becker', 'Karsten', 'Einsatzbereit', '', '0', 'Funk', '', '', '6227331', 'A2P', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2429', NULL, '1000', 'test a2p', '', '1686162333', '90126', '1', '', '1686163359', 'sdfsdf', '1', '', '1', '', '', 'test a2p', '', 'test&nbsp;test', 'Einsatzbereit', '', '0', 'Anschlagmittel', '', '', '', 'A2P', '', '1', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2430', NULL, '30360145', 'Steuerorgan', '', '1738368000', '90113', '4', '', '1686245497', '', '1', '', '1', '', '', 'DSO1252103', '', 'Jan Hendrik&nbsp;Friedrich', 'Einsatzbereit', '', '0', 'TH', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2431', NULL, '30360143', 'Hebekissenschlauch', '', '1738368000', '90113', '4', '', '1686245589', 'Schlauch für ND Kissen', '1', '', '1', '', '', '', '', 'Jan Hendrik&nbsp;Friedrich', 'Einsatzbereit', '', '0', 'TH', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2432', NULL, '30360144', 'Hebekissenschlauch', '', '1738368000', '90113', '4', '', '1686245666', 'Schlauch für ND Kissen', '1', '', '1', '', '', '', '', 'Jan Hendrik&nbsp;Friedrich', 'Einsatzbereit', '', '0', 'TH', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2433', NULL, '30360146', 'Druckminderer', '', '1738368000', '90113', '4', '', '1686245772', '', '1', '', '1', '', '', 'DM1252103', '', 'Jan Hendrik&nbsp;Friedrich', 'Einsatzbereit', '', '0', 'TH', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2434', NULL, '8010', 'Sandsäcke ungefüllt', '', '1704582000', '50001', '', '', '1704653834', '', '300', '02.08.2024 - 10:56:20', '404', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik&nbsp;Friedrich', 'Einsatzbereit', '', '0', '', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2435', NULL, '8011', 'Sandsäcke gefüllt', '', '1704582000', '50001', '', '', '1704653925', '', '200', '02.08.2024 - 10:56:46', '110', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik&nbsp;Friedrich', 'Einsatzbereit', '', '0', '', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2436', NULL, '4090', 'Schwimmsaugkorb', '', '1733526000', '90114', 'GR', '', '1706711679', 'RC Pumpe', '1', '25.08.2024 - 11:12:22', '1', '', '', 'RC 12-68-1-9', 'Jan Hendrik Friedrich', 'Jan Hendrik&nbsp;Friedrich', 'Einsatzbereit', '', '0', 'Wasserentnahme', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2437', NULL, '4091', 'Saugschlauch B', '', '1733526000', '90114', 'GR', '', '1706712105', 'RC Pumpe', '6', '25.08.2024 - 11:12:50', '6', '', '', 'RC 12-68-1-9', 'Jan Hendrik Friedrich', 'Jan Hendrik&nbsp;Friedrich', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2438', NULL, '30360956', 'Schwimmpumpe', '', '1733526000', '90114', 'GR', '', '1706712249', 'RC Pumpe', '1', '25.08.2024 - 11:13:09', '1', '', '', 'RC 12-68-1-9', 'Jan Hendrik Friedrich', 'Jan Hendrik&nbsp;Friedrich', 'Einsatzbereit', '', '0', 'Wasserentnahme', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2439', NULL, '4093', 'Allzweckpumpe', '', '1733526000', '90114', 'GR', '', '1706714311', 'RC Pumpe', '1', '25.08.2024 - 11:14:04', '1', '', '', 'RC 12-68-1-9', 'Jan Hendrik Friedrich', 'Jan Hendrik&nbsp;Friedrich', 'Einsatzbereit', '', '0', 'Wasserentnahme', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2440', NULL, '4094', 'Benzin Kanister 10l', '', '1733526000', '90114', 'GR', '', '1706715704', 'RC Pumpe', '1', '25.08.2024 - 11:15:02', '1', '', '', 'RC 12-68-1-9', 'Jan Hendrik Friedrich', 'Jan Hendrik&nbsp;Friedrich', 'Einsatzbereit', '', '0', 'Sonstiges', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2441', NULL, '4095', 'Ausgießer ', '', '1733526000', '90114', 'GR', '', '1706784322', 'RC Pumpe', '1', '25.08.2024 - 11:08:54', '1', '', '', 'RC 12-68-1-9', 'Jan Hendrik Friedrich', 'Jan Hendrik&nbsp;Friedrich', 'Einsatzbereit', '', '0', 'Sonstiges', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2442', NULL, '4096', 'Wathose', '', '1733526000', '90114', '8', '', '1706784680', 'RC Pumpe', '2', '25.08.2024 - 11:09:18', '2', '', '', 'RC 12-68-1-9', 'Jan Hendrik Friedrich', 'Jan Hendrik&nbsp;Friedrich', 'Einsatzbereit', '', '0', 'Schutzkleidung', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2443', NULL, '4097', 'Handschuhe kurze Stulpe', '', '1733526000', '90114', 'GR', '', '1706784894', 'RC Pumpe', '2', '25.08.2024 - 11:09:41', '2', '', '', 'RC 12-68-1-9', 'Jan Hendrik Friedrich', 'Jan Hendrik&nbsp;Friedrich', 'Einsatzbereit', '', '0', 'Schutzkleidung', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2444', NULL, '4098', 'Handschuhe lange Stulpe', '', '1733526000', '90114', 'GR', '', '1706785000', 'RC Pumpe', '2', '25.08.2024 - 11:10:16', '2', '', '', 'RC 12-68-1-9', 'Jan Hendrik Friedrich', 'Jan Hendrik&nbsp;Friedrich', 'Einsatzbereit', '', '0', 'Schutzkleidung', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2445', NULL, '4099', 'Ventilleine', '', '1733526000', '90114', 'GR', '', '1706785501', 'RC Pumpe', '2', '25.08.2024 - 11:10:40', '2', '', '', 'RC 12-68-1-9', 'Jan Hendrik Friedrich', 'Jan Hendrik&nbsp;Friedrich', 'Einsatzbereit', '', '0', 'Sonstiges', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2446', NULL, '4100', 'Halteleine', '0', '1733443200', '90114', 'GR', '', '1706785581', 'RC Pumpe', '4', '25.08.2024 - 11:10:56', '4', '', '', 'RC 12-68-1-9', 'Jan Hendrik Friedrich', 'Jan Hendrik&nbsp;Friedrich', 'Einsatzbereit', '', '0', 'Sonstiges', '', '', '', 'A2BZ', '123465', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2447', NULL, '4101', 'Saugkorb B', '', '1733526000', '90114', 'GR', '', '1706786186', 'RC Pumpe', '1', '25.08.2024 - 11:11:12', '1', '', '', 'RC 12-68-1-9', 'Jan Hendrik Friedrich', 'Jan Hendrik&nbsp;Friedrich', 'Einsatzbereit', '', '0', 'Wasserentnahme', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2448', NULL, '4102', 'Kupplungsschlüssel', '', '1733526000', '90114', 'GR', '', '1706786226', 'RC Pumpe', '2', '25.08.2024 - 11:11:31', '2', '', '', 'RC 12-68-1-9', 'Jan Hendrik Friedrich', 'Jan Hendrik&nbsp;Friedrich', 'Einsatzbereit', '', '0', 'Werkzeug', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2449', NULL, '4103', 'Absperrorgan B', '', '1733526000', '90114', 'GR', '', '1706786353', 'RC Pumpe', '2', '25.08.2024 - 11:11:47', '2', '', '', 'RC 12-68-1-9', 'Jan Hendrik Friedrich', 'Jan Hendrik&nbsp;Friedrich', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2450', NULL, '4104', 'Krümmer C 90°', '', '1733526000', '90114', 'GR', '', '1706786534', 'RC Pumpe', '1', '25.08.2024 - 11:13:25', '1', '', '', 'RC 12-68-1-9', 'Jan Hendrik Friedrich', 'Jan Hendrik&nbsp;Friedrich', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2451', NULL, '4105', 'Erdanker', '', '1733526000', '90114', 'GR', '', '1706786857', 'RC Pumpe', '3', '25.08.2024 - 11:13:44', '3', '', '', 'RC 12-68-1-9', 'Jan Hendrik Friedrich', 'Jan Hendrik&nbsp;Friedrich', 'Einsatzbereit', '', '0', 'Sonstiges', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2452', NULL, '4106', 'Krümmer B 90°', '', '1733526000', '90114', 'GR', '', '1707837456', 'RC Pumpe', '1', '25.08.2024 - 11:14:31', '1', '', '', 'RC 12-68-1-9', 'Jan Hendrik Friedrich', 'Jan Hendrik&nbsp;Friedrich', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2453', NULL, '30361659', 'Wathose', '', '1738368000', '90113', '6', '', '1714115851', '', '1', '', '1', '', '', '', '', 'Jan Hendrik&nbsp;Friedrich', 'Einsatzbereit', '', '0', 'Schutzkleidung', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2454', NULL, '8522', 'CO2 Löscher 2kg', '', '1716328800', '50001', '', '', '1716361425', '2kg', '1', '23.05.2024 - 10:25:22', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik&nbsp;Friedrich', 'Einsatzbereit', '', '0', 'Feuerlöscher', '', '', '', 'A2BZ', '', '24', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2455', NULL, '8523', 'CO2 Löscher 2kg', '', '1716328800', '50001', '', '', '1716361459', '2kg', '1', '23.05.2024 - 10:25:35', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik&nbsp;Friedrich', 'Einsatzbereit', '', '0', 'Feuerlöscher', '', '', '', 'A2BZ', '', '24', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2456', NULL, '---1', 'Wärmebildkamera', '', '1725832800', '90120', 'Mannschaft Vorne', '', '1717163150', 'Typ:FLIR K33', '1', '', '1', '', '', 'WBK1243401', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Elektro', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2457', NULL, '---2', 'Gasmessgerät', '', '1725832800', '90120', 'Mannschaft Vorne', '', '1717163340', 'CO Warner\r\nan Gruppenführerweste', '1', '', '1', '', '', 'MEß1243401', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Gefahrgut', '', '', '', 'A2E', '', '6', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2458', NULL, '---3', 'Atemschutzüberwachungstafel', '', '1725832800', '90120', 'Mannschaft Vorne', '', '1717163467', 'Typ:Regis300', '1', '', '1', '', '', 'ÜWT1243401', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Elektro', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2459', NULL, '30358100', 'Handlampe Adalit ', '', '1725832800', '90120', 'Mannschaft Vorne', '', '1717163669', '', '1', '10.09.2024 - 07:49:58', '1', '', '', 'HSW1243401', 'Florian Oltmer', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Handlampe', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2460', NULL, '30358099', 'Handlampe Adalit ', '', '1725832800', '90120', 'Mannschaft Vorne', '', '1717163744', '', '1', '', '1', '', '', 'HSW1243402', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Handlampe', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2461', NULL, '30358102', 'Handlampe Adalit ', '', '1725832800', '90120', 'Mannschaft Hinten', '', '1717163875', '', '1', '', '1', '', '', 'HSW1243403', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Handlampe', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2462', NULL, '30358101', 'Handlampe Adalit ', '', '1725832800', '90120', 'Mannschaft Hinten', '', '1717163959', '', '1', '', '1', '', '', 'HSW1243404', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Handlampe', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2463', NULL, 'Tei:000190014208820', 'Funkgerät HRT', '', '1725832800', '90120', 'Mannschaft Vorne', '', '1717164497', '', '1', '', '1', '', '', 'HRT1243401', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Funk', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2464', NULL, 'Tei:000190333956380', 'Funkgerät HRT', '', '1725832800', '90120', 'Mannschaft Vorne', 'STP9038', '1717164590', '', '1', '', '1', '', '', 'HRT1243402', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Funk', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2465', NULL, 'Tei:000190366255180', 'Funkgerät HRT', '', '1725832800', '90120', 'Mannschaft Hinten', 'STP9038', '1717164687', 'Angriffstrupp 308*', '1', '', '1', '', '', 'HRT1243403', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Funk', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2466', NULL, 'Tei:000190366247680', 'Funkgerät HRT', '', '1725832800', '90120', 'Mannschaft Hinten', 'STP9038', '1717164769', 'Wassertrupp 308*', '1', '', '1', '', '', 'HRT1243404', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Funk', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2467', NULL, '30358104', 'Winkerkelle', '', '1725832800', '90120', 'Mannschaft Vorne', '', '1717164992', '', '1', '', '1', '', '', 'WK1243402', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Funk', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2468', NULL, '30358103', 'Winkerkelle', '', '1725832800', '90120', 'Mannschaft Vorne', '', '1717165051', '', '1', '', '1', '', '', 'WK1243401', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Elektro', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2469', NULL, '30358105', 'Winkerkelle', '', '1725832800', '90120', 'Mannschaft Vorne', '', '1717165099', '', '1', '', '1', '', '', 'WK1243403', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Elektro', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2470', NULL, '---4', 'Ipad', '', '1725832800', '90120', 'Mannschaft Vorne', '', '1717165213', 'Einsatz Ipad', '1', '', '1', '', '', 'IPAD1243401', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Elektro', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2471', NULL, '---5', 'Tragetuch', '', '1725832800', '90120', 'Mannschaft Hinten', '', '1717166301', 'Sitzbank Hinten', '1', '', '1', '', '', 'Rett2401', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Rettungsgerät', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2472', NULL, '---6', 'Werkzeugkasten', '', '1725832800', '90120', 'Mannschaft Hinten', '', '1717166400', 'Norm Werkzeugkasten \r\nM\r\n', '1', '', '1', '', '', '', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Werkzeug', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2473', NULL, '30360643', 'Megaphone', '', '1725832800', '90120', 'Mannschaft Hinten', '', '1717166651', '', '1', '', '1', '', '', 'MPH1243401', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Elektro', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2474', NULL, '30351006', 'Verbandkasten Fw', '', '1725832800', '90120', 'Mannschaft Hinten', 'Bis 06/25', '1717166819', '', '1', '', '1', '', '', 'SAN1243401', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Sanitätsgerät', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2475', NULL, '30348839', 'Schnittschutzhose', '', '1725832800', '90120', 'Mannschaft Hinten', '', '1717166919', 'Sitzbank Hinten', '1', '', '1', '', '', 'SCHN2401', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Schutzkleidung', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2476', NULL, '30348789', 'Solarblitz', '', '1725832800', '90120', 'Mannschaft Hinten', '', '1717166983', '', '1', '', '1', '', '', 'BLI1243401', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Elektro', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2477', NULL, '30348786', 'Solarblitz', '', '1725832800', '90120', 'Mannschaft Hinten', '', '1717167054', '', '1', '', '1', '', '', 'BLI1243402', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Elektro', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2478', NULL, '30358369', 'Solarblitz', '', '1725832800', '90120', 'Mannschaft Hinten', '', '1717167098', '', '1', '', '1', '', '', 'BLI1243403', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Elektro', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2479', NULL, '---7', 'Hitzeschutz', '', '1725832800', '90120', 'Mannschaft Hinten', '', '1717167175', 'Hitzeschutzhandschuhe', '1', '', '1', '', '', 'HIZ2402', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Schutzkleidung', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2480', NULL, '30360644', 'Warnlampe', '', '1725832800', '90120', 'Mannschaft Hinten', '', '1717167228', '', '1', '', '1', '', '', 'WARN1243401', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Elektro', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2481', NULL, '---8', 'Bügelsäge', '', '1725832800', '90120', 'Mannschaft Hinten', '', '1717167369', 'Metall', '1', '', '1', '', '', '', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Werkzeug', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2482', NULL, '---9', 'Bolzenschneider', '', '1725832800', '90120', 'Mannschaft Hinten', '', '1717167413', '', '1', '', '1', '', '', '', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Werkzeug', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2483', NULL, '30359520', 'Krankentrage', '', '1725832800', '90120', 'Mannschaft Hinten', '', '1717167493', 'Norm Feuerwehr Krankentrage ', '1', '', '1', '', '', 'KT1243401', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Rettungsgerät', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2484', NULL, '30361057', 'Akku Schrauber', '', '1725832800', '90120', 'Mannschaft Hinten', 'DHP485', '1717167724', '', '1', '', '1', '', '', 'SCHR1243401', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Elektro', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2485', NULL, '--10', 'Türöffnung', '', '1725832800', '90120', 'Mannschaft Hinten', '', '1717426563', 'Multi Zetter', '1', '', '1', '', '', 'TÜ1243401', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Werkzeug', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2486', NULL, 'FWAxt', 'Feuerwehraxt', '', '1725832800', '90120', '1', '', '1717426694', '', '2', '', '2', '', '', 'FwAxt1243401', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Arbeitsgerät', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2487', NULL, '--11', 'TS8/8', '', '1725832800', '90120', '1', 'Ziegler Utralpower ', '1717426889', '', '1', '', '1', '', '', 'TS12434', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Sondergerät', '', '', '', 'A2E', '', '6', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2488', NULL, '--12', 'Standrohr', '', '1725832800', '90120', '1', '', '1717426972', 'Standrohr+Schlüssel', '1', '', '1', '', '', 'WA1243401', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Wasserentnahme', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2489', NULL, '30348838', 'Motorkettensäge', '', '1725832800', '90120', '2', 'Stihl', '1717427131', '', '1', '', '1', '', '', 'MA12434', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Sondergerät', '', '', '', 'A2E', '', '6', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2490', NULL, '--13', 'Schnittschutzhose', '', '1725832800', '90120', '2', '', '1717427228', '', '1', '', '1', '', '', 'SCHN2402', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Schutzkleidung', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2491', NULL, '30348894', 'Forsthelm', '', '1725832800', '90120', '2', '', '1717427317', '', '1', '', '1', '', '', 'WAH1243401', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Schutzkleidung', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2492', NULL, '30346894', 'Forsthelm', '', '1725832800', '90120', '2', '', '1717427362', '', '1', '', '1', '', '', 'WAH1243402', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Schutzkleidung', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2493', NULL, '30348893', 'Kombi Kanister', '', '1725832800', '90120', '2', '', '1717427441', '', '1', '', '1', '', '', 'KOMBI1243401', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Dieselkanister', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2494', NULL, '--14', 'Stativ ', '', '1725832800', '90120', '2', '', '1717439415', '', '1', '', '1', '', '', 'ST1243401', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Sondergerät', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2495', NULL, '--15', 'Abgasschlauch klein', '', '1725832800', '90120', '2', '', '1717439535', '1xStromerzeuger\r\n1xTS', '2', '', '2', '', '', 'ABGA12434', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Sonstiges', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2496', NULL, '30348782', 'Strahler mit Tragegestell', '', '1725832800', '90120', '2', '', '1717439713', '', '1', '', '1', '', '', 'STRA1243401', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Beleuchtungsgerät', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2497', NULL, '30348783', 'Strahler mit Tragegestell', '', '1725832800', '90120', '2', '', '1717439757', '', '1', '', '1', '', '', 'STRA1243402', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Beleuchtungsgerät', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2498', NULL, '30348784', 'Stromerzeuger', '', '1725832800', '90120', '2', '', '1717439877', '', '1', '10.09.2024 - 07:48:48', '1', '', '', 'NEA12434', 'Florian Oltmer', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Elektro', '', '', '', 'A2E', '', '6', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2499', NULL, '30348802', 'Kabeltrommel 230V', '', '1725832800', '90120', '2', '50m', '1717439998', '', '1', '', '1', '', '', 'KAB1243401', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Elektro', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2500', NULL, '30348803', 'Kabeltrommel 230V', '', '1725832800', '90120', '2', '50m', '1717440071', '', '1', '', '1', '', '', 'KAB1243402', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Elektro', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2501', NULL, '--16', 'Schaummittel', '', '1725832800', '90120', '2', '20L Kanister', '1717440144', '', '3', '', '3', '', '', 'Schaum12434', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Sonstiges', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2502', NULL, '--17', 'Stützkrümmer B', '', '1725832800', '90120', '3', '', '1717440239', '', '1', '', '1', '', '', 'WA1243402', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Wasserabgabe', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2503', NULL, '--18', 'Mehrzweckstrahlrohr C', '', '1725832800', '90120', '3', '', '1717440287', '', '3', '', '3', '', '', 'WA1243403', '', 'Florian&nbsp;Oltmer', '', '', '0', 'Wasserabgabe', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2504', NULL, '--19', 'Mehrzweckstrahlrohr D', '', '1725832800', '90120', '3', '', '1717440335', '', '1', '', '1', '', '', 'WA1243404', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Wasserabgabe', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2505', NULL, '--20', 'Hohlstrahlrohr C', '', '1725832800', '90120', '3', '', '1717440383', '', '1', '', '1', '', '', 'WA1243405', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Wasserabgabe', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2506', NULL, '--21', 'Hohlstrahlrohr B', '', '1725832800', '90120', '3', '', '1717440431', '', '1', '', '1', '', '', 'WA1243406', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Wasserabgabe', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2507', NULL, '--22', 'Verteiler', '', '1725832800', '90120', '3', '', '1717440499', '', '1', '', '1', '', '', 'WA1243407', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2508', NULL, '--23', 'Druckbegrenzungsventil', '', '1725832800', '90120', '3', '', '1717440549', '', '1', '', '1', '', '', 'WA1243408', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2509', NULL, '--24', 'Systemtrenner', '', '1725832800', '90120', '3', '', '1717440609', '', '1', '', '1', '', '', 'WA1243409', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2510', NULL, '--25', 'Übergangsstück C-B', '', '1725832800', '90120', '3', '', '1717440698', '', '1', '', '1', '', '', 'WA1243410', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2511', NULL, '--26', 'Mulde', '', '1725832800', '90120', '3', '', '1717440742', '', '1', '', '1', '', '', 'MUL12434', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', '', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2512', NULL, '--27', 'WagenTS', '', '1725832800', '90120', '3', '', '1717440831', '', '1', '', '1', '', '', 'WATS12434', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Sonstiges', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2513', NULL, '--28', 'Atemschutznotfalltasche', '', '1693519200', '90120', '3', '', '1717440932', '', '1', '', '1', '', '', 'ATNO12434', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Atemschutz', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2514', NULL, '--29', 'Halligan-Tool', '', '1725832800', '90120', '3', '', '1717440987', '', '1', '', '1', '', '', 'HALL12434', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Werkzeug', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2515', NULL, '--30', 'Spalthammer', '', '1725832800', '90120', '3', '', '1717441032', 'Kunstoffgriff', '1', '', '1', '', '', 'SPH12434', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Werkzeug', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2516', NULL, '--31', 'Zumischer Z2', '', '1725832800', '90120', '4', '', '1717441085', '', '1', '', '1', '', '', 'WA1243411', '', 'Florian&nbsp;Oltmer', '', '', '0', 'Wasserführend', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2517', NULL, '--32', 'Schwerschaumrohr S4', '', '1725832800', '90120', '4', '', '1717441126', '', '1', '', '1', '', '', 'WA1243412', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Wasserabgabe', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2518', NULL, '--33', 'Schlauchtragekorb C', '', '1725832800', '90120', '4', '', '1717441182', '', '3', '', '3', '', '', 'WA1243413', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2519', NULL, '--34', 'Schlauchpaket', '', '1725832800', '90120', '4', '', '1717441246', '', '1', '', '1', '', '', 'WA1243414', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2520', NULL, '--35', 'Übergangsstück C-B', '', '1725832800', '90120', '4', '', '1717441304', '', '2', '', '2', '', '', 'WA1243415', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2521', NULL, '30359575', 'Tauchpumpe TP8', '', '1725832800', '90120', '4', 'Spechtenhauser', '1717441442', '', '1', '', '1', '', '', 'TP12434', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Wasserentnahme', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2522', NULL, '--36', 'Verkehrsleitkegel', '', '1725832800', '90120', '4', '', '1717441595', '', '4', '', '4', '', '', 'VK12434', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Verkehrsabsicherung', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2523', NULL, '--37', 'Druckschlauch B', '', '1725832800', '90120', '', '', '1717441697', '', '15', '', '15', '', '', 'BSCH', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2E', '', '48', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2524', NULL, '--38', 'Druckschlauch C', '', '1725832800', '90120', '', '', '1717441750', '', '8', '', '8', '', '', 'CSCH12434', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2E', '', '48', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2525', NULL, '--39', 'Druckschlauch B 5m', '', '1725832800', '90120', '', '', '1717441800', '', '1', '', '1', '', '', 'B5SCH12434', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2E', '', '48', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2526', NULL, '30357247', 'Saugschlauch', '', '1725832800', '90120', 'GR', '', '1717441906', '', '1', '09.09.2024 - 17:25:58', '1', '', '', 'SAUG1243401', 'Florian Oltmer', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Wasserentnahme', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2527', NULL, '30357248', 'Saugschlauch', '', '1725832800', '90120', 'GR', 'A-Saugschlauch', '1717441961', '', '1', '', '1', '', '', 'SAUG1243402', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Wasserentnahme', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2528', NULL, '30357246', 'Saugschlauch', '', '1725832800', '90120', 'GR', 'A-Saugschlauch', '1717442002', '', '1', '', '1', '', '', 'SAUG1243403', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Wasserentnahme', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2529', NULL, '30357244', 'Saugschlauch', '', '1725832800', '90120', 'GR', 'A-Saugschlauch', '1717442057', '', '1', '', '1', '', '', 'SAUG1243404', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Wasserentnahme', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2530', NULL, '30357245', 'Saugschlauch', '', '1725832800', '90120', 'GR', 'A-Saugschlauch', '1717442099', '', '1', '', '1', '', '', 'SAUG1243405', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Wasserentnahme', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2531', NULL, '30357243', 'Saugschlauch', '', '1725832800', '90120', 'GR', 'A-Saugschlauch', '1717442150', '', '1', '', '1', '', '', 'SAUG1243406', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Wasserentnahme', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2532', NULL, '--40', 'Flachsaugkorb', '', '1725832800', '90120', 'GR', '', '1717775716', '', '1', '', '1', '', '', 'WA1243416', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', '', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2533', NULL, '--41', 'Ventilleine', '', '1693519200', '0', 'GR', 'Ventilleine', '1717776123', '', '1', '', '1', '', '', 'LEI1243409', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Anschlagmittel', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2534', NULL, '30348843', 'Halteleine', '', '1725832800', '90120', '', '', '1717776210', '', '1', '', '1', '', '', 'LEI1243401', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Feuerwehrleine', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2535', NULL, '30348842', 'Halteleine', '', '1725832800', '90120', '', '', '1717776244', '', '1', '07.06.2024 - 18:31:43', '1', '', '', 'LEI1243402', 'Florian Oltmer', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '2348929909', '0', 'Feuerwehrleine', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2536', NULL, '30348844', 'Halteleine', '', '1725832800', '90120', '', '', '1717777309', 'test', '', '09.09.2024 - 17:14:23', '', '', '', 'LEI1243403', 'Manuel Arntjen', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '2357046867', '0', 'Feuerwehrleine', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2537', NULL, '303430348845', 'Halteleine', '', '1725832800', '90120', '', '', '1717777365', '', '1', '07.06.2024 - 18:32:27', '1', '', '', 'LEI1243404', 'Florian Oltmer', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '2348929954', '0', 'Feuerwehrleine', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2538', NULL, '30348841', 'Halteleine', '', '1725832800', '90120', '', '', '1717777422', '', '1', '', '1', '', '', 'LEI1243405', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Feuerwehrleine', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2539', NULL, '30348846', 'Halteleine', '', '1725832800', '90120', '', '', '1717777462', '', '1', '', '1', '', '', 'LEI1243406', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Feuerwehrleine', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2540', NULL, '30348840', 'Halteleine', '', '1725832800', '90120', '', '', '1717777543', '', '1', '', '1', '', '', 'LEI1243407', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Feuerwehrleine', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2541', NULL, '30348847', 'Halteleine', '', '1725832800', '90120', '', '', '1717777577', '', '1', '10.09.2024 - 07:48:37', '1', '', '', 'LEI1243407', 'Florian Oltmer', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '2357099321', '0', 'Feuerwehrleine', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2542', NULL, '30355380', 'Steckleiterteil', '', '1725832800', '90120', 'Dach', '', '1717778057', '', '1', '', '1', '', '', 'LEITER1243401', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Leitern', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2543', NULL, '30355379', 'Steckleiterteil', '', '1725832800', '90120', 'Dach', '', '1717778096', '', '1', '10.09.2024 - 07:49:49', '1', '', '', 'LEITER1243402', 'Florian Oltmer', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Leitern', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2544', NULL, '30355378', 'Steckleiterteil', '', '1725832800', '90120', 'Dach', '', '1717778136', '', '1', '', '1', '', '', 'LEITER1243403', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Leitern', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2545', NULL, '30355377', 'Steckleiterteil', '', '1725832800', '90120', 'Dach', '', '1717778187', '', '1', '', '1', '', '', 'LEITER1243404', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Leitern', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2546', NULL, '30355376', 'Steckleiter-Verbindungsteil ', '', '1725832800', '90120', 'Dach', '', '1717778232', '', '1', '', '1', '', '', 'LEITER1243405', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Leitern', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2547', NULL, '30355361', 'Einreißhaken', '', '1725832800', '90120', 'Dach', '', '1717778295', '', '1', '', '1', '', '', 'ERH12434', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Sonstiges', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2548', NULL, '--42', 'Kupplungsschlüssel', '', '1725832800', '90120', 'GR', '', '1717779868', '', '2', '', '2', '', '', 'Kup12434', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Sonstiges', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2549', NULL, '--43', 'Übergangsstück A-B', '', '1725832800', '90120', 'GR', '', '1717779926', '', '1', '', '1', '', '', 'Über12434', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Sonstiges', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2550', NULL, '--44', 'Saugschutzkorb', '', '1725832800', '90120', 'GR', '', '1717780014', '', '1', '', '1', '', '', 'SK1243401', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Wasserentnahme', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2551', NULL, '--45', 'Schaufel', '', '1725832800', '90120', 'GR', '', '1717780071', '', '1', '', '1', '', '', 'SCH1243401', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Sonstiges', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2552', NULL, '30348194', 'Schleifkorbtrage', '', '1725832800', '90120', 'Dach', '', '1717780239', '', '1', '', '1', '', '', 'RETT2402', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Rettungsgerät', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2553', NULL, '--46', 'Spaten', '', '1725832800', '90120', 'Dach', '', '1717780372', '', '1', '', '1', '', '', 'HW1243402', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Sonstiges', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2554', NULL, '--47', 'Stoßbesen', '', '1725832800', '90120', 'Dach', '', '1717780412', '', '1', '', '1', '', '', 'HW1243403', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Sonstiges', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2555', NULL, '--48', 'Dunggabel', '', '1725832800', '90120', 'Dach', '', '1717780442', '', '1', '', '1', '', '', 'HW1243404', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Sonstiges', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2556', NULL, '--49', 'Schlauchbrücke', '', '1725832800', '90120', 'Dach', '', '1717780496', '', '3', '', '3', '', '', 'WA1243416', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Wasserführend', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2557', NULL, '123456789', 'Lieferschein Barcode', '', '1704063600', '50001', '', '', '1725204798', '', '1', '01.09.2024 - 17:34:36', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik&nbsp;Friedrich', 'Bedingt Einsatzbereit', '', '0', 'Sonstiges', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2558', NULL, '99999', 'TEST', '1725906180', '1725832800', '50008', '1', '', '1725894990', 'TEST', '1', '10.09.2024 - 09:51:07', '1', '', '10.09.2024', 'TEST', 'Florian Oltmer', 'Florian&nbsp;Oltmer', 'Ausgesondert', '', '0', 'Anschlagmittel', '', '', '', 'A2E', '', '1', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2559', NULL, '1PSJ01820G790TE', 'Funkgerät MRT', '', '1722463200', '90121', 'Mannschaft Vorne', 'Sepura SRG 3900', '1725947028', 'MRT', '1', '', '1', '', '', 'FUG12-17-4', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Funk', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2560', NULL, '2393824597', 'Funkgerät HRT', '', '1720994400', '90121', 'Mannschaft Vorne', 'Sepura STP9000', '1725947116', 'HRT mit Sprechganitur', '1', '', '1', '', '', 'FUG12-17-4-1', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Funk', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2561', NULL, '30350477', 'Anhaltestab', '', '1720994400', '90121', 'Mannschaft Vorne', '', '1725947193', '', '1', '10.09.2024 - 09:50:48', '1', '', '', 'WK1217401', 'Florian Oltmer', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Elektro', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2562', NULL, '30359288', 'Einspeisekabel', '', '1720994400', '90121', 'Mannschaft Vorne', '', '1725947245', '', '1', '', '1', '', '', 'SPK1217401', '', 'Florian&nbsp;Oltmer', 'Einsatzbereit', '', '0', 'Elektro', '', '', '', 'A2E', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2563', NULL, '1147', 'Einsatztablet iPad', '0', '1737504000', '90111', 'Mannschaft Vorne', '', '1732218925', '', '1', '21.11.2024 - 20:57:38', '1', '', '', '', 'Thede Meischen', 'Thede&nbsp;Meischen', 'Einsatzbereit', '', '0', 'EDV', '', '', '', 'A2BZ', '', '1', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2564', NULL, '30363167', 'Handlampe Adalit 	', '', '1733526000', '90114', 'Mannschaft Hinten', '', '1733846716', '', '1', '', '1', '', '', '', '', 'Jan Hendrik&nbsp;Friedrich', 'Einsatzbereit', '', '0', 'Handlampe', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2565', NULL, '30363165', 'Handlampe Adalit', '', '1733526000', '90114', 'Mannschaft Hinten', '', '1733846783', '', '1', '', '1', '', '1733007600', '', '', 'Jan Hendrik&nbsp;Friedrich', 'Einsatzbereit', '', '0', 'Handlampe', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2566', NULL, '30363164', 'Handlampe Adalit 	', '', '1733526000', '90114', 'Mannschaft Hinten', '', '1733847055', '', '1', '', '1', '', '', '', '', 'Jan Hendrik&nbsp;Friedrich', 'Einsatzbereit', '', '0', 'Handlampe', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2567', NULL, '30363166', 'Handlampe Adalit', '', '1733526000', '90114', 'Mannschaft Hinten', '', '1733847131', '', '1', '', '1', '', '', '', '', 'Jan Hendrik&nbsp;Friedrich', 'Einsatzbereit', '', '0', 'Handlampe', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2568', NULL, '30363168', 'Handlampe Adalit', '', '1733526000', '90114', 'Mannschaft Hinten', '', '1733847181', '', '1', '', '1', '', '', '', '', 'Jan Hendrik&nbsp;Friedrich', 'Einsatzbereit', '', '0', 'Handlampe', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2569', NULL, '30363169', 'Handlampe Adalit', '', '1733526000', '90114', 'Mannschaft Hinten', '', '1733847873', '', '1', '', '1', '', '', '', '', 'Jan Hendrik&nbsp;Friedrich', 'Einsatzbereit', '', '0', 'Handlampe', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');
INSERT INTO `ffw_geraete` VALUES ('2570', NULL, '2138', 'Sichtschutzwand', '1735689600', '1738368000', '90113', 'GR', '', '1740484512', '+ Zubehör', '1', '25.02.2025 - 12:55:29', '1', '', '', '', 'Jan Hendrik Friedrich', 'Jan Hendrik&nbsp;Friedrich', 'Einsatzbereit', '', '0', 'TH', '', '', '', 'A2BZ', '', '12', '', '', '0', '', '', '');


DROP TABLE IF EXISTS `gemeinden`;
CREATE TABLE `gemeinden` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `landkreis_id` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `landkreis_id` (`landkreis_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `gemeinden` VALUES ('1', 'Gemeinde Bad Zwischenahn', '1');


DROP TABLE IF EXISTS `geraete_kommentare`;
CREATE TABLE `geraete_kommentare` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `barcode` varchar(255) NOT NULL,
  `benutzer` varchar(100) NOT NULL,
  `kommentar` text NOT NULL,
  `zeitstempel` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `geraete_kommentare` VALUES ('1', '6026', ' ', 'test', '2025-04-18 20:54:33');
INSERT INTO `geraete_kommentare` VALUES ('2', '6026', ' ', 'test2', '2025-04-18 21:15:45');
INSERT INTO `geraete_kommentare` VALUES ('3', '6026', ' ', 'test', '2025-04-20 13:59:23');
INSERT INTO `geraete_kommentare` VALUES ('4', '6026', ' ', 'test', '2025-04-20 14:00:11');
INSERT INTO `geraete_kommentare` VALUES ('5', '1020', ' ', 'Brauchste unbedingt', '2025-04-20 14:06:44');
INSERT INTO `geraete_kommentare` VALUES ('6', '1020', ' ', 'Brauchste unbedingt', '2025-04-20 14:08:28');
INSERT INTO `geraete_kommentare` VALUES ('7', '1020', ' ', 'Test', '2025-04-20 14:08:35');
INSERT INTO `geraete_kommentare` VALUES ('8', '1020', ' ', 'test', '2025-04-20 14:10:44');
INSERT INTO `geraete_kommentare` VALUES ('9', '1020', 'Unbekannt', 'teasd', '2025-04-20 14:11:40');
INSERT INTO `geraete_kommentare` VALUES ('10', '1020', 'Nils Bonk', 'blaa', '2025-04-20 14:12:50');
INSERT INTO `geraete_kommentare` VALUES ('11', '1020', 'Unbekannt', 'Mega ding', '2025-04-20 14:15:48');
INSERT INTO `geraete_kommentare` VALUES ('12', '2138', 'Nils Bonk', 'Gutes ding', '2025-04-20 21:02:51');
INSERT INTO `geraete_kommentare` VALUES ('13', '1020', 'Nils Bonk', 'asd', '2025-05-01 21:35:55');
INSERT INTO `geraete_kommentare` VALUES ('14', '1020', 'Nils Bonk', 'asd', '2025-05-02 14:30:31');
INSERT INTO `geraete_kommentare` VALUES ('15', '1020', 'Nils Bonk', 'asd', '2025-05-03 13:05:38');


DROP TABLE IF EXISTS `geraete_log`;
CREATE TABLE `geraete_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `barcode` varchar(255) NOT NULL,
  `benutzer` varchar(100) NOT NULL,
  `aktion` text NOT NULL,
  `zeitstempel` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=36 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `geraete_log` VALUES ('1', '6026', ' ', 'Gerät bearbeitet (Status: Einsatzbereit, GR: GR)', '2025-04-18 20:52:40');
INSERT INTO `geraete_log` VALUES ('2', '6026', ' ', 'Gerät bearbeitet (Status: Einsatzbereit, GR: GR)', '2025-04-18 20:54:50');
INSERT INTO `geraete_log` VALUES ('3', '1020', ' ', 'Gerät bearbeitet (Status: Einsatzbereit, GR: )', '2025-04-18 21:01:08');
INSERT INTO `geraete_log` VALUES ('4', '1020', ' ', 'Gerät bearbeitet (Status: Einsatzbereit, GR: 2)', '2025-04-18 21:01:19');
INSERT INTO `geraete_log` VALUES ('5', '1020', ' ', 'Gerät bearbeitet (Status: Einsatzbereit, GR: 2)', '2025-04-18 21:01:28');
INSERT INTO `geraete_log` VALUES ('6', '1020', ' ', 'Gerät bearbeitet (Status: Einsatzbereit, GR: 2)', '2025-04-18 21:01:42');
INSERT INTO `geraete_log` VALUES ('7', '6026', ' ', 'Gerät bearbeitet (Status: Einsatzbereit, GR: GR, Intervall: 12 Monate)', '2025-04-18 21:07:49');
INSERT INTO `geraete_log` VALUES ('8', '6026', ' ', 'Gerät bearbeitet (Status: Einsatzbereit, GR: GR, Intervall: 12 Monate)', '2025-04-18 21:11:51');
INSERT INTO `geraete_log` VALUES ('9', '6026', ' ', 'Gerät bearbeitet (Status: Einsatzbereit, GR: GR, Intervall: 12 Monate)', '2025-04-18 21:15:58');
INSERT INTO `geraete_log` VALUES ('10', '6026', ' ', 'Gerät bearbeitet (Status: Einsatzbereit, GR: GR, Intervall: 12 Monate)', '2025-04-18 21:18:33');
INSERT INTO `geraete_log` VALUES ('11', '1020', ' ', 'Gerät bearbeitet (Status: Einsatzbereit, GR: 2, Intervall: 12 Monate)', '2025-04-18 21:19:11');
INSERT INTO `geraete_log` VALUES ('12', '1020', ' ', 'Gerät bearbeitet (Status: Einsatzbereit, GR: 2, Intervall: 12 Monate)', '2025-04-18 21:24:05');
INSERT INTO `geraete_log` VALUES ('13', '1020', ' ', 'Gerät bearbeitet (Status: Einsatzbereit, GR: 2, Intervall: 12 Monate)', '2025-04-18 21:24:10');
INSERT INTO `geraete_log` VALUES ('14', '1020', ' ', 'Gerät bearbeitet (Status: Einsatzbereit, GR: 2, Intervall: 12 Monate)', '2025-04-18 21:24:22');
INSERT INTO `geraete_log` VALUES ('15', '60009', ' ', 'Gerät bearbeitet (Status: Einsatzbereit, GR: 1, Intervall: 1 Monate)', '2025-04-18 21:35:28');
INSERT INTO `geraete_log` VALUES ('16', '60009', ' ', 'Gerät bearbeitet (Status: Einsatzbereit, GR: 1, Intervall: 1 Monate)', '2025-04-18 21:35:54');
INSERT INTO `geraete_log` VALUES ('17', '1020', ' ', 'Gerät bearbeitet (Status: Einsatzbereit, GR: 2, Intervall: 12 Monate)', '2025-04-18 21:44:01');
INSERT INTO `geraete_log` VALUES ('18', '60009', ' ', 'Gerät bearbeitet (Status: Einsatzbereit, GR: 1, Intervall: 1 Monate)', '2025-04-18 21:55:30');
INSERT INTO `geraete_log` VALUES ('19', '1147', ' ', 'Gerät bearbeitet (Status: Einsatzbereit, GR: Mannschaft Vorne, Intervall: 1 Monate)', '2025-04-18 22:00:32');
INSERT INTO `geraete_log` VALUES ('20', '1020', ' ', 'Gerät bearbeitet (Status: Einsatzbereit, GR: 2, Intervall: 12 Monate)', '2025-04-19 10:49:22');
INSERT INTO `geraete_log` VALUES ('21', '1020', ' ', 'Gerät bearbeitet (Status: Einsatzbereit, GR: 2, Intervall: 12 Monate)', '2025-04-19 10:56:15');
INSERT INTO `geraete_log` VALUES ('22', '1020', ' ', 'Gerät bearbeitet (Status: Einsatzbereit, GR: 2, Intervall: 12 Monate)', '2025-04-19 10:56:36');
INSERT INTO `geraete_log` VALUES ('23', '6026', ' ', 'Gerät bearbeitet (Status: Bedingt Einsatzbereit, GR: GR, Intervall: 12 Monate)', '2025-04-20 14:00:28');
INSERT INTO `geraete_log` VALUES ('24', '6026', ' ', 'Gerät bearbeitet (Status: Bedingt Einsatzbereit, GR: GR, Intervall: 12 Monate)', '2025-04-20 14:00:41');
INSERT INTO `geraete_log` VALUES ('25', '1020', 'Nils Bonk', 'Gerät bearbeitet (Status: Einsatzbereit, GR: 2, Intervall: 12 Monate)', '2025-04-20 14:13:45');
INSERT INTO `geraete_log` VALUES ('26', '1020', 'Unbekannt', 'Gerät bearbeitet (Status: Einsatzbereit, GR: 2, Intervall: 12 Monate)', '2025-04-20 14:15:43');
INSERT INTO `geraete_log` VALUES ('27', '4100', 'Nils Bonk', 'Gerät bearbeitet (Status: Einsatzbereit, GR: GR, Intervall: 12 Monate)', '2025-04-20 21:01:49');
INSERT INTO `geraete_log` VALUES ('28', '2138', 'Nils Bonk', 'Gerät bearbeitet (Status: Einsatzbereit, GR: GR, Intervall: 12 Monate)', '2025-04-20 21:02:20');
INSERT INTO `geraete_log` VALUES ('29', '1020', 'Nils Bonk', 'Gerät bearbeitet (Status: Einsatzbereit, GR: 2, Intervall: 12 Monate)', '2025-05-02 14:33:38');
INSERT INTO `geraete_log` VALUES ('30', '1020', 'Nils Bonk', 'Gerät bearbeitet (Status: Einsatzbereit, GR: 2, Intervall: 12 Monate)', '2025-05-02 14:35:31');
INSERT INTO `geraete_log` VALUES ('31', '61000', 'Nils Bonk', 'Gerät bearbeitet (Status: Einsatzbereit, GR: 1, Intervall: 1 Monate)', '2025-05-03 13:25:55');
INSERT INTO `geraete_log` VALUES ('32', '60001', 'Nils Bonk', 'Gerät bearbeitet (Status: Einsatzbereit, GR: 1, Intervall: 1 Monate)', '2025-05-03 13:27:33');
INSERT INTO `geraete_log` VALUES ('33', '61000', 'Nils Bonk', 'Gerät bearbeitet (Status: Einsatzbereit, GR: 1, Intervall: 1 Monate)', '2025-05-03 20:46:47');
INSERT INTO `geraete_log` VALUES ('34', '60003', 'Nils Bonk', 'Gerät bearbeitet (Status: Einsatzbereit, GR: 1, Intervall: 1 Monate)', '2025-05-03 20:46:54');
INSERT INTO `geraete_log` VALUES ('35', '60001', 'Nils Bonk', 'Gerät bearbeitet (Status: Einsatzbereit, GR: 1, Intervall: 1 Monate)', '2025-05-03 20:47:01');


DROP TABLE IF EXISTS `geraete_uploads`;
CREATE TABLE `geraete_uploads` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `barcode` varchar(255) NOT NULL,
  `dateiname` varchar(255) NOT NULL,
  `typ` varchar(50) NOT NULL,
  `hochgeladen_am` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `geraete_uploads` VALUES ('1', '6026', '6802a3f7449ca.png', 'image/png', '2025-04-18 21:11:51');
INSERT INTO `geraete_uploads` VALUES ('2', '6026', '6802a4eedc30d.png', 'image/png', '2025-04-18 21:15:58');
INSERT INTO `geraete_uploads` VALUES ('3', '6026', '6802a589c4f50.png', 'image/png', '2025-04-18 21:18:33');
INSERT INTO `geraete_uploads` VALUES ('8', '6026', '6804e1e95a9ec.png', 'image/png', '2025-04-20 14:00:41');


DROP TABLE IF EXISTS `geraete_wartung`;
CREATE TABLE `geraete_wartung` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `barcode` varchar(255) NOT NULL,
  `datum` datetime NOT NULL,
  `benutzer` varchar(255) NOT NULL,
  `notiz` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `geraete_wartung` VALUES ('1', '1020', '2025-05-02 00:00:00', 'Nils Bonk', 'Monatliche Prüfung');
INSERT INTO `geraete_wartung` VALUES ('2', '61000', '2025-05-03 00:00:00', 'Nils Bonk', 'Wöchentlicher Check');


DROP TABLE IF EXISTS `kameraden`;
CREATE TABLE `kameraden` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `vorname` varchar(100) NOT NULL,
  `nachname` varchar(100) NOT NULL,
  `email` varchar(150) DEFAULT NULL,
  `spindnr` varchar(50) NOT NULL,
  `groesse_jacke` varchar(50) DEFAULT NULL,
  `groesse_hose` varchar(50) DEFAULT NULL,
  `groesse_hose_agt` varchar(50) DEFAULT NULL,
  `groesse_stiefel` varchar(50) DEFAULT NULL,
  `helm_id` varchar(255) NOT NULL,
  `helmlampe_id` varchar(255) NOT NULL,
  `handschuhe_id` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=67 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `kameraden` VALUES ('1', 'Nils', 'Bonk', 'nils.bonk@me.com', '63', 'L', 'L', 'XL', '43', '', '', '');
INSERT INTO `kameraden` VALUES ('2', 'Thede', 'Meischen', 'thede.meischen@web.de', '15', 'S', '', 'M', '43', '102', '10', '222');
INSERT INTO `kameraden` VALUES ('4', 'Niklas', 'Trump', 'niklas-trump@web.de', '3', 'L', '', 'L', '45', '', '', '');
INSERT INTO `kameraden` VALUES ('5', 'Martin', 'Schreiber', 'martin.schreiber@ewetel.net', '1', 'XL', '', 'L', '45', '', '', '');
INSERT INTO `kameraden` VALUES ('6', 'Andi', 'Münder', 'andi.muender@icloud.com', '4', 'L', '', 'L', '0', '', '', '');
INSERT INTO `kameraden` VALUES ('7', 'Patrick', 'helms', 'patrick.he1394@gmail.com', '5', 'M', '', 'L', '44', '', '', '');
INSERT INTO `kameraden` VALUES ('8', 'Jens', 'Rudolp', 'info@der-dachdeckermeister.com', '7', 'XL', '', '', '46', '', '', '');
INSERT INTO `kameraden` VALUES ('9', 'Tim', 'Cölsmann', 'tim.coelsmann@t-online.de', '8', 'XXL', '', '', '45', '', '', '');
INSERT INTO `kameraden` VALUES ('10', 'Adelbert', 'Coman', 'admin@it-coman.de', '9', '', '', '', '49', '', '', '');
INSERT INTO `kameraden` VALUES ('11', 'Uwe', 'Trump', 'uwe-trump@web.de', '10', 'XXL', '', '', '47', '', '', '');
INSERT INTO `kameraden` VALUES ('12', 'Lucas', 'Schröder', 'lucas.s.95@web.de', '11', 'L', '', 'L', '48', '', '', '');
INSERT INTO `kameraden` VALUES ('13', 'Oliver', 'Gatzsch', 'o.gatzsch@web.de', '12', 'S', '', 'XS', '0', '', '', '');
INSERT INTO `kameraden` VALUES ('14', 'Besucher', 'Besucher', '', '13', '', '', '', '0', '', '', '');
INSERT INTO `kameraden` VALUES ('15', 'jens', 'tammen', 'jenstammen@web.de', '14', 'L', '', '', '0', '', '', '');
INSERT INTO `kameraden` VALUES ('16', 'Leer', 'leer', '', '16', NULL, NULL, NULL, NULL, '', '', '');
INSERT INTO `kameraden` VALUES ('17', 'Michael', 'tapken', 'michael.tapken@hotmail.de', '17', 'XXL', '', '', '0', '', '', '');
INSERT INTO `kameraden` VALUES ('18', 'Niklas', 'Renken', 'niklas@server-fl.de', '18', 'L', '', 'L', '0', '', '', '');
INSERT INTO `kameraden` VALUES ('19', 'Lars', 'Böhmann', 'lars.boehmann@ewetel.net', '19', 'S', '', 'S', '43', '', '', '');
INSERT INTO `kameraden` VALUES ('20', 'Masiyar', 'Namadi', '', '20', 'M', '', '', '0', '', '', '');
INSERT INTO `kameraden` VALUES ('21', 'Günter', 'Wille', 'guenter.wille@ewetel.net', '21', '', '', '', '0', '', '', '');
INSERT INTO `kameraden` VALUES ('22', 'Sören', 'Bock', 'bock8@web.de', '22', 'M', '', '', '46', '', '', '');
INSERT INTO `kameraden` VALUES ('23', 'Goran', 'Hajj Nurad', 'goran.morad95@gmail.com', '23', 'XS', '', '', '45', '', '', '');
INSERT INTO `kameraden` VALUES ('24', 'Niels', 'Strahl', 'niels.strahl@t-online.de', '24', 'L', '', 'XL', '0', '', '', '');
INSERT INTO `kameraden` VALUES ('25', 'Fabian', 'Schiller', 'kirstein-fabian@web.de', '25', 'L', '', 'M', '0', '', '', '');
INSERT INTO `kameraden` VALUES ('26', 'Leer', 'Leer', '', '26', NULL, NULL, NULL, NULL, '', '', '');
INSERT INTO `kameraden` VALUES ('27', 'Patrick', 'Fuhrken', 'patrick.fuhrken@ewetel.net', '27', 'L', '', 'XL', '0', '', '', '');
INSERT INTO `kameraden` VALUES ('28', 'Leer', 'Leer', '', '28', NULL, NULL, NULL, NULL, '', '', '');
INSERT INTO `kameraden` VALUES ('29', 'Carsten', 'Bruns', 'fahrschule-carsten-bruns@gmx.de', '29', 'XXXL', '', '', '48', '', '', '');
INSERT INTO `kameraden` VALUES ('30', 'Jan-Ole', 'Janßen', 'janolejanssen@gmail.com', '30', 'L', '', 'L', '45', '', '', '');
INSERT INTO `kameraden` VALUES ('31', 'Sascha', 'Kirstein', 'kirsteinsascha@web.de', '31', 'L', '', 'M', '43', '', '', '');
INSERT INTO `kameraden` VALUES ('32', 'Leer', 'leer', '', '32', NULL, NULL, NULL, NULL, '', '', '');
INSERT INTO `kameraden` VALUES ('33', 'Mike', 'Wetzel', 'wetzel_82@web.de', '33', 'L', '', 'L', '44', '', '', '');
INSERT INTO `kameraden` VALUES ('34', 'olaf', 'janßen', 'olaf.kerstin@t-online.de', '35', 'L', '', 'L', '44', '', '', '');
INSERT INTO `kameraden` VALUES ('35', 'Kai Oliver', 'Schröder', '', '36', 'XL', '', '', '46', '', '', '');
INSERT INTO `kameraden` VALUES ('36', 'Jan-Niklas', 'Schröder', 'nigelmania1@web.de', '37', '', '', '', '44', '', '', '');
INSERT INTO `kameraden` VALUES ('37', 'Mark', 'Behrendt', 'markbehrendt@gmx.de', '38', 'M', '', 'L', '44', '', '', '');
INSERT INTO `kameraden` VALUES ('38', 'Julian', 'Menkens', 'julian.menkens@ewe.net', '39', 'M', '', 'M', '44', '', '', '');
INSERT INTO `kameraden` VALUES ('39', 'Tim', 'Weichert', 'tim230190@gmx.de', '40', 'XL', '', 'XL', '43', '', '', '');
INSERT INTO `kameraden` VALUES ('40', 'Sascha', 'Oltmer', 'sascha.oltmer@web.de', '41', 'XXL', '', '', '47', '', '', '');
INSERT INTO `kameraden` VALUES ('41', 'Philip', 'Hagendorff', 'phillip.hagendorff@gmail.com', '42', 'M', '', 'M', '43', '', '', '');
INSERT INTO `kameraden` VALUES ('42', 'Moritz', 'Kraft', '', '43', 'M', '', '', '43', '', '', '');
INSERT INTO `kameraden` VALUES ('43', 'Jann', 'Butschkus', 'butschkus@web.de', '44', 'L', '', 'L', '43', '', '', '');
INSERT INTO `kameraden` VALUES ('44', 'Matthias', 'Wille', 'matthias.wille.mobil@gmail.com', '45', 'XXXL', '', '', '50', '', '', '');
INSERT INTO `kameraden` VALUES ('45', 'Malte', 'Nannen', 'nannen.malte@ewetel.net', '46', 'M', '', 'M', '43', '', '', '');
INSERT INTO `kameraden` VALUES ('46', 'Patrick', 'kranz', 'paddy112991@web.de', '47', 'L', '', 'L', '43', '', '', '');
INSERT INTO `kameraden` VALUES ('47', 'Jonas', 'Albers', '', '48', 'L', '', 'L', '0', '', '', '');
INSERT INTO `kameraden` VALUES ('48', 'Kai', 'Brand', 'kai.brandt@ewetel.net', '49', '', '', '', '0', '', '', '');
INSERT INTO `kameraden` VALUES ('49', 'Ralf', 'kikilus', 'ralf.kikillus@gmail.com', '50', '', '', '', '44', '', '', '');
INSERT INTO `kameraden` VALUES ('50', 'Axel', 'Roßkamp', 'axel.rosskamp@ewetel.net', '51', 'XL', '', '', '44', '', '', '');
INSERT INTO `kameraden` VALUES ('51', 'Michael', 'Hooby', 'michael.hobbie@gmx.de', '52', 'L', '', 'L', '0', '', '', '');
INSERT INTO `kameraden` VALUES ('52', 'Muhammed', 'Bayezit', 'bayezit.muhammed1@gmail.com', '53', 'M', '', '', '43', '', '', '');
INSERT INTO `kameraden` VALUES ('53', 'Sunke', 'Oetken', 'sunke1@web.de', '54', 'L', '', '', '46', '', '', '');
INSERT INTO `kameraden` VALUES ('54', 'Dieter', 'Schröder', 'dieter.schroeder15@ewetel.net', '55', '', '', '', '44', '', '', '');
INSERT INTO `kameraden` VALUES ('55', 'Geredt', 'Strahl', 'gesame@ewetel.net', '56', 'L', '', 'XL', '45', '', '', '');
INSERT INTO `kameraden` VALUES ('56', 'Rene', 'Peters', 'rene.peters@ewetel.net', '58', '', '', 'L', '49', '', '', '');
INSERT INTO `kameraden` VALUES ('57', 'Christian', 'Peters', 'c.peters1993@icloud.com', '59', '', '', '', '0', '', '', '');
INSERT INTO `kameraden` VALUES ('58', 'Sven', 'Peters', 'sven.peters4@ewetel.net', '60', 'L', '', '', '43', '', '', '');
INSERT INTO `kameraden` VALUES ('59', 'Jürgen', 'Kirstein', 'juergen-kirstein@web.de', '61', 'S', '', 'S', '42', '', '', '');
INSERT INTO `kameraden` VALUES ('60', 'Arne', 'Hülsmann', 'arne.huelsmann@ewetel.net', '62', 'L', '', 'XL', '45', '', '', '');
INSERT INTO `kameraden` VALUES ('61', 'Harald', 'Witthus', 'harald.witthus@ewe.net', '64', '', '', '', '46', '', '', '');
INSERT INTO `kameraden` VALUES ('62', 'Jan Hendrik', 'Friedrich', 'janhendrikfriedrich@t-online.de', '65', 'L', '', 'L', '45', '', '', '');
INSERT INTO `kameraden` VALUES ('63', 'Janine', 'Tapken-Meier', 'diejaninemeier@web.de', '71', 'S', '', 'S', '0', '', '', '');
INSERT INTO `kameraden` VALUES ('64', 'Lieske', 'Trump', '', '70', 'M', '', '', '0', '', '', '');
INSERT INTO `kameraden` VALUES ('65', 'Tanja', 'Kuhlmann', 'tageku112@web.de', '69', 'S', '', '', '41', '', '', '');
INSERT INTO `kameraden` VALUES ('66', 'Sebastian', 'Tapken', 'usshawk55@hotmail.de', '57', 'XL', '', 'XL', '45', '', '', '');


DROP TABLE IF EXISTS `kostenstellen`;
CREATE TABLE `kostenstellen` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `bezeichnung` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `kostenstellen` VALUES ('8', 'Geräteverwaltung');
INSERT INTO `kostenstellen` VALUES ('7', 'TZ fahrten');
INSERT INTO `kostenstellen` VALUES ('3', 'Dienstbesprechung');
INSERT INTO `kostenstellen` VALUES ('5', 'Wartung');
INSERT INTO `kostenstellen` VALUES ('6', 'Verwaltung');
INSERT INTO `kostenstellen` VALUES ('9', 'Atemschutztätigkeiten');
INSERT INTO `kostenstellen` VALUES ('10', 'Funktätigkeiten');


DROP TABLE IF EXISTS `lager_bestand`;
CREATE TABLE `lager_bestand` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `artikelnummer` varchar(50) NOT NULL,
  `artikelname` varchar(255) NOT NULL,
  `kategorie` enum('PSA','Dienstbekleidung','Uniform') NOT NULL,
  `groesse` varchar(50) DEFAULT NULL,
  `bestand` int(11) NOT NULL DEFAULT 0,
  `mindesbestand` int(11) DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `artikelnummer` (`artikelnummer`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `lager_bestand` VALUES ('1', 'DB-001', 'Pullover', 'Dienstbekleidung', 'XL', '7', '10');
INSERT INTO `lager_bestand` VALUES ('2', 'PSA-0001', 'Einsatzhose S-Gard Hunter', '', 'XL', '10', '3');
INSERT INTO `lager_bestand` VALUES ('3', 'PSA-0002', 'AGT-Handschuhe ', '', '9', '2', '3');


DROP TABLE IF EXISTS `lager_historie`;
CREATE TABLE `lager_historie` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `lager_id` int(10) unsigned NOT NULL,
  `buchungstyp` enum('Zugang','Abgang') NOT NULL,
  `anzahl` int(11) NOT NULL,
  `datum` datetime NOT NULL DEFAULT current_timestamp(),
  `kamerad_id` int(10) unsigned DEFAULT NULL,
  `bemerkung` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_lager_id` (`lager_id`),
  KEY `idx_kamerad_id` (`kamerad_id`),
  CONSTRAINT `fk_kamerad_id` FOREIGN KEY (`kamerad_id`) REFERENCES `kameraden` (`id`) ON DELETE SET NULL ON UPDATE CASCADE,
  CONSTRAINT `fk_lager_id` FOREIGN KEY (`lager_id`) REFERENCES `lager_bestand` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `lager_historie` VALUES ('1', '1', 'Abgang', '1', '2025-04-26 13:28:01', '1', 'Ausgabe');
INSERT INTO `lager_historie` VALUES ('2', '1', 'Zugang', '1', '2025-04-26 13:57:14', NULL, 'Test');
INSERT INTO `lager_historie` VALUES ('3', '1', 'Abgang', '1', '2025-05-02 08:53:16', '1', 'Defekt');
INSERT INTO `lager_historie` VALUES ('4', '1', 'Abgang', '1', '2025-05-02 08:55:12', NULL, 'Test');
INSERT INTO `lager_historie` VALUES ('5', '1', 'Abgang', '1', '2025-05-02 13:40:58', NULL, 'Test');
INSERT INTO `lager_historie` VALUES ('6', '1', 'Abgang', '1', '2025-05-02 13:50:52', NULL, 'Test');
INSERT INTO `lager_historie` VALUES ('7', '3', 'Abgang', '1', '2025-05-02 16:20:41', '2', 'Bekam am 02.05.2025 neue Handschuhe');
INSERT INTO `lager_historie` VALUES ('8', '3', 'Zugang', '1', '2025-05-04 14:40:56', NULL, '');
INSERT INTO `lager_historie` VALUES ('9', '3', 'Abgang', '8', '2025-05-04 14:41:12', NULL, 'jgkoh');


DROP TABLE IF EXISTS `landkreise`;
CREATE TABLE `landkreise` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `landkreise` VALUES ('1', 'Landkreis Ammerland');


DROP TABLE IF EXISTS `lieferschein_geraete`;
CREATE TABLE `lieferschein_geraete` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lieferschein_id` int(11) DEFAULT NULL,
  `geraet_id` int(11) DEFAULT NULL,
  `bemerkung` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lieferschein_id` (`lieferschein_id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `lieferschein_geraete` VALUES ('1', '1', '2065', NULL);
INSERT INTO `lieferschein_geraete` VALUES ('2', '1', '870', NULL);
INSERT INTO `lieferschein_geraete` VALUES ('3', '2', '2065', NULL);
INSERT INTO `lieferschein_geraete` VALUES ('4', '2', '870', NULL);
INSERT INTO `lieferschein_geraete` VALUES ('5', '2', '871', NULL);
INSERT INTO `lieferschein_geraete` VALUES ('6', '2', '209', NULL);
INSERT INTO `lieferschein_geraete` VALUES ('7', '2', '120', NULL);
INSERT INTO `lieferschein_geraete` VALUES ('8', '2', '207', NULL);
INSERT INTO `lieferschein_geraete` VALUES ('9', '2', '2226', NULL);
INSERT INTO `lieferschein_geraete` VALUES ('10', '3', '2213', NULL);
INSERT INTO `lieferschein_geraete` VALUES ('11', '3', '2214', NULL);
INSERT INTO `lieferschein_geraete` VALUES ('12', '3', '2215', NULL);


DROP TABLE IF EXISTS `lieferschein_positionen`;
CREATE TABLE `lieferschein_positionen` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `lieferschein_id` int(11) DEFAULT NULL,
  `bezeichnung` varchar(255) DEFAULT NULL,
  `menge` varchar(50) DEFAULT NULL,
  `bemerkung` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lieferschein_id` (`lieferschein_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `lieferschein_positionen` VALUES ('1', '2', 'PSA', '1', 'Wäsche');


DROP TABLE IF EXISTS `lieferscheine`;
CREATE TABLE `lieferscheine` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `einheit` varchar(255) DEFAULT NULL,
  `erstellt_von` int(11) DEFAULT NULL,
  `erstellt_am` datetime DEFAULT current_timestamp(),
  `lieferdatum` date DEFAULT NULL,
  `empfaenger` varchar(255) DEFAULT NULL,
  `adresse_id` int(11) DEFAULT NULL,
  `status` enum('offen','geliefert','storniert') DEFAULT 'offen',
  `rueckmeldung` text DEFAULT NULL,
  `rueckmelde_datum` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `lieferscheine` VALUES ('1', 'A2BZ', '1', '2025-05-17 21:35:23', '2025-05-17', 'Michael Sommer', '1', 'geliefert', 'gtest', '2025-05-17 21:54:33');
INSERT INTO `lieferscheine` VALUES ('2', 'A2BZ', '1', '2025-05-17 21:37:58', '2025-05-17', 'Michael Sommer', '1', 'geliefert', 'test', '2025-05-17 21:54:23');
INSERT INTO `lieferscheine` VALUES ('3', 'A2BZ', '1', '2025-05-17 21:56:22', '2025-05-17', 'Nils Bonk', '1', 'offen', NULL, NULL);


DROP TABLE IF EXISTS `login_history`;
CREATE TABLE `login_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `ip_address` varchar(45) NOT NULL,
  `login_time` datetime DEFAULT current_timestamp(),
  `action` enum('login','logout') NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=73 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `login_history` VALUES ('1', '1', '37.138.93.212', '2025-05-03 09:18:53', 'login');
INSERT INTO `login_history` VALUES ('2', '1', '37.138.93.212', '2025-05-03 09:19:17', 'logout');
INSERT INTO `login_history` VALUES ('3', '1', '37.138.93.212', '2025-05-03 09:20:08', 'login');
INSERT INTO `login_history` VALUES ('4', '1', '37.138.93.212', '2025-05-03 09:21:24', 'logout');
INSERT INTO `login_history` VALUES ('5', '1', '37.138.93.212', '2025-05-03 09:21:25', 'login');
INSERT INTO `login_history` VALUES ('6', '13', '178.142.22.13', '2025-05-03 09:24:08', 'login');
INSERT INTO `login_history` VALUES ('7', '13', '178.142.22.13', '2025-05-03 09:24:25', 'logout');
INSERT INTO `login_history` VALUES ('8', '1', '31.150.74.191', '2025-05-03 10:00:59', 'login');
INSERT INTO `login_history` VALUES ('9', '14', '178.142.23.176', '2025-05-03 10:03:54', 'login');
INSERT INTO `login_history` VALUES ('10', '14', '178.142.23.176', '2025-05-03 10:05:47', 'logout');
INSERT INTO `login_history` VALUES ('11', '15', '85.16.32.232', '2025-05-03 10:09:30', 'login');
INSERT INTO `login_history` VALUES ('12', '1', '104.28.62.44', '2025-05-03 10:13:40', 'login');
INSERT INTO `login_history` VALUES ('13', '1', '104.28.62.44', '2025-05-03 10:13:52', 'logout');
INSERT INTO `login_history` VALUES ('14', '1', '31.150.74.191', '2025-05-03 10:14:10', 'logout');
INSERT INTO `login_history` VALUES ('15', '1', '31.150.74.191', '2025-05-03 10:14:12', 'login');
INSERT INTO `login_history` VALUES ('16', '1', '31.150.74.191', '2025-05-03 10:24:20', 'logout');
INSERT INTO `login_history` VALUES ('17', '1', '31.150.74.191', '2025-05-03 11:25:12', 'login');
INSERT INTO `login_history` VALUES ('18', '1', '31.150.74.191', '2025-05-03 11:25:48', 'logout');
INSERT INTO `login_history` VALUES ('19', '1', '31.150.74.191', '2025-05-03 11:49:09', 'login');
INSERT INTO `login_history` VALUES ('20', '1', '31.150.74.191', '2025-05-03 11:50:30', 'logout');
INSERT INTO `login_history` VALUES ('21', '1', '31.150.74.191', '2025-05-03 11:51:44', 'login');
INSERT INTO `login_history` VALUES ('22', '1', '31.150.74.191', '2025-05-03 11:53:03', 'logout');
INSERT INTO `login_history` VALUES ('23', '1', '31.150.74.191', '2025-05-03 12:25:34', 'login');
INSERT INTO `login_history` VALUES ('24', '1', '31.150.74.191', '2025-05-03 12:25:40', 'logout');
INSERT INTO `login_history` VALUES ('25', '1', '31.150.74.191', '2025-05-03 12:55:57', 'login');
INSERT INTO `login_history` VALUES ('26', '13', '178.142.22.13', '2025-05-03 14:54:08', 'login');
INSERT INTO `login_history` VALUES ('27', '13', '178.142.22.13', '2025-05-03 14:55:17', 'logout');
INSERT INTO `login_history` VALUES ('28', '1', '31.150.74.191', '2025-05-03 18:59:16', 'login');
INSERT INTO `login_history` VALUES ('29', '1', '31.150.74.191', '2025-05-03 20:11:30', 'login');
INSERT INTO `login_history` VALUES ('30', '1', '31.150.74.191', '2025-05-03 20:12:31', 'logout');
INSERT INTO `login_history` VALUES ('31', '17', '31.150.74.191', '2025-05-03 20:12:38', 'login');
INSERT INTO `login_history` VALUES ('32', '1', '31.150.74.191', '2025-05-03 20:13:07', 'login');
INSERT INTO `login_history` VALUES ('33', '17', '31.150.74.191', '2025-05-03 20:13:43', 'logout');
INSERT INTO `login_history` VALUES ('34', '1', '31.150.74.191', '2025-05-03 20:13:46', 'logout');
INSERT INTO `login_history` VALUES ('35', '1', '31.150.74.191', '2025-05-03 20:15:34', 'login');
INSERT INTO `login_history` VALUES ('36', '1', '31.150.74.191', '2025-05-03 21:24:41', 'logout');
INSERT INTO `login_history` VALUES ('37', '1', '31.150.74.191', '2025-05-03 22:07:29', 'login');
INSERT INTO `login_history` VALUES ('38', '1', '31.150.128.110', '2025-05-03 22:34:45', 'logout');
INSERT INTO `login_history` VALUES ('39', '1', '178.142.19.153', '2025-05-04 08:22:30', 'login');
INSERT INTO `login_history` VALUES ('40', '1', '178.142.19.153', '2025-05-04 08:22:56', 'logout');
INSERT INTO `login_history` VALUES ('41', '1', '178.142.19.153', '2025-05-04 10:32:08', 'login');
INSERT INTO `login_history` VALUES ('42', '1', '178.142.19.153', '2025-05-04 10:32:29', 'logout');
INSERT INTO `login_history` VALUES ('43', '1', '178.142.19.153', '2025-05-04 10:36:11', 'login');
INSERT INTO `login_history` VALUES ('44', '1', '178.142.19.153', '2025-05-04 10:44:46', 'logout');
INSERT INTO `login_history` VALUES ('45', '1', '178.142.19.153', '2025-05-04 10:46:11', 'login');
INSERT INTO `login_history` VALUES ('46', '1', '178.142.19.153', '2025-05-04 13:52:05', 'login');
INSERT INTO `login_history` VALUES ('47', '1', '178.142.19.153', '2025-05-04 13:52:14', 'logout');
INSERT INTO `login_history` VALUES ('48', '1', '178.142.19.153', '2025-05-04 13:52:29', 'login');
INSERT INTO `login_history` VALUES ('49', '13', '178.142.20.214', '2025-05-04 14:02:20', 'login');
INSERT INTO `login_history` VALUES ('50', '13', '178.142.20.214', '2025-05-04 14:09:43', 'login');
INSERT INTO `login_history` VALUES ('51', '1', '178.142.19.153', '2025-05-04 14:13:04', 'logout');
INSERT INTO `login_history` VALUES ('52', '13', '178.142.20.214', '2025-05-04 14:45:15', 'logout');
INSERT INTO `login_history` VALUES ('53', '13', '178.142.20.214', '2025-05-04 15:44:19', 'login');
INSERT INTO `login_history` VALUES ('54', '13', '178.142.20.214', '2025-05-04 16:35:38', 'logout');
INSERT INTO `login_history` VALUES ('55', '13', '178.142.20.214', '2025-05-04 16:40:30', 'login');
INSERT INTO `login_history` VALUES ('56', '14', '31.150.134.119', '2025-05-04 19:09:50', 'login');
INSERT INTO `login_history` VALUES ('57', '14', '31.150.134.119', '2025-05-04 19:10:50', 'logout');
INSERT INTO `login_history` VALUES ('58', '14', '31.150.134.119', '2025-05-04 19:37:34', 'login');
INSERT INTO `login_history` VALUES ('59', '14', '31.150.134.119', '2025-05-04 19:38:46', 'logout');
INSERT INTO `login_history` VALUES ('60', '14', '178.142.79.154', '2025-05-05 09:25:41', 'login');
INSERT INTO `login_history` VALUES ('61', '14', '178.142.79.154', '2025-05-05 09:46:12', 'logout');
INSERT INTO `login_history` VALUES ('62', '14', '178.142.79.154', '2025-05-05 10:01:52', 'login');
INSERT INTO `login_history` VALUES ('63', '14', '178.142.79.154', '2025-05-05 10:03:05', 'logout');
INSERT INTO `login_history` VALUES ('64', '1', '31.150.75.212', '2025-05-08 19:49:34', 'login');
INSERT INTO `login_history` VALUES ('65', '1', '31.150.75.212', '2025-05-08 19:53:10', 'logout');
INSERT INTO `login_history` VALUES ('66', '14', '178.142.20.23', '2025-05-12 18:20:35', 'login');
INSERT INTO `login_history` VALUES ('67', '14', '178.142.20.23', '2025-05-12 18:21:05', 'logout');
INSERT INTO `login_history` VALUES ('68', '1', '31.150.75.216', '2025-05-17 19:56:01', 'login');
INSERT INTO `login_history` VALUES ('69', '1', '31.150.75.216', '2025-05-17 20:25:03', 'login');
INSERT INTO `login_history` VALUES ('70', '1', '31.150.75.216', '2025-05-17 20:25:35', 'logout');
INSERT INTO `login_history` VALUES ('71', '1', '31.150.75.216', '2025-05-17 20:54:06', 'login');
INSERT INTO `login_history` VALUES ('72', '1', '31.150.75.216', '2025-05-17 22:47:15', 'logout');


DROP TABLE IF EXISTS `melder`;
CREATE TABLE `melder` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `seriennummer` varchar(255) NOT NULL,
  `typ` varchar(255) NOT NULL,
  `kennung` varchar(255) DEFAULT NULL,
  `kamerad_id` int(11) unsigned DEFAULT NULL,
  `ausgabe_datum` date DEFAULT NULL,
  `ladegeraet` tinyint(1) DEFAULT 0,
  `antenne` tinyint(1) DEFAULT 0,
  `schutztasche` tinyint(1) DEFAULT 0,
  `created_at` datetime DEFAULT current_timestamp(),
  `einheit` varchar(255) NOT NULL,
  `prog_obm` tinyint(1) DEFAULT 0,
  `prog_ats` tinyint(1) DEFAULT 0,
  `prog_gg` tinyint(1) DEFAULT 0,
  `prog_ggf` tinyint(1) DEFAULT 0,
  `prog_elw` tinyint(1) DEFAULT 0,
  `prog_fuest` tinyint(1) DEFAULT 0,
  `prog_kfb` tinyint(1) DEFAULT 0,
  `programm_obm` tinyint(1) NOT NULL DEFAULT 0,
  `programm_agt` tinyint(1) NOT NULL DEFAULT 0,
  `programm_gg` tinyint(1) NOT NULL DEFAULT 0,
  `programm_ggf` tinyint(1) NOT NULL DEFAULT 0,
  `programm_elw` tinyint(1) NOT NULL DEFAULT 0,
  `programm_fuest` tinyint(1) NOT NULL DEFAULT 0,
  `programm_kfb` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `melder` VALUES ('1', 'C201916.00863', 's.Quad X15', 'A2BZ63', '1', '2019-04-26', '1', '1', '1', '2025-04-26 18:54:56', 'A2BZ', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1', '1');
INSERT INTO `melder` VALUES ('2', 'C202311.024389', 's.Quad X15', 'A2BZ01', '4', '2024-07-01', '1', '1', '1', '2025-05-01 19:42:03', 'A2BZ', '0', '0', '0', '0', '0', '0', '0', '0', '1', '1', '1', '1', '1', '1');


DROP TABLE IF EXISTS `melder_kommentare`;
CREATE TABLE `melder_kommentare` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `melder_id` int(11) unsigned NOT NULL,
  `kommentar` text NOT NULL,
  `verfasser` varchar(255) NOT NULL,
  `zeitstempel` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `melder_kommentare` VALUES ('1', '1', 'test', 'Nils Bonk', '2025-04-26 19:46:59');
INSERT INTO `melder_kommentare` VALUES ('2', '2', 'test', 'Nils Bonk', '2025-05-01 19:44:31');


DROP TABLE IF EXISTS `neue_tickets`;
CREATE TABLE `neue_tickets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ticketnummer` varchar(50) NOT NULL,
  `fachbereich` varchar(100) NOT NULL,
  `name` varchar(255) NOT NULL,
  `spindnr` varchar(50) DEFAULT NULL,
  `beschreibung` text NOT NULL,
  `status` enum('offen','in Bearbeitung','erledigt') NOT NULL DEFAULT 'offen',
  `bearbeiter_id` int(11) DEFAULT NULL,
  `erstellt_am` datetime NOT NULL DEFAULT current_timestamp(),
  `bearbeitet_am` datetime DEFAULT NULL,
  `erledigt_am` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `neue_tickets` VALUES ('1', 'T-20250426-5345', 'Melder', 'Nils Bonk', '63', 'Melder hat keinen Empfang mehr', 'erledigt', '1', '2025-04-26 20:49:26', '2025-05-01 18:09:57', '2025-05-03 11:25:35');


DROP TABLE IF EXISTS `news`;
CREATE TABLE `news` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `titel` text DEFAULT NULL,
  `verfasser` varchar(255) DEFAULT NULL,
  `inhalt` text DEFAULT NULL,
  `highlight` tinyint(1) DEFAULT 0,
  `bild` varchar(255) DEFAULT NULL,
  `dokument` varchar(255) DEFAULT NULL,
  `erstellt_am` datetime DEFAULT current_timestamp(),
  `kategorie` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `news` VALUES ('11', '🚀 Release-Version 3.0 steht in den Startlöchern!', 'Nils Bonk', 'Hallo zusammen,\r\n\r\nder Release der Version 3.0 steht kurz bevor – und ich freue mich riesig, euch bald die vielen Neuerungen vorstellen zu können!\r\n\r\nIch habe in den letzten Wochen intensiv an Verbesserungen gearbeitet, um das Programm für euch noch intuitiver, stabiler und funktionsreicher zu gestalten. Viele eurer Rückmeldungen habe ich dabei direkt umgesetzt – danke an alle, die mitgedacht und mitgetestet haben!\r\n\r\nPassend zum nächsten großen Schritt bekommt auch das Logo ein frisches Redesign, das den modernen Charakter der Software widerspiegelt.\r\n\r\nDer offizielle Starttermin wird in Kürze bekannt gegeben. Ich bin überzeugt: Version 3.0 wird euch begeistern!\r\n\r\nVielen Dank für euer Vertrauen und eure Unterstützung.\r\nIch freue mich auf das, was kommt!\r\n\r\nBeste Grüße', '1', '', '', '2025-05-03 13:00:04', 'Update');


DROP TABLE IF EXISTS `psa_ausruestung`;
CREATE TABLE `psa_ausruestung` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `typ` enum('Einsatzjacke','Einsatzhose','Einsatzhose AGT','Stiefel','Helm','Helmlampe') NOT NULL,
  `hersteller` varchar(100) NOT NULL,
  `modell` varchar(100) NOT NULL,
  `groesse` varchar(50) DEFAULT NULL,
  `spindnr` varchar(10) DEFAULT NULL,
  `einheit` varchar(100) NOT NULL,
  `created_at` datetime DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=126 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `psa_ausruestung` VALUES ('1', 'Einsatzhose AGT', 'S-Gard', 'Hunter', '50', '63', 'A2BZ', '2025-05-02 18:08:02');
INSERT INTO `psa_ausruestung` VALUES ('2', 'Einsatzhose AGT', 'S-Gard', 'Hunter', '50', '1', 'A2BZ', '2025-05-02 18:08:13');
INSERT INTO `psa_ausruestung` VALUES ('3', 'Helm', 'Rossenbauer', '7062', '', '1', 'A2BZ', '2025-05-04 16:58:12');
INSERT INTO `psa_ausruestung` VALUES ('4', 'Helm', 'Rossenbauer', '7089', '', '3', 'A2BZ', '2025-05-04 17:04:10');
INSERT INTO `psa_ausruestung` VALUES ('5', 'Helm', 'Rossenbauer', '7044', '', '5', 'A2BZ', '2025-05-04 17:11:28');
INSERT INTO `psa_ausruestung` VALUES ('6', 'Helm', 'Rossenbauer', '7155', '', '7', 'A2BZ', '2025-05-04 17:14:38');
INSERT INTO `psa_ausruestung` VALUES ('7', 'Helm', 'Rossenbauer', '7074', '', '8', 'A2BZ', '2025-05-04 17:16:31');
INSERT INTO `psa_ausruestung` VALUES ('8', 'Helm', 'Rossenbauer', '7070', '', '9', 'A2BZ', '2025-05-04 17:17:56');
INSERT INTO `psa_ausruestung` VALUES ('9', 'Helm', 'Rossenbauer', '7061', '', '10', 'A2BZ', '2025-05-04 17:19:32');
INSERT INTO `psa_ausruestung` VALUES ('10', 'Helm', 'Rossenbauer', '7049', '', '11', 'A2BZ', '2025-05-04 17:21:37');
INSERT INTO `psa_ausruestung` VALUES ('11', 'Helm', 'Rossenbauer', '7046', '', '12', 'A2BZ', '2025-05-04 17:23:10');
INSERT INTO `psa_ausruestung` VALUES ('12', 'Helm', 'Rossenbauer', '7002', '', '13', 'A2BZ', '2025-05-04 17:24:15');
INSERT INTO `psa_ausruestung` VALUES ('13', 'Helm', 'Rossenbauer', '7068', '', '14', 'A2BZ', '2025-05-04 17:25:31');
INSERT INTO `psa_ausruestung` VALUES ('14', 'Helm', 'Rossenbauer', '7087', '', '16', 'A2BZ', '2025-05-04 17:26:20');
INSERT INTO `psa_ausruestung` VALUES ('15', 'Helm', 'Rossenbauer', '7005', '', '17', 'A2BZ', '2025-05-04 17:27:54');
INSERT INTO `psa_ausruestung` VALUES ('16', 'Helm', 'Rossenbauer', '7023', '', '15', 'A2BZ', '2025-05-04 17:28:23');
INSERT INTO `psa_ausruestung` VALUES ('17', 'Helm', 'Rossenbauer', '7050', '', '18', 'A2BZ', '2025-05-04 17:29:47');
INSERT INTO `psa_ausruestung` VALUES ('18', 'Helm', 'Rossenbauer', '7035', '', '19', 'A2BZ', '2025-05-04 17:31:54');
INSERT INTO `psa_ausruestung` VALUES ('19', 'Helm', 'Rossenbauer', '7174', '', '20', 'A2BZ', '2025-05-04 17:33:09');
INSERT INTO `psa_ausruestung` VALUES ('20', 'Helm', 'Rossenbauer', '7026', '', '21', 'A2BZ', '2025-05-04 17:34:41');
INSERT INTO `psa_ausruestung` VALUES ('21', 'Helmlampe', 'Petzel', '7135', '', '21', 'A2BZ', '2025-05-04 17:35:10');
INSERT INTO `psa_ausruestung` VALUES ('22', 'Helm', 'Rossenbauer', '7094', '', '22', 'A2BZ', '2025-05-04 17:36:30');
INSERT INTO `psa_ausruestung` VALUES ('23', 'Helm', 'Rossenbauer', '7066', '', '23', 'A2BZ', '2025-05-04 17:38:26');
INSERT INTO `psa_ausruestung` VALUES ('24', 'Helmlampe', 'Petzel', '7183', '', '23', 'A2BZ', '2025-05-04 17:38:40');
INSERT INTO `psa_ausruestung` VALUES ('25', 'Helm', 'Rossenbauer', '7057', '', '24', 'A2BZ', '2025-05-04 17:41:03');
INSERT INTO `psa_ausruestung` VALUES ('26', 'Helmlampe', 'Petzel', '7118', '', '24', 'A2BZ', '2025-05-04 17:41:18');
INSERT INTO `psa_ausruestung` VALUES ('27', 'Helm', 'Rossenbauer', '7065', '', '25', 'A2BZ', '2025-05-04 17:42:57');
INSERT INTO `psa_ausruestung` VALUES ('28', 'Helmlampe', 'Petzel', '7147', '', '25', 'A2BZ', '2025-05-04 17:43:10');
INSERT INTO `psa_ausruestung` VALUES ('29', 'Helm', 'Rossenbauer', '7008', '', '26', 'A2BZ', '2025-05-04 17:43:59');
INSERT INTO `psa_ausruestung` VALUES ('30', 'Helmlampe', 'Petzel', '7142', '', '26', 'A2BZ', '2025-05-04 17:44:11');
INSERT INTO `psa_ausruestung` VALUES ('31', 'Helm', 'Rossenbauer', '7014', '', '27', 'A2BZ', '2025-05-04 17:45:33');
INSERT INTO `psa_ausruestung` VALUES ('32', 'Helmlampe', 'Petzel', '7109', '', '27', 'A2BZ', '2025-05-04 17:45:45');
INSERT INTO `psa_ausruestung` VALUES ('33', 'Helm', 'Rossenbauer', '7030', '', '28', 'A2BZ', '2025-05-04 17:46:27');
INSERT INTO `psa_ausruestung` VALUES ('34', 'Helm', 'Rossenbauer', '7063', '', '29', 'A2BZ', '2025-05-04 17:48:10');
INSERT INTO `psa_ausruestung` VALUES ('35', 'Helmlampe', 'Petzel', '7156', '', '29', 'A2BZ', '2025-05-04 17:48:28');
INSERT INTO `psa_ausruestung` VALUES ('36', 'Helm', 'Rossenbauer', '7081', '', '30', 'A2BZ', '2025-05-04 17:49:59');
INSERT INTO `psa_ausruestung` VALUES ('37', 'Helmlampe', 'Petzel', '7141', '', '30', 'A2BZ', '2025-05-04 17:50:48');
INSERT INTO `psa_ausruestung` VALUES ('38', 'Helm', 'Rossenbauer', '7039', '', '31', 'A2BZ', '2025-05-04 17:52:30');
INSERT INTO `psa_ausruestung` VALUES ('39', 'Helmlampe', 'Petzel', '7163', '', '31', 'A2BZ', '2025-05-04 17:52:43');
INSERT INTO `psa_ausruestung` VALUES ('40', 'Helm', 'Rossenbauer', '7018', '', '32', 'A2BZ', '2025-05-04 17:53:33');
INSERT INTO `psa_ausruestung` VALUES ('41', 'Helmlampe', 'Petzel', '7153', '', '32', 'A2BZ', '2025-05-04 17:53:45');
INSERT INTO `psa_ausruestung` VALUES ('42', 'Helm', 'Rossenbauer', '7073', '', '33', 'A2BZ', '2025-05-04 17:55:00');
INSERT INTO `psa_ausruestung` VALUES ('43', 'Helmlampe', 'Petzel', '7121', '', '33', 'A2BZ', '2025-05-04 17:55:15');
INSERT INTO `psa_ausruestung` VALUES ('44', 'Helm', 'Rossenbauer', '7056', '', '35', 'A2BZ', '2025-05-04 18:15:18');
INSERT INTO `psa_ausruestung` VALUES ('45', 'Helmlampe', 'Petzel', '7112', '', '35', 'A2BZ', '2025-05-04 18:15:32');
INSERT INTO `psa_ausruestung` VALUES ('46', 'Helm', 'Rossenbauer', '7054', '', '36', 'A2BZ', '2025-05-04 18:17:25');
INSERT INTO `psa_ausruestung` VALUES ('47', 'Helmlampe', 'Petzel', '7148', '', '36', 'A2BZ', '2025-05-04 18:17:39');
INSERT INTO `psa_ausruestung` VALUES ('48', 'Helm', 'Rossenbauer', '7080', '', '37', 'A2BZ', '2025-05-04 18:18:56');
INSERT INTO `psa_ausruestung` VALUES ('49', 'Helmlampe', 'Petzel', '7143', '', '37', 'A2BZ', '2025-05-04 18:19:09');
INSERT INTO `psa_ausruestung` VALUES ('50', 'Helm', 'Rossenbauer', '7048', '', '38', 'A2BZ', '2025-05-04 18:20:36');
INSERT INTO `psa_ausruestung` VALUES ('51', 'Helmlampe', 'Petzel', '7180', '', '38', 'A2BZ', '2025-05-04 18:20:50');
INSERT INTO `psa_ausruestung` VALUES ('52', 'Helm', 'Rossenbauer', '7011', '', '39', 'A2BZ', '2025-05-04 18:22:11');
INSERT INTO `psa_ausruestung` VALUES ('53', 'Helmlampe', 'Petzel', '7101', '', '39', 'A2BZ', '2025-05-04 18:22:24');
INSERT INTO `psa_ausruestung` VALUES ('54', 'Helm', 'Rossenbauer', '7084', '', '40', 'A2BZ', '2025-05-04 18:24:16');
INSERT INTO `psa_ausruestung` VALUES ('55', 'Helmlampe', 'Petzel', '7126', '', '40', 'A2BZ', '2025-05-04 18:24:29');
INSERT INTO `psa_ausruestung` VALUES ('56', 'Helm', 'Rossenbauer', '7090', '', '41', 'A2BZ', '2025-05-04 18:25:48');
INSERT INTO `psa_ausruestung` VALUES ('57', 'Helmlampe', 'Petzel', '7124', '', '41', 'A2BZ', '2025-05-04 18:25:59');
INSERT INTO `psa_ausruestung` VALUES ('58', 'Helm', 'Rossenbauer', '7025', '', '42', 'A2BZ', '2025-05-04 18:27:49');
INSERT INTO `psa_ausruestung` VALUES ('59', 'Helmlampe', 'Petzel', '7129', '', '42', 'A2BZ', '2025-05-04 18:28:02');
INSERT INTO `psa_ausruestung` VALUES ('60', 'Helm', 'Rossenbauer', '7015', '', '43', 'A2BZ', '2025-05-04 18:29:16');
INSERT INTO `psa_ausruestung` VALUES ('61', 'Helmlampe', 'Petzel', '7131', '', '43', 'A2BZ', '2025-05-04 18:29:33');
INSERT INTO `psa_ausruestung` VALUES ('62', 'Helm', 'Rossenbauer', '7086', '', '44', 'A2BZ', '2025-05-04 18:30:57');
INSERT INTO `psa_ausruestung` VALUES ('63', 'Helmlampe', 'Petzel', '7102', '', '44', 'A2BZ', '2025-05-04 18:31:09');
INSERT INTO `psa_ausruestung` VALUES ('64', 'Helm', 'Rossenbauer', '7067', '', '45', 'A2BZ', '2025-05-04 18:32:30');
INSERT INTO `psa_ausruestung` VALUES ('65', 'Helmlampe', 'Petzel', '7160', '', '45', 'A2BZ', '2025-05-04 18:32:43');
INSERT INTO `psa_ausruestung` VALUES ('66', 'Helm', 'Rossenbauer', '7000', '', '46', 'A2BZ', '2025-05-04 18:34:15');
INSERT INTO `psa_ausruestung` VALUES ('67', 'Helmlampe', 'Petzel', '7150', '', '46', 'A2BZ', '2025-05-04 18:34:29');
INSERT INTO `psa_ausruestung` VALUES ('68', 'Helm', 'Rossenbauer', '7013', '', '47', 'A2BZ', '2025-05-04 18:35:54');
INSERT INTO `psa_ausruestung` VALUES ('69', 'Helmlampe', 'Petzel', '7130', '', '47', 'A2BZ', '2025-05-04 18:36:07');
INSERT INTO `psa_ausruestung` VALUES ('70', 'Helm', 'Rossenbauer', '7057', '', '49', 'A2BZ', '2025-05-04 18:38:31');
INSERT INTO `psa_ausruestung` VALUES ('71', 'Helmlampe', 'Petzel', '7115', '', '49', 'A2BZ', '2025-05-04 18:38:45');
INSERT INTO `psa_ausruestung` VALUES ('72', 'Helm', 'Rossenbauer', '7099', '', '50', 'A2BZ', '2025-05-04 18:40:04');
INSERT INTO `psa_ausruestung` VALUES ('73', 'Helmlampe', 'Petzel', '7133', '', '50', 'A2BZ', '2025-05-04 18:40:20');
INSERT INTO `psa_ausruestung` VALUES ('74', 'Helm', 'Rossenbauer', '7077', '', '51', 'A2BZ', '2025-05-04 18:41:50');
INSERT INTO `psa_ausruestung` VALUES ('75', 'Helmlampe', 'Petzel', '7100', '', '51', 'A2BZ', '2025-05-04 18:42:04');
INSERT INTO `psa_ausruestung` VALUES ('76', 'Helm', 'Rossenbauer', '7098', '', '52', 'A2BZ', '2025-05-04 18:43:28');
INSERT INTO `psa_ausruestung` VALUES ('77', 'Helmlampe', 'Petzel', '7144', '', '52', 'A2BZ', '2025-05-04 18:43:39');
INSERT INTO `psa_ausruestung` VALUES ('78', 'Helm', 'Rossenbauer', '7010', '', '53', 'A2BZ', '2025-05-04 18:45:02');
INSERT INTO `psa_ausruestung` VALUES ('79', 'Helmlampe', 'Petzel', '7192', '', '53', 'A2BZ', '2025-05-04 18:45:17');
INSERT INTO `psa_ausruestung` VALUES ('80', 'Helm', 'Rossenbauer', '7053', '', '56', 'A2BZ', '2025-05-04 18:46:37');
INSERT INTO `psa_ausruestung` VALUES ('81', 'Helmlampe', 'Petzel', '7128', '', '54', 'A2BZ', '2025-05-04 18:46:50');
INSERT INTO `psa_ausruestung` VALUES ('82', 'Helm', 'Rossenbauer', '7088', '', '55', 'A2BZ', '2025-05-04 18:48:19');
INSERT INTO `psa_ausruestung` VALUES ('83', 'Helmlampe', 'Petzel', '7162', '', '55', 'A2BZ', '2025-05-04 18:48:31');
INSERT INTO `psa_ausruestung` VALUES ('84', 'Helm', 'Rossenbauer', '7053', '', '56', 'A2BZ', '2025-05-04 18:50:01');
INSERT INTO `psa_ausruestung` VALUES ('85', 'Helmlampe', 'Petzel', '7128', '', '56', 'A2BZ', '2025-05-04 18:50:16');
INSERT INTO `psa_ausruestung` VALUES ('86', 'Helm', 'Rossenbauer', '7040', '', '58', 'A2BZ', '2025-05-04 18:51:47');
INSERT INTO `psa_ausruestung` VALUES ('87', 'Helmlampe', 'Petzel', '7198', '', '58', 'A2BZ', '2025-05-04 18:52:01');
INSERT INTO `psa_ausruestung` VALUES ('88', 'Helm', 'Rossenbauer', '7034', '', '59', 'A2BZ', '2025-05-04 18:53:18');
INSERT INTO `psa_ausruestung` VALUES ('89', 'Helmlampe', 'Petzel', '7103', '', '59', 'A2BZ', '2025-05-04 18:53:35');
INSERT INTO `psa_ausruestung` VALUES ('90', 'Helm', 'Rossenbauer', '7043', '', '60', 'A2BZ', '2025-05-04 18:54:49');
INSERT INTO `psa_ausruestung` VALUES ('91', 'Helmlampe', 'Petzel', '7170', '', '60', 'A2BZ', '2025-05-04 18:55:03');
INSERT INTO `psa_ausruestung` VALUES ('92', 'Helm', 'Rossenbauer', '7009', '', '61', 'A2BZ', '2025-05-04 18:56:39');
INSERT INTO `psa_ausruestung` VALUES ('93', 'Helmlampe', 'Petzel', '7122', '', '61', 'A2BZ', '2025-05-04 18:56:51');
INSERT INTO `psa_ausruestung` VALUES ('94', 'Helm', 'Rossenbauer', '7024', '', '62', 'A2BZ', '2025-05-04 18:58:22');
INSERT INTO `psa_ausruestung` VALUES ('95', 'Helmlampe', 'Petzel', '7177', '', '62', 'A2BZ', '2025-05-04 18:58:37');
INSERT INTO `psa_ausruestung` VALUES ('96', 'Helm', 'Rossenbauer', '7029', '', '64', 'A2BZ', '2025-05-04 19:00:17');
INSERT INTO `psa_ausruestung` VALUES ('97', 'Helmlampe', 'Petzel', '7113', '', '64', 'A2BZ', '2025-05-04 19:00:30');
INSERT INTO `psa_ausruestung` VALUES ('98', 'Helm', 'Rossenbauer', '7045', '', '65', 'A2BZ', '2025-05-04 19:02:05');
INSERT INTO `psa_ausruestung` VALUES ('99', 'Helmlampe', 'Petzel', '7110', '', '65', 'A2BZ', '2025-05-04 19:02:20');
INSERT INTO `psa_ausruestung` VALUES ('100', 'Helm', 'Rossenbauer', '7016', '', '71', 'A2BZ', '2025-05-04 19:04:10');
INSERT INTO `psa_ausruestung` VALUES ('101', 'Helmlampe', 'Petzel', '7154', '', '71', 'A2BZ', '2025-05-04 19:04:31');
INSERT INTO `psa_ausruestung` VALUES ('102', 'Helm', 'Rossenbauer', '7064', '', '70', 'A2BZ', '2025-05-04 19:06:04');
INSERT INTO `psa_ausruestung` VALUES ('103', 'Helmlampe', 'Petzel', '7123', '', '69', 'A2BZ', '2025-05-04 19:08:16');
INSERT INTO `psa_ausruestung` VALUES ('104', 'Helm', 'Rossenbauer', '7096', '', '57', 'A2BZ', '2025-05-04 19:10:39');
INSERT INTO `psa_ausruestung` VALUES ('105', 'Helmlampe', 'Petzel', '7189', '', '57', 'A2BZ', '2025-05-04 19:10:52');
INSERT INTO `psa_ausruestung` VALUES ('106', 'Helm', 'Rossenbauer', '7062', '', '1', 'A2BZ', '2025-05-04 19:11:58');
INSERT INTO `psa_ausruestung` VALUES ('107', 'Helmlampe', 'Petzel', '7196', '', '1', 'A2BZ', '2025-05-04 19:12:16');
INSERT INTO `psa_ausruestung` VALUES ('108', 'Helm', 'Rossenbauer', '7089', '', '3', 'A2BZ', '2025-05-04 19:12:44');
INSERT INTO `psa_ausruestung` VALUES ('109', 'Helmlampe', 'Petzel', '7168', '', '3', 'A2BZ', '2025-05-04 19:12:58');
INSERT INTO `psa_ausruestung` VALUES ('110', 'Helmlampe', 'Petzel', '7179', '', '4', 'A2BZ', '2025-05-04 19:13:26');
INSERT INTO `psa_ausruestung` VALUES ('111', 'Helm', 'Rossenbauer', '7044', '', '5', 'A2BZ', '2025-05-04 19:13:43');
INSERT INTO `psa_ausruestung` VALUES ('112', 'Helmlampe', 'Petzel', '7167', '', '5', 'A2BZ', '2025-05-04 19:13:56');
INSERT INTO `psa_ausruestung` VALUES ('113', 'Helm', 'Rossenbauer', '7091', '', '7', 'A2BZ', '2025-05-04 19:14:36');
INSERT INTO `psa_ausruestung` VALUES ('114', 'Helmlampe', 'Petzel', '7155', '', '7', 'A2BZ', '2025-05-04 19:14:54');
INSERT INTO `psa_ausruestung` VALUES ('115', 'Helm', 'Rossenbauer', '7074', '', '8', 'A2BZ', '2025-05-04 19:15:15');
INSERT INTO `psa_ausruestung` VALUES ('116', 'Helmlampe', 'Petzel', '7165', '', '8', 'A2BZ', '2025-05-04 19:15:37');
INSERT INTO `psa_ausruestung` VALUES ('117', 'Helm', 'Rossenbauer', '7070', '', '9', 'A2BZ', '2025-05-04 19:15:58');
INSERT INTO `psa_ausruestung` VALUES ('118', 'Helmlampe', 'Petzel', '7152', '', '9', 'A2BZ', '2025-05-04 19:16:13');
INSERT INTO `psa_ausruestung` VALUES ('119', 'Helm', 'Rossenbauer', '7061', '', '10', 'A2BZ', '2025-05-04 19:16:33');
INSERT INTO `psa_ausruestung` VALUES ('120', 'Helmlampe', 'Petzel', '7149', '', '10', 'A2BZ', '2025-05-04 19:16:45');
INSERT INTO `psa_ausruestung` VALUES ('121', 'Helm', 'Rossenbauer', '7049', '', '11', 'A2BZ', '2025-05-04 19:17:02');
INSERT INTO `psa_ausruestung` VALUES ('122', 'Helmlampe', 'Petzel', '7166', '', '11', 'A2BZ', '2025-05-04 19:17:13');
INSERT INTO `psa_ausruestung` VALUES ('123', 'Helm', 'Rossenbauer', '7046', '', '12', 'A2BZ', '2025-05-04 19:17:34');
INSERT INTO `psa_ausruestung` VALUES ('124', 'Helm', 'Rossenbauer', '7002', '', '13', 'A2BZ', '2025-05-04 19:18:03');
INSERT INTO `psa_ausruestung` VALUES ('125', 'Helmlampe', 'Petzel', '7188', '', '13', 'A2BZ', '2025-05-04 19:18:17');


DROP TABLE IF EXISTS `raum_buchungen`;
CREATE TABLE `raum_buchungen` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `raum` varchar(100) NOT NULL,
  `thema` varchar(255) NOT NULL,
  `zeit` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `raum_buchungen` VALUES ('1', 'Nils Bonk', 'Schulungsraum', 'FüSt Ausbildung', '2025-05-17 22:39:56');


DROP TABLE IF EXISTS `ticket_kommentare`;
CREATE TABLE `ticket_kommentare` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ticket_id` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `kommentar` text NOT NULL,
  `erstellt_am` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

INSERT INTO `ticket_kommentare` VALUES ('1', '1', '1', 'test kommentar', '2025-04-27 08:42:39');


DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) NOT NULL,
  `password` varchar(255) NOT NULL,
  `is_admin` tinyint(1) DEFAULT 0,
  `feuerwehr_id` varchar(255) NOT NULL,
  `gemeinde_id` varchar(255) NOT NULL,
  `lk_id` varchar(255) NOT NULL,
  `einheit` varchar(255) NOT NULL,
  `vorname` varchar(255) NOT NULL,
  `nachname` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `bereich` varchar(255) NOT NULL,
  `rolle` int(11) DEFAULT 5,
  `eingeloggt` tinyint(1) DEFAULT 0,
  `rfid_card` varchar(255) NOT NULL,
  `root` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `username` (`username`),
  KEY `feuerwehr_id` (`feuerwehr_id`)
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `users` VALUES ('1', 'nils.bonk', '$2y$10$l/OPZshXLb.1t4k7dbnAAuZjYzO/V5PIYOywrMW7uIKAmO8hNTgum', '1', 'A2BZ', 'Bad Zwischenahn', 'Landkreis Ammerland', 'A2BZ', 'Nils', 'Bonk', 'nils.bonk@me.com', '0', '5', '0', '0006776212', '1');
INSERT INTO `users` VALUES ('13', 'thede.meischen', '$2y$10$92fxgxZgClvla3WMkBPHmOzQ0YX5KYlxSylsWPkA8JsGgcpyWpbkC', '0', 'A2BZ', 'Bad Zwischenahn', 'Landkreis Ammerland', 'A2BZ', 'Thede', 'Meischen', 'thede.meischen@web.de', 'PSA', '2', '1', '', '0');
INSERT INTO `users` VALUES ('14', 'janhendrik.friedrich', '$2y$10$Jzo4K7prGzOrvZtuXcnoguiWtOVU1AWTuUOC9oJMGLm6A0Gq3itLi', '0', 'A2BZ', 'Bad Zwischenahn', 'Landkreis Ammerland', 'A2BZ', 'Jan Hendrik', 'Friedrich', 'janhendrikfriedrich@t-online.de', 'Geräteverwaltung', '1', '0', '', '0');
INSERT INTO `users` VALUES ('15', 'tim.coelsmann', '$2y$10$GAs/PbD54I47dYAM0WyJr.P7HLnw/80cbeV774i5BdTwUZAUxvWti', '1', 'A2BZ', 'Bad Zwischenahn', 'Landkreis Ammerland', 'A2BZ', 'Tim', 'Cölsmann', 'tim.coelsmann@t-online.de', 'Ortsbrandmeister', '1', '1', '', '0');
INSERT INTO `users` VALUES ('16', 'janine.tapken-meier', '$2y$10$6Cjhax2pgYGm3zqYsRf3UefAJvyCfDCSKMp4Efa3Q2xUGWojlVBUK', '0', '', '', '', 'A2BZ', 'Janine', 'Tapken-Meier', 'janine-Meier1993@outlook.de', 'Kleiderkammer', '3', '0', '', '0');
INSERT INTO `users` VALUES ('17', 'dummy.user', '$2y$10$OJnxTAigWCVRovAVvTydUeslBQJXGH7nfAWFvD59GuF3r1TVBBYdS', '0', '', '', '', 'A2BZ', 'Dummy', 'User', 'nils.bonk@googlemail.com', 'Test', '1', '0', '', '0');


DROP TABLE IF EXISTS `zeiterfassung`;
CREATE TABLE `zeiterfassung` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `kamerad_id` int(11) NOT NULL,
  `startzeit` datetime NOT NULL,
  `endzeit` datetime DEFAULT NULL,
  `manuell` tinyint(1) DEFAULT 0,
  `kostenstelle_id` int(11) DEFAULT NULL,
  `angelegt_am` datetime DEFAULT current_timestamp(),
  `rfid_card` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `kostenstelle_id` (`kostenstelle_id`)
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

INSERT INTO `zeiterfassung` VALUES ('1', '1', '2025-05-01 11:50:26', '2025-05-01 11:50:31', '0', '5', '2025-05-01 11:50:26', '');
INSERT INTO `zeiterfassung` VALUES ('2', '1', '2025-05-01 09:00:00', '2025-05-01 12:00:00', '1', '5', '2025-05-01 11:50:48', '');
INSERT INTO `zeiterfassung` VALUES ('3', '1', '2025-04-30 07:00:00', '2025-04-30 18:00:00', '1', '2', '2025-05-01 11:51:45', '');
INSERT INTO `zeiterfassung` VALUES ('4', '1', '2025-04-28 10:00:00', '2025-04-28 19:00:00', '1', '6', '2025-05-01 11:55:07', '');
INSERT INTO `zeiterfassung` VALUES ('5', '1', '2025-05-02 07:00:00', '2025-05-02 18:00:00', '1', '6', '2025-05-03 07:25:12', '');
INSERT INTO `zeiterfassung` VALUES ('6', '1', '2025-05-04 11:43:22', '2025-05-04 11:43:43', '0', '1', '2025-05-04 11:43:22', '');
INSERT INTO `zeiterfassung` VALUES ('7', '1', '2025-05-04 11:44:59', '2025-05-04 11:45:24', '0', '1', '2025-05-04 11:44:59', '');
INSERT INTO `zeiterfassung` VALUES ('8', '1', '2025-05-04 11:46:16', '2025-05-04 11:46:41', '0', '1', '2025-05-04 11:46:16', '');
INSERT INTO `zeiterfassung` VALUES ('9', '1', '2025-05-04 11:51:55', '2025-05-04 11:52:53', '0', '1', '2025-05-04 11:51:55', '');
INSERT INTO `zeiterfassung` VALUES ('10', '1', '2025-05-04 11:56:02', '2025-05-04 11:57:39', '0', '1', '2025-05-04 11:56:02', '');
INSERT INTO `zeiterfassung` VALUES ('11', '1', '2025-05-04 11:59:19', '2025-05-04 11:59:21', '0', '1', '2025-05-04 11:59:19', '');
INSERT INTO `zeiterfassung` VALUES ('12', '1', '2025-05-04 11:59:23', '2025-05-04 11:59:40', '0', '1', '2025-05-04 11:59:23', '');
INSERT INTO `zeiterfassung` VALUES ('13', '1', '2025-05-04 11:59:44', '2025-05-04 11:59:47', '0', '1', '2025-05-04 11:59:44', '');
INSERT INTO `zeiterfassung` VALUES ('14', '13', '2025-05-04 08:00:00', '2025-05-04 13:30:00', '1', '8', '2025-05-04 14:10:39', '');
INSERT INTO `zeiterfassung` VALUES ('15', '13', '2025-05-04 14:11:25', '2025-05-04 14:11:32', '0', '7', '2025-05-04 14:11:25', '');
INSERT INTO `zeiterfassung` VALUES ('16', '13', '2025-05-04 16:47:38', '2025-05-04 19:19:53', '0', '6', '2025-05-04 16:47:38', '');
INSERT INTO `zeiterfassung` VALUES ('17', '1', '2025-05-17 19:11:00', '2025-05-17 21:11:00', '1', '6', '2025-05-17 21:11:28', '');


