<?php
include '../includes/header.php';
include '../includes/nav.php';
?>

<div class="container my-5">
  <h1 class="mb-4 text-center">🦺 Hilfe zur PSA-Verwaltung</h1>

  <div class="accordion" id="psaHelpAccordion">
    <!-- Einführung -->
    <div class="accordion-item">
      <h2 class="accordion-header" id="headingIntro">
        <button class="accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseIntro" aria-expanded="true">
          🔰 Einführung
        </button>
      </h2>
      <div id="collapseIntro" class="accordion-collapse collapse show" data-bs-parent="#psaHelpAccordion">
        <div class="accordion-body">
          In der PSA-Verwaltung kannst du persönliche Schutzausrüstung für alle Kamerad:innen verwalten. Die PSA ist nach Typ sortiert und enthält Hersteller, Modell, Größe und Spindnummer.
        </div>
      </div>
    </div>

    <!-- Neue PSA hinzufügen -->
    <div class="accordion-item">
      <h2 class="accordion-header" id="headingAdd">
        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseAdd">
          ➕ Neue PSA hinzufügen
        </button>
      </h2>
      <div id="collapseAdd" class="accordion-collapse collapse" data-bs-parent="#psaHelpAccordion">
        <div class="accordion-body">
          <ol>
            <li>Klicke auf <strong>„+ Neue PSA“</strong></li>
            <li>Wähle den Typ (z. B. Helm, Einsatzjacke)</li>
            <li>Fülle die Felder wie Hersteller, Modell, Größe etc. aus</li>
            <li>Klicke auf <strong>„Speichern“</strong></li>
          </ol>
          Die Einträge erscheinen automatisch im passenden Tab.
        </div>
      </div>
    </div>

    <!-- PSA bearbeiten -->
    <div class="accordion-item">
      <h2 class="accordion-header" id="headingEdit">
        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseEdit">
          ✏️ PSA bearbeiten
        </button>
      </h2>
      <div id="collapseEdit" class="accordion-collapse collapse" data-bs-parent="#psaHelpAccordion">
        <div class="accordion-body">
          <ol>
            <li>Klicke auf das <strong>Bearbeiten-Symbol (🖊)</strong> neben einem Eintrag</li>
            <li>Nimm die gewünschten Änderungen vor</li>
            <li>Speichere mit dem Button unten im Formular</li>
          </ol>
        </div>
      </div>
    </div>

    <!-- Tipps -->
    <div class="accordion-item">
      <h2 class="accordion-header" id="headingTips">
        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseTips">
          💡 Tipps & Hinweise
        </button>
      </h2>
      <div id="collapseTips" class="accordion-collapse collapse" data-bs-parent="#psaHelpAccordion">
        <div class="accordion-body">
          <ul>
            <li>Verwende eindeutige <strong>Spindnummern</strong> zur Zuordnung</li>
            <li>Markiere defekte PSA über den <strong>Status</strong></li>
            <li>Nutze den Typ-Filter, um schneller durch Kategorien zu navigieren</li>
          </ul>
        </div>
      </div>
    </div>

    <!-- Kontakt -->
    <div class="accordion-item">
      <h2 class="accordion-header" id="headingSupport">
        <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSupport">
          📞 Support kontaktieren
        </button>
      </h2>
      <div id="collapseSupport" class="accordion-collapse collapse" data-bs-parent="#psaHelpAccordion">
        <div class="accordion-body">
          Wenn du technische Probleme hast oder Unterstützung brauchst, wende dich bitte an: <br>
          <a href="mailto:support@dein-system.de">support@dein-system.de</a> oder nutze das <a href="feedback.php">Feedback-Formular</a>.
        </div>
      </div>
    </div>
  </div>
</div>

<?php include '../includes/footer.php'; ?>
