<?php
include 'includes/db.php';

// Artikel-ID auslesen
$id = (int)($_GET['id'] ?? 0);

if ($id <= 0) {
    die('Ungültige ID');
}

// Artikelname holen für Dateiname
$stmt = $conn->prepare("SELECT artikelname FROM lager_bestand WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$res = $stmt->get_result();
$artikel = $res->fetch_assoc();

if (!$artikel) {
    die('Artikel nicht gefunden');
}

// Historie abrufen
$stmt_hist = $conn->prepare("SELECT h.*, k.vorname, k.nachname FROM lager_historie h
LEFT JOIN kameraden k ON h.kamerad_id = k.id
WHERE h.lager_id = ?
ORDER BY h.datum ASC");
$stmt_hist->bind_param("i", $id);
$stmt_hist->execute();
$historie = $stmt_hist->get_result();

// Header für CSV-Download
header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename="Historie_' . preg_replace('/[^A-Za-z0-9]/', '_', $artikel['artikelname']) . '.csv"');

$output = fopen('php://output', 'w');

// Kopfzeile schreiben
fputcsv($output, ['Datum', 'Buchungstyp', 'Anzahl', 'Kamerad', 'Bemerkung']);

// Daten schreiben
while ($row = $historie->fetch_assoc()) {
    $kamerad = $row['vorname'] && $row['nachname'] ? $row['vorname'] . ' ' . $row['nachname'] : '-';
    fputcsv($output, [
        date('d.m.Y H:i', strtotime($row['datum'])),
        $row['buchungstyp'],
        $row['anzahl'],
        $kamerad,
        $row['bemerkung']
    ]);
}

fclose($output);
exit;
?>
