<?php
session_start();
include '../includes/db.php';

$meldung = '';

// E-Mail hinzufügen
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['email_hinzufuegen'])) {
    $typ = $_POST['typ'];
    $email = trim($_POST['email']);
    $aktiv = isset($_POST['aktiv']) ? 1 : 0;

    if (filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $stmt = $conn->prepare("INSERT INTO ticket_mail_empfaenger (typ, email, aktiv) VALUES (?, ?, ?)");
        $stmt->bind_param("ssi", $typ, $email, $aktiv);
        $stmt->execute();
        $meldung = "<div class='alert alert-success'>Empfänger hinzugefügt.</div>";
    } else {
        $meldung = "<div class='alert alert-danger'>Ungültige E-Mail-Adresse.</div>";
    }
}

// Löschen
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $conn->query("DELETE FROM ticket_mail_empfaenger WHERE id = $id");
    $meldung = "<div class='alert alert-info'>Empfänger entfernt.</div>";
}

// Aktiv/Inaktiv umschalten
if (isset($_GET['toggle'])) {
    $id = intval($_GET['toggle']);
    $conn->query("UPDATE ticket_mail_empfaenger SET aktiv = NOT aktiv WHERE id = $id");
    $meldung = "<div class='alert alert-secondary'>Empfängerstatus geändert.</div>";
}

$empfaenger = $conn->query("SELECT * FROM ticket_mail_empfaenger ORDER BY typ, id");
?>

<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="UTF-8">
  <title>Ticket-Mail Empfänger</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="p-4 bg-light">
  <div class="container bg-white p-4 rounded shadow">
    <h2 class="mb-4">📧 Ticket-Mail Empfänger</h2>
    <?= $meldung ?>
    <form method="POST" class="row g-3 mb-4">
      <div class="col-md-2">
        <select name="typ" class="form-select" required>
          <option value="standard">Standard</option>
          <option value="bcc">BCC</option>
        </select>
      </div>
      <div class="col-md-6">
        <input type="email" name="email" class="form-control" placeholder="E-Mail-Adresse" required>
      </div>
      <div class="col-md-2 form-check pt-2">
        <input class="form-check-input" type="checkbox" name="aktiv" id="aktiv" checked>
        <label class="form-check-label" for="aktiv">Aktiv</label>
      </div>
      <div class="col-md-2">
        <button name="email_hinzufuegen" class="btn btn-primary w-100">➕ Hinzufügen</button>
      </div>
    </form>

    <table class="table table-bordered table-hover">
      <thead class="table-secondary">
        <tr>
          <th>#</th>
          <th>Typ</th>
          <th>E-Mail</th>
          <th>Status</th>
          <th>Aktionen</th>
        </tr>
      </thead>
      <tbody>
        <?php while ($row = $empfaenger->fetch_assoc()): ?>
          <tr>
            <td><?= $row['id'] ?></td>
            <td><?= ucfirst($row['typ']) ?></td>
            <td><?= htmlspecialchars($row['email']) ?></td>
            <td>
              <a href="?toggle=<?= $row['id'] ?>" class="badge <?= $row['aktiv'] ? 'bg-success' : 'bg-secondary' ?>">
                <?= $row['aktiv'] ? 'Aktiv' : 'Inaktiv' ?>
              </a>
            </td>
            <td>
              <a href="?delete=<?= $row['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Wirklich löschen?')">🗑️ Entfernen</a>
            </td>
          </tr>
        <?php endwhile; ?>
      </tbody>
    </table>
  </div>
</body>
</html>
