<?php
if (!isset($_SESSION)) session_start();
if (!isset($_SESSION['user_id']) || $_SESSION['root'] != 1) {
    echo "<div class='alert alert-danger text-center m-4'>⛔ Kein Zugriff – Adminrechte erforderlich.</div>";
    exit;
}
?>

<nav class="navbar navbar-expand-lg navbar-dark bg-dark mb-4">
  <div class="container-fluid">
    <a class="navbar-brand" href="/admin">⚙ Adminbereich</a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#adminNavbar" aria-controls="adminNavbar" aria-expanded="false" aria-label="Toggle navigation">
      <span class="navbar-toggler-icon"></span>
    </button>

    <div class="collapse navbar-collapse" id="adminNavbar">
      <ul class="navbar-nav me-auto mb-2 mb-lg-0">

        <li class="nav-item">
          <a class="nav-link" href="/admin/admin_users.php">👤 Benutzer</a>
        </li>

        <li class="nav-item">
          <a class="nav-link" href="/admin/admin_rollen.php">🔐 Rollen</a>
        </li>

        <li class="nav-item">
          <a class="nav-link" href="/admin/admin_rechte.php">🧩 Rechteverwaltung</a>
        </li>

        <li class="nav-item">
          <a class="nav-link" href="/admin/admin_log.php">📜 Audit-Log</a>
        </li>

      </ul>

      <span class="navbar-text text-light me-3">
        👋 <?php echo $_SESSION['user_vorname'] ?? 'Admin'; ?>
      </span>
      <a href="/logout.php" class="btn btn-sm btn-outline-light">Logout</a>
    </div>
  </div>
</nav>
