<?php
session_start();

// Prüfe, ob der Nutzer eingeloggt ist
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    die("❌ Zugriff verweigert. Bitte einloggen!");
}

// Lade Besucherdaten
$file = 'visitors.json';
$data = file_exists($file) ? json_decode(file_get_contents($file), true) : [];

// Besucherliste abrufen & nach Zeitstempel absteigend sortieren
$visitors = isset($data['visitors']) ? $data['visitors'] : [];
usort($visitors, function($a, $b) {
    return $b['last_seen'] - $a['last_seen']; // Neueste zuerst
});

// Tages- und Monatsstatistiken abrufen
$dailyStats = isset($data['stats']['daily']) ? $data['stats']['daily'] : [];
$monthlyStats = isset($data['stats']['monthly']) ? $data['stats']['monthly'] : [];

?>
<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Live Besucher-Ansicht</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            text-align: center;
            margin: 0;
            padding: 20px;
            background: #f4f4f4;
        }
        .container {
            max-width: 900px;
            margin: auto;
            background: white;
            border-radius: 10px;
            padding: 20px;
            box-shadow: 0px 4px 10px rgba(0,0,0,0.1);
        }
        h2 {
            color: #333;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
        }
        th, td {
            border: 1px solid #ddd;
            padding: 10px;
            text-align: left;
        }
        th {
            background: #007aff;
            color: white;
        }
        tr:nth-child(even) {
            background: #f9f9f9;
        }
        .refresh {
            margin-top: 10px;
            padding: 10px;
            border: none;
            background: #007aff;
            color: white;
            font-size: 16px;
            border-radius: 5px;
            cursor: pointer;
        }
        .refresh:hover {
            background: #0056b3;
        }
        .stats {
            text-align: left;
            margin-top: 20px;
        }
        .stats h3 {
            margin-bottom: 5px;
            color: #007aff;
        }
        .stats p {
            background: #f1f1f1;
            padding: 10px;
            border-radius: 5px;
        }
    </style>
</head>
<body>

    <div class="container">
        <h2>📡 Live Besucher-Ansicht</h2>
        <button class="refresh" onclick="location.reload()">🔄 Aktualisieren</button>

        <div class="stats">
            <h3>📆 Besuchszahlen</h3>
            <p><strong>Heute:</strong> <?php echo $dailyStats[date("Y-m-d")] ?? 0; ?> Besucher</p>
            <p><strong>Diesen Monat:</strong> <?php echo $monthlyStats[date("Y-m")] ?? 0; ?> Besucher</p>
        </div>

        <h3>👥 Letzte Besucher (Neueste oben)</h3>
        <table>
            <tr>
                <th>IP-Adresse</th>
                <th>Endgerät / Browser</th>
                <th>Letzte Aktivität</th>
            </tr>
            <?php foreach ($visitors as $visitor) { ?>
                <tr>
                    <td><?php echo $visitor['ip']; ?></td>
                    <td><?php echo $visitor['user_agent']; ?></td>
                    <td><?php echo date("d.m.Y H:i:s", $visitor['last_seen']); ?></td>
                </tr>
            <?php } ?>
        </table>
    </div>

</body>
</html>
