<?php
// geraete_bild_upload_barcode.php – Bildupload pro Gerät via Barcode (mobiloptimiert + Resize)

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// -------------------- DB-Verbindung --------------------
$host = 'localhost';
$user = 'kd54698_cloud';
$pass = 'w3r24asd!!!';
$db   = 'kd54698_cloud';

$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    die("Verbindung fehlgeschlagen: " . $conn->connect_error);
}
$conn->set_charset("utf8mb4");

// -------------------- Basis / Helper --------------------
if (session_status() !== PHP_SESSION_ACTIVE) {
    session_start();
}

function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

// Upload-Zielordner (URL + physisch) – Pfad bei Bedarf anpassen
$uploadDirFs  = __DIR__ . '/uploads/geraete/'; // Physischer Pfad
$uploadDirUrl = '../lernapp/uploads/geraete/';           // URL im Browser

if (!is_dir($uploadDirFs)) {
    @mkdir($uploadDirFs, 0775, true);
}

$msg = '';
$err = '';

// Einheit aus Session (optional, falls du nur deine Einheit willst)
$sessionEinheit = $_SESSION['einheit'] ?? '';

// -------------------- Bild verkleinern (Helper) --------------------
/**
 * Verkleinert ein Bild aus $srcTmp und speichert es als $destPath.
 * Maximalbreite/-höhe wird über $maxW / $maxH begrenzt.
 */
function resize_image_upload(string $srcTmp, string $destPath, int $maxW = 1600, int $maxH = 1600): bool
{
    $imgInfo = @getimagesize($srcTmp);
    if ($imgInfo === false) {
        return false;
    }

    [$width, $height] = $imgInfo;
    $mime = $imgInfo['mime'] ?? '';

    // Wenn das Bild bereits klein genug ist → einfach kopieren (schneller)
    if ($width <= $maxW && $height <= $maxH) {
        return move_uploaded_file($srcTmp, $destPath);
    }

    // Seitenverhältnis beibehalten
    $ratio = $width / $height;
    $newW = $maxW;
    $newH = (int)round($maxW / $ratio);

    if ($newH > $maxH) {
        $newH = $maxH;
        $newW = (int)round($maxH * $ratio);
    }

    // Ursprungsbild je nach Typ laden
    switch ($mime) {
        case 'image/jpeg':
        case 'image/pjpeg':
            $srcImg = @imagecreatefromjpeg($srcTmp);
            break;
        case 'image/png':
            $srcImg = @imagecreatefrompng($srcTmp);
            break;
        case 'image/gif':
            $srcImg = @imagecreatefromgif($srcTmp);
            break;
        case 'image/webp':
            if (function_exists('imagecreatefromwebp')) {
                $srcImg = @imagecreatefromwebp($srcTmp);
            } else {
                return false;
            }
            break;
        default:
            return false;
    }

    if (!$srcImg) {
        return false;
    }

    $dstImg = imagecreatetruecolor($newW, $newH);

    // Transparenz für PNG/GIF/WebP erhalten
    if (in_array($mime, ['image/png', 'image/gif', 'image/webp'], true)) {
        imagecolortransparent($dstImg, imagecolorallocatealpha($dstImg, 0, 0, 0, 127));
        imagealphablending($dstImg, false);
        imagesavealpha($dstImg, true);
    }

    imagecopyresampled($dstImg, $srcImg, 0, 0, 0, 0, $newW, $newH, $width, $height);

    // Ausgabe je nach Typ
    $ok = false;
    switch ($mime) {
        case 'image/jpeg':
        case 'image/pjpeg':
            $ok = imagejpeg($dstImg, $destPath, 82); // Qualität 0–100
            break;
        case 'image/png':
            $ok = imagepng($dstImg, $destPath, 6);   // Kompression 0–9
            break;
        case 'image/gif':
            $ok = imagegif($dstImg, $destPath);
            break;
        case 'image/webp':
            if (function_exists('imagewebp')) {
                $ok = imagewebp($dstImg, $destPath, 80);
            }
            break;
    }

    imagedestroy($srcImg);
    imagedestroy($dstImg);

    // tmp-Upload danach entfernen, falls noch vorhanden
    if (is_file($srcTmp)) {
        @unlink($srcTmp);
    }

    return $ok;
}

// -------------------- Barcode-Suche & Upload --------------------
$currentBarcode = trim($_GET['barcode'] ?? '');
$currentDevice  = null;

// Upload-Verarbeitung
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $geraetId = (int)($_POST['geraet_id'] ?? 0);
    $currentBarcode = trim($_POST['barcode'] ?? '');

    if ($geraetId <= 0) {
        $err = 'Gerät nicht gefunden. Bitte Barcode neu scannen/eingeben.';
    } elseif (empty($_FILES['bild']['name'])) {
        $err = 'Bitte eine Bilddatei auswählen.';
    } elseif ($_FILES['bild']['error'] !== UPLOAD_ERR_OK) {
        $err = 'Fehler beim Upload (Fehlercode: '.$_FILES['bild']['error'].').';
    } else {
        $fileTmp  = $_FILES['bild']['tmp_name'];
        $fileName = $_FILES['bild']['name'];
        $fileSize = (int)$_FILES['bild']['size'];

        // max. 8 MB
        if ($fileSize <= 0 || $fileSize > 8 * 1024 * 1024) {
            $err = 'Die Datei ist zu groß oder ungültig (max. 8 MB).';
        } else {
            $ext = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));
            $allowedExt = ['jpg','jpeg','png','gif','webp'];

            if (!in_array($ext, $allowedExt, true)) {
                $err = 'Nur JPG, JPEG, PNG, GIF oder WEBP sind erlaubt.';
            } else {
                $imgInfo = @getimagesize($fileTmp);
                if ($imgInfo === false) {
                    $err = 'Die Datei scheint kein gültiges Bild zu sein.';
                } else {
                    $rand = bin2hex(random_bytes(6));
                    $targetName = 'geraet_'.$geraetId.'_'.$rand.'.'.$ext;
                    $targetPath = $uploadDirFs . $targetName;

                    // Altes Bild aus DB holen
                    $oldImg = null;
                    $stmtOld = $conn->prepare("SELECT bild FROM ffw_geraete WHERE id = ?");
                    $stmtOld->bind_param('i', $geraetId);
                    $stmtOld->execute();
                    $resOld = $stmtOld->get_result()->fetch_assoc();
                    $stmtOld->close();
                    if ($resOld && !empty($resOld['bild']) && $resOld['bild'] !== 'kein-bild.svg') {
                        $oldImg = $resOld['bild'];
                    }

                    // === Neu: Bild beim Speichern verkleinern ===
                    $resizeOk = resize_image_upload($fileTmp, $targetPath, 1600, 1600);

                    if (!$resizeOk || !is_file($targetPath)) {
                        $err = 'Die Datei konnte nicht gespeichert oder verarbeitet werden.';
                    } else {
                        @chmod($targetPath, 0644);

                        $stmt = $conn->prepare("UPDATE ffw_geraete SET bild = ? WHERE id = ?");
                        $stmt->bind_param('si', $targetName, $geraetId);
                        $stmt->execute();
                        $stmt->close();

                        // altes Bild löschen
                        if ($oldImg) {
                            $oldPath = $uploadDirFs . $oldImg;
                            if (is_file($oldPath)) {
                                @unlink($oldPath);
                            }
                        }

                        $msg = 'Bild erfolgreich hochgeladen, verkleinert und zugeordnet.';
                    }
                }
            }
        }
    }
}

// nach Upload oder bei GET: aktuelles Gerät via Barcode suchen
if ($currentBarcode !== '') {
    $sql = "
        SELECT id, barcode, bezeichnung, fahrzeug, einheit, gr, kat, bild, memo
        FROM ffw_geraete
        WHERE del = 0
          AND barcode = ?
    ";
    if ($sessionEinheit !== '') {
        $sql .= " AND einheit = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param('ss', $currentBarcode, $sessionEinheit);
    } else {
        $stmt = $conn->prepare($sql);
        $stmt->bind_param('s', $currentBarcode);
    }

    $stmt->execute();
    $res = $stmt->get_result();
    $devicesFound = $res->fetch_all(MYSQLI_ASSOC);
    $stmt->close();

    if (count($devicesFound) === 1) {
        $currentDevice = $devicesFound[0];
    } elseif (count($devicesFound) > 1) {
        // falls Barcode mehrfach vorkommt -> erstes nehmen und Hinweis anzeigen
        $currentDevice = $devicesFound[0];
        if (!$msg) {
            $msg = 'Hinweis: Mehrere Geräte mit diesem Barcode gefunden, es wird das erste angezeigt.';
        }
    } else {
        if (!$err && $currentBarcode !== '') {
            $err = 'Kein Gerät mit diesem Barcode gefunden.';
        }
    }
}
?>
<!doctype html>
<html lang="de">
<head>
  <meta charset="utf-8">
  <title>Geräte-Bild per Barcode hochladen</title>
  <meta name="viewport" content="width=device-width, initial-scale=1">

  <!-- Bootstrap CDN -->
  <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">

  <style>
    body {
      background: radial-gradient(circle at top, #f7fbff 0, #e3eefc 40%, #d6e4f5 100%);
      min-height: 100vh;
    }
    .page-container {
      max-width: 600px;
      margin: 0 auto;
      padding: 1rem;
    }
    .card-glass {
      background: rgba(255,255,255,0.92);
      backdrop-filter: blur(12px);
      border-radius: 18px;
      box-shadow: 0 10px 30px rgba(0,0,0,0.12);
      border: none;
    }
    .device-image-wrap {
      border-radius: 14px;
      overflow: hidden;
      background: #f3f4f6;
      display: flex;
      align-items: center;
      justify-content: center;
      max-height: 320px;
    }
    .device-image-wrap img {
      width: 100%;
      height: auto;
      object-fit: contain;
    }
    @media (max-width: 768px) {
      .page-container {
        padding: 0.75rem;
      }
    }
  </style>
</head>
<body>

<div class="page-container">

  <h1 class="h4 mb-3 text-center">Geräte-Bild per Barcode</h1>
  <p class="text-muted small text-center mb-4">
    Barcode scannen oder eintippen, Gerät wird gesucht und Bild kann hochgeladen werden.
  </p>

  <?php if ($msg): ?>
    <div class="alert alert-success py-2"><?= h($msg) ?></div>
  <?php endif; ?>
  <?php if ($err): ?>
    <div class="alert alert-danger py-2"><?= h($err) ?></div>
  <?php endif; ?>

  <!-- Barcode-Eingabe -->
  <div class="card card-glass mb-3">
    <div class="card-body">
      <form method="get" class="mb-0">
        <div class="mb-3">
          <label for="barcode" class="form-label">Barcode</label>
          <input
            type="text"
            class="form-control"
            id="barcode"
            name="barcode"
            value="<?= h($currentBarcode) ?>"
            inputmode="numeric"
            autocomplete="off"
            placeholder="Barcode scannen oder eingeben..."
            autofocus
          >
          <small class="text-muted">
            Tipp: Viele Handyscanner tragen den Barcode direkt in dieses Feld ein und senden mit Enter.
          </small>
        </div>
        <button type="submit" class="btn btn-primary w-100">
          🔍 Gerät suchen
        </button>
      </form>
    </div>
  </div>

  <?php if ($currentDevice): ?>
    <!-- Gerätedaten + Bildupload -->
    <div class="card card-glass mb-3">
      <div class="card-body">
        <h2 class="h5 mb-1"><?= h($currentDevice['bezeichnung']) ?></h2>
        <div class="small text-muted mb-2">
          Barcode: <?= h($currentDevice['barcode']) ?>
          <?php if (!empty($currentDevice['einheit'])): ?> · Einheit: <?= h($currentDevice['einheit']) ?><?php endif; ?>
          <?php if (!empty($currentDevice['fahrzeug'])): ?> · Fzg: <?= h($currentDevice['fahrzeug']) ?><?php endif; ?>
          <?php if (!empty($currentDevice['gr'])): ?> · GR: <?= h($currentDevice['gr']) ?><?php endif; ?>
          <?php if (!empty($currentDevice['kat'])): ?> · Kat: <?= h($currentDevice['kat']) ?><?php endif; ?>
        </div>

        <?php if (!empty($currentDevice['memo'])): ?>
          <p class="small mb-3"><?= nl2br(h($currentDevice['memo'])) ?></p>
        <?php endif; ?>

        <div class="mb-3">
          <label class="form-label">Aktuelles Bild</label>
          <div class="device-image-wrap mb-2">
            <?php if (!empty($currentDevice['bild']) && $currentDevice['bild'] !== 'kein-bild.svg'): ?>
              <img src="<?= h($uploadDirUrl.$currentDevice['bild']) ?>" alt="<?= h($currentDevice['bezeichnung']) ?>">
            <?php else: ?>
              <div class="text-muted small p-3">Noch kein Bild hinterlegt.</div>
            <?php endif; ?>
          </div>
          <small class="text-muted">Neues Bild hochladen, um das vorhandene zu ersetzen.</small>
        </div>

        <form method="post" enctype="multipart/form-data">
          <input type="hidden" name="geraet_id" value="<?= (int)$currentDevice['id'] ?>">
          <input type="hidden" name="barcode" value="<?= h($currentBarcode) ?>">

          <div class="mb-3">
            <label for="bild" class="form-label">Bild auswählen</label>
            <input type="file" class="form-control" id="bild" name="bild" accept="image/*" required>
            <small class="text-muted">Max. 8 MB, Formate: JPG, PNG, GIF, WEBP.</small>
          </div>

          <button type="submit" class="btn btn-success w-100">
            📷 Bild hochladen & speichern
          </button>
        </form>
      </div>
    </div>
  <?php elseif ($currentBarcode !== '' && !$err): ?>
    <div class="alert alert-info">
      Kein Gerät für diesen Barcode gefunden.
    </div>
  <?php endif; ?>

</div>

</body>
</html>
