<footer class="bg-light text-center py-4 mt-5 border-top">
    <div class="container">
        <p class="mb-1">&copy; <?php echo date("Y"); ?> cloud.F-Invent</p>
        <p class="small mb-0">
            ❓ Fragen? <a href="#" data-bs-toggle="modal" data-bs-target="#supportModal" class="text-decoration-none">Support kontaktieren</a>
        </p>

        <?php
        
        if (isset($_SESSION['root']) && $_SESSION['root'] == 1): ?>
            <p class="mt-3">
                <a href="/admin" target="_blank" class="btn btn-sm btn-outline-dark">🛠 Adminbereich öffnen</a>
            </p>
        <?php endif; ?>
    </div>
</footer>

<!-- Support Modal -->
<div class="modal fade" id="supportModal" tabindex="-1" aria-labelledby="supportModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form method="post" class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="supportModalLabel">Support-Anfrage senden</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Schließen"></button>
      </div>
      <div class="modal-body">
        <div class="mb-3">
          <label for="support_betreff" class="form-label">Betreff</label>
          <input type="text" name="support_betreff" id="support_betreff" class="form-control" required>
        </div>
        <div class="mb-3">
          <label for="support_nachricht" class="form-label">Nachricht</label>
          <textarea name="support_nachricht" id="support_nachricht" class="form-control" rows="4" required></textarea>
        </div>
        <?php
        if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['support_betreff'], $_POST['support_nachricht'])) {
            include_once __DIR__ . '/includes/db.php';
            $uid = $_SESSION['user_id'] ?? null;
            $betreff = trim($_POST['support_betreff']);
            $nachricht = trim($_POST['support_nachricht']);
            if ($betreff && $nachricht) {
                $stmt = $conn->prepare("INSERT INTO support_tickets (user_id, betreff, nachricht) VALUES (?, ?, ?)");
                $stmt->bind_param("iss", $uid, $betreff, $nachricht);
                $stmt->execute();
                echo "<div class='alert alert-success'>✅ Vielen Dank! Deine Anfrage wurde übermittelt.</div>";
            } else {
                echo "<div class='alert alert-danger'>⚠ Bitte alle Felder ausfüllen.</div>";
            }
        }
        ?>
      </div>
      <div class="modal-footer">
        <button type="submit" class="btn btn-primary" name="support_absenden">Absenden</button>
      </div>
    </form>
  </div>
</div>

<!-- Bootstrap JS -->
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
<?php ob_end_flush(); ?>
