<?php
session_start();
include 'includes/db.php';

if (!isset($_SESSION['user_id']) || !isset($_POST['geraet_id'])) {
    header("Location: geraete.php");
    exit;
}

$user_id = $_SESSION['user_id'];
$geraet_id = (int)$_POST['geraet_id'];

$stmt = $conn->prepare("SELECT id FROM ffw_favoriten WHERE user_id = ? AND geraet_id = ?");
$stmt->bind_param("ii", $user_id, $geraet_id);
$stmt->execute();
$stmt->store_result();

if ($stmt->num_rows > 0) {
    $del = $conn->prepare("DELETE FROM ffw_favoriten WHERE user_id = ? AND geraet_id = ?");
    $del->bind_param("ii", $user_id, $geraet_id);
    $del->execute();
} else {
    $add = $conn->prepare("INSERT INTO ffw_favoriten (user_id, geraet_id) VALUES (?, ?)");
    $add->bind_param("ii", $user_id, $geraet_id);
    $add->execute();
}

header("Location: " . $_SERVER['HTTP_REFERER']);
exit;

?>
