<?php
// lieferschein_rueckmeldung.php – Lieferung bestätigen (nur eigene Einheit, nur offene LS)
ob_start();
session_start();
require_once __DIR__ . '/includes/db.php';
require_once __DIR__ . '/includes/header.php';
require_once __DIR__ . '/includes/nav.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php'); exit;
}

$einheit = $_SESSION['einheit'] ?? '';
if ($einheit === '') {
    echo "<div class='container my-5'><div class='alert alert-warning'>⚠️ Keine Einheit in der Session gefunden. Bitte erneut einloggen.</div></div>";
    include 'includes/footer.php'; exit;
}

function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

$lieferschein_id = (int)($_GET['id'] ?? 0);
$meldung = '';

// ------------------ Lieferschein laden & prüfen ------------------
$st = $conn->prepare("
  SELECT l.*,
         u.vorname, u.nachname,
         a.bezeichnung, a.strasse, a.plz, a.ort, a.hinweis
    FROM lieferscheine l
LEFT JOIN users u ON l.erstellt_von = u.id
LEFT JOIN adressen a ON l.adresse_id = a.id
   WHERE l.id = ? AND l.einheit = ?
  LIMIT 1
");
$st->bind_param("is", $lieferschein_id, $einheit);
$st->execute();
$lieferschein = $st->get_result()->fetch_assoc();
$st->close();

if (!$lieferschein) {
    echo "<div class='container my-5'><div class='alert alert-danger'>❌ Lieferschein nicht gefunden oder gehört nicht zu deiner Einheit.</div></div>";
    include 'includes/footer.php'; exit;
}

// Status darf nur von 'offen' -> 'geliefert' gewechselt werden
if ($lieferschein['status'] !== 'offen') {
    echo "<div class='container my-5'>
            <div class='alert alert-info'>ℹ️ Dieser Lieferschein ist bereits <strong>".h($lieferschein['status'])."</strong>.
            <div class='mt-3'><a href='lieferschein_liste.php' class='btn btn-secondary'>Zur Übersicht</a></div></div>
          </div>";
    include 'includes/footer.php'; exit;
}

// Zähler laden (optional, für Info)
$cntG = 0; $cntP = 0;
$rg = $conn->prepare("SELECT COUNT(*) c FROM lieferschein_geraete WHERE lieferschein_id = ?");
$rg->bind_param("i", $lieferschein_id); $rg->execute();
$cntG = (int)($rg->get_result()->fetch_assoc()['c'] ?? 0); $rg->close();

$rp = $conn->prepare("SELECT COUNT(*) c FROM lieferschein_positionen WHERE lieferschein_id = ?");
$rp->bind_param("i", $lieferschein_id); $rp->execute();
$cntP = (int)($rp->get_result()->fetch_assoc()['c'] ?? 0); $rp->close();

// ------------------ POST: Rückmeldung speichern ------------------
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['confirm_delivery'])) {
    $kommentar = trim($_POST['rueckmeldung'] ?? '');

    $up = $conn->prepare("
        UPDATE lieferscheine
           SET status = 'geliefert',
               rueckmeldung = ?,
               rueckmelde_datum = NOW()
         WHERE id = ? AND einheit = ? AND status = 'offen'
    ");
    $up->bind_param("sis", $kommentar, $lieferschein_id, $einheit);
    $up->execute();

    if ($up->affected_rows > 0) {
        // Optional: Hier Mail/Benachrichtigung einbinden
        header("Location: lieferschein_liste.php?status=geliefert");
        exit;
    } else {
        $meldung = "<div class='alert alert-danger'>❌ Konnte nicht bestätigen (möglicherweise bereits geändert).</div>";
    }
    $up->close();
}
?>

<style>
  .kpi-card{border:1px solid #eee;border-radius:14px;padding:16px;background:#fff}
  .kpi-val{font-size:1.2rem;font-weight:700}
  .kpi-sub{font-size:.9rem;color:#6c757d}
</style>

<div class="container my-5">
  <div class="d-flex justify-content-between align-items-end mb-3">
    <div>
      <h2 class="mb-1">✅ Rückmeldung zu Lieferschein <span class="text-monospace">#<?= (int)$lieferschein_id ?></span></h2>
      <div class="text-muted">Einheit: <span class="badge text-bg-secondary"><?= h($einheit) ?></span></div>
    </div>
    <div>
      <a href="lieferschein_liste.php" class="btn btn-outline-secondary">Zur Übersicht</a>
      <a href="lieferschein_druck.php?id=<?= (int)$lieferschein_id ?>" class="btn btn-outline-primary" target="_blank">🖨️ Anzeigen</a>
    </div>
  </div>

  <?= $meldung ?>

  <div class="row g-3 mb-4">
    <div class="col-md-3">
      <div class="kpi-card">
        <div class="kpi-sub">Status</div>
        <div class="kpi-val"><span class="badge bg-secondary">Offen</span></div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="kpi-card">
        <div class="kpi-sub">Lieferdatum</div>
        <div class="kpi-val"><?= $lieferschein['lieferdatum'] ? date('d.m.Y', strtotime($lieferschein['lieferdatum'])) : '—' ?></div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="kpi-card">
        <div class="kpi-sub">Geräte</div>
        <div class="kpi-val"><?= $cntG ?></div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="kpi-card">
        <div class="kpi-sub">Freie Positionen</div>
        <div class="kpi-val"><?= $cntP ?></div>
      </div>
    </div>
  </div>

  <div class="card shadow-sm mb-4">
    <div class="card-body">
      <h5 class="card-title mb-3">Empfänger / Ziel</h5>
      <div class="row">
        <div class="col-md-6">
          <div class="mb-2"><strong>Empfänger:</strong> <?= h($lieferschein['empfaenger']) ?></div>
          <div class="mb-2"><strong>Ziel:</strong> <?= h($lieferschein['bezeichnung'] ?? '-') ?></div>
          <div><?= h($lieferschein['strasse'] ?? '') ?><br><?= h(trim(($lieferschein['plz'] ?? '').' '.($lieferschein['ort'] ?? ''))) ?></div>
          <?php if (!empty($lieferschein['hinweis'])): ?>
            <div class="text-muted small mt-2"><i class="bi bi-info-circle"></i> <?= nl2br(h($lieferschein['hinweis'])) ?></div>
          <?php endif; ?>
        </div>
        <div class="col-md-6">
          <div class="mb-2"><strong>Erstellt von:</strong> <?= h(trim(($lieferschein['vorname'] ?? '').' '.($lieferschein['nachname'] ?? ''))) ?></div>
          <div class="mb-2"><strong>Erstellt am:</strong> <?= $lieferschein['erstellt_am'] ? date('d.m.Y H:i', strtotime($lieferschein['erstellt_am'])) : '—' ?></div>
          <div class="mb-2"><strong>Lieferscheinnr.:</strong> #<?= (int)$lieferschein['id'] ?></div>
        </div>
      </div>
    </div>
  </div>

  <form method="post" class="card p-4 bg-white shadow-sm">
    <h5 class="mb-3">Lieferung bestätigen</h5>
    <div class="mb-3">
      <label class="form-label">Kommentar / Bestätigung (optional)</label>
      <textarea name="rueckmeldung" class="form-control" rows="4" placeholder="z. B. Uhrzeit der Anlieferung, Ansprechpartner vor Ort, Abweichungen ..."></textarea>
    </div>
    <div class="d-flex gap-2">
      <button type="submit" name="confirm_delivery" class="btn btn-success">✅ Als geliefert bestätigen</button>
      <a href="lieferschein_liste.php" class="btn btn-secondary">Abbrechen</a>
    </div>
  </form>
</div>

<?php include 'includes/footer.php'; ob_end_flush(); ?>
