<?php
ob_start();
session_start();
include 'includes/db.php';
include 'includes/header.php';
include 'includes/nav.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

$einheit = $_SESSION['einheit'] ?? '';
$id = (int)($_GET['id'] ?? 0);

// ---------------- Fahrzeug laden ----------------
$stmt = $conn->prepare("SELECT * FROM ffw_fahrzeuge WHERE id = ? AND einheit = ?");
$stmt->bind_param("is", $id, $einheit);
$stmt->execute();
$fahrzeug = $stmt->get_result()->fetch_assoc();

if (!$fahrzeug) {
    echo "<div class='container my-5'><div class='alert alert-danger'>Fahrzeug nicht gefunden oder kein Zugriff.</div></div>";
    include 'includes/footer.php';
    exit;
}

// ---------------- Formularverarbeitung ----------------
$meldung = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['speichern'])) {
    $bezeichnung   = trim($_POST['fahrzeugbezeichnung']);
    $kurz          = trim($_POST['fahrzeugkurz']);
    $kennzeichen   = trim($_POST['kennzeichen']);
    $funkrufname   = trim($_POST['funkrufname']);
    $barcode       = trim($_POST['barcode_fzg']);
    $memo          = trim($_POST['memo']);
    $lpruefung_date= $_POST['lpruefung'] ?? '';
    $lpruefung     = $lpruefung_date ? strtotime($lpruefung_date) : '';

    $stmt = $conn->prepare("UPDATE ffw_fahrzeuge
        SET fahrzeugbezeichnung = ?, fahrzeugkurz = ?, kennzeichen = ?, funkrufname = ?, barcode_fzg = ?, memo = ?, lpruefung = ?
        WHERE id = ? AND einheit = ?");
    $stmt->bind_param("sssssssis", $bezeichnung, $kurz, $kennzeichen, $funkrufname, $barcode, $memo, $lpruefung, $id, $einheit);

    if ($stmt->execute()) {
        header("Location: fahrzeug_edit.php?id=" . $id);
        exit;
    } else {
        $meldung = "<div class='alert alert-danger'>Fehler beim Speichern: " . h($stmt->error) . "</div>";
    }
}

// Timestamp in YYYY-MM-DD für das Date-Input
$lpruefung_form = '';
if (!empty($fahrzeug['lpruefung']) && is_numeric($fahrzeug['lpruefung'])) {
    $lpruefung_form = date('Y-m-d', (int)$fahrzeug['lpruefung']);
}

// Nächste Prüfung (einfach 1 Jahr) + Badge
$next_ts   = (!empty($fahrzeug['lpruefung']) && is_numeric($fahrzeug['lpruefung'])) ? strtotime('+1 year', (int)$fahrzeug['lpruefung']) : null;
$next_disp = $next_ts ? date('d.m.Y', $next_ts) : '–';
$diffDays  = $next_ts ? floor(($next_ts - time())/86400) : null;

$chipClass = 'bg-secondary text-white';
$chipText  = '–';
if ($diffDays !== null) {
  if ($diffDays < 7)       { $chipClass = 'bg-danger';  $chipText = $next_disp.' ('.$diffDays.' T.)'; }
  elseif ($diffDays < 30)  { $chipClass = 'bg-warning text-dark'; $chipText = $next_disp.' ('.$diffDays.' T.)'; }
  else                     { $chipClass = 'bg-success'; $chipText = $next_disp.' ('.$diffDays.' T.)'; }
}
?>
<style>
  .sticky-actions{
    position:sticky; top:0; z-index:5; background:#fff; padding:.75rem 0;
    border-bottom:1px solid rgba(0,0,0,.06);
  }
  .meta-grid .meta{
    background:#f8f9fa;border:1px solid #eef0f2;border-radius:.75rem;padding:.75rem 1rem;
  }
  .meta small{color:#6c757d}
  .help-hint{font-size:.875rem;color:#6c757d}
</style>

<div class="container my-5">
  <div class="d-flex align-items-center justify-content-between mb-3">
    <div>
      <a href="fahrzeuge.php" class="btn btn-outline-secondary btn-sm me-2">
        <i class="bi bi-arrow-left"></i> Zurück
      </a>
      <span class="badge <?= $chipClass ?> align-middle">
        <i class="bi bi-calendar-check pe-1"></i> Nächste Prüfung: <?= h($chipText) ?>
      </span>
    </div>
    <h2 class="mb-0">Fahrzeug bearbeiten</h2>
  </div>

  <?= $meldung ?>

  <!-- Kopf-Infos -->
  <div class="row meta-grid g-3 mb-3">
    <div class="col-12 col-md-4">
      <div class="meta">
        <div class="fw-semibold mb-1">Aktuelle Bezeichnung</div>
        <div><?= h($fahrzeug['fahrzeugbezeichnung'] ?? '–') ?></div>
        <small>Kurzwort: <?= h($fahrzeug['fahrzeugkurz'] ?? '–') ?></small>
      </div>
    </div>
    <div class="col-12 col-md-4">
      <div class="meta">
        <div class="fw-semibold mb-1">Funkrufname / Kennzeichen</div>
        <div><?= h($fahrzeug['funkrufname'] ?? '–') ?></div>
        <small><?= h($fahrzeug['kennzeichen'] ?? '–') ?></small>
      </div>
    </div>
    <div class="col-12 col-md-4">
      <div class="meta">
        <div class="fw-semibold mb-1">Barcode (Fahrzeug)</div>
        <div><?= h($fahrzeug['barcode_fzg'] ?? '–') ?></div>
        <small>Einheit: <?= h($einheit) ?></small>
      </div>
    </div>
  </div>

  <!-- Sticky Actionbar -->
  <div class="sticky-actions d-flex justify-content-end gap-2">
    <button form="vehForm" class="btn btn-primary">
      <i class="bi bi-save"></i> Änderungen speichern
    </button>
  </div>

  <form method="post" id="vehForm" class="card p-4 bg-white shadow-sm">
    <!-- Abschnitt: Stammdaten -->
    <h5 class="mb-3">Stammdaten</h5>
    <div class="row g-3">
      <div class="col-12 col-lg-6">
        <label class="form-label">Bezeichnung <span class="text-danger">*</span></label>
        <input type="text" name="fahrzeugbezeichnung" class="form-control" value="<?= h($fahrzeug['fahrzeugbezeichnung']) ?>" required>
        <div class="help-hint">Offizieller Anzeigename, z. B. „HLF 20 (Rosenbauer)“</div>
      </div>
      <div class="col-12 col-lg-6">
        <label class="form-label">Kurzwort</label>
        <input type="text" name="fahrzeugkurz" class="form-control" value="<?= h($fahrzeug['fahrzeugkurz']) ?>">
        <div class="help-hint">Kurzbezeichnung für Übersichten (optional)</div>
      </div>

      <div class="col-12 col-md-6">
        <label class="form-label">Kennzeichen</label>
        <input type="text" name="kennzeichen" class="form-control" value="<?= h($fahrzeug['kennzeichen']) ?>">
      </div>
      <div class="col-12 col-md-6">
        <label class="form-label">Funkrufname</label>
        <input type="text" name="funkrufname" class="form-control" value="<?= h($fahrzeug['funkrufname']) ?>">
      </div>

      <div class="col-12 col-md-6">
        <label class="form-label">Barcode (fahrzeugbezogen)</label>
        <input type="text" name="barcode_fzg" class="form-control" value="<?= h($fahrzeug['barcode_fzg']) ?>">
      </div>

      <div class="col-12 col-md-6">
        <label class="form-label">Letzte Prüfung</label>
        <div class="input-group">
          <span class="input-group-text"><i class="bi bi-calendar-event"></i></span>
          <input type="date" name="lpruefung" id="lpruefung" class="form-control" value="<?= h($lpruefung_form) ?>">
          <button type="button" class="btn btn-outline-secondary" onclick="setToday('lpruefung')">Heute</button>
          <button type="button" class="btn btn-outline-secondary" onclick="clearDate('lpruefung')">Leeren</button>
        </div>
        <div class="help-hint">Dieses Datum dient als Grundlage zur Berechnung der nächsten (jährlichen) Prüfung.</div>
      </div>
    </div>

    <hr class="my-4">

    <!-- Abschnitt: Notizen -->
    <h5 class="mb-3">Notizen / Bemerkungen</h5>
    <div class="mb-3">
      <textarea name="memo" class="form-control" rows="4" placeholder="Interne Hinweise, Besonderheiten, Historie …"><?= h($fahrzeug['memo']) ?></textarea>
    </div>

    <div class="d-flex justify-content-end gap-2">
      <a href="fahrzeuge.php" class="btn btn-outline-secondary">
        Abbrechen
      </a>
      <button type="submit" name="speichern" class="btn btn-primary">
        <i class="bi bi-save"></i> Änderungen speichern
      </button>
    </div>
  </form>
</div>

<script>
  function setToday(id){
    const el = document.getElementById(id);
    if(!el) return;
    el.value = new Date().toISOString().slice(0,10);
  }
  function clearDate(id){
    const el = document.getElementById(id);
    if(!el) return;
    el.value = '';
  }
</script>

<?php include 'includes/footer.php'; ?>
<?php ob_end_flush(); ?>
