self.addEventListener('install', function(e) {
  console.log('Service Worker: Installiert');
  e.waitUntil(
    caches.open('ticketsystem-cache').then(function(cache) {
      return cache.addAll([
        '/',
        '/index.php',
        '/manifest.json',
        '/icons/icon-192x192.png',
        '/icons/icon-512x512.png'
      ]);
    })
  );
});

self.addEventListener('fetch', function(e) {
  e.respondWith(
    caches.match(e.request).then(function(response) {
      return response || fetch(e.request);
    })
  );
});
