<?php
ob_start();
session_start();
include 'includes/db.php';
include 'includes/header.php';
include 'includes/nav.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

function h($s){ return htmlspecialchars((string)$s, ENT_QUOTES, 'UTF-8'); }

$einheit = $_SESSION['einheit'] ?? '';
$meldung = '';

// ---------------- Prüfung speichern (Logik unverändert) ----------------
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['pruefung_speichern'])) {
    $fahrzeug_id = (int)$_POST['fahrzeug_id'];
    $datum = $_POST['datum'] ?? '';
    $timestamp = strtotime($datum);

    if ($timestamp && $fahrzeug_id > 0) {
        // Fahrzeugdaten abrufen
        $stmt = $conn->prepare("SELECT fahrzeugbezeichnung, barcode_fzg FROM ffw_fahrzeuge WHERE id = ? AND einheit = ?");
        $stmt->bind_param("is", $fahrzeug_id, $einheit);
        $stmt->execute();
        $fahrzeug = $stmt->get_result()->fetch_assoc();

        if ($fahrzeug) {
            $barcode = $fahrzeug['barcode_fzg'];
            $fahrzeugname = $fahrzeug['fahrzeugbezeichnung'];
            $benutzer = ($_SESSION['user_vorname'] ?? '') . ' ' . ($_SESSION['user_nachname'] ?? '');
            $datum_anzeige = date('d.m.Y', $timestamp);

            // Mail
            include 'mail/mail_fahrzeugintervall.php';

            // Fahrzeug aktualisieren
            $stmt = $conn->prepare("UPDATE ffw_fahrzeuge SET lpruefung = ? WHERE id = ?");
            $stmt->bind_param("si", $timestamp, $fahrzeug_id);
            $stmt->execute();

            // Alle NICHT-Atemschutz-Geräte am Fahrzeug auf dasselbe Datum setzen
            $stmt = $conn->prepare("UPDATE ffw_geraete SET lpruefung = ? WHERE fahrzeug = ? AND kat != 'Atemschutz'");
            $stmt->bind_param("is", $timestamp, $barcode);
            $stmt->execute();

            $meldung = "<div class='alert alert-success'>✅ Prüfdatum für <strong>".h($fahrzeugname)."</strong> wurde auf <strong>".h($datum_anzeige)."</strong> gesetzt (Benutzer: <strong>".h(trim($benutzer))."</strong>).</div>";
        } else {
            $meldung = "<div class='alert alert-danger'>Fahrzeug nicht gefunden oder keine Berechtigung.</div>";
        }
    } else {
        $meldung = "<div class='alert alert-warning'>Bitte ein gültiges Datum auswählen.</div>";
    }
}

// ---------------- Fahrzeuge laden (unverändert) ----------------
$stmt = $conn->prepare("SELECT * FROM ffw_fahrzeuge WHERE einheit = ? ORDER BY fahrzeugbezeichnung ASC");
$stmt->bind_param("s", $einheit);
$stmt->execute();
$fahrzeuge = $stmt->get_result();
?>
<style>
  .veh-toolbar{gap:.5rem}
  .status-chip{
    display:inline-flex;align-items:center;gap:.4rem;padding:.2rem .6rem;
    border-radius:999px;font-size:.85rem;font-weight:600;white-space:nowrap;
  }
  .chip-ok{background:#e8f5e9;color:#1b5e20}
  .chip-warn{background:#fff8e1;color:#8a6d00}
  .chip-danger{background:#ffebee;color:#b71c1c}
  .chip-na{background:#eceff1;color:#37474f}
  .table thead th{position:sticky;top:0;background:#f8f9fa;z-index:2}
  @media (max-width: 992px){
    .hide-lg{display:none}
    .table-responsive{border-radius:12px;overflow:hidden}
  }
</style>

<div class="container my-5">
  <div class="d-flex flex-wrap align-items-center justify-content-between mb-3">
    <h2 class="mb-2 mb-lg-0">🚒 Fahrzeugverwaltung – Einheit: <?= h($einheit) ?></h2>
    <div class="veh-toolbar d-flex align-items-center">
      <div class="input-group">
        <span class="input-group-text"><i class="bi bi-search"></i></span>
        <input id="vehSearch" type="text" class="form-control" placeholder="Suche (Bezeichnung, Funkrufname, Kennzeichen, Barcode)">
      </div>
      <button class="btn btn-outline-secondary" id="vehReset"><i class="bi bi-x-circle"></i> Reset</button>
    </div>
  </div>

  <?= $meldung ?>

  <div class="alert alert-info d-flex align-items-start gap-2">
    <i class="bi bi-info-circle fs-5"></i>
    <div>
      <strong>Hinweis:</strong> Beim Setzen des Prüfdatums werden alle <em>nicht-Atemschutz</em>-Geräte dieses Fahrzeugs automatisch auf dasselbe Datum gesetzt.
    </div>
  </div>

  <div class="table-responsive shadow-sm rounded">
    <table class="table table-hover align-middle mb-0" id="vehTable">
      <thead class="table-light">
        <tr>
          <th>Bezeichnung</th>
          <th class="hide-lg">Funkrufname</th>
          <th class="hide-lg">Kennzeichen</th>
          <th>Barcode</th>
          <th>Letzte Prüfung</th>
          <th>Nächste (±)</th>
          <th class="text-center">Aktion</th>
        </tr>
      </thead>
      <tbody>
        <?php while ($fzg = $fahrzeuge->fetch_assoc()): ?>
          <?php
            // Letzte Prüfung
            $last = (is_numeric($fzg['lpruefung']) && (int)$fzg['lpruefung']>0) ? (int)$fzg['lpruefung'] : null;
            $lastDisp = $last ? date('d.m.Y', $last) : '–';

            // Nächste (unter Annahme 1 Jahr Intervall)
            $nextTs = $last ? strtotime('+1 year', $last) : null;
            $nextDisp = $nextTs ? date('d.m.Y', $nextTs) : '–';

            // Diff
            $chip = '<span class="status-chip chip-na">–</span>';
            if ($nextTs) {
              $diffDays = (int)floor(($nextTs - time())/86400);
              if ($diffDays < 7) {
                $chip = '<span class="status-chip chip-danger"><i class="bi bi-circle-fill" style="font-size:.55rem;"></i> '.$nextDisp.' ('.$diffDays.' T.)</span>';
              } elseif ($diffDays < 30) {
                $chip = '<span class="status-chip chip-warn"><i class="bi bi-circle-fill" style="font-size:.55rem;"></i> '.$nextDisp.' ('.$diffDays.' T.)</span>';
              } else {
                $chip = '<span class="status-chip chip-ok"><i class="bi bi-circle-fill" style="font-size:.55rem;"></i> '.$nextDisp.' ('.$diffDays.' T.)</span>';
              }
            }
          ?>
          <tr>
            <td class="fw-semibold">
              <?= h($fzg['fahrzeugbezeichnung']) ?>
              <?php if (!empty($fzg['funkrufname'])): ?>
                <div class="small text-muted"><?= h($fzg['funkrufname']) ?></div>
              <?php endif; ?>
            </td>
            <td class="hide-lg"><?= h($fzg['funkrufname'] ?? '') ?></td>
            <td class="hide-lg"><?= h($fzg['kennzeichen'] ?? '') ?></td>
            <td><?= h($fzg['barcode_fzg'] ?? '') ?></td>
            <td><?= $lastDisp ?></td>
            <td><?= $chip ?></td>
            <td class="text-center">
              <div class="d-flex justify-content-center gap-2 flex-wrap">
                <a href="fahrzeug_edit.php?id=<?= (int)$fzg['id'] ?>" class="btn btn-sm btn-outline-primary">
                  <i class="bi bi-pencil-square"></i> Bearbeiten
                </a>
                <form method="post" class="d-inline-block">
                  <input type="hidden" name="fahrzeug_id" value="<?= (int)$fzg['id'] ?>">
                  <div class="input-group input-group-sm" style="min-width: 260px;">
                    <span class="input-group-text"><i class="bi bi-calendar-event"></i></span>
                    <input type="date" name="datum" class="form-control form-control-sm" required>
                    <button type="submit" name="pruefung_speichern" class="btn btn-sm btn-success">
                      Setzen
                    </button>
                  </div>
                  <div class="d-flex gap-1 mt-1">
                    <button type="button" class="btn btn-outline-secondary btn-sm"
                            onclick="this.closest('form').querySelector('input[name=datum]').value = new Date().toISOString().slice(0,10);">
                      Heute
                    </button>
                    <button type="button" class="btn btn-outline-secondary btn-sm"
                            onclick="const d=new Date(); d.setDate(d.getDate()+7); this.closest('form').querySelector('input[name=datum]').value = d.toISOString().slice(0,10);">
                      +7 Tage
                    </button>
                    <button type="button" class="btn btn-outline-secondary btn-sm"
                            onclick="const d=new Date(); d.setMonth(d.getMonth()+1); this.closest('form').querySelector('input[name=datum]').value = d.toISOString().slice(0,10);">
                      +1 Monat
                    </button>
                  </div>
                </form>
              </div>
            </td>
          </tr>
        <?php endwhile; ?>
      </tbody>
    </table>
  </div>
</div>

<script>
  (function(){
    const q = document.getElementById('vehSearch');
    const reset = document.getElementById('vehReset');
    const table = document.getElementById('vehTable');
    if(!q || !table) return;

    const rows = Array.from(table.querySelectorAll('tbody tr'));

    function filter(){
      const term = q.value.trim().toLowerCase();
      rows.forEach(tr => {
        const txt = tr.innerText.toLowerCase();
        tr.style.display = txt.includes(term) ? '' : 'none';
      });
    }
    q.addEventListener('input', filter);
    reset.addEventListener('click', ()=>{ q.value=''; filter(); q.focus(); });
  })();
</script>

<?php include 'includes/footer.php'; ob_end_flush(); ?>
