<?php
// DB-Zugangsdaten
$host = 'localhost';
$user = 'kd54698_cloud';
$pass = 'w3r24asd!!!';
$db   = 'kd54698_cloud';

// DB-Verbindung aufbauen
$conn = new mysqli($host, $user, $pass, $db);
if ($conn->connect_error) {
    die('❌ Datenbankverbindung fehlgeschlagen: ' . $conn->connect_error);
}

$sql = "SELECT artikelnummer, artikelname, bestand, mindesbestand
        FROM lager_bestand
        WHERE bestand <= mindesbestand";
$result = $conn->query($sql);

$nachricht = "";
if ($result && $result->num_rows > 0) {
    $nachricht .= "Die folgenden Artikel haben den Mindestbestand unterschritten:\n\n";
    $nachricht .= sprintf("%-15s %-35s %10s %10s\n", "Artikelnummer", "Name", "Bestand", "Mindest");

    while ($row = $result->fetch_assoc()) {
        $nachricht .= sprintf(
            "%-15s %-35s %10s %10s\n",
            $row['artikelnummer'],
            mb_strimwidth($row['artikelname'], 0, 34, "..."),
            $row['bestand'],
            $row['mindesbestand']
        );
    }
}

// PHPMailer
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
include_once __DIR__ . '/PHPMailer/PHProcksAutoloader.php';

$subject = "⚠️ Lager: Mindestbestand unterschritten";

$oMailer = new PHPMailer;
$oMailer->CharSet = 'UTF-8';

$nachricht_html = "<pre style='font-family: monospace; background:#f8f9fa; padding:10px; border-radius:6px;'>" . htmlspecialchars($nachricht) . "</pre>";

$html = <<<HTML
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <title>Mindestbestand</title>
  <style>
    body {
      font-family: Arial, sans-serif;
      background-color: #f4f4f4;
      padding: 20px;
    }
    .container {
      max-width: 600px;
      margin: 0 auto;
      background: #ffffff;
      padding: 20px;
      border-radius: 10px;
      box-shadow: 0 0 10px rgba(0,0,0,0.1);
    }
    .header {
      background: #dc3545;
      color: #fff;
      padding: 15px;
      font-size: 20px;
      font-weight: bold;
      text-align: center;
      border-radius: 10px 10px 0 0;
    }
    .content {
      padding: 20px;
      font-size: 16px;
      color: #333;
    }
    .footer {
      margin-top: 20px;
      font-size: 14px;
      color: #888;
      text-align: center;
    }
  </style>
</head>
<body>
  <div class="container">
    <div class="header">⚠️ Mindestbestand erreicht</div>
    <div class="content">
      <p>Moin,</p>
      <p>folgende Artikel im Lagerbestand haben den definierten Mindestwert erreicht oder unterschritten:</p>
      $nachricht_html
      <p>Bitte kümmere dich schnellstmöglich um Nachbestellung oder Umlagerung.</p>
      <p>Mit kameradschaftlichen Grüßen</p>
    </div>
    <div class="footer">&copy; app.f-invent.de</div>
  </div>
</body>
</html>
HTML;

$oMailer->isSMTP();
$oMailer->Host = 'mail.f-invent.de';
$oMailer->SMTPAuth = true;
$oMailer->Username = 'noreply@f-invent.de';
$oMailer->Password = 'b*Y!@Ys.aKS^';
$oMailer->SMTPSecure = 'tls';
$oMailer->Port = 587;

$oMailer->From = 'noreply@f-invent.de';
$oMailer->FromName = 'app.F-Invent.de';
$oMailer->addAddress('geraeteverwaltung@feuerwehr-bad-zwischenahn.de');
$oMailer->addBCC('ticketsystem@app.f-invent.de');
$oMailer->addReplyTo('ticketsystem@app.f-invent.de');

$oMailer->isHTML(true);
$oMailer->Subject = $subject;
$oMailer->Body = $html;
$oMailer->AltBody = strip_tags($nachricht);

if (!$oMailer->send()) {
    echo '❌ Fehler beim Versand der E-Mail!';
}

$conn->close();
?>
