<?php
session_start();
include '../includes/db.php';
include 'admin_nav.php';
if (!isset($_SESSION['user_id']) || $_SESSION['root'] != 1) {
    echo "<div class='alert alert-danger text-center m-4'>⛔ Kein Zugriff – Adminrechte erforderlich.</div>";
    exit;
}

// Fahrzeug löschen
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $stmt = $conn->prepare("DELETE FROM ffw_fahrzeuge WHERE id = ?");
    $stmt->bind_param("i", $id);
    $stmt->execute();
    header("Location: admin_fahrzeuge.php");
    exit;
}

// Fahrzeug speichern (Neu oder Bearbeitung)
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id = intval($_POST['id']);
    $name = $_POST['fahrzeugname'];
    $bez = $_POST['fahrzeugbezeichnung'];
    $kurz = $_POST['fahrzeugkurz'];
    $memo = $_POST['memo'];
    $lpruefung = $_POST['lpruefung'];
    $kennz = $_POST['kennzeichen'];
    $funk = $_POST['funkrufname'];
    $barcode = $_POST['barcode_fzg'];
    $einheit = $_POST['einheit'];

    if ($id == 0) {
        $stmt = $conn->prepare("INSERT INTO ffw_fahrzeuge (fahrzeugname, fahrzeugbezeichnung, fahrzeugkurz, memo, lpruefung, kennzeichen, funkrufname, barcode_fzg, einheit)
                                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("sssssssss", $name, $bez, $kurz, $memo, $lpruefung, $kennz, $funk, $barcode, $einheit);
    } else {
        $stmt = $conn->prepare("UPDATE ffw_fahrzeuge SET fahrzeugname=?, fahrzeugbezeichnung=?, fahrzeugkurz=?, memo=?, lpruefung=?, kennzeichen=?, funkrufname=?, barcode_fzg=?, einheit=?
                                WHERE id=?");
        $stmt->bind_param("sssssssssi", $name, $bez, $kurz, $memo, $lpruefung, $kennz, $funk, $barcode, $einheit, $id);
    }

    $stmt->execute();
    header("Location: admin_fahrzeuge.php");
    exit;
}

// Fahrzeug zum Bearbeiten laden
$edit = null;
if (isset($_GET['edit'])) {
    $id = intval($_GET['edit']);
    $res = $conn->query("SELECT * FROM ffw_fahrzeuge WHERE id = $id");
    $edit = $res->fetch_assoc();
}

// Alle Fahrzeuge
$fzg = $conn->query("SELECT * FROM ffw_fahrzeuge ORDER BY einheit, fahrzeugname");
?>

<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <title>Fahrzeugverwaltung</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container mt-4">
<h2>🚒 Fahrzeugverwaltung</h2>

<form method="post" class="border p-3 mb-4 bg-light rounded">
    <input type="hidden" name="id" value="<?= $edit['id'] ?? 0 ?>">
    <div class="row g-2">
        <div class="col-md-4"><input class="form-control" name="fahrzeugname" placeholder="Fahrzeugname" required value="<?= $edit['fahrzeugname'] ?? '' ?>"></div>
        <div class="col-md-4"><input class="form-control" name="fahrzeugbezeichnung" placeholder="Bezeichnung" value="<?= $edit['fahrzeugbezeichnung'] ?? '' ?>"></div>
        <div class="col-md-4"><input class="form-control" name="fahrzeugkurz" placeholder="Kurzbezeichnung" value="<?= $edit['fahrzeugkurz'] ?? '' ?>"></div>
        <div class="col-md-12"><textarea class="form-control" name="memo" placeholder="Memo"><?= $edit['memo'] ?? '' ?></textarea></div>
        <div class="col-md-3"><input class="form-control" name="lpruefung" placeholder="Letzte Prüfung" value="<?= $edit['lpruefung'] ?? '' ?>"></div>
        <div class="col-md-3"><input class="form-control" name="kennzeichen" placeholder="Kennzeichen" value="<?= $edit['kennzeichen'] ?? '' ?>"></div>
        <div class="col-md-3"><input class="form-control" name="funkrufname" placeholder="Funkrufname" value="<?= $edit['funkrufname'] ?? '' ?>"></div>
        <div class="col-md-3"><input class="form-control" name="barcode_fzg" placeholder="Barcode" value="<?= $edit['barcode_fzg'] ?? '' ?>"></div>
        <div class="col-md-4"><input class="form-control" name="einheit" placeholder="Einheit" value="<?= $edit['einheit'] ?? '' ?>"></div>
        <div class="col-md-2"><button type="submit" class="btn btn-success w-100">💾 Speichern</button></div>
        <?php if ($edit): ?>
            <div class="col-md-2"><a href="admin_fahrzeuge.php" class="btn btn-secondary w-100">↩ Abbrechen</a></div>
        <?php endif; ?>
    </div>
</form>

<table class="table table-bordered table-striped">
    <thead>
        <tr>
            <th>Name</th><th>Bezeichnung</th><th>Funk</th><th>Kennzeichen</th><th>Einheit</th><th>Aktion</th>
        </tr>
    </thead>
    <tbody>
        <?php while ($row = $fzg->fetch_assoc()): ?>
            <tr>
                <td><?= htmlspecialchars($row['fahrzeugname']) ?></td>
                <td><?= htmlspecialchars($row['fahrzeugbezeichnung']) ?></td>
                <td><?= htmlspecialchars($row['funkrufname']) ?></td>
                <td><?= htmlspecialchars($row['kennzeichen']) ?></td>
                <td><?= htmlspecialchars($row['einheit']) ?></td>
                <td>
                    <a href="?edit=<?= $row['id'] ?>" class="btn btn-sm btn-warning">Bearbeiten</a>
                    <a href="?delete=<?= $row['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Wirklich löschen?')">Löschen</a>
                </td>
            </tr>
        <?php endwhile; ?>
    </tbody>
</table>
</body>
</html>
