<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
include_once __DIR__ . '/PHPMailer/PHProcksAutoloader.php';
include_once __DIR__ . '../includes/db.php'; // Nur wenn `$conn` noch nicht verfügbar

// Nachricht zusammenstellen
$nachricht = "Ein neues Ticket wurde erfolgreich erstellt:\n\n";
$nachricht .= sprintf("%-15s %-35s\n", "Feld", "Wert");
$nachricht .= str_repeat("-", 50) . "\n";
$nachricht .= sprintf("%-15s %-35s\n", "Ticketnummer:", $ticketnummer);
$nachricht .= sprintf("%-15s %-35s\n", "Erstellt am:", $erstellt);
$nachricht .= sprintf("%-15s %-35s\n", "Name:", $name);
$nachricht .= sprintf("%-15s %-35s\n", "E-Mail:", $email ?: '-');
$nachricht .= sprintf("%-15s %-35s\n", "Spindnummer:", $spindnr ?: '-');
$nachricht .= sprintf("%-15s %-35s\n", "Fachbereich:", $fachbereich);
$nachricht .= sprintf("%-15s %-35s\n", "Beschreibung:", $beschreibung);
$nachricht .= sprintf("%-15s %-35s\n", "Anhang:", $bild ?? 'Keiner');

$nachricht_html = "<pre>" . htmlspecialchars($nachricht) . "</pre>";

// HTML-Layout
$html = <<<HTML
<!DOCTYPE html>
<html>
<head>
  <meta charset="UTF-8">
  <style>
    body { font-family: Arial, sans-serif; background-color: #f4f4f4; padding: 20px; }
    .container { max-width: 900px; margin: auto; background: #fff; padding: 20px; border-radius: 10px; box-shadow: 0 0 10px rgba(0,0,0,0.1); }
    .header { background: #0d6efd; color: #fff; padding: 15px; font-size: 20px; font-weight: bold; text-align: center; border-radius: 10px 10px 0 0; }
    .content { padding: 20px; font-size: 16px; color: #333; }
    pre { background: #f8f9fa; padding: 10px; border-radius: 6px; font-family: monospace; overflow-x: auto; }
    .footer { margin-top: 20px; font-size: 14px; color: #888; text-align: center; }
  </style>
</head>
<body>
  <div class="container">
    <div class="header">Ticket erstellt</div>
    <div class="content">
      <p>Moin,</p>
      <p>folgendes Ticket wurde erfolgreich im System erstellt:</p>
      {$nachricht_html}
      <p>Mit kameradschaftlichen Grüßen</p>
    </div>
    <div class="footer">&copy; app.f-invent.de</div>
  </div>
</body>
</html>
HTML;

// Mail versenden
$oMailer = new PHPMailer;
$oMailer->CharSet = 'UTF-8';
$oMailer->isSMTP();
$oMailer->Host = 'mail.f-invent.de';
$oMailer->SMTPAuth = true;
$oMailer->Username = 'noreply@f-invent.de';
$oMailer->Password = 'b*Y!@Ys.aKS^';
$oMailer->SMTPSecure = 'tls';
$oMailer->Port = 587;

$oMailer->From = 'noreply@f-invent.de';
$oMailer->FromName = 'app.F-Invent.de';
$oMailer->addReplyTo('ticketsystem@app.f-invent.de');

// Empfänger: Kunde
if (!empty($email) && filter_var($email, FILTER_VALIDATE_EMAIL)) {
    $oMailer->addAddress($email);
}

// Feste interne BCCs
$oMailer->addBCC('ticketsystem@app.f-invent.de');
$oMailer->addBCC('geraeteverwaltung@feuerwehr-bad-zwischenahn.de');

// Optional: Empfänger aus Datenbank laden
$result = $conn->query("SELECT * FROM ticket_mail_empfaenger WHERE aktiv = 1");
if ($result) {
    while ($row = $result->fetch_assoc()) {
        if ($row['typ'] === 'standard') {
            $oMailer->addAddress($row['email']);
        } elseif ($row['typ'] === 'bcc') {
            $oMailer->addBCC($row['email']);
        }
    }
}

$oMailer->isHTML(true);
$oMailer->Subject = "🎫 Ticket {$ticketnummer}";
$oMailer->Body    = $html;
$oMailer->AltBody = strip_tags($nachricht);

// Anhang einfügen (falls vorhanden)
if (!empty($bild) && file_exists("uploads/tickets/" . $bild)) {
    $oMailer->addAttachment("uploads/tickets/" . $bild);
}

// Versand + Logging
if ($oMailer->send()) {
    $status = 'erfolgreich';
    $fehler = null;
} else {
    $status = 'fehler';
    $fehler = $oMailer->ErrorInfo;
}

// Log-Eintrag
$log_empfaenger = $email ?: '-';
$log_betreff = $oMailer->Subject;
$stmt = $conn->prepare("INSERT INTO email_log (empfaenger, betreff, status, fehlertext) VALUES (?, ?, ?, ?)");
$stmt->bind_param("ssss", $log_empfaenger, $log_betreff, $status, $fehler);
$stmt->execute();
?>
