<?php
ob_start();
session_start();
include 'includes/db.php';
include 'includes/header.php';
include 'includes/nav.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$einheit = $_SESSION['einheit'] ?? '';
$id = (int)($_GET['id'] ?? 0);

// Fahrzeug laden
$stmt = $conn->prepare("SELECT * FROM ffw_fahrzeuge WHERE id = ? AND einheit = ?");
$stmt->bind_param("is", $id, $einheit);
$stmt->execute();
$fahrzeug = $stmt->get_result()->fetch_assoc();

if (!$fahrzeug) {
    echo "<div class='container my-5'><div class='alert alert-danger'>Fahrzeug nicht gefunden oder kein Zugriff.</div></div>";
    include 'includes/footer.php';
    exit;
}

// Formularverarbeitung
$meldung = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['speichern'])) {
    $bezeichnung = trim($_POST['fahrzeugbezeichnung']);
    $kurz = trim($_POST['fahrzeugkurz']);
    $kennzeichen = trim($_POST['kennzeichen']);
    $funkrufname = trim($_POST['funkrufname']);
    $barcode = trim($_POST['barcode_fzg']);
    $memo = trim($_POST['memo']);
    $lpruefung_date = $_POST['lpruefung'] ?? '';
    $lpruefung = $lpruefung_date ? strtotime($lpruefung_date) : '';

    $stmt = $conn->prepare("UPDATE ffw_fahrzeuge
        SET fahrzeugbezeichnung = ?, fahrzeugkurz = ?, kennzeichen = ?, funkrufname = ?, barcode_fzg = ?, memo = ?, lpruefung = ?
        WHERE id = ? AND einheit = ?");
    $stmt->bind_param("sssssssis", $bezeichnung, $kurz, $kennzeichen, $funkrufname, $barcode, $memo, $lpruefung, $id, $einheit);

    if ($stmt->execute()) {
        header("Location: fahrzeug_edit.php?id=" . $id);
        exit;
    } else {
        $meldung = "<div class='alert alert-danger'>Fehler beim Speichern: " . htmlspecialchars($stmt->error) . "</div>";
    }
}

// Timestamp in YYYY-MM-DD umwandeln für Anzeige
$lpruefung_form = '';
if (!empty($fahrzeug['lpruefung']) && is_numeric($fahrzeug['lpruefung'])) {
    $lpruefung_form = date('Y-m-d', $fahrzeug['lpruefung']);
}
?>

<div class="container my-5">
  <a href="fahrzeuge.php" class="btn btn-secondary mb-4">&laquo; Zurück</a>
  <h2 class="mb-4">Fahrzeug bearbeiten</h2>

  <?= $meldung ?>

  <form method="post" class="card p-4 bg-white shadow-sm">
    <div class="mb-3">
      <label class="form-label">Bezeichnung</label>
      <input type="text" name="fahrzeugbezeichnung" class="form-control" value="<?= htmlspecialchars($fahrzeug['fahrzeugbezeichnung']) ?>" required>
    </div>
    <div class="mb-3">
      <label class="form-label">Kurzwort</label>
      <input type="text" name="fahrzeugkurz" class="form-control" value="<?= htmlspecialchars($fahrzeug['fahrzeugkurz']) ?>">
    </div>
    <div class="mb-3">
      <label class="form-label">Kennzeichen</label>
      <input type="text" name="kennzeichen" class="form-control" value="<?= htmlspecialchars($fahrzeug['kennzeichen']) ?>">
    </div>
    <div class="mb-3">
      <label class="form-label">Funkrufname</label>
      <input type="text" name="funkrufname" class="form-control" value="<?= htmlspecialchars($fahrzeug['funkrufname']) ?>">
    </div>
    <div class="mb-3">
      <label class="form-label">Barcode</label>
      <input type="text" name="barcode_fzg" class="form-control" value="<?= htmlspecialchars($fahrzeug['barcode_fzg']) ?>">
    </div>
    <div class="mb-3">
      <label class="form-label">Letzte Prüfung (Datum)</label>
      <input type="date" name="lpruefung" class="form-control" value="<?= $lpruefung_form ?>">
    </div>
    <div class="mb-3">
      <label class="form-label">Notizen / Bemerkungen</label>
      <textarea name="memo" class="form-control" rows="4"><?= htmlspecialchars($fahrzeug['memo']) ?></textarea>
    </div>
    <button type="submit" name="speichern" class="btn btn-primary">Änderungen speichern</button>
  </form>
</div>

<?php include 'includes/footer.php'; ?>
