<?php

class PHProcksAutoloader {


    private $PathTemplate = __DIR__ . '/src/{{CLASS_NAME}}.php';



    public function __construct() {

        spl_autoload_register( [$this, 'Prepare'] );

    }


    private function Prepare( $class_name ) : bool {

        $this->NamespaceRoute = explode( '\\', $class_name );
        $this->ClassName = end( $this->NamespaceRoute );

        return $this->Load();

    }


    private function Load() : bool {

        if ( !$this->ClassExists() )
            return false;


        return include_once $this->GetClassPath();

    }


    private function GetClassPath() : string {

        return str_replace( '{{CLASS_NAME}}', $this->ClassName, $this->PathTemplate );

    }


    private function ClassExists() : bool {

        return file_exists( $this->GetClassPath() );

    }


}


$oLoader = new PHProcksAutoloader; 



 ?>
