<?php
session_start();
include 'includes/db.php';
include 'includes/header.php';
include 'includes/nav.php';

$user_id = $_SESSION['user_id'];
$meldung = '';

// ✅ Position löschen
if (isset($_GET['remove'])) {
    $stmt = $conn->prepare("DELETE FROM warenkorb WHERE id = ? AND user_id = ?");
    $stmt->bind_param("ii", $_GET['remove'], $user_id);
    $stmt->execute();
    header("Location: warenkorb.php");
    exit;
}

// ✅ Bestellung absenden
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['bestellung_absenden'])) {
    $conn->begin_transaction();
    $stmt = $conn->prepare("INSERT INTO bestellungen (user_id, status) VALUES (?, 'bestellt')");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $bestellung_id = $conn->insert_id;

    $stmt = $conn->prepare("SELECT * FROM warenkorb WHERE user_id = ?");
    $stmt->bind_param("i", $user_id);
    $stmt->execute();
    $res = $stmt->get_result();

    $stmt_insert = $conn->prepare("INSERT INTO bestellpositionen (bestellung_id, artikelname, groesse, anzahl) VALUES (?, ?, ?, ?)");
    while ($row = $res->fetch_assoc()) {
        $stmt_insert->bind_param("issi", $bestellung_id, $row['artikelname'], $row['groesse'], $row['anzahl']);
        $stmt_insert->execute();
    }

    $conn->query("DELETE FROM warenkorb WHERE user_id = $user_id");
    $conn->commit();

    include 'mail/mail_bestellung.php';
    $meldung = "<div class='alert alert-success'>✅ Bestellung erfolgreich abgeschickt.</div>";
}

// ✅ Neue Position hinzufügen (Lagerartikel oder manuell)
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['hinzufuegen'])) {
    $artikelname = trim($_POST['artikelname']);
    $groesse = trim($_POST['groesse']);
    $anzahl = intval($_POST['anzahl'] ?? 1);
    $artikel_id = is_numeric($_POST['artikel_id'] ?? null) ? intval($_POST['artikel_id']) : null;

    if ($artikelname !== '' && $anzahl > 0) {
        $stmt = $conn->prepare("INSERT INTO warenkorb (user_id, artikel_id, artikelname, groesse, anzahl) VALUES (?, ?, ?, ?, ?)");
        $stmt->bind_param("iissi", $user_id, $artikel_id, $artikelname, $groesse, $anzahl);
        $stmt->execute();
    }
}

// ✅ Aktuelle Warenkorb-Artikel laden
$stmt = $conn->prepare("SELECT * FROM warenkorb WHERE user_id = ?");
$stmt->bind_param("i", $user_id);
$stmt->execute();
$artikel = $stmt->get_result()->fetch_all(MYSQLI_ASSOC);

// ✅ Lagerartikel laden (für Auswahl)
$lager_result = $conn->query("SELECT id, artikelname, groesse FROM lager_bestand ORDER BY artikelname ASC");
$lager_artikel = $lager_result->fetch_all(MYSQLI_ASSOC);
?>

<div class="container my-5">
  <h2>🛒 Warenkorb & Bestellung</h2>
  <?= $meldung ?>

  <!-- 📥 Artikel aus Lager hinzufügen -->
  <form method="post" class="row gy-2 mb-4 align-items-end">
    <input type="hidden" name="hinzufuegen" value="1">
    <div class="col-md-4">
      <select name="artikel_id" class="form-select" onchange="fillFromLager(this)">
        <option value="">➕ Lagerartikel auswählen</option>
        <?php foreach ($lager_artikel as $la): ?>
          <option value="<?= $la['id'] ?>" data-name="<?= htmlspecialchars($la['artikelname']) ?>" data-groesse="<?= htmlspecialchars($la['groesse']) ?>">
            <?= $la['artikelname'] ?> (<?= $la['groesse'] ?>)
          </option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-md-3"><input type="text" name="artikelname" id="artikelname" class="form-control" placeholder="Artikelname" required></div>
    <div class="col-md-2"><input type="text" name="groesse" id="groesse" class="form-control" placeholder="Größe"></div>
    <div class="col-md-2"><input type="number" name="anzahl" class="form-control" value="1" min="1" required></div>
    <div class="col-md-1"><button class="btn btn-primary w-100">➕</button></div>
  </form>

  <!-- 🧺 Warenkorb anzeigen -->
  <?php if (count($artikel) === 0): ?>
    <div class="alert alert-info">Dein Warenkorb ist leer.</div>
  <?php else: ?>
    <form method="post">
      <table class="table table-bordered">
        <thead><tr><th>Artikel</th><th>Größe</th><th>Anzahl</th><th>🗑</th></tr></thead>
        <tbody>
          <?php foreach ($artikel as $a): ?>
            <tr>
              <td><?= htmlspecialchars($a['artikelname']) ?></td>
              <td><?= htmlspecialchars($a['groesse']) ?></td>
              <td><?= $a['anzahl'] ?></td>
              <td><a href="?remove=<?= $a['id'] ?>" class="btn btn-sm btn-danger">–</a></td>
            </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
      <button type="submit" name="bestellung_absenden" class="btn btn-success">📦 Verbindlich bestellen</button>
    </form>
  <?php endif; ?>
</div>

<script>
function fillFromLager(select) {
  const option = select.options[select.selectedIndex];
  document.getElementById('artikelname').value = option.dataset.name || '';
  document.getElementById('groesse').value = option.dataset.groesse || '';
}
</script>

<?php include 'includes/footer.php'; ?>
