<?php
include 'includes/header.php';
include 'includes/nav.php';
include 'includes/db.php';

session_start();
if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_rechte = $_SESSION['is_admin'] ?? 0;
$meldung = '';

// Artikel löschen
if (isset($_GET['delete']) && is_numeric($_GET['delete']) && $user_rechte > 0) {
    $delId = (int)$_GET['delete'];
    $stmt = $conn->prepare("DELETE FROM lager_bestand WHERE id = ?");
    $stmt->bind_param("i", $delId);
    if ($stmt->execute()) {
        $meldung = "<div class='alert alert-success'>🗑️ Artikel wurde gelöscht.</div>";
    } else {
        $meldung = "<div class='alert alert-danger'>❌ Fehler beim Löschen.</div>";
    }
}

// Artikelnummer generieren
function generiere_artikelnummer($kategorie, $conn) {
    $prefix_map = [
        'PSA-Einsatzjacke' => 'PSA',
        'PSA-Einsatzhose' => 'PSA',
        'PSA-Einsatzhose AGT' => 'PSA',
        'PSA-Handschuhe' => 'PSA',
        'PSA-Helmlampe' => 'PSA',
        'PSA-Helm' => 'PSA',
        'PSA-Stiefel' => 'PSA',
        'Dienstbekleidung' => 'DB',
        'Uniform' => 'UNI',
        'Diverse' => 'DIV'
    ];
    $prefix = $prefix_map[$kategorie] ?? 'ART';

    $sql = "SELECT COUNT(*) AS anzahl FROM lager_bestand WHERE artikelnummer LIKE CONCAT(?, '-%')";
    $stmt = $conn->prepare($sql);
    $stmt->bind_param("s", $prefix);
    $stmt->execute();
    $res = $stmt->get_result()->fetch_assoc();
    $laufnummer = $res['anzahl'] + 1;

    return $prefix . '-' . str_pad($laufnummer, 4, '0', STR_PAD_LEFT);
}

// Artikel speichern
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['artikel_speichern'])) {
    $artikelnummer = generiere_artikelnummer($_POST['kategorie'], $conn);

    $stmt = $conn->prepare("INSERT INTO lager_bestand (artikelnummer, artikelname, kategorie, groesse, bestand, mindesbestand)
                            VALUES (?, ?, ?, ?, ?, ?)");
    $stmt->bind_param("ssssii",
        $artikelnummer,
        $_POST['artikelname'],
        $_POST['kategorie'],
        $_POST['groesse'],
        $_POST['bestand'],
        $_POST['mindesbestand']
    );
    $stmt->execute();
    $meldung = "<div class='alert alert-success'>✅ Artikel wurde erfolgreich gespeichert.</div>";
}

// Artikel abrufen
if ($user_rechte == 2) {
    $stmt = $conn->prepare("SELECT * FROM lager_bestand WHERE kategorie LIKE 'PSA%' ORDER BY artikelname ASC");
} elseif ($user_rechte == 3) {
    $stmt = $conn->prepare("SELECT * FROM lager_bestand WHERE kategorie IN ('Dienstbekleidung', 'Uniform') ORDER BY artikelname ASC");
} else {
    $stmt = $conn->prepare("SELECT * FROM lager_bestand ORDER BY kategorie, artikelname ASC");
}
$stmt->execute();
$artikel = $stmt->get_result();
?>

<div class="container my-5">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h2>Lagerverwaltung</h2>
    <button class="btn btn-success" data-bs-toggle="modal" data-bs-target="#artikelModal">➕ Artikel hinzufügen</button>
  </div>

  <?= $meldung ?>

  <div class="table-responsive">
    <table class="table table-bordered table-hover bg-white align-middle">
      <thead class="table-dark">
        <tr>
          <th>Artikelnummer</th>
          <th>Name</th>
          <th>Kategorie</th>
          <th>Größe</th>
          <th>Bestand</th>
          <th>Aktion</th>
        </tr>
      </thead>
      <tbody>
        <?php while ($row = $artikel->fetch_assoc()): ?>
          <?php $warnung = ($row['bestand'] <= $row['mindesbestand']); ?>
          <tr class="<?= $warnung ? 'table-danger' : '' ?>">
            <td><?= htmlspecialchars($row['artikelnummer']) ?></td>
            <td><?= htmlspecialchars($row['artikelname']) ?></td>
            <td><?= htmlspecialchars($row['kategorie']) ?></td>
            <td><?= htmlspecialchars($row['groesse']) ?></td>
            <td>
              <?= $row['bestand'] ?>
              <?php if ($warnung): ?>
                <span class="badge bg-danger ms-2">Mindestbestand!</span>
              <?php endif; ?>
            </td>
            <td>
              <a href="lager_buchung.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-outline-primary">Buchen</a>
              <a href="lager_historie.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-outline-secondary">Historie</a>
              <a href="bestellwesen.php?artikel_id=<?= $row['id'] ?>" class="btn btn-sm btn-outline-success" title="Artikel bestellen">🛒</a>
              </a>
              <?php if ($user_rechte >= 1): ?>
                <a href="?delete=<?= $row['id'] ?>" class="btn btn-sm btn-outline-danger"
                   onclick="return confirm('❗ Diesen Artikel wirklich löschen?');">Löschen</a>
              <?php endif; ?>
            </td>
          </tr>
        <?php endwhile; ?>
      </tbody>
    </table>
  </div>
</div>

<!-- Modal: Artikel hinzufügen -->
<div class="modal fade" id="artikelModal" tabindex="-1" aria-labelledby="artikelModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <form method="post" class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="artikelModalLabel">Artikel hinzufügen</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <div class="mb-3"><label>Artikelname</label><input name="artikelname" class="form-control" required></div>
        <div class="mb-3">
          <label>Kategorie</label>
          <select name="kategorie" id="kategorieSelect" class="form-select" required>
            <option value="">– bitte wählen –</option>
            <option>PSA-Einsatzjacke</option>
            <option>PSA-Einsatzhose</option>
            <option>PSA-Einsatzhose AGT</option>
            <option>PSA-Handschuhe</option>
            <option>PSA-Helmlampe</option>
            <option>PSA-Helm</option>
            <option>PSA-Stiefel</option>
            <option>Dienstbekleidung</option>
            <option>Uniform</option>
            <option>Diverse</option>
          </select>
        </div>
        <div class="mb-3"><label>Größe</label><input name="groesse" class="form-control"></div>
        <div class="mb-3"><label>Bestand</label><input type="number" name="bestand" class="form-control" value="0"></div>
        <div class="mb-3"><label>Mindestbestand</label><input type="number" name="mindesbestand" class="form-control" value="0"></div>
      </div>
      <div class="modal-footer">
        <button type="submit" name="artikel_speichern" class="btn btn-primary">Speichern</button>
        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Abbrechen</button>
      </div>
    </form>
  </div>
</div>

<?php include 'includes/footer.php'; ?>
