<?php
include 'includes/header.php';
include 'includes/nav.php';
include 'includes/db.php';
session_start();

$user_id = $_SESSION['user_id'];
$meldung = '';

// Vorbelegung über artikel_id (z. B. von Lagerseite)
$artikel_id = $_GET['artikel_id'] ?? null;
$vorbelegung = [];

if ($artikel_id && is_numeric($artikel_id)) {
    $stmt = $conn->prepare("SELECT artikelname, groesse FROM lager_bestand WHERE id = ?");
    $stmt->bind_param("i", $artikel_id);
    $stmt->execute();
    $res = $stmt->get_result();
    $vorbelegung = $res->fetch_assoc();
}

// Bestellung speichern
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['bestellung_absenden'])) {
    $artikelname = $_POST['artikelname'];
    $groesse = $_POST['groesse'];
    $anzahl = $_POST['anzahl'];

    if (count($artikelname) > 0) {
        $conn->begin_transaction();
        $stmt = $conn->prepare("INSERT INTO bestellungen (user_id, status) VALUES (?, 'bestellt')");
        $stmt->bind_param("i", $user_id);
        $stmt->execute();
        $bestellung_id = $conn->insert_id;

        $bestellte_artikel = []; // 👈 Array zur Übergabe vorbereiten

        $stmt = $conn->prepare("INSERT INTO bestellpositionen (bestellung_id, artikelname, groesse, anzahl) VALUES (?, ?, ?, ?)");
        for ($i = 0; $i < count($artikelname); $i++) {
            if (trim($artikelname[$i]) !== '') {
                $stmt->bind_param("issi", $bestellung_id, $artikelname[$i], $groesse[$i], $anzahl[$i]);
                $stmt->execute();

                $bestellte_artikel[] = [
                    'artikelname' => $artikelname[$i],
                    'groesse'     => $groesse[$i],
                    'anzahl'      => $anzahl[$i]
                ];
            }
        }

        $conn->commit();

        // 📧 E-Mail-Versand einbinden
        include 'mail/mail_bestellung.php';

        $meldung = "<div class='alert alert-success'>✅ Bestellung erfolgreich abgeschickt.</div>";
    } else {
        $meldung = "<div class='alert alert-warning'>Bitte mindestens einen Artikel angeben.</div>";
    }
}
?>

<div class="container my-5">
  <h2 class="mb-4">🛒 Neue Bestellung</h2>
  <?= $meldung ?>

  <form method="post">
    <div id="artikelContainer">
      <div class="row g-2 mb-2">
        <div class="col-md-5">
          <input type="text" name="artikelname[]" class="form-control" placeholder="Artikelname" required
                 value="<?= htmlspecialchars($vorbelegung['artikelname'] ?? '') ?>">
        </div>
        <div class="col-md-3">
          <input type="text" name="groesse[]" class="form-control" placeholder="Größe"
                 value="<?= htmlspecialchars($vorbelegung['groesse'] ?? '') ?>">
        </div>
        <div class="col-md-2">
          <input type="number" name="anzahl[]" class="form-control" placeholder="Anzahl" value="1" required>
        </div>
        <div class="col-md-2">
          <button type="button" class="btn btn-danger w-100 removeRow">–</button>
        </div>
      </div>
    </div>
    <button type="button" class="btn btn-secondary mb-3" id="addArtikel">+ Artikel hinzufügen</button><br>
    <button type="submit" name="bestellung_absenden" class="btn btn-success">📦 Verbindlich bestellen</button>
  </form>
</div>

<script>
document.getElementById('addArtikel').addEventListener('click', () => {
  const container = document.getElementById('artikelContainer');
  const row = document.createElement('div');
  row.className = 'row g-2 mb-2';
  row.innerHTML = `
    <div class="col-md-5"><input type="text" name="artikelname[]" class="form-control" placeholder="Artikelname" required></div>
    <div class="col-md-3"><input type="text" name="groesse[]" class="form-control" placeholder="Größe"></div>
    <div class="col-md-2"><input type="number" name="anzahl[]" class="form-control" placeholder="Anzahl" required></div>
    <div class="col-md-2"><button type="button" class="btn btn-danger w-100 removeRow">–</button></div>`;
  container.appendChild(row);
});

document.addEventListener('click', e => {
  if (e.target.classList.contains('removeRow')) {
    e.target.closest('.row').remove();
  }
});
</script>

<?php include 'includes/footer.php'; ?>
