<?php
ob_start();
session_start();
include '../includes/db.php';
include 'admin_nav.php';

// Nur für root-User
if (!isset($_SESSION['user_id']) || $_SESSION['root'] != 1) {
    echo "<div class='alert alert-danger'>Kein Zugriff.</div>";
    exit;
}

// Benutzer löschen
if (isset($_GET['delete'])) {
    $id = intval($_GET['delete']);
    $conn->query("DELETE FROM users WHERE id = $id");
    echo "<div class='alert alert-success'>Benutzer gelöscht.</div>";
}

// Benutzer hinzufügen oder bearbeiten
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $id       = intval($_POST['id']);
    $vorname  = trim($_POST['vorname']);
    $nachname = trim($_POST['nachname']);
    $email    = trim($_POST['email']);
    $einheit  = trim($_POST['einheit']);
    $root     = isset($_POST['root']) ? 1 : 0;

    if ($id == 0) {
        // Neuer Benutzer mit Passwort 123456
        $passwort = password_hash('123456', PASSWORD_DEFAULT);
        $stmt = $conn->prepare("INSERT INTO users (vorname, nachname, email, einheit, passwort, root) VALUES (?, ?, ?, ?, ?, ?)");
        $stmt->bind_param("sssssi", $vorname, $nachname, $email, $einheit, $passwort, $root);
        $stmt->execute();
    } else {
        $stmt = $conn->prepare("UPDATE users SET vorname = ?, nachname = ?, email = ?, einheit = ?, root = ? WHERE id = ?");
        $stmt->bind_param("ssssii", $vorname, $nachname, $email, $einheit, $root, $id);
        $stmt->execute();
    }
    echo "<div class='alert alert-success'>Benutzerdaten gespeichert.</div>";
}

// Alle Benutzer laden
$nutzer = $conn->query("SELECT * FROM users ORDER BY nachname, vorname");
?>

<!DOCTYPE html>
<html lang="de">
<head>
    <meta charset="UTF-8">
    <title>Benutzerverwaltung</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container mt-4">
<h2>👤 Benutzerverwaltung</h2>

<form method="post" class="mb-4">
    <input type="hidden" name="id" value="0">
    <div class="row g-2">
        <div class="col"><input type="text" name="vorname" class="form-control" placeholder="Vorname" required></div>
        <div class="col"><input type="text" name="nachname" class="form-control" placeholder="Nachname" required></div>
        <div class="col"><input type="email" name="email" class="form-control" placeholder="E-Mail" required></div>
        <div class="col"><input type="text" name="einheit" class="form-control" placeholder="Einheit" required></div>
        <div class="col"><label><input type="checkbox" name="root"> Admin</label></div>
        <div class="col"><button type="submit" class="btn btn-primary">➕ Hinzufügen</button></div>
    </div>
</form>

<table class="table table-bordered table-striped">
    <thead><tr><th>Name</th><th>E-Mail</th><th>Einheit</th><th>root</th><th>Aktion</th></tr></thead>
    <tbody>
    <?php while($row = $nutzer->fetch_assoc()): ?>
        <tr>
            <td><?= htmlspecialchars($row['vorname'] . ' ' . $row['nachname']) ?></td>
            <td><?= htmlspecialchars($row['email']) ?></td>
            <td><?= htmlspecialchars($row['einheit']) ?></td>
            <td><?= $row['root'] == 1 ? '✅' : '' ?></td>
            <td>
                <a href="admin_users_edit.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-warning">Bearbeiten</a>
                <a href="?delete=<?= $row['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('Wirklich löschen?')">Löschen</a>
                <a href="../mail/admin_user_pwreset.php?id=<?= $row['id'] ?>" class="btn btn-sm btn-info">Passwort reset</a>

            </td>
        </tr>
    <?php endwhile; ?>
    </tbody>
</table>
</body>
</html>
