<?php
ob_start();
session_start();
include 'includes/db.php';
include 'includes/header.php';
include 'includes/nav.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$einheit = $_SESSION['einheit'] ?? '';
$meldung = '';

// Prüfung speichern
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['pruefung_speichern'])) {
    $fahrzeug_id = (int)$_POST['fahrzeug_id'];
    $datum = $_POST['datum'] ?? '';
    $timestamp = strtotime($datum);

    if ($timestamp && $fahrzeug_id > 0) {
    // Fahrzeugdaten abrufen
    $stmt = $conn->prepare("SELECT fahrzeugbezeichnung, barcode_fzg FROM ffw_fahrzeuge WHERE id = ? AND einheit = ?");
    $stmt->bind_param("is", $fahrzeug_id, $einheit);
    $stmt->execute();
    $fahrzeug = $stmt->get_result()->fetch_assoc();

    if ($fahrzeug) {
        $barcode = $fahrzeug['barcode_fzg'];
        $fahrzeugname = $fahrzeug['fahrzeugbezeichnung'];
        $benutzer = $_SESSION['user_vorname'] . ' ' . $_SESSION['user_nachname'];
        $datum_anzeige = date('d.m.Y', $timestamp);

        include 'mail/mail_fahrzeugintervall.php';

        // Fahrzeug aktualisieren
        $stmt = $conn->prepare("UPDATE ffw_fahrzeuge SET lpruefung = ? WHERE id = ?");
        $stmt->bind_param("si", $timestamp, $fahrzeug_id);
        $stmt->execute();

        // Nur Geräte aktualisieren, die NICHT zur Kategorie "Atemschutz" gehören
        $stmt = $conn->prepare("UPDATE ffw_geraete SET lpruefung = ? WHERE fahrzeug = ? AND kat != 'Atemschutz'");
        $stmt->bind_param("is", $timestamp, $barcode);
        $stmt->execute();

        // Meldung mit gespeicherten Infos
        $meldung = "<div class='alert alert-success'>Prüfdatum für <strong>$fahrzeugname</strong> wurde auf <strong>$datum_anzeige</strong> gesetzt (Benutzer: <strong>$benutzer</strong>)</div>";
    } else {
        $meldung = "<div class='alert alert-danger'>Fahrzeug nicht gefunden oder keine Berechtigung.</div>";
    }
}

}

// Fahrzeuge laden
$stmt = $conn->prepare("SELECT * FROM ffw_fahrzeuge WHERE einheit = ? ORDER BY fahrzeugbezeichnung ASC");
$stmt->bind_param("s", $einheit);
$stmt->execute();
$fahrzeuge = $stmt->get_result();
?>

<div class="container my-5">
  <h2 class="mb-4">Fahrzeugverwaltung – Einheit: <?= htmlspecialchars($einheit) ?></h2>

  <?= $meldung ?>

  <div class="table-responsive">
    <table class="table table-bordered table-hover bg-white">
      <thead class="table-dark">
        <tr>
          <th>Bezeichnung</th>
          <th>Funkrufname</th>
          <th>Kennzeichen</th>
          <th>Barcode</th>
          <th>Letzte Prüfung</th>
          <th>Aktion</th>
        </tr>
      </thead>
      <tbody>
        <?php while ($fzg = $fahrzeuge->fetch_assoc()): ?>
          <tr>
            <td><?= htmlspecialchars($fzg['fahrzeugbezeichnung']) ?></td>
            <td><?= htmlspecialchars($fzg['funkrufname']) ?></td>
            <td><?= htmlspecialchars($fzg['kennzeichen']) ?></td>
            <td><?= htmlspecialchars($fzg['barcode_fzg']) ?></td>
            <td><?= is_numeric($fzg['lpruefung']) && $fzg['lpruefung'] > 0 ? date('d.m.Y', $fzg['lpruefung']) : '-' ?></td>
            <td>
              <a href="fahrzeug_edit.php?id=<?= $fzg['id'] ?>" class="btn btn-sm btn-outline-primary">Bearbeiten</a>
              <form method="post" class="d-inline-block ms-2">
                <input type="hidden" name="fahrzeug_id" value="<?= $fzg['id'] ?>">
                <div class="input-group input-group-sm">
                  <input type="date" name="datum" class="form-control form-control-sm" required>
                  <button type="submit" name="pruefung_speichern" class="btn btn-sm btn-success">Setze Prüfung</button>
                </div>
              </form>
            </td>
          </tr>
        <?php endwhile; ?>
      </tbody>
    </table>
  </div>
</div>

<?php include 'includes/footer.php'; ob_end_flush(); ?>
