<?php
session_start();
include 'includes/db.php';
include 'includes/header.php';
include 'includes/nav.php';

$einheit = $_SESSION['einheit'] ?? '';
$info = '';
$fehler = '';

if (!$einheit) {
    echo "<div class='alert alert-danger'>Einheit nicht gefunden.</div>";
    exit;
}

// Formularverarbeitung
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $strasse = $_POST['strasse'] ?? '';
    $plz = $_POST['plz'] ?? '';
    $ort = $_POST['ort'] ?? '';
    $name2 = $_POST['name2'] ?? '';
    $art = $_POST['art'] ?? '';
    $obm_1 = $_POST['obm_1'] ?? '';
    $obm_2 = $_POST['obm_2'] ?? '';
    $obm_3 = $_POST['obm_3'] ?? '';
    $geraetewart = $_POST['geraetewart'] ?? '';
    $agw = $_POST['agw'] ?? '';
    $telefon = $_POST['telefon'] ?? '';
    $email = $_POST['email'] ?? '';

    // Prüfen ob Eintrag existiert
    $check = $conn->prepare("SELECT id FROM feuerwehren WHERE name = ?");
    $check->bind_param("s", $einheit);
    $check->execute();
    $result = $check->get_result();

    if ($result->num_rows > 0) {
        $update = $conn->prepare("UPDATE feuerwehren SET strasse=?, plz=?, ort=?, name2=?, art=?, obm_1=?, obm_2=?, obm_3=?, geraetewart=?, agw=?, telefon=?, email=? WHERE name=?");
        $update->bind_param("sssssssssssss", $strasse, $plz, $ort, $name2, $art, $obm_1, $obm_2, $obm_3, $geraetewart, $agw, $telefon, $email, $einheit);
        $update->execute();
        $info = "Einheitsdaten wurden aktualisiert.";
    } else {
        $insert = $conn->prepare("INSERT INTO feuerwehren (name, strasse, plz, ort, name2, art, obm_1, obm_2, obm_3, geraetewart, agw, telefon, email) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
        $insert->bind_param("sssssssssssss", $einheit, $strasse, $plz, $ort, $name2, $art, $obm_1, $obm_2, $obm_3, $geraetewart, $agw, $telefon, $email);

        $insert->execute();
        $info = "Einheitsdaten wurden gespeichert.";
    }
}

// Bestehende Daten laden
$stmt = $conn->prepare("SELECT * FROM feuerwehren WHERE name = ?");
$stmt->bind_param("s", $einheit);
$stmt->execute();
$daten = $stmt->get_result()->fetch_assoc();
?>

<div class="container mt-5">
    <h1 class="mb-4">🏘️ Meine Einheit – <?= htmlspecialchars($einheit) ?></h1>

    <?php if ($info): ?>
        <div class="alert alert-success"><?= $info ?></div>
    <?php endif; ?>

    <form method="post" class="row g-3">
        <div class="col-md-6">
            <label class="form-label">Straße</label>
            <input type="text" name="strasse" class="form-control" value="<?= htmlspecialchars($daten['strasse'] ?? '') ?>">
        </div>
        <div class="col-md-3">
            <label class="form-label">PLZ</label>
            <input type="text" name="plz" class="form-control" value="<?= htmlspecialchars($daten['plz'] ?? '') ?>">
        </div>
        <div class="col-md-3">
            <label class="form-label">Ort</label>
            <input type="text" name="ort" class="form-control" value="<?= htmlspecialchars($daten['ort'] ?? '') ?>">
        </div>

        <div class="col-md-6">
            <label class="form-label">Name</label>
            <input type="text" name="name2" class="form-control" value="<?= htmlspecialchars($daten['name2'] ?? '') ?>">
        </div>
        <div class="col-md-6">
            <label class="form-label">Art der Feuerwehr</label>
            <select name="art" class="form-select" required>
                <option value="">Bitte wählen</option>
                <?php
                $arten = ['Ortswehr', 'Schwerpunktwehr', 'Stützpunktwehr'];
                foreach ($arten as $a) {
                    $selected = ($daten['art'] ?? '') === $a ? 'selected' : '';
                    echo "<option value=\"$a\" $selected>$a</option>";
                }
                ?>
            </select>
        </div>

        <div class="col-md-4">
            <label class="form-label">Ortsbrandmeister 1</label>
            <input type="text" name="obm_1" class="form-control" value="<?= htmlspecialchars($daten['obm_1'] ?? '') ?>">
        </div>
        <div class="col-md-4">
            <label class="form-label">Ortsbrandmeister 2</label>
            <input type="text" name="obm_2" class="form-control" value="<?= htmlspecialchars($daten['obm_2'] ?? '') ?>">
        </div>
        <div class="col-md-4">
            <label class="form-label">Ortsbrandmeister 3</label>
            <input type="text" name="obm_3" class="form-control" value="<?= htmlspecialchars($daten['obm_3'] ?? '') ?>">
        </div>

        <div class="col-md-6">
            <label class="form-label">Gerätewart</label>
            <input type="text" name="geraetewart" class="form-control" value="<?= htmlspecialchars($daten['geraetewart'] ?? '') ?>">
        </div>
        <div class="col-md-6">
            <label class="form-label">Atemschutzgerätewart</label>
            <input type="text" name="agw" class="form-control" value="<?= htmlspecialchars($daten['agw'] ?? '') ?>">
        </div>

        <div class="col-md-6">
            <label class="form-label">Telefon</label>
            <input type="text" name="telefon" class="form-control" value="<?= htmlspecialchars($daten['telefon'] ?? '') ?>">
        </div>
        <div class="col-md-6">
            <label class="form-label">E-Mail</label>
            <input type="email" name="email" class="form-control" value="<?= htmlspecialchars($daten['email'] ?? '') ?>">
        </div>

        <div class="col-12">
            <button type="submit" class="btn btn-primary">💾 Speichern</button>
        </div>
    </form>
</div>

<?php include 'includes/footer.php'; ?>
