<?php
include 'includes/db.php';
include 'includes/header.php';
include 'includes/nav.php';
session_start();

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$meldung = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $artikelname = $_POST['artikelname'];
    $menge = (int)$_POST['menge'];
    $verwendungszweck = $_POST['verwendungszweck'];
    $herstellerlink = $_POST['herstellerlink'];
    $user_id = $_SESSION['user_id'];

    $stmt = $conn->prepare("INSERT INTO bestellungen (artikelname, menge, verwendungszweck, herstellerlink, angelegt_von) VALUES (?, ?, ?, ?, ?)");
    $stmt->bind_param("sisss", $artikelname, $menge, $verwendungszweck, $herstellerlink, $user_id);
    $stmt->execute();
    $meldung = "✅ Bestellung wurde erfasst.";
}
?>

<div class="container my-5">
  <h2>🛒 Neue Bestellanforderung</h2>
  <?php if ($meldung): ?>
    <div class="alert alert-success"><?= $meldung ?></div>
  <?php endif; ?>

  <form method="post" class="row g-3">
    <div class="col-md-6">
      <label class="form-label">Artikelname</label>
      <input type="text" name="artikelname" class="form-control" required>
    </div>
    <div class="col-md-2">
      <label class="form-label">Menge</label>
      <input type="number" name="menge" class="form-control" required>
    </div>
    <div class="col-md-12">
      <label class="form-label">Verwendungszweck</label>
      <textarea name="verwendungszweck" class="form-control" rows="3"></textarea>
    </div>
    <div class="col-md-12">
      <label class="form-label">Herstellerlink</label>
      <input type="url" name="herstellerlink" class="form-control">
    </div>
    <div class="col-12">
      <button class="btn btn-primary">Anfordern</button>
    </div>
  </form>
</div>

<?php include 'includes/footer.php'; ?>
