<?php
include '../includes/db.php';

$meldung = '';

// Formularverarbeitung
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name']);
    $raum = trim($_POST['raum']);
    $thema = trim($_POST['thema']);

    if ($name && $raum && $thema) {
        $stmt = $conn->prepare("INSERT INTO raum_buchungen (name, raum, thema) VALUES (?, ?, ?)");
        $stmt->bind_param("sss", $name, $raum, $thema);
        $stmt->execute();
        $meldung = "✅ Buchung gespeichert!";
    } else {
        $meldung = "❌ Bitte alle Felder ausfüllen!";
    }
}

// Räume-Liste
$raeume = ['Sitzungsraum 1', 'Schulungsraum', 'Fahrzeughalle', 'Besprechung 3'];

?>

<!DOCTYPE html>
<html lang="de">
<head>
  <meta charset="UTF-8">
  <title>Raumbuchung</title>
  <style>
    body { font-family: sans-serif; max-width: 700px; margin: 20px auto; }
    label { display: block; margin-top: 12px; font-weight: bold; }
    input, select { width: 100%; padding: 8px; margin-top: 4px; }
    .meldung { margin-top: 10px; padding: 10px; background: #f0f0f0; border-radius: 5px; }
    table { width: 100%; border-collapse: collapse; margin-top: 20px; }
    th, td { padding: 10px; border-bottom: 1px solid #ccc; }
  </style>
</head>
<body>

  <h2>📋 Raum-/Ressourcenbuchung</h2>

  <?php if ($meldung): ?>
    <div class="meldung"><?= $meldung ?></div>
  <?php endif; ?>

  <form method="post">
    <label>Dein Name</label>
    <input type="text" name="name" required>

    <label>Raum wählen</label>
    <select name="raum" required>
      <option value="">-- bitte wählen --</option>
      <?php foreach ($raeume as $r): ?>
        <option value="<?= htmlspecialchars($r) ?>"><?= htmlspecialchars($r) ?></option>
      <?php endforeach; ?>
    </select>

    <label>Thema / Anlass</label>
    <input type="text" name="thema" required>

    <button type="submit" style="margin-top: 15px; padding: 10px 20px;">✅ Jetzt buchen</button>
  </form>

  <h3>📅 Aktuelle Buchungen</h3>

  <table>
    <tr><th>Zeit</th><th>Name</th><th>Raum</th><th>Thema</th></tr>
    <?php
    $result = $conn->query("SELECT * FROM raum_buchungen ORDER BY zeit DESC");
    while ($row = $result->fetch_assoc()):
    ?>
      <tr>
        <td><?= date('d.m.Y H:i', strtotime($row['zeit'])) ?></td>
        <td><?= htmlspecialchars($row['name']) ?></td>
        <td><?= htmlspecialchars($row['raum']) ?></td>
        <td><?= htmlspecialchars($row['thema']) ?></td>
      </tr>
    <?php endwhile; ?>
  </table>

</body>
</html>
