<?php
include 'includes/db.php';

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $benutzername = $_POST['benutzername'];
    $passwort = $_POST['passwort'];

    // Passwort hashen
    $passwortHash = password_hash($passwort, PASSWORD_DEFAULT);

    // Benutzer in Datenbank speichern
    $stmt = $conn->prepare("INSERT INTO users (username, password) VALUES (?, ?)");
    $stmt->bind_param("ss", $benutzername, $passwortHash);

    if ($stmt->execute()) {
        echo "Benutzer erfolgreich registriert!";
    } else {
        echo "Fehler: " . $stmt->error;
    }

    $stmt->close();
}
?>

<form method="post">
    Benutzername: <input type="text" name="benutzername" required><br><br>
    Passwort: <input type="password" name="passwort" required><br><br>
    <button type="submit">Registrieren</button>
</form>

?>