<?php
session_start();
include 'includes/db.php';
include 'includes/header.php';
include 'includes/nav.php';

// Falls du nur die eigenen sehen willst, kannst du später einen Filter auf user_id ergänzen
$res = $conn->query("SELECT * FROM bestellpositionen ORDER BY bestellung_id DESC, id ASC");

$gruppen = [];
while ($row = $res->fetch_assoc()) {
    $gruppen[$row['bestellung_id']][] = $row;
}
?>

<div class="container my-5">
  <h2>📋 Alle Bestellungen</h2>

  <?php if (empty($gruppen)): ?>
    <div class="alert alert-info">Keine Positionen gefunden.</div>
  <?php else: ?>
    <?php foreach ($gruppen as $bestellung_id => $positionen): ?>
      <div class="card mb-4">
        <div class="card-header bg-primary text-white d-flex justify-content-between align-items-center">
          <span>Bestellung #<?= $bestellung_id ?></span>
          <a href="bestellung_detail.php?id=<?= $bestellung_id ?>" class="btn btn-light btn-sm">🔍 Details anzeigen</a>
        </div>

        <div class="card-body p-0">
          <table class="table table-sm m-0">
            <thead class="table-light">
              <tr>
                <th>Artikelname</th>
                <th>Größe</th>
                <th>Anzahl</th>
              </tr>
            </thead>
            <tbody>
              <?php foreach ($positionen as $pos): ?>
                <tr>
                  <td><?= htmlspecialchars($pos['artikelname']) ?></td>
                  <td><?= htmlspecialchars($pos['groesse']) ?></td>
                  <td><?= $pos['anzahl'] ?></td>
                </tr>
              <?php endforeach; ?>
            </tbody>
          </table>
        </div>
      </div>
    <?php endforeach; ?>
  <?php endif; ?>
</div>

<?php include 'includes/footer.php'; ?>
