<?php
include 'includes/db.php';
include 'includes/header.php';
include 'includes/nav.php';

session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

$user_id = $_SESSION['user_id'];

// Ticket übernehmen
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['uebernehmen'])) {
    $ticket_id = (int)$_POST['ticket_id'];
    $stmt = $conn->prepare("UPDATE neue_tickets SET status = 'in Bearbeitung', bearbeiter_id = ?, bearbeitet_am = NOW() WHERE id = ? AND status = 'offen'");
    $stmt->bind_param("ii", $user_id, $ticket_id);
    $stmt->execute();
}

// Ticket als erledigt markieren
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['erledigt'])) {
    $ticket_id = (int)$_POST['ticket_id'];
    $stmt = $conn->prepare("UPDATE neue_tickets SET status = 'erledigt', erledigt_am = NOW() WHERE id = ? AND bearbeiter_id = ?");
    $stmt->bind_param("ii", $ticket_id, $user_id);
    $stmt->execute();
}

// Tickets abrufen
$tickets = $conn->query("SELECT t.*, u.username AS bearbeiter_name
    FROM neue_tickets t
    LEFT JOIN users u ON t.bearbeiter_id = u.id
    ORDER BY t.erstellt_am DESC");
?>

<div class="container my-5">
  <h2 class="mb-4">Ticketsystem</h2>

  <table class="table table-bordered table-hover">
    <thead class="table-dark">
      <tr>
        <th>Ticketnummer</th>
        <th>Fachbereich</th>
        <th>Name</th>
        <th>Spindnr</th>
        <th>Beschreibung</th>
        <th>Status</th>
        <th>Bearbeiter</th>
        <th>Aktion</th>
      </tr>
    </thead>
    <tbody>
      <?php while ($ticket = $tickets->fetch_assoc()): ?>
        <tr>
          <td>
  <a href="ticket_details.php?id=<?= $ticket['id'] ?>" class="text-decoration-none">
    <?= htmlspecialchars($ticket['ticketnummer']) ?>
  </a>
</td>

          <td><?= htmlspecialchars($ticket['fachbereich']) ?></td>
          <td><?= htmlspecialchars($ticket['name']) ?></td>
          <td><?= htmlspecialchars($ticket['spindnr'] ?? '-') ?></td>
          <td><?= nl2br(htmlspecialchars($ticket['beschreibung'])) ?></td>
          <td>
            <?php if ($ticket['status'] == 'offen'): ?>
              <span class="badge bg-secondary">Offen</span>
            <?php elseif ($ticket['status'] == 'in Bearbeitung'): ?>
              <span class="badge bg-warning text-dark">In Bearbeitung</span>
            <?php else: ?>
              <span class="badge bg-success">Erledigt</span>
            <?php endif; ?>
          </td>
          <td><?= htmlspecialchars($ticket['bearbeiter_name'] ?? '-') ?></td>
          <td>
            <form method="post" class="d-inline">
              <input type="hidden" name="ticket_id" value="<?= $ticket['id'] ?>">
              <?php if ($ticket['status'] == 'offen'): ?>
                <button type="submit" name="uebernehmen" class="btn btn-sm btn-primary">Übernehmen</button>
              <?php elseif ($ticket['status'] == 'in Bearbeitung' && $ticket['bearbeiter_id'] == $user_id): ?>
                <button type="submit" name="erledigt" class="btn btn-sm btn-success">Erledigt</button>
              <?php else: ?>
                <span class="text-muted">-</span>
              <?php endif; ?>
            </form>
          </td>
        </tr>
      <?php endwhile; ?>
    </tbody>
  </table>
</div>

<?php include 'includes/footer.php'; ?>
