<?php
ob_start();
session_start();

include 'includes/header.php';
include 'includes/nav.php';
include 'includes/db.php';

if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

$id = (int)($_GET['id'] ?? 0);
$meldung = '';

// Melder abrufen
$stmt = $conn->prepare("SELECT * FROM melder WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$melder = $stmt->get_result()->fetch_assoc();

if (!$melder) {
    echo "<div class='container my-5'><div class='alert alert-danger'>Melder nicht gefunden.</div></div>";
    include 'includes/footer.php';
    exit;
}

// Kameraden abrufen
$kameraden = $conn->query("SELECT id, vorname, nachname FROM kameraden ORDER BY nachname ASC");

// Formular speichern
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['melder_speichern'])) {
    $seriennummer = trim($_POST['seriennummer']);
    $typ = trim($_POST['typ']);
    $kennung = trim($_POST['kennung']);
    $ausgabe_datum = !empty($_POST['ausgabe_datum']) ? $_POST['ausgabe_datum'] : NULL;
    $ladegeraet = isset($_POST['ladegeraet']) ? 1 : 0;
    $antenne = isset($_POST['antenne']) ? 1 : 0;
    $schutztasche = isset($_POST['schutztasche']) ? 1 : 0;
    $kamerad_id = !empty($_POST['kamerad_id']) ? (int)$_POST['kamerad_id'] : NULL;

    $programm_obm = isset($_POST['programm_obm']) ? 1 : 0;
    $programm_agt = isset($_POST['programm_agt']) ? 1 : 0;
    $programm_gg = isset($_POST['programm_gg']) ? 1 : 0;
    $programm_ggf = isset($_POST['programm_ggf']) ? 1 : 0;
    $programm_elw = isset($_POST['programm_elw']) ? 1 : 0;
    $programm_fuest = isset($_POST['programm_fuest']) ? 1 : 0;
    $programm_kfb = isset($_POST['programm_kfb']) ? 1 : 0;

    $stmt = $conn->prepare("UPDATE melder SET seriennummer = ?, typ = ?, kennung = ?, ausgabe_datum = ?, ladegeraet = ?, antenne = ?, schutztasche = ?, kamerad_id = ?, programm_obm = ?, programm_agt = ?, programm_gg = ?, programm_ggf = ?, programm_elw = ?, programm_fuest = ?, programm_kfb = ? WHERE id = ?");
    $stmt->bind_param("ssssiiiiiiiiiiii", $seriennummer, $typ, $kennung, $ausgabe_datum, $ladegeraet, $antenne, $schutztasche, $kamerad_id, $programm_obm, $programm_agt, $programm_gg, $programm_ggf, $programm_elw, $programm_fuest, $programm_kfb, $id);
    $stmt->execute();

    $meldung = "<div class='alert alert-success'>Melder erfolgreich aktualisiert.</div>";
    header("Location: melder_edit.php?id=$id");
    exit;
}
?>

<div class="container my-5">
  <a href="melder.php" class="btn btn-secondary mb-4">&laquo; Zurück</a>
  <h2 class="mb-4">Melder bearbeiten: <?= htmlspecialchars($melder['kennung']) ?></h2>

  <?= $meldung ?>

  <form method="post" class="card p-4">
    <div class="row g-3">
      <div class="col-md-6">
        <label class="form-label">Seriennummer*</label>
        <input type="text" name="seriennummer" class="form-control" value="<?= htmlspecialchars($melder['seriennummer']) ?>" required>
      </div>
      <div class="col-md-6">
        <label class="form-label">Typ*</label>
        <input type="text" name="typ" class="form-control" value="<?= htmlspecialchars($melder['typ']) ?>" required>
      </div>
      <div class="col-md-6">
        <label class="form-label">Kennung</label>
        <input type="text" name="kennung" class="form-control" value="<?= htmlspecialchars($melder['kennung']) ?>">
      </div>
      <div class="col-md-6">
        <label class="form-label">Ausgabe-Datum</label>
        <input type="date" name="ausgabe_datum" class="form-control" value="<?= htmlspecialchars($melder['ausgabe_datum']) ?>">
      </div>
      <div class="col-md-6">
        <label class="form-label">Kamerad</label>
        <select name="kamerad_id" class="form-select">
          <option value="">- Keine Auswahl -</option>
          <?php while ($k = $kameraden->fetch_assoc()): ?>
            <option value="<?= $k['id'] ?>" <?= $melder['kamerad_id'] == $k['id'] ? 'selected' : '' ?>>
              <?= htmlspecialchars($k['vorname'] . ' ' . $k['nachname']) ?>
            </option>
          <?php endwhile; ?>
        </select>
      </div>
      <div class="col-md-12">
        <label class="form-label"><b>Zubehör</b></label><br>
        <div class="form-check form-check-inline"><input class="form-check-input" type="checkbox" name="ladegeraet" <?= $melder['ladegeraet'] ? 'checked' : '' ?>> Ladegerät</div>
        <div class="form-check form-check-inline"><input class="form-check-input" type="checkbox" name="antenne" <?= $melder['antenne'] ? 'checked' : '' ?>> Antenne</div>
        <div class="form-check form-check-inline"><input class="form-check-input" type="checkbox" name="schutztasche" <?= $melder['schutztasche'] ? 'checked' : '' ?>> Schutztasche</div>
      </div>

      <div class="col-md-12">
        <label class="form-label"><b>Programmierungen</b></label><br>
        <div class="form-check form-check-inline"><input class="form-check-input" type="checkbox" name="programm_obm" <?= $melder['programm_obm'] ? 'checked' : '' ?>> Ortsbrandmeister</div>
        <div class="form-check form-check-inline"><input class="form-check-input" type="checkbox" name="programm_agt" <?= $melder['programm_agt'] ? 'checked' : '' ?>> Atemschutz</div>
        <div class="form-check form-check-inline"><input class="form-check-input" type="checkbox" name="programm_gg" <?= $melder['programm_gg'] ? 'checked' : '' ?>> Gefahrgutgruppe</div>
        <div class="form-check form-check-inline"><input class="form-check-input" type="checkbox" name="programm_ggf" <?= $melder['programm_ggf'] ? 'checked' : '' ?>> Gefahrgutgruppenführer</div>
        <div class="form-check form-check-inline"><input class="form-check-input" type="checkbox" name="programm_elw" <?= $melder['programm_elw'] ? 'checked' : '' ?>> ELW</div>
        <div class="form-check form-check-inline"><input class="form-check-input" type="checkbox" name="programm_fuest" <?= $melder['programm_fuest'] ? 'checked' : '' ?>> FüST</div>
        <div class="form-check form-check-inline"><input class="form-check-input" type="checkbox" name="programm_kfb" <?= $melder['programm_kfb'] ? 'checked' : '' ?>> KFB</div>
      </div>
    </div>

    <button type="submit" name="melder_speichern" class="btn btn-primary mt-4">Speichern</button>
  </form>
</div>

<?php include 'includes/footer.php'; ob_end_flush(); ?>
