<?php
ob_start();
session_start();
include 'includes/db.php';
include 'includes/header.php';
include 'includes/nav.php';

$meldung = '';
$spindnr = $_GET['spindnr'] ?? null;

// PIN-Abfrage & PIN-Erstellung
if ($spindnr && (!isset($_SESSION['auth_spindnr']) || $_SESSION['auth_spindnr'] !== $spindnr)) {

    // 1. PIN erstellen, wenn noch keiner gesetzt
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['pin_erstellen'])) {
        $neuer_pin = intval($_POST['neuer_pin']);

        if ($neuer_pin >= 1000 && $neuer_pin <= 9999) {
            $stmt = $conn->prepare("UPDATE kameraden SET pin = ? WHERE spindnr = ? AND pin = 0");
            $stmt->bind_param("is", $neuer_pin, $spindnr);
            $stmt->execute();
            if ($stmt->affected_rows > 0) {
                $meldung = '<div class="alert alert-success mt-3">✅ PIN wurde erfolgreich gesetzt. Bitte jetzt einloggen.</div>';
            } else {
                $meldung = '<div class="alert alert-danger mt-3">❌ PIN konnte nicht gesetzt werden oder existiert bereits.</div>';
            }
        } else {
            $meldung = '<div class="alert alert-warning mt-3">❗ Bitte eine 4-stellige Zahl als PIN eingeben.</div>';
        }
    }

    // Kamerad laden
    $stmt = $conn->prepare("SELECT pin, vorname, nachname, email FROM kameraden WHERE spindnr = ?");
    $stmt->bind_param("s", $spindnr);
    $stmt->execute();
    $result = $stmt->get_result();
    $row = $result->fetch_assoc();

    // PIN noch nicht gesetzt → PIN erstellen Formular
    if ($row && intval($row['pin']) === 0) {
        ?>
        <div class="container my-5">
          <div class="row justify-content-center">
            <div class="col-lg-6">
              <h3 class="mb-4">🔐 PIN erstellen für Spindnummer <?= htmlspecialchars($spindnr) ?></h3>
              <?= $meldung ?>
              <form method="post" class="card p-4 shadow-sm">
                <div class="mb-3">
                  <label class="form-label">Gewünschter PIN (4-stellig)</label>
                  <input type="number" name="neuer_pin" class="form-control" min="1000" max="9999" required>
                </div>
                <button type="submit" name="pin_erstellen" class="btn btn-success w-100">🔒 PIN setzen</button>
              </form>
            </div>
          </div>
        </div>
        <?php
        include 'includes/footer.php';
        ob_end_flush();
        exit;
    }

    // 🔐 2. PIN-Eingabe prüfen
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['pin_eingabe'])) {
        $eingegebene_pin = $_POST['pin'];
        $stmt = $conn->prepare("SELECT * FROM kameraden WHERE spindnr = ? AND pin = ?");
        $stmt->bind_param("si", $spindnr, $eingegebene_pin);
        $stmt->execute();
        $result = $stmt->get_result();
        if ($row = $result->fetch_assoc()) {
            $_SESSION['auth_spindnr'] = $spindnr;
            $_SESSION['vorbefuellung'] = [
                'name' => $row['vorname'] . ' ' . $row['nachname'],
                'email' => $row['email'],
                'spindnr' => $spindnr
            ];
            header("Location: " . $_SERVER['PHP_SELF'] . "?spindnr=" . urlencode($spindnr));
            exit;
        } else {
            $meldung = '<div class="alert alert-danger mt-3">❌ Falscher PIN!</div>';
        }
    }

    // 🔐 PIN-Abfrage-Formular
    ?>
    <div class="container my-5">
      <div class="row justify-content-center">
        <div class="col-lg-6">
          <h3 class="mb-4">🔐 PIN-Eingabe für Spindnummer <?= htmlspecialchars($spindnr) ?></h3>
          <?= $meldung ?>
          <form method="post" class="card p-4 shadow-sm">
            <div class="mb-3">
              <label class="form-label">PIN</label>
              <input type="password" name="pin" class="form-control" required>
            </div>
            <button type="submit" name="pin_eingabe" class="btn btn-primary w-100">✅ Bestätigen</button>
          </form>
        </div>
      </div>
    </div>
    <?php
    include 'includes/footer.php';
    ob_end_flush();
    exit;
}

// 🧠 Formular vorausgefüllte Werte
$name = $_SESSION['vorbefuellung']['name'] ?? ($_POST['name'] ?? '');
$email = $_SESSION['vorbefuellung']['email'] ?? ($_POST['email'] ?? '');
$spindnr = $_SESSION['vorbefuellung']['spindnr'] ?? ($_POST['spindnr'] ?? '');

// 🛠️ Ticketverarbeitung
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['ticket_absenden'])) {
    $name = trim($_POST['name']);
    $email = trim($_POST['email']) ?: '-';
    $spindnr = trim($_POST['spindnr']);
    $fachbereich = trim($_POST['fachbereich']);
    $beschreibung = trim($_POST['beschreibung']);

    if ($name && $fachbereich && $beschreibung) {
        $ticketnummer = 'T-' . date('Ymd') . '-' . rand(1000, 9999);
        $erstellt = date("Y-m-d H:i:s");

        // 📎 Datei-Upload
        $bild = null;
        if (!empty($_FILES['anhang']['name'])) {
            $uploadDir = 'uploads/tickets/';
            if (!is_dir($uploadDir)) {
                mkdir($uploadDir, 0777, true);
            }
            $fileName = $ticketnummer . '_' . uniqid() . '_' . basename($_FILES['anhang']['name']);
            move_uploaded_file($_FILES['anhang']['tmp_name'], $uploadDir . $fileName);
            $bild = $fileName;
        }

        // 📬 Speichern
        $stmt = $conn->prepare("INSERT INTO neue_tickets (ticketnummer, fachbereich, name, spindnr, beschreibung, status, erstellt_am) VALUES (?, ?, ?, ?, ?, 'offen', NOW())");
        $stmt->bind_param("sssss", $ticketnummer, $fachbereich, $name, $spindnr, $beschreibung);
        $stmt->execute();

        // 📤 Mail
        include 'mail/ticket_mail_senden.php';

        // ✅ Session löschen
        unset($_SESSION['auth_spindnr'], $_SESSION['vorbefuellung']);

        $meldung = '<div class="alert alert-success mt-3">✅ Ticket wurde erfolgreich erstellt.</div>';
    } else {
        $meldung = '<div class="alert alert-danger mt-3">❌ Bitte alle Pflichtfelder ausfüllen!</div>';
    }
}
?>

<div class="container my-5">
  <div class="row justify-content-center">
    <div class="col-lg-8 col-md-10">
      <h2 class="mb-4 text-center">🛠️ Neues Ticket erstellen</h2>

      <div class="alert alert-info">
        <strong>Wofür ist dieses Ticketsystem?</strong><br>
        Es dient zur Entlastung der Fachwarte und sorgt für eine strukturierte Aufgabenverteilung. Bitte gib dein Anliegen möglichst vollständig an.
      </div>

      <?= $meldung ?>

      <form method="post" enctype="multipart/form-data" class="card p-4 bg-white shadow-sm">
        <div class="mb-3">
          <label class="form-label">Name *</label>
          <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($name) ?>" required>
        </div>

        <div class="mb-3">
          <label class="form-label">E-Mail *</label>
          <input type="email" name="email" class="form-control" value="<?= htmlspecialchars($email) ?>">
        </div>

        <div class="mb-3">
          <label class="form-label">Spindnummer</label>
          <input type="text" name="spindnr" class="form-control" value="<?= htmlspecialchars($spindnr) ?>" readonly>
        </div>

        <div class="mb-3">
          <label class="form-label">Fachbereich *</label>
          <select name="fachbereich" class="form-select" required>
            <option value="">-- Bitte auswählen --</option>
            <option value="Ortsbrandmeister">Ortsbrandmeister</option>
            <option value="PSA">PSA</option>
            <option value="Dienstbekleidung">Dienstbekleidung</option>
            <option value="Uniform">Uniform</option>
            <option value="Melder">Melder / Schlüssel / Transponder</option>
            <option value="Gerät">Geräte</option>
          </select>
        </div>

        <div class="mb-3">
          <label class="form-label">Beschreibung *</label>
          <textarea name="beschreibung" class="form-control" rows="4" required></textarea>
        </div>

        <div class="mb-3">
          <label class="form-label">Anhang (Bild oder PDF)</label>
          <input type="file" name="anhang" class="form-control" accept=".jpg,.jpeg,.png,.pdf">
        </div>

        <button type="submit" name="ticket_absenden" class="btn btn-primary w-100">✅ Ticket absenden</button>
      </form>
    </div>
  </div>
</div>

<?php include 'includes/footer.php'; ?>
<?php ob_end_flush(); ?>
