<?php
include 'includes/db.php';
include 'includes/header.php';
include 'includes/nav.php';
session_start();

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit;
}

$user_id = $_SESSION['user_id'];
$is_admin = true; // optional: Rechteprüfung

// Freigabe/Kommentar verarbeiten
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['freigabe_id'])) {
    $id = (int)$_POST['freigabe_id'];
    $status = $_POST['status'];
    $kommentar = $_POST['kommentar'];

    $stmt = $conn->prepare("UPDATE bestellungen SET status=?, kommentar=?, genehmigt_von=?, genehmigt_am=NOW() WHERE id=?");
    $stmt->bind_param("ssii", $status, $kommentar, $user_id, $id);
    $stmt->execute();
}

// Bestellungen laden
$result = $conn->query("
    SELECT b.*, u.vorname, u.nachname
    FROM bestellungen b
    LEFT JOIN users u ON b.angelegt_von = u.id
    ORDER BY b.erstellt_am DESC
");
?>

<div class="container my-5">
  <h2>📋 Alle Bestellungen</h2>
  <div class="table-responsive">
    <table class="table table-bordered table-striped">
      <thead class="table-dark">
        <tr>
          <th>Artikel</th>
          <th>Menge</th>
          <th>Verwendungszweck</th>
          <th>Link</th>
          <th>Status</th>
          <th>Angelegt von</th>
          <th>Aktion</th>
        </tr>
      </thead>
      <tbody>
        <?php while ($row = $result->fetch_assoc()): ?>
          <tr>
            <td><?= htmlspecialchars($row['artikelname']) ?></td>
            <td><?= $row['menge'] ?></td>
            <td><?= nl2br(htmlspecialchars($row['verwendungszweck'])) ?></td>
            <td>
              <?php if ($row['herstellerlink']): ?>
                <a href="<?= htmlspecialchars($row['herstellerlink']) ?>" target="_blank">🔗 Link</a>
              <?php endif; ?>
            </td>
            <td>
              <span class="badge bg-<?=
                $row['status'] === 'offen' ? 'secondary' :
                ($row['status'] === 'genehmigt' ? 'success' : 'danger') ?>">
                <?= ucfirst($row['status']) ?>
              </span><br>
              <?php if ($row['kommentar']): ?><small><em><?= htmlspecialchars($row['kommentar']) ?></em></small><?php endif; ?>
            </td>
            <td><?= htmlspecialchars($row['vorname'].' '.$row['nachname']) ?></td>
            <td>
              <?php if ($row['status'] === 'offen' && $is_admin): ?>
                <form method="post" class="d-flex flex-column gap-1">
                  <input type="hidden" name="freigabe_id" value="<?= $row['id'] ?>">
                  <select name="status" class="form-select">
                    <option value="genehmigt">Genehmigen</option>
                    <option value="abgelehnt">Ablehnen</option>
                  </select>
                  <textarea name="kommentar" class="form-control" placeholder="Kommentar"></textarea>
                  <button class="btn btn-sm btn-success">✓ Abschicken</button>
                </form>
              <?php endif; ?>
            </td>
          </tr>
        <?php endwhile; ?>
      </tbody>
    </table>
  </div>
</div>

<?php include 'includes/footer.php'; ?>
