<?php
include 'includes/db.php';
include 'includes/header.php';
include 'includes/nav.php';

$spindnr = trim($_GET['spindnr'] ?? '');

if ($spindnr === '') {
    echo "<div class='container my-5'><div class='alert alert-danger'>Keine Spindnummer angegeben.</div></div>";
    include 'includes/footer.php';
    exit;
}

// Kamerad anhand Spindnummer suchen
$stmt = $conn->prepare("SELECT * FROM kameraden WHERE spindnr = ?");
$stmt->bind_param("s", $spindnr);
$stmt->execute();
$kamerad = $stmt->get_result()->fetch_assoc();

if (!$kamerad) {
    echo "<div class='container my-5'><div class='alert alert-danger'>Kamerad nicht gefunden.</div></div>";
    include 'includes/footer.php';
    exit;
}

// Melder abrufen
$stmt_melder = $conn->prepare("SELECT * FROM melder WHERE kamerad_id = ?");
$stmt_melder->bind_param("i", $kamerad['id']);
$stmt_melder->execute();
$melder = $stmt_melder->get_result();

// Historie abrufen
$stmt_hist = $conn->prepare("SELECT h.*, l.artikelname
    FROM lager_historie h
    LEFT JOIN lager_bestand l ON h.lager_id = l.id
    WHERE h.kamerad_id = ?
    ORDER BY h.id DESC");
$stmt_hist->bind_param("i", $kamerad['id']);
$stmt_hist->execute();
$historie = $stmt_hist->get_result();

// PSA-Daten zur Spindnummer laden
$stmt_psa = $conn->prepare("SELECT typ, id_code FROM psa_ausruestung WHERE spindnr = ?");
$stmt_psa->bind_param("s", $spindnr);
$stmt_psa->execute();
$psa_items = $stmt_psa->get_result()->fetch_all(MYSQLI_ASSOC);

$psa_idcodes = [];
foreach ($psa_items as $item) {
    $psa_idcodes[$item['typ']] = $item['id_code'];
}

// Transponder und Schlüssel abrufen
$stmt_ts = $conn->prepare("SELECT * FROM transponder_schluessel WHERE spindnr = ?");
$stmt_ts->bind_param("s", $spindnr);
$stmt_ts->execute();
$ts_result = $stmt_ts->get_result();
$ts_items = $ts_result->fetch_all(MYSQLI_ASSOC);
?>

<div class="container my-5">
  <h2 class="mb-4">Ausrüstung von <?= htmlspecialchars($kamerad['vorname'].' '.$kamerad['nachname']) ?></h2>

  <!-- Button mit verstecktem POST-Formular -->
  <form id="ticketForm" action="https://app.f-invent.de/add_ticket.php" method="post" style="display: none;">
      <input type="hidden" name="name" value="<?= htmlspecialchars($kamerad['vorname'] . ' ' . $kamerad['nachname']) ?>">
      <input type="hidden" name="email" value="<?= htmlspecialchars($kamerad['email']) ?>">
      <input type="hidden" name="spindnr" value="<?= htmlspecialchars($kamerad['spindnr']) ?>">
  </form>

  <a href="#" onclick="document.getElementById('ticketForm').submit();" class="btn btn-primary mb-4">
      ➕ Neues Ticket erstellen
  </a>

  <div class="mb-4">
    <h5>Größen & ID-Codes</h5>
    <ul class="list-group">
      <li class="list-group-item">
        Einsatzjacke: <?= htmlspecialchars($kamerad['groesse_jacke'] ?? '-') ?>
        <?php if (!empty($psa_idcodes['Einsatzjacke'])): ?>
          <br><small class="text-muted">ID-Code: <?= htmlspecialchars($psa_idcodes['Einsatzjacke']) ?></small>
        <?php endif; ?>
      </li>
      <li class="list-group-item">
        Einsatzhose: <?= htmlspecialchars($kamerad['groesse_hose'] ?? '-') ?>
        <?php if (!empty($psa_idcodes['Einsatzhose'])): ?>
          <br><small class="text-muted">ID-Code: <?= htmlspecialchars($psa_idcodes['Einsatzhose']) ?></small>
        <?php endif; ?>
      </li>
      <li class="list-group-item">
        Einsatzhose AGT: <?= htmlspecialchars($kamerad['groesse_hose_agt'] ?? '-') ?>
        <?php if (!empty($psa_idcodes['Einsatzhose AGT'])): ?>
          <br><small class="text-muted">ID-Code: <?= htmlspecialchars($psa_idcodes['Einsatzhose AGT']) ?></small>
        <?php endif; ?>
      </li>
      <li class="list-group-item">
        Stiefel: <?= htmlspecialchars($kamerad['groesse_stiefel'] ?? '-') ?>
        <?php if (!empty($psa_idcodes['Stiefel'])): ?>
          <br><small class="text-muted">ID-Code: <?= htmlspecialchars($psa_idcodes['Stiefel']) ?></small>
        <?php endif; ?>
      </li>
    </ul>
  </div>

  <div class="mb-5">
    <h4>Transponder & Schlüssel</h4>
    <?php if (!empty($ts_items)): ?>
      <ul class="list-group">
        <?php foreach ($ts_items as $item): ?>
          <li class="list-group-item">
            <strong><?= htmlspecialchars($item['typ']) ?>:</strong> <?= htmlspecialchars($item['nummer']) ?>
            <?php if (!empty($item['kommentar'])): ?>
              <br><small class="text-muted">📝 <?= htmlspecialchars($item['kommentar']) ?></small>
            <?php endif; ?>
          </li>
        <?php endforeach; ?>
      </ul>
    <?php else: ?>
      <p class="text-muted">Keine Transponder oder Schlüssel für diese Spindnummer erfasst.</p>
    <?php endif; ?>
  </div>

  <div class="mb-5">
    <h4>Melderdaten</h4>
    <?php if ($melder->num_rows > 0): ?>
      <?php while ($item = $melder->fetch_assoc()): ?>
        <div class="card mb-2">
          <div class="card-body">
            <strong>Seriennummer:</strong> <?= htmlspecialchars($item['seriennummer']) ?><br>
            <strong>Typ:</strong> <?= htmlspecialchars($item['typ']) ?><br>
            <strong>Kennung:</strong> <?= htmlspecialchars($item['kennung']) ?><br>
            <strong>Zubehör:</strong><br>
            <?= $item['ladegeraet'] ? '🔌 Ladegerät<br>' : '' ?>
            <?= $item['antenne'] ? '📡 Antenne<br>' : '' ?>
            <?= $item['schutztasche'] ? '👜 Schutztasche<br>' : '' ?>
          </div>
        </div>
      <?php endwhile; ?>
    <?php else: ?>
      <p class="text-muted">Kein Melder für diesen Kameraden hinterlegt.</p>
    <?php endif; ?>
  </div>

  <div class="mb-5">
    <h4>Buchungshistorie (Lager)</h4>
    <?php if ($historie->num_rows > 0): ?>
      <div class="table-responsive">
        <table class="table table-bordered">
          <thead class="table-dark">
            <tr>
              <th>Datum</th>
              <th>Artikel</th>
              <th>Buchungstyp</th>
              <th>Anzahl</th>
              <th>Bemerkung</th>
            </tr>
          </thead>
          <tbody>
            <?php while ($h = $historie->fetch_assoc()): ?>
              <tr>
                <td>
                  <?= (!empty($h['zeitstempel']) && $h['zeitstempel'] !== '0000-00-00 00:00:00')
                      ? date('d.m.Y H:i', strtotime($h['zeitstempel']))
                      : '-' ?>
                </td>
                <td><?= htmlspecialchars($h['artikelname']) ?></td>
                <td><?= htmlspecialchars($h['buchungstyp']) ?></td>
                <td><?= htmlspecialchars($h['anzahl']) ?></td>
                <td><?= htmlspecialchars($h['bemerkung']) ?></td>
              </tr>
            <?php endwhile; ?>
          </tbody>
        </table>
      </div>
    <?php else: ?>
      <p class="text-muted">Keine Buchungshistorie vorhanden.</p>
    <?php endif; ?>
  </div>
</div>

<?php include 'includes/footer.php'; ?>
