<?php
include 'includes/header.php';
include 'includes/nav.php';
include 'includes/db.php';

session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit;
}

$id = (int)($_GET['id'] ?? 0);
$meldung = '';

// Kamerad laden
$stmt = $conn->prepare("SELECT * FROM kameraden WHERE id = ?");
$stmt->bind_param("i", $id);
$stmt->execute();
$kamerad = $stmt->get_result()->fetch_assoc();
if (!$kamerad) {
    echo "<div class='container my-5'><div class='alert alert-danger'>Kamerad nicht gefunden.</div></div>";
    include 'includes/footer.php';
    exit;
}

// Werte
$groessen_textil = ['XS', 'S', 'M', 'L', 'XL', 'XXL', 'XXXL'];
$groessen_schuhe = range(38, 50);
$spindnummern = range(1, 80);

// Spind-Zuordnungen
$belegte_spinde = [];
$result = $conn->query("SELECT id, spindnr, vorname, nachname FROM kameraden WHERE id != $id");
while ($row = $result->fetch_assoc()) {
    if (!empty($row['spindnr'])) {
        $belegte_spinde[$row['spindnr']] = $row['vorname'] . ' ' . $row['nachname'];
    }
}

// Formular speichern
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['save'])) {
    $vorname = trim($_POST['vorname']);
    $nachname = trim($_POST['nachname']);
    $email = trim($_POST['email']);
    $spindnr = trim($_POST['spindnr']);
    $groesse_jacke = $_POST['groesse_jacke'];
    $groesse_hose = $_POST['groesse_hose'];
    $groesse_hose_agt = $_POST['groesse_hose_agt'];
    $groesse_stiefel = $_POST['groesse_stiefel'];

    if (isset($belegte_spinde[$spindnr])) {
        $meldung = "<div class='alert alert-danger'>❌ Spind $spindnr ist bereits vergeben an {$belegte_spinde[$spindnr]}.</div>";
    } else {
        $stmt = $conn->prepare("UPDATE kameraden SET vorname = ?, nachname = ?, email = ?, spindnr = ?, groesse_jacke = ?, groesse_hose = ?, groesse_hose_agt = ?, groesse_stiefel = ? WHERE id = ?");
        $stmt->bind_param("sssssssii", $vorname, $nachname, $email, $spindnr, $groesse_jacke, $groesse_hose, $groesse_hose_agt, $groesse_stiefel, $id);
        $stmt->execute();

        $meldung = "<div class='alert alert-success'>✅ Kamerad erfolgreich aktualisiert.</div>";

        // Reload
        $stmt = $conn->prepare("SELECT * FROM kameraden WHERE id = ?");
        $stmt->bind_param("i", $id);
        $stmt->execute();
        $kamerad = $stmt->get_result()->fetch_assoc();
    }
}
?>

<div class="container my-5">
  <h2 class="mb-4">Kamerad bearbeiten</h2>

  <?= $meldung ?>

  <form method="post" class="card p-4 bg-white shadow-sm">
    <div class="mb-3">
      <label class="form-label">Vorname</label>
      <input type="text" name="vorname" value="<?= htmlspecialchars($kamerad['vorname']) ?>" class="form-control" required>
    </div>
    <div class="mb-3">
      <label class="form-label">Nachname</label>
      <input type="text" name="nachname" value="<?= htmlspecialchars($kamerad['nachname']) ?>" class="form-control" required>
    </div>
    <div class="mb-3">
      <label class="form-label">E-Mail</label>
      <input type="email" name="email" value="<?= htmlspecialchars($kamerad['email']) ?>" class="form-control">
    </div>
    <div class="mb-3">
      <label class="form-label">Spindnummer</label>
      <select name="spindnr" class="form-select" required>
        <option value="">– bitte wählen –</option>
        <?php foreach ($spindnummern as $nr): ?>
          <?php
            $ist_eigener = $kamerad['spindnr'] == $nr;
            $vergeben = isset($belegte_spinde[$nr]);
            $text = $vergeben ? " (vergeben an {$belegte_spinde[$nr]})" : '';
          ?>
          <option value="<?= $nr ?>"
            <?= $ist_eigener ? 'selected' : '' ?>
            <?= (!$ist_eigener && $vergeben) ? 'disabled' : '' ?>>
            <?= $nr . $text ?>
          </option>
        <?php endforeach; ?>
      </select>
    </div>

    <h4 class="mb-4">Größen</h4>
    <div class="row g-3 mb-4">
      <div class="col-md-6">
        <label class="form-label">Einsatzjacke</label>
        <select name="groesse_jacke" class="form-select">
          <option value="">– bitte wählen –</option>
          <?php foreach ($groessen_textil as $size): ?>
            <option value="<?= $size ?>" <?= ($kamerad['groesse_jacke'] ?? '') === $size ? 'selected' : '' ?>><?= $size ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-6">
        <label class="form-label">Einsatzhose</label>
        <select name="groesse_hose" class="form-select">
          <option value="">– bitte wählen –</option>
          <?php foreach ($groessen_textil as $size): ?>
            <option value="<?= $size ?>" <?= ($kamerad['groesse_hose'] ?? '') === $size ? 'selected' : '' ?>><?= $size ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-6">
        <label class="form-label">Einsatzhose AGT</label>
        <select name="groesse_hose_agt" class="form-select">
          <option value="">– bitte wählen –</option>
          <?php foreach ($groessen_textil as $size): ?>
            <option value="<?= $size ?>" <?= ($kamerad['groesse_hose_agt'] ?? '') === $size ? 'selected' : '' ?>><?= $size ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div class="col-md-6">
        <label class="form-label">Stiefel</label>
        <select name="groesse_stiefel" class="form-select">
          <option value="">– bitte wählen –</option>
          <?php foreach ($groessen_schuhe as $size): ?>
            <option value="<?= $size ?>" <?= ($kamerad['groesse_stiefel'] ?? '') == $size ? 'selected' : '' ?>><?= $size ?></option>
          <?php endforeach; ?>
        </select>
      </div>
    </div>

    <button type="submit" name="save" class="btn btn-primary">Speichern</button>
  </form>
</div>

<?php include 'includes/footer.php'; ?>
