<?php
session_start();
include 'includes/db.php';
include 'includes/header.php';
include 'includes/nav.php';

$meldung = '';

// Vorausgefüllte Daten aus vorherigem POST
$name = $_POST['name'] ?? '';
$email = $_POST['email'] ?? '';
$spindnr = $_POST['spindnr'] ?? '';

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['ticket_absenden'])) {
    $name = trim($_POST['name']);
    $email = trim($_POST['email']) ?: '-';
    $spindnr = trim($_POST['spindnr']);
    $fachbereich = trim($_POST['fachbereich']);
    $beschreibung = trim($_POST['beschreibung']);

    if ($name && $fachbereich && $beschreibung) {
        $ticketnummer = 'T-' . date('Ymd') . '-' . rand(1000, 9999);
        $erstellt = date("Y-m-d H:i:s");

        // Datei hochladen
        $bild = null;
        if (!empty($_FILES['anhang']['name'])) {
            $uploadDir = 'uploads/tickets/';
            if (!is_dir($uploadDir)) {
                mkdir($uploadDir, 0777, true);
            }
            $fileName = $ticketnummer . '_' . uniqid() . '_' . basename($_FILES['anhang']['name']);
            move_uploaded_file($_FILES['anhang']['tmp_name'], $uploadDir . $fileName);
            $bild = $fileName;
        }

        // In Datenbank speichern
        $stmt = $conn->prepare("INSERT INTO neue_tickets (ticketnummer, fachbereich, name, spindnr, beschreibung, status, erstellt_am) VALUES (?, ?, ?, ?, ?, 'offen', NOW())");
        $stmt->bind_param("sssss", $ticketnummer, $fachbereich, $name, $spindnr, $beschreibung);
        $stmt->execute();

        // Mailversand (extern ausgelagert)
        include 'mail/ticket_mail_senden.php';

        // Einfache Erfolgsnachricht
        $meldung = '<div class="alert alert-success mt-3">✅ Ticket wurde erfolgreich erstellt.</div>';
    } else {
        $meldung = '<div class="alert alert-danger mt-3">❌ Bitte alle Pflichtfelder ausfüllen!</div>';
    }
}
?>

<div class="container my-5">
  <div class="row justify-content-center">
    <div class="col-lg-8 col-md-10">
      <h2 class="mb-4 text-center">🛠️ Neues Ticket erstellen</h2>

      <div class="alert alert-info">
        <strong>Wofür ist dieses Ticketsystem?</strong><br>
        Es dient zur Entlastung der Fachwarte und sorgt für eine strukturierte Aufgabenverteilung. Bitte gib dein Anliegen möglichst vollständig an.
      </div>

      <?= $meldung ?>

      <form method="post" enctype="multipart/form-data" class="card p-4 bg-white shadow-sm">
        <div class="mb-3">
          <label class="form-label">Name *</label>
          <input type="text" name="name" class="form-control" value="<?= htmlspecialchars($name) ?>" required>
        </div>

        <div class="mb-3">
          <label class="form-label">E-Mail</label>
          <input type="email" name="email" class="form-control" placeholder="Optional" value="<?= htmlspecialchars($email) ?>">
        </div>

        <div class="mb-3">
          <label class="form-label">Spindnummer</label>
          <input type="text" name="spindnr" class="form-control" placeholder="Optional" value="<?= htmlspecialchars($spindnr) ?>">
        </div>

        <div class="mb-3">
          <label class="form-label">Fachbereich *</label>
          <select name="fachbereich" class="form-select" required>
            <option value="">-- Bitte auswählen --</option>
            <option value="PSA">PSA</option>
            <option value="Dienstbekleidung">Dienstbekleidung</option>
            <option value="Uniform">Uniform</option>
            <option value="Melder">Melder</option>
            <option value="Gerät">Gerät</option>
          </select>
        </div>

        <div class="mb-3">
          <label class="form-label">Beschreibung *</label>
          <textarea name="beschreibung" class="form-control" rows="4" required></textarea>
        </div>

        <div class="mb-3">
          <label class="form-label">Anhang (Bild oder PDF)</label>
          <input type="file" name="anhang" class="form-control" accept=".jpg,.jpeg,.png,.pdf">
        </div>

        <button type="submit" name="ticket_absenden" class="btn btn-primary w-100">✅ Ticket absenden</button>
      </form>
    </div>
  </div>
</div>

<?php include 'includes/footer.php'; ?>
